DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -1.34963085984344E-11   0.00000000000000E+00   1.31938183508750E-10   1.64411234925073E-22
      1.33643758479115E-08   1.34963140314204E-08  -7.90356667088163E-19  -2.50371042858464E-01  -2.50371042857040E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42386139856159E-09   0.00000000000000E+00  -1.42386139856159E-09
      3.70001668496812E-18  -2.50371042858463E-01  -2.46567585215326E-01   0.00000000000000E+00  -4.28244497965210E-12
     -9.83405481597034E-23  -1.20681701878818E-08  -1.20724526328616E-08  -2.90966001787995E-18
      1.17500000000000E-12
      0.00000000000000E+00  -1.34927266536833E-11   0.00000000000000E+00   8.88167131119997E-12   1.65785630604856E-22
      1.34838990896185E-08   1.34927807609299E-08  -7.89530143318320E-19  -2.50727023102224E-01  -2.50727023100884E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33966529009802E-09   0.00000000000000E+00  -1.33966529009802E-09
      3.69911241089730E-18  -2.50727023102222E-01  -2.46898160230406E-01   0.00000000000000E+00  -5.90624903871893E-12
     -9.83451993307235E-23  -1.21472092217934E-08  -1.21531154708322E-08  -2.90958226757898E-18
      2.08625000000000E-12
      0.00000000000000E+00  -1.34885936405090E-11   0.00000000000000E+00   2.89542674168389E-13   1.68053894679820E-22
      1.34883042186241E-08   1.34885937612984E-08  -7.88547512361122E-19  -2.51140737930659E-01  -2.51140737929450E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20884850237488E-09   0.00000000000000E+00  -1.20884850237488E-09
      3.69801084769951E-18  -2.51140737930659E-01  -2.47271964092228E-01   0.00000000000000E+00  -6.68041321377350E-12
     -9.83514500034771E-23  -1.22730648457083E-08  -1.22797452589221E-08  -2.90946333533839E-18
      2.24002343750000E-12
      0.00000000000000E+00  -1.34879507273485E-11   0.00000000000000E+00  -6.06630523083853E-14   1.68445245519092E-22
      1.34879716867845E-08   1.34879110237323E-08  -7.88385412305805E-19  -2.51208897626916E-01  -2.51208897625729E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18639459359787E-09   0.00000000000000E+00  -1.18639459359787E-09
      3.69782841172463E-18  -2.51208897626917E-01  -2.47333264338900E-01   0.00000000000000E+00  -6.78363043080925E-12
     -9.83524989823906E-23  -1.22947327997073E-08  -1.23015164301383E-08  -2.90944299941882E-18
      2.34382050781250E-12
      0.00000000000000E+00  -1.34874915036625E-11   0.00000000000000E+00  -1.35309084659520E-13   1.68712344248252E-22
      1.34875934050376E-08   1.34874580959531E-08  -7.88277660858136E-19  -2.51254190404010E-01  -2.51254190402839E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17110270113531E-09   0.00000000000000E+00  -1.17110270113531E-09
      3.69770685469521E-18  -2.51254190404011E-01  -2.47373882048189E-01   0.00000000000000E+00  -6.83801238482492E-12
     -9.83532030308949E-23  -1.23095173824238E-08  -1.23163553948087E-08  -2.90942919383708E-18
      2.48394655273438E-12
      0.00000000000000E+00  -1.34868485905021E-11   0.00000000000000E+00  -1.59238885017458E-13   1.69076028044677E-22
      1.34870184417730E-08   1.34868592028881E-08  -7.88135167692088E-19  -2.51314079711673E-01  -2.51314079710523E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15030364376685E-09   0.00000000000000E+00  -1.15030364376685E-09
      3.69754566719515E-18  -2.51314079711674E-01  -2.47427407227718E-01   0.00000000000000E+00  -6.88278514002994E-12
     -9.83541408683464E-23  -1.23296727739783E-08  -1.23365555591184E-08  -2.90941049950306E-18
      2.67311671337891E-12
      0.00000000000000E+00  -1.34860219878672E-11   0.00000000000000E+00  -1.62344985963498E-13   1.69568035688995E-22
      1.34862352679972E-08   1.34860729230114E-08  -7.87948069701098E-19  -2.51392713007235E-01  -2.51392713006113E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12214698934290E-09   0.00000000000000E+00  -1.12214698934290E-09
      3.69733339046891E-18  -2.51392713007248E-01  -2.47497417427958E-01   0.00000000000000E+00  -6.89484550679199E-12
     -9.83553873517947E-23  -1.23570310881669E-08  -1.23639259336738E-08  -2.90938532076781E-18
      2.92849643024902E-12
      0.00000000000000E+00  -1.34850116957579E-11   0.00000000000000E+00  -1.57962436682292E-13   1.70225981028973E-22
      1.34852084110346E-08   1.34850504485981E-08  -7.87704747234799E-19  -2.51494971481797E-01  -2.51494971480713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08438999372932E-09   0.00000000000000E+00  -1.08438999372932E-09
      3.69705645925934E-18  -2.51494971481783E-01  -2.47588102642153E-01   0.00000000000000E+00  -6.84274112153050E-12
     -9.83570195156962E-23  -1.23938177137420E-08  -1.24006604548636E-08  -2.90935171202453E-18
      3.27325904802368E-12
      0.00000000000000E+00  -1.34837258694370E-11   0.00000000000000E+00  -1.50204798695740E-13   1.71090763735448E-22
      1.34838882141471E-08   1.34837380093486E-08  -7.87392345403244E-19  -2.51626248116264E-01  -2.51626248115230E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03452921961793E-09   0.00000000000000E+00  -1.03452921961793E-09
      3.69669979225741E-18  -2.51626248116230E-01  -2.47704084135642E-01   0.00000000000000E+00  -6.68932715188013E-12
     -9.83591270748568E-23  -1.24425194625807E-08  -1.24492087897326E-08  -2.90930744685417E-18
      3.73868858201947E-12
      0.00000000000000E+00  -1.34820726641673E-11   0.00000000000000E+00  -1.39507892893096E-13   1.72201601825478E-22
      1.34822220112962E-08   1.34820825034035E-08  -7.86998084914941E-19  -2.51791892979872E-01  -2.51791892978902E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70090134828701E-10   0.00000000000000E+00  -9.70090134828701E-10
      3.69624828365803E-18  -2.51791892979950E-01  -2.47849949232068E-01   0.00000000000000E+00  -6.40206252572419E-12
     -9.83618014438604E-23  -1.25055903060500E-08  -1.25119923685759E-08  -2.90925019874309E-18
      4.36701845291379E-12
      0.00000000000000E+00  -1.34800520799487E-11   0.00000000000000E+00  -1.28633708773537E-13   1.73588219313019E-22
      1.34801672377377E-08   1.34800386040291E-08  -7.86511767429488E-19  -2.51996156322831E-01  -2.51996156321942E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.89102657117786E-10   0.00000000000000E+00  -8.89102657117786E-10
      3.69568963390027E-18  -2.51996156322872E-01  -2.48029340899465E-01   0.00000000000000E+00  -5.95824354947656E-12
     -9.83651217191532E-23  -1.25849777033617E-08  -1.25909359469113E-08  -2.90917786647078E-18
      4.79114111576745E-12
      0.00000000000000E+00  -1.34787662536278E-11   0.00000000000000E+00  -1.21338374055108E-13   1.74472505981559E-22
      1.34788641003548E-08   1.34787427619809E-08  -7.86203247566749E-19  -2.52125706375117E-01  -2.52125706374280E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37237520674597E-10   0.00000000000000E+00  -8.37237520674597E-10
      3.69533454249356E-18  -2.52125706352040E-01  -2.48142958868188E-01   0.00000000000000E+00  -5.65272011160453E-12
     -9.83672526865045E-23  -1.26358525211945E-08  -1.26415052413062E-08  -2.90913129492681E-18
      4.93428251448056E-12
      0.00000000000000E+00  -1.34783070299418E-11   0.00000000000000E+00  -1.18496741469769E-13   1.74765081789187E-22
      1.34784336334947E-08   1.34783151367534E-08  -7.86101328520060E-19  -2.52168497586145E-01  -2.52168497585325E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20052518555020E-10   0.00000000000000E+00  -8.20052518555020E-10
      3.69521715902903E-18  -2.52168497555399E-01  -2.48180470730099E-01   0.00000000000000E+00  -5.54996729011503E-12
     -9.83679477909680E-23  -1.26527126509082E-08  -1.26582626181984E-08  -2.90911583050897E-18
      5.12752340274326E-12
      0.00000000000000E+00  -1.34777559615185E-11   0.00000000000000E+00  -1.15362839467233E-13   1.75149550801200E-22
      1.34778690239343E-08   1.34777536610950E-08  -7.85967646523115E-19  -2.52224618303572E-01  -2.52224618302775E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97432479508650E-10   0.00000000000000E+00  -7.97432479508650E-10
      3.69506306246837E-18  -2.52224618208887E-01  -2.48229641740338E-01   0.00000000000000E+00  -5.41133205755299E-12
     -9.83694166546689E-23  -1.26749098495442E-08  -1.26803211816018E-08  -2.90909541594525E-18
      5.38839860189791E-12
      0.00000000000000E+00  -1.34770212036209E-11   0.00000000000000E+00  -1.10686367691448E-13   1.75649819209708E-22
      1.34771358885067E-08   1.34770252021391E-08  -7.85794035543220E-19  -2.52297492187952E-01  -2.52297492187184E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.67939505412203E-10   0.00000000000000E+00  -7.67939505412203E-10
      3.69486272609695E-18  -2.52297492091941E-01  -2.48293453425779E-01   0.00000000000000E+00  -5.22716629207083E-12
     -9.83707504579543E-23  -1.27038585304296E-08  -1.27090856967217E-08  -2.90906869055373E-18
      5.74058012075668E-12
      0.00000000000000E+00  -1.34761027562488E-11   0.00000000000000E+00  -1.04895341412879E-13   1.76291968974055E-22
      1.34761965103461E-08   1.34760916150049E-08  -7.85571546552087E-19  -2.52390867417676E-01  -2.52390867416946E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29981110688562E-10   0.00000000000000E+00  -7.29981110688562E-10
      3.69460564024065E-18  -2.52390867335625E-01  -2.48375164019828E-01   0.00000000000000E+00  -4.98451245449889E-12
     -9.83718545585299E-23  -1.27411259918648E-08  -1.27461105043194E-08  -2.90903409368857E-18
      6.21602517121602E-12
      0.00000000000000E+00  -1.34749087746651E-11   0.00000000000000E+00  -9.73045625663246E-14   1.77101339963140E-22
      1.34750140636327E-08   1.34749167590703E-08  -7.85291428145019E-19  -2.52508403165510E-01  -2.52508403164828E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81977135722134E-10   0.00000000000000E+00  -6.81977135722134E-10
      3.69428139758695E-18  -2.52508403101084E-01  -2.48477946382973E-01   0.00000000000000E+00  -4.67145465254912E-12
     -9.83736157947171E-23  -1.27882681686965E-08  -1.27929396233491E-08  -2.90898996944193E-18
      6.85787598933613E-12
      0.00000000000000E+00  -1.34734392588698E-11   0.00000000000000E+00  -8.92689562468477E-14   1.78097098258948E-22
      1.34735603451251E-08   1.34734710761690E-08  -7.84946953652322E-19  -2.52652900627228E-01  -2.52652900626605E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22673623518553E-10   0.00000000000000E+00  -6.22673623518553E-10
      3.69388173401227E-18  -2.52652900576064E-01  -2.48604215468876E-01   0.00000000000000E+00  -4.27662296881295E-12
     -9.83759842621549E-23  -1.28465208296830E-08  -1.28507974526519E-08  -2.90893478035995E-18
      7.29112529156720E-12
      0.00000000000000E+00  -1.34725208114977E-11   0.00000000000000E+00  -8.34940403657926E-14   1.78727534128088E-22
      1.34726400601574E-08   1.34725565661172E-08  -7.84728864177972E-19  -2.52744361144618E-01  -2.52744361144033E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85018943654946E-10   0.00000000000000E+00  -5.85018943654946E-10
      3.69362827496314E-18  -2.52744361105558E-01  -2.48684101048628E-01   0.00000000000000E+00  -4.02472320012968E-12
     -9.83774311984599E-23  -1.28835128992604E-08  -1.28875376224606E-08  -2.90889941078517E-18
      7.36423611131870E-12
      0.00000000000000E+00  -1.34724289667605E-11   0.00000000000000E+00  -8.29076666671523E-14   1.78832739453743E-22
      1.34724864887291E-08   1.34724035810626E-08  -7.84692468734898E-19  -2.52759623312033E-01  -2.52759623311454E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78731701991449E-10   0.00000000000000E+00  -5.78731701991449E-10
      3.69358596341399E-18  -2.52759623261031E-01  -2.48697430492842E-01   0.00000000000000E+00  -3.98225713551249E-12
     -9.83776788876113E-23  -1.28896896219491E-08  -1.28936718790847E-08  -2.90889349467909E-18
      7.46293571798321E-12
      0.00000000000000E+00  -1.34722452772861E-11   0.00000000000000E+00  -8.16649144574820E-14   1.78972658110826E-22
      1.34722822860456E-08   1.34722006211313E-08  -7.84644065741410E-19  -2.52779919447522E-01  -2.52779919446952E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70364314936914E-10   0.00000000000000E+00  -5.70364314936914E-10
      3.69352966868045E-18  -2.52779919389124E-01  -2.48715154409805E-01   0.00000000000000E+00  -3.92617159873057E-12
     -9.83780522909796E-23  -1.28979101345883E-08  -1.29018363061872E-08  -2.90888560293904E-18
      7.59618018698031E-12
      0.00000000000000E+00  -1.34719697430744E-11   0.00000000000000E+00  -8.00020065036204E-14   1.79157787988145E-22
      1.34720121577021E-08   1.34719321556958E-08  -7.84580027228548E-19  -2.52806769980852E-01  -2.52806769980293E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59283805660274E-10   0.00000000000000E+00  -5.59283805660274E-10
      3.69345514720675E-18  -2.52806769923065E-01  -2.48738598606868E-01   0.00000000000000E+00  -3.85184444086275E-12
     -9.83785340530501E-23  -1.29087965056028E-08  -1.29126483500438E-08  -2.90887511997820E-18
      7.77606022012639E-12
      0.00000000000000E+00  -1.34716023641256E-11   0.00000000000000E+00  -7.78727590422645E-14   1.79401036231643E-22
      1.34716573057366E-08   1.34715794329777E-08  -7.84495891642747E-19  -2.52842044115755E-01  -2.52842044115211E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44708689360447E-10   0.00000000000000E+00  -5.44708689360447E-10
      3.69335716498965E-18  -2.52842044063413E-01  -2.48769391962247E-01   0.00000000000000E+00  -3.75379593594638E-12
     -9.83791585042668E-23  -1.29231169476852E-08  -1.29268707436213E-08  -2.90886127334690E-18
      8.01889826487360E-12
      0.00000000000000E+00  -1.34711431404396E-11   0.00000000000000E+00  -7.50630988195970E-14   1.79717643922778E-22
      1.34711954805188E-08   1.34711204174202E-08  -7.84386381229936E-19  -2.52887951961526E-01  -2.52887951961000E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25710164209156E-10   0.00000000000000E+00  -5.25710164209156E-10
      3.69322950256127E-18  -2.52887951917192E-01  -2.48809458931534E-01   0.00000000000000E+00  -3.62550971547820E-12
     -9.83799504526490E-23  -1.29417847434908E-08  -1.29454102532063E-08  -2.90884312133133E-18
      8.34672962528234E-12
      0.00000000000000E+00  -1.34705002272791E-11   0.00000000000000E+00  -7.14146013563295E-14   1.80124490233733E-22
      1.34706019058289E-08   1.34705304912277E-08  -7.84245614992547E-19  -2.52946954416820E-01  -2.52946954416319E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01247438170842E-10   0.00000000000000E+00  -5.01247438170842E-10
      3.69306517793171E-18  -2.52946954380033E-01  -2.48860940265045E-01   0.00000000000000E+00  -3.45943198034207E-12
     -9.83809551946718E-23  -1.29658236210721E-08  -1.29692830530526E-08  -2.90881956293916E-18
      8.78930196183413E-12
      0.00000000000000E+00  -1.34698573141187E-11   0.00000000000000E+00  -6.66931870389871E-14   1.80638370504263E-22
      1.34698516405223E-08   1.34697849473354E-08  -7.84067662992757E-19  -2.53021529635493E-01  -2.53021529635022E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70262971981620E-10   0.00000000000000E+00  -4.70262971981620E-10
      3.69285705254941E-18  -2.53021529605123E-01  -2.48925988745728E-01   0.00000000000000E+00  -3.24783328689149E-12
     -9.83822310132889E-23  -1.29962741420689E-08  -1.29995219753558E-08  -2.90878938955665E-18
      9.38677461617904E-12
      0.00000000000000E+00  -1.34688470220094E-11   0.00000000000000E+00  -6.05713191932305E-14   1.81272737999686E-22
      1.34689241144162E-08   1.34688635430972E-08  -7.83847619906178E-19  -2.53113721594943E-01  -2.53113721594511E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31869639687270E-10   0.00000000000000E+00  -4.31869639687270E-10
      3.69259902224945E-18  -2.53113721570357E-01  -2.49006375301885E-01   0.00000000000000E+00  -2.98421858483153E-12
     -9.83838217604929E-23  -1.30340096848235E-08  -1.30369939034085E-08  -2.90875140234328E-18
      1.01933626995447E-11
      0.00000000000000E+00  -1.34677448851629E-11   0.00000000000000E+00  -5.45046656269074E-14   1.82032463754967E-22
      1.34678104623464E-08   1.34677559576810E-08  -7.83583340638649E-19  -2.53224411165880E-01  -2.53224411165494E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85657184321992E-10   0.00000000000000E+00  -3.85657184321992E-10
      3.69228795576031E-18  -2.53224411147267E-01  -2.49102854328075E-01   0.00000000000000E+00  -2.66364829858211E-12
     -9.83857514385042E-23  -1.30794351250597E-08  -1.30820987733583E-08  -2.90870461512166E-18
      1.07378096558165E-11
      0.00000000000000E+00  -1.34671019720024E-11   0.00000000000000E+00  -4.94019522951396E-14   1.82504251752969E-22
      1.34671179705251E-08   1.34670685685729E-08  -7.83418749844792E-19  -2.53293329754533E-01  -2.53293329754177E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.56834483397906E-10   0.00000000000000E+00  -3.56834483397906E-10
      3.69209367831193E-18  -2.53293330446205E-01  -2.49162909824968E-01   0.00000000000000E+00  -2.46460050938920E-12
     -9.83869610847467E-23  -1.31077694846640E-08  -1.31102340851735E-08  -2.90867492846714E-18
      1.09215605035582E-11
      0.00000000000000E+00  -1.34668264377908E-11   0.00000000000000E+00  -4.94465485091187E-14   1.82658974663278E-22
      1.34668907911923E-08   1.34668413446440E-08  -7.83364730240464E-19  -2.53315946756463E-01  -2.53315946756116E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47370316674328E-10   0.00000000000000E+00  -3.47370316674328E-10
      3.69202984872177E-18  -2.53315947350350E-01  -2.49182616163563E-01   0.00000000000000E+00  -2.39733920296142E-12
     -9.83876067184014E-23  -1.31170736887629E-08  -1.31194710279660E-08  -2.90866511848130E-18
      1.11696241480096E-11
      0.00000000000000E+00  -1.34665509035792E-11   0.00000000000000E+00  -4.72127973481973E-14   1.82860120118346E-22
      1.34665948514211E-08   1.34665476386239E-08  -7.83294488836248E-19  -2.53345352127526E-01  -2.53345352127191E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35055366021244E-10   0.00000000000000E+00  -3.35055366021244E-10
      3.69194673366658E-18  -2.53345352509561E-01  -2.49208234191890E-01   0.00000000000000E+00  -2.31226002508127E-12
     -9.83883142944205E-23  -1.31291800125860E-08  -1.31314922726112E-08  -2.90865224483033E-18
      1.15045100680189E-11
      0.00000000000000E+00  -1.34661835246304E-11   0.00000000000000E+00  -4.49612413380793E-14   1.83118102678110E-22
      1.34662150404795E-08   1.34661700792384E-08  -7.83204316845443E-19  -2.53383095782965E-01  -2.53383095782646E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19233012841964E-10   0.00000000000000E+00  -3.19233012841964E-10
      3.69183982702537E-18  -2.53383096201150E-01  -2.49241111965395E-01   0.00000000000000E+00  -2.20213541455472E-12
     -9.83887018534174E-23  -1.31447349309856E-08  -1.31469370664003E-08  -2.90863551017993E-18
      1.19566060600314E-11
      0.00000000000000E+00  -1.34656324562071E-11   0.00000000000000E+00  -4.19096895461454E-14   1.83442896874146E-22
      1.34657352872937E-08   1.34656933776043E-08  -7.83090514848655E-19  -2.53430721340389E-01  -2.53430721340089E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99247978927116E-10   0.00000000000000E+00  -2.99247978927116E-10
      3.69170453821349E-18  -2.53430721659239E-01  -2.49282591363988E-01   0.00000000000000E+00  -2.06264739828927E-12
     -9.83894329027224E-23  -1.31643827512779E-08  -1.31664453986763E-08  -2.90861402336483E-18
      1.25669356492484E-11
      0.00000000000000E+00  -1.34651732325211E-11   0.00000000000000E+00  -3.80779298491101E-14   1.83842081641085E-22
      1.34651435910109E-08   1.34651055130813E-08  -7.82950092044238E-19  -2.53489472525421E-01  -2.53489472525147E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74571095286975E-10   0.00000000000000E+00  -2.74571095286975E-10
      3.69153695934969E-18  -2.53489472767428E-01  -2.49333753272010E-01   0.00000000000000E+00  -1.88969337746067E-12
     -9.83904613495265E-23  -1.31886447244177E-08  -1.31905344177953E-08  -2.90858686730545E-18
      1.33908805946913E-11
      0.00000000000000E+00  -1.34644384746234E-11   0.00000000000000E+00  -3.31953171874489E-14   1.84317447145282E-22
      1.34644353906868E-08   1.34644021953698E-08  -7.82781877250981E-19  -2.53559826884791E-01  -2.53559826884546E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44999190033956E-10   0.00000000000000E+00  -2.44999190033956E-10
      3.69133509350542E-18  -2.53559827144426E-01  -2.49395012745243E-01   0.00000000000000E+00  -1.68184018324001E-12
     -9.83917378025447E-23  -1.32177211651538E-08  -1.32194030053371E-08  -2.90855321625445E-18
      1.45032062710393E-11
      0.00000000000000E+00  -1.34636118719886E-11   0.00000000000000E+00  -2.89942529598411E-14   1.84860712188086E-22
      1.34636197720845E-08   1.34635907778317E-08  -7.82587987407643E-19  -2.53640880160716E-01  -2.53640880160505E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10921776874552E-10   0.00000000000000E+00  -2.10921776874552E-10
      3.69110047979731E-18  -2.53640880514865E-01  -2.49465585387680E-01   0.00000000000000E+00  -1.43994461065551E-12
     -9.83932584608965E-23  -1.32512290563446E-08  -1.32526690009553E-08  -2.90851249238966E-18
      1.60048459341090E-11
      0.00000000000000E+00  -1.34626934246165E-11   0.00000000000000E+00  -2.30366139435960E-14   1.85449003348555E-22
      1.34627326761298E-08   1.34627096395160E-08  -7.82375283653954E-19  -2.53729738126648E-01  -2.53729738126474E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73603162662341E-10   0.00000000000000E+00  -1.73603162662341E-10
      3.69083979040261E-18  -2.53729735976287E-01  -2.49542961286800E-01   0.00000000000000E+00  -1.17501434670745E-12
     -9.83949489442946E-23  -1.32879314625061E-08  -1.32891064768529E-08  -2.90846450674866E-18
      1.62582476272520E-11
      0.00000000000000E+00  -1.34626015798793E-11   0.00000000000000E+00  -2.28976747926960E-14   1.85544302473404E-22
      1.34625868466442E-08   1.34625639489696E-08  -7.82340735791321E-19  -2.53744167957509E-01  -2.53744167957341E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67540755488563E-10   0.00000000000000E+00  -1.67540755488563E-10
      3.69079733529150E-18  -2.53744165480606E-01  -2.49555526595061E-01   0.00000000000000E+00  -1.13161446189400E-12
     -9.83952048482545E-23  -1.32938915790241E-08  -1.32950231934860E-08  -2.90845659950018E-18
      1.66003399129950E-11
      0.00000000000000E+00  -1.34623260456676E-11   0.00000000000000E+00  -2.19893111567060E-14   1.85666056439726E-22
      1.34623981745404E-08   1.34623761852294E-08  -7.82296424271951E-19  -2.53762672134294E-01  -2.53762672134134E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59765748421295E-10   0.00000000000000E+00  -1.59765748421295E-10
      3.69074268066144E-18  -2.53762669521095E-01  -2.49571640271005E-01   0.00000000000000E+00  -1.07654264397952E-12
     -9.83955592005582E-23  -1.33015338941652E-08  -1.33026104368093E-08  -2.90844625638949E-18
      1.70621644987482E-11
      0.00000000000000E+00  -1.34621423561932E-11   0.00000000000000E+00  -2.04890974614515E-14   1.85818732681584E-22
      1.34621606698540E-08   1.34621401807567E-08  -7.82240560499438E-19  -2.53785994547979E-01  -2.53785994547829E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49970957130454E-10   0.00000000000000E+00  -1.49970957130454E-10
      3.69067342038629E-18  -2.53785992082206E-01  -2.49591951334068E-01   0.00000000000000E+00  -1.00697201211238E-12
     -9.83960169125568E-23  -1.33111622516149E-08  -1.33121692236271E-08  -2.90843285988685E-18
      1.76856276895149E-11
      0.00000000000000E+00  -1.34618668219816E-11   0.00000000000000E+00  -1.85378109920802E-14   1.86005456324393E-22
      1.34618695680826E-08   1.34618510302718E-08  -7.82171714063598E-19  -2.53814727078041E-01  -2.53814727077903E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37918054853942E-10   0.00000000000000E+00  -1.37918054853942E-10
      3.69058743355575E-18  -2.53814725036243E-01  -2.49616978124579E-01   0.00000000000000E+00  -9.21066459135118E-13
     -9.83965859842802E-23  -1.33230119089567E-08  -1.33239329754160E-08  -2.90841571949215E-18
      1.85273029970500E-11
      0.00000000000000E+00  -1.34614994430328E-11   0.00000000000000E+00  -1.64321027634433E-14   1.86226333089106E-22
      1.34615228453107E-08   1.34615064132081E-08  -7.82089350086000E-19  -2.53849084177569E-01  -2.53849084177445E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23535460231721E-10   0.00000000000000E+00  -1.23535460231721E-10
      3.69048345680927E-18  -2.53849082820952E-01  -2.49646913206049E-01   0.00000000000000E+00  -8.18102406246538E-13
     -9.83972768330049E-23  -1.33371528505710E-08  -1.33379709529774E-08  -2.90839410672327E-18
      1.96635646622224E-11
      0.00000000000000E+00  -1.34611320640840E-11   0.00000000000000E+00  -1.39939073282117E-14   1.86476328412349E-22
      1.34611246977878E-08   1.34611107038807E-08  -7.81994524256295E-19  -2.53888611793013E-01  -2.53888611792906E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07046903609811E-10   0.00000000000000E+00  -1.07046903609811E-10
      3.69036182351632E-18  -2.53888611403463E-01  -2.49681371723437E-01   0.00000000000000E+00  -6.99894216655414E-13
     -9.83980925994549E-23  -1.33533639060532E-08  -1.33540638002700E-08  -2.90836729926002E-18
      2.04305412862137E-11
      0.00000000000000E+00  -1.34608565298723E-11   0.00000000000000E+00  -1.25389997427586E-14   1.86625512655578E-22
      1.34608841651783E-08   1.34608716261788E-08  -7.81937174084973E-19  -2.53912504922784E-01  -2.53912504922687E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71089066320138E-11   0.00000000000000E+00  -9.71089066320138E-11
      3.69028734325495E-18  -2.53912505190283E-01  -2.49702209857688E-01   0.00000000000000E+00  -6.28593996395882E-13
     -9.83985959007849E-23  -1.33631341255500E-08  -1.33637627195465E-08  -2.90835016916998E-18
      2.14659597286021E-11
      0.00000000000000E+00  -1.34605809956607E-11   0.00000000000000E+00  -1.06463150095582E-14   1.86796316415378E-22
      1.34606035031761E-08   1.34605928568613E-08  -7.81870187188850E-19  -2.53940391827885E-01  -2.53940391827800E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55640334433710E-11   0.00000000000000E+00  -8.55640334433710E-11
      3.69019874867672E-18  -2.53940392979914E-01  -2.49726548318635E-01   0.00000000000000E+00  -5.45858008745388E-13
     -9.83992009164198E-23  -1.33744829654094E-08  -1.33750288234182E-08  -2.90832856148787E-18
      2.28637746258263E-11
      0.00000000000000E+00  -1.34603054614491E-11   0.00000000000000E+00  -8.52791976993057E-15   1.86981342641585E-22
      1.34602903327001E-08   1.34602818047806E-08  -7.81795349491757E-19  -2.53971513040382E-01  -2.53971513040309E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27796393109960E-11   0.00000000000000E+00  -7.27796393109960E-11
      3.69009701621267E-18  -2.53971515371767E-01  -2.49753741056290E-01   0.00000000000000E+00  -4.54133286258825E-13
     -9.83999058024941E-23  -1.33870480321837E-08  -1.33875021654700E-08  -2.90830166672092E-18
      2.47508247370791E-11
      0.00000000000000E+00  -1.34599380825003E-11   0.00000000000000E+00  -6.13477758996094E-15   1.87167428054093E-22
      1.34599598570887E-08   1.34599537223113E-08  -7.81716237638332E-19  -2.54004358743677E-01  -2.54004358743617E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.94630651028126E-11   0.00000000000000E+00  -5.94630651028126E-11
      3.68998480642906E-18  -2.54004362625174E-01  -2.49782496420500E-01   0.00000000000000E+00  -3.58669388550362E-13
     -9.84006989380422E-23  -1.34001319878204E-08  -1.34004906572090E-08  -2.90826856879073E-18
      2.72983423872703E-11
      0.00000000000000E+00  -1.34595707035514E-11   0.00000000000000E+00  -3.62788437378614E-15   1.87336357632514E-22
      1.34596337312471E-08   1.34596301033629E-08  -7.81637959318555E-19  -2.54036780231473E-01  -2.54036780231427E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66196546846440E-11   0.00000000000000E+00  -4.66196546846440E-11
      3.68986604203590E-18  -2.54036786098977E-01  -2.49810975728414E-01   0.00000000000000E+00  -2.66734474093694E-13
     -9.84015614417778E-23  -1.34127437142036E-08  -1.34130104486778E-08  -2.90822808271735E-18
      3.07374912150284E-11
      0.00000000000000E+00  -1.34592951693398E-11   0.00000000000000E+00  -3.44850953761011E-15   1.87468040519025E-22
      1.34593352879450E-08   1.34593318394356E-08  -7.81566032016553E-19  -2.54066464294887E-01  -2.54066464294852E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53536435543696E-11   0.00000000000000E+00  -3.53536435543696E-11
      3.68974445559411E-18  -2.54066472602994E-01  -2.49837206380163E-01   0.00000000000000E+00  -1.84088097321664E-13
     -9.84024763026154E-23  -1.34237941077839E-08  -1.34239781958813E-08  -2.90817842357756E-18
      3.30589166737651E-11
      0.00000000000000E+00  -1.34592033246026E-11   0.00000000000000E+00  -2.75992853112679E-15   1.87525006824885E-22
      1.34591811424257E-08   1.34591783824974E-08  -7.81528751189486E-19  -2.54081803804733E-01  -2.54081803804703E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97754776686931E-11   0.00000000000000E+00  -2.97754776686931E-11
      3.68967533404221E-18  -2.54081813638282E-01  -2.49850838321400E-01   0.00000000000000E+00  -1.43792536135091E-13
     -9.84030097101005E-23  -1.34292591122922E-08  -1.34294029048285E-08  -2.90814658285272E-18
      3.38423977660888E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.85571290790921E-15   1.87541006689247E-22
      1.34591338705509E-08   1.34591310148382E-08  -7.81517312202714E-19  -2.54086504658414E-01  -2.54086504658386E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80982582157138E-11   0.00000000000000E+00  -2.80982582157138E-11
      3.68965331958817E-18  -2.54086515014488E-01  -2.49855026106406E-01   0.00000000000000E+00  -1.31382993289513E-13
     -9.84031855336314E-23  -1.34309013736276E-08  -1.34310327566210E-08  -2.90813600738545E-18
      3.49000972407257E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.23025045385107E-15   1.87557587349540E-22
      1.34590775971090E-08   1.34590753668588E-08  -7.81503656706508E-19  -2.54092107066368E-01  -2.54092107066342E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61550687634030E-11   0.00000000000000E+00  -2.61550687634030E-11
      3.68962565538568E-18  -2.54092118074593E-01  -2.49860034604167E-01   0.00000000000000E+00  -1.17741267597175E-13
     -9.84033995805120E-23  -1.34328025568282E-08  -1.34329202980959E-08  -2.90812199867917E-18
      3.63279915314855E-11
      0.00000000000000E+00  -1.34590196351282E-11   0.00000000000000E+00  -1.91075614972949E-15   1.87572547292662E-22
      1.34590128361052E-08   1.34590109253492E-08  -7.81487883891789E-19  -2.54098563951073E-01  -2.54098563951049E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40093395718945E-11   0.00000000000000E+00  -2.40093395718945E-11
      3.68959137258678E-18  -2.54098575777740E-01  -2.49865836599966E-01   0.00000000000000E+00  -1.02324643591306E-13
     -9.84036730956652E-23  -1.34348992611358E-08  -1.34350015857795E-08  -2.90810348869499E-18
      3.82556488240113E-11
      0.00000000000000E+00  -1.34589277903910E-11   0.00000000000000E+00  -1.57783592575830E-15   1.87582445557908E-22
      1.34589409399208E-08   1.34589393620851E-08  -7.81470320225899E-19  -2.54105733985998E-01  -2.54105733985976E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17797817046162E-11   0.00000000000000E+00  -2.17797817046162E-11
      3.68954938863175E-18  -2.54105746830094E-01  -2.49872327780782E-01   0.00000000000000E+00  -8.63476884284698E-14
     -9.84040143034907E-23  -1.34370732326914E-08  -1.34371595803799E-08  -2.90807906840585E-18
      4.08579861689211E-11
      0.00000000000000E+00  -1.34588359456538E-11   0.00000000000000E+00  -1.25240945969689E-15   1.87582635938075E-22
      1.34588639982355E-08   1.34588627458262E-08  -7.81451450297526E-19  -2.54113413001618E-01  -2.54113413001598E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96316363875848E-11   0.00000000000000E+00  -1.96316363875848E-11
      3.68949830049123E-18  -2.54113427064564E-01  -2.49879355387175E-01   0.00000000000000E+00  -7.10252952010184E-14
     -9.84044372825898E-23  -1.34391600841440E-08  -1.34392311094393E-08  -2.90804685019371E-18
      4.43711415845494E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -1.02429221727307E-15   1.87567661468966E-22
      1.34587837993244E-08   1.34587827750324E-08  -7.81431703148892E-19  -2.54121427964611E-01  -2.54121427964593E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77417725277864E-11   0.00000000000000E+00  -1.77417725277864E-11
      3.68943597088699E-18  -2.54121443405261E-01  -2.49886801511174E-01   0.00000000000000E+00  -5.75984490703378E-14
     -9.84049628634228E-23  -1.34409834040551E-08  -1.34410410025043E-08  -2.90800426773810E-18
      4.55568315373239E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.50867957725100E-16   1.87561156384258E-22
      1.34587590076638E-08   1.34587580567960E-08  -7.81425590623951E-19  -2.54123907036839E-01  -2.54123907036822E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72008601536132E-11   0.00000000000000E+00  -1.72008601536132E-11
      3.68941557599993E-18  -2.54123922912653E-01  -2.49889118391645E-01   0.00000000000000E+00  -5.37801884969353E-14
     -9.84051356812367E-23  -1.34415034164541E-08  -1.34415571966426E-08  -2.90798998537598E-18
      4.57569167168546E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.38370923234760E-16   1.87560018566688E-22
      1.34587548866277E-08   1.34587539482570E-08  -7.81424574391552E-19  -2.54124319140261E-01  -2.54124319140244E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71122566290783E-11   0.00000000000000E+00  -1.71122566290783E-11
      3.68941215209099E-18  -2.54124335088512E-01  -2.49889503947548E-01   0.00000000000000E+00  -5.31557618196226E-14
     -9.84051646902699E-23  -1.34415885358648E-08  -1.34416416916267E-08  -2.90798757769944E-18
      4.60270317092211E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.22048105449451E-16   1.87558412433015E-22
      1.34587494333894E-08   1.34587485113415E-08  -7.81423229179975E-19  -2.54124864568219E-01  -2.54124864568202E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69973179531883E-11   0.00000000000000E+00  -1.69973179531883E-11
      3.68940756086058E-18  -2.54124880612907E-01  -2.49890014973668E-01   0.00000000000000E+00  -5.23468278480203E-14
     -9.84052037497579E-23  -1.34416988465551E-08  -1.34417511933830E-08  -2.90798433168061E-18
      4.63916869489158E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.01231398000146E-16   1.87556123779732E-22
      1.34587422611562E-08   1.34587413599250E-08  -7.81421459245207E-19  -2.54125582080793E-01  -2.54125582080776E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68502093707652E-11   0.00000000000000E+00  -1.68502093707652E-11
      3.68940141634345E-18  -2.54125598252985E-01  -2.49890688520593E-01   0.00000000000000E+00  -5.13130959089983E-14
     -9.84052561423200E-23  -1.34418398374601E-08  -1.34418911505561E-08  -2.90797995709824E-18
      4.68839715225036E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.75132569499992E-16   1.87552831610845E-22
      1.34587328992589E-08   1.34587320241265E-08  -7.81419147999315E-19  -2.54126518877357E-01  -2.54126518877340E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66652414018566E-11   0.00000000000000E+00  -1.66652414018566E-11
      3.68939321230219E-18  -2.54126535216673E-01  -2.49891570151857E-01   0.00000000000000E+00  -5.00162368056572E-14
     -9.84053261860949E-23  -1.34420167664837E-08  -1.34420667827206E-08  -2.90797406430287E-18
      4.75485556968472E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.43181683132310E-16   1.87548055019849E-22
      1.34587207900717E-08   1.34587199468902E-08  -7.81416157242309E-19  -2.54127730958200E-01  -2.54127730958184E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64380155524026E-11   0.00000000000000E+00  -1.64380155524026E-11
      3.68938228785719E-18  -2.54127747514140E-01  -2.49892714667436E-01   0.00000000000000E+00  -4.84284067154361E-14
     -9.84054196382065E-23  -1.34422335029339E-08  -1.34422819313407E-08  -2.90796613061489E-18
      4.84457443322111E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.05244513367918E-16   1.87541079689607E-22
      1.34587052892975E-08   1.34587044840532E-08  -7.81412327508623E-19  -2.54129283142708E-01  -2.54129283142692E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61671516388251E-11   0.00000000000000E+00  -1.61671516388251E-11
      3.68936778287248E-18  -2.54129299975135E-01  -2.49894186665283E-01   0.00000000000000E+00  -4.65450168527783E-14
     -9.84055440703980E-23  -1.34424907873962E-08  -1.34425373324132E-08  -2.90795545536386E-18
      4.96569489899523E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.61980954994003E-16   1.87530863763841E-22
      1.34586856622617E-08   1.34586849002809E-08  -7.81407478037161E-19  -2.54131249492518E-01  -2.54131249492502E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58564053864576E-11   0.00000000000000E+00  -1.58564053864576E-11
      3.68934857752042E-18  -2.54131266670194E-01  -2.49896061630958E-01   0.00000000000000E+00  -4.44005691334519E-14
     -9.84057093912457E-23  -1.34427840943245E-08  -1.34428284948938E-08  -2.90794109948326E-18
      5.12920752779030E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.15490332742022E-16   1.87515929224762E-22
      1.34586610561080E-08   1.34586603406179E-08  -7.81401402153774E-19  -2.54133716125683E-01  -2.54133716125667E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55164813100717E-11   0.00000000000000E+00  -1.55164813100717E-11
      3.68932320611393E-18  -2.54133733720941E-01  -2.49898429327941E-01   0.00000000000000E+00  -4.20819380204590E-14
     -9.84059286199213E-23  -1.34431017773703E-08  -1.34431438593084E-08  -2.90792180396016E-18
      5.18439304000863E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.49590928829870E-15   1.87510937396624E-22
      1.34586511077864E-08   1.34586496118773E-08  -7.81399402375908E-19  -2.54134528268065E-01  -2.54134528268049E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54077700997462E-11   0.00000000000000E+00  -1.54077700997462E-11
      3.68931470325708E-18  -2.54134546191546E-01  -2.49899210732483E-01   0.00000000000000E+00  -4.07481895067903E-14
     -9.84079650615345E-23  -1.34432010935876E-08  -1.34432418417772E-08  -2.90791530088117E-18
      5.19370559519547E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.37748756418905E-16   1.87510100130540E-22
      1.34586500502576E-08   1.34586495125090E-08  -7.81399066196336E-19  -2.54134664836919E-01  -2.54134664836904E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53898180474692E-11   0.00000000000000E+00  -1.53898180474692E-11
      3.68931327007178E-18  -2.54134683141178E-01  -2.49899342254948E-01   0.00000000000000E+00  -4.15594010365138E-14
     -9.84102413794441E-23  -1.34432181350554E-08  -1.34432596944565E-08  -2.90791420387545E-18
      5.20627754469771E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.54509597170876E-16   1.87508959639338E-22
      1.34586485802963E-08   1.34586480257869E-08  -7.81398614814168E-19  -2.54134848231861E-01  -2.54134848231845E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53663468153147E-11   0.00000000000000E+00  -1.53663468153147E-11
      3.68931133822242E-18  -2.54134866794497E-01  -2.49899518982196E-01   0.00000000000000E+00  -4.12780611817094E-14
     -9.84093231330379E-23  -1.34432404009192E-08  -1.34432816789805E-08  -2.90791272340825E-18
      5.22324967652574E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.98573190394716E-16   1.87507383096724E-22
      1.34586464468675E-08   1.34586458482945E-08  -7.81398009846174E-19  -2.54135094065134E-01  -2.54135094065119E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53357243527434E-11   0.00000000000000E+00  -1.53357243527434E-11
      3.68930873542307E-18  -2.54135112790695E-01  -2.49899756017051E-01   0.00000000000000E+00  -4.09142108843827E-14
     -9.84078480788972E-23  -1.34432692097296E-08  -1.34433101239406E-08  -2.90791072557689E-18
      5.24616205449357E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.16071595793381E-16   1.87505184357476E-22
      1.34586434910228E-08   1.34586428749514E-08  -7.81397200901584E-19  -2.54135422864273E-01  -2.54135422864258E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52958012952476E-11   0.00000000000000E+00  -1.52958012952476E-11
      3.68930523079126E-18  -2.54135441707402E-01  -2.49900073293054E-01   0.00000000000000E+00  -4.05675860259406E-14
     -9.84068433465340E-23  -1.34433065060654E-08  -1.34433470736515E-08  -2.90790802988968E-18
      5.27709376475014E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.33574765372601E-16   1.87502137048559E-22
      1.34586394005299E-08   1.34586387669553E-08  -7.81396122402230E-19  -2.54135861375867E-01  -2.54135861375851E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52440153246255E-11   0.00000000000000E+00  -1.52440153246255E-11
      3.68930051555661E-18  -2.54135880313464E-01  -2.49900496878547E-01   0.00000000000000E+00  -4.01976711700049E-14
     -9.84063820343400E-23  -1.34433545539579E-08  -1.34433947516292E-08  -2.90790439315438E-18
      5.31885157359651E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.48947931092217E-16   1.87497962731239E-22
      1.34586337647144E-08   1.34586331157667E-08  -7.81394689835848E-19  -2.54136444143608E-01  -2.54136444143593E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51776426804736E-11   0.00000000000000E+00  -1.51776426804736E-11
      3.68929417770559E-18  -2.54136463166184E-01  -2.49901060601466E-01   0.00000000000000E+00  -3.97578488189832E-14
     -9.84062500663712E-23  -1.34434157152339E-08  -1.34434554730828E-08  -2.90789948786974E-18
      5.37522461553911E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.51647771181195E-16   1.87492272495126E-22
      1.34586261530677E-08   1.34586255014201E-08  -7.81392795411964E-19  -2.54137215382027E-01  -2.54137215382012E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50941664630237E-11   0.00000000000000E+00  -1.50941664630237E-11
      3.68928566866480E-18  -2.54137234497682E-01  -2.49901808033344E-01   0.00000000000000E+00  -3.92159619227666E-14
     -9.84062692452778E-23  -1.34434921189959E-08  -1.34435313349579E-08  -2.90789287325284E-18
      5.45132822216163E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.42646544244900E-16   1.87484493484230E-22
      1.34586160604656E-08   1.34586154178193E-08  -7.81390303020119E-19  -2.54138231225942E-01  -2.54138231225927E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49917656703489E-11   0.00000000000000E+00  -1.49917656703489E-11
      3.68927425939043E-18  -2.54138250455980E-01  -2.49902794908018E-01   0.00000000000000E+00  -3.85525537417077E-14
     -9.84063558162628E-23  -1.34435850995960E-08  -1.34436236521498E-08  -2.90788395637031E-18
      5.55406809110202E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.27463216032330E-16   1.87473803515279E-22
      1.34586028201802E-08   1.34586021927172E-08  -7.81387042030558E-19  -2.54139562643549E-01  -2.54139562643534E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48699530423591E-11   0.00000000000000E+00  -1.48699530423591E-11
      3.68925898202016E-18  -2.54139582011504E-01  -2.49904092254280E-01   0.00000000000000E+00  -3.77665785006828E-14
     -9.84064865158528E-23  -1.34436944730959E-08  -1.34437322396745E-08  -2.90787193998960E-18
      5.69276691417155E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.09522555684737E-16   1.87459061583539E-22
      1.34585855505049E-08   1.34585849409825E-08  -7.81382798689677E-19  -2.54141299700216E-01  -2.54141299700201E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47302686154333E-11   0.00000000000000E+00  -1.47302686154333E-11
      3.68923855131095E-18  -2.54141319221088E-01  -2.49905790893139E-01   0.00000000000000E+00  -3.68785089314764E-14
     -9.84066642901598E-23  -1.34438177938571E-08  -1.34438546723661E-08  -2.90785575262128E-18
      5.88001032531541E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.90400941848260E-16   1.87438718073047E-22
      1.34585630989881E-08   1.34585625085873E-08  -7.81377302729744E-19  -2.54143558451278E-01  -2.54143558451263E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45766780686571E-11   0.00000000000000E+00  -1.45766780686571E-11
      3.68921125744171E-18  -2.54143578119590E-01  -2.49908008472580E-01   0.00000000000000E+00  -3.59297280999859E-14
     -9.84069025744481E-23  -1.34439499007907E-08  -1.34439858305189E-08  -2.90783395471196E-18
      6.13278893035963E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.71273448226568E-16   1.87410703043382E-22
      1.34585339385877E-08   1.34585333673144E-08  -7.81370206017500E-19  -2.54146492283069E-01  -2.54146492283055E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44150955416775E-11   0.00000000000000E+00  -1.44150955416775E-11
      3.68917481916428E-18  -2.54146512054365E-01  -2.49910900684894E-01   0.00000000000000E+00  -3.49780705319134E-14
     -9.84072213185675E-23  -1.34440832937015E-08  -1.34441182717721E-08  -2.90780461314678E-18
      6.47404004716933E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.53299537373531E-16   1.87372295686593E-22
      1.34584959985878E-08   1.34584954452885E-08  -7.81361051233688E-19  -2.54150309379658E-01  -2.54150309379644E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42515397893826E-11   0.00000000000000E+00  -1.42515397893826E-11
      3.68912618562559E-18  -2.54150329137858E-01  -2.49914678191766E-01   0.00000000000000E+00  -3.40854000975293E-14
     -9.84076475936117E-23  -1.34442098200981E-08  -1.34442439054983E-08  -2.90776513439190E-18
      6.93472905486242E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.37226690015294E-16   1.87319966811645E-22
      1.34584464423734E-08   1.34584459051469E-08  -7.81349233529075E-19  -2.54155296478561E-01  -2.54155296478547E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40891142873774E-11   0.00000000000000E+00  -1.40891142873774E-11
      3.68906127862478E-18  -2.54155315962730E-01  -2.49919629457887E-01   0.00000000000000E+00  -3.32969422081830E-14
     -9.84082178059171E-23  -1.34443234939176E-08  -1.34443567908599E-08  -2.90771204509571E-18
      7.55665921524809E-11
      0.00000000000000E+00  -1.34583767219677E-11   0.00000000000000E+00  -5.22834287100500E-16   1.87249168828584E-22
      1.34583814478993E-08   1.34583809250652E-08  -7.81333966292839E-19  -2.54161846520050E-01  -2.54161846520036E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39251075278571E-11   0.00000000000000E+00  -1.39251075278571E-11
      3.68897467418121E-18  -2.54161865091339E-01  -2.49926147395906E-01   0.00000000000000E+00  -3.26210905215400E-14
     -9.84089807824997E-23  -1.34444231964462E-08  -1.34444558175368E-08  -2.90764070788837E-18
      8.39626493176874E-11
      0.00000000000000E+00  -1.34582848772305E-11   0.00000000000000E+00  -5.08650273649586E-16   1.87154043090357E-22
      1.34582960938960E-08   1.34582955852459E-08  -7.81314268633864E-19  -2.54170486336345E-01  -2.54170486336331E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37500700306594E-11   0.00000000000000E+00  -1.37500700306594E-11
      3.68885922780720E-18  -2.54170502123053E-01  -2.49934756178742E-01   0.00000000000000E+00  -3.20227354117388E-14
     -9.84100016198324E-23  -1.34445134924798E-08  -1.34445455152154E-08  -2.90754495917334E-18
      9.52973264907162E-11
      0.00000000000000E+00  -1.34581930324933E-11   0.00000000000000E+00  -4.92250501089068E-16   1.87027038050337E-22
      1.34581844713532E-08   1.34581839791028E-08  -7.81288991247787E-19  -2.54181902410609E-01  -2.54181902410595E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35497079007904E-11   0.00000000000000E+00  -1.35497079007904E-11
      3.68870564624236E-18  -2.54181909376458E-01  -2.49946135483352E-01   0.00000000000000E+00  -3.14357199258551E-14
     -9.84113662679302E-23  -1.34446028354821E-08  -1.34446342712021E-08  -2.90741665499457E-18
      1.10599140674305E-10
      0.00000000000000E+00  -1.34580093430189E-11   0.00000000000000E+00  -4.72131443414815E-16   1.86858469936360E-22
      1.34580398207461E-08   1.34580393486148E-08  -7.81256892105958E-19  -2.54196965943133E-01  -2.54196965943119E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33081982243406E-11   0.00000000000000E+00  -1.33081982243406E-11
      3.68850200666601E-18  -2.54196945975991E-01  -2.49961141579220E-01   0.00000000000000E+00  -3.07866762868562E-14
     -9.84131868267197E-23  -1.34447003637141E-08  -1.34447311503905E-08  -2.90724511456005E-18
      1.30599140674305E-10
      0.00000000000000E+00  -1.34578256535445E-11   0.00000000000000E+00  -4.55626999704301E-16   1.86642975814438E-22
      1.34578575031024E-08   1.34578570474756E-08  -7.81217971626752E-19  -2.54216137980046E-01  -2.54216137980033E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30181056495344E-11   0.00000000000000E+00  -1.30181056495344E-11
      3.68824164455302E-18  -2.54216057289230E-01  -2.49980218955680E-01   0.00000000000000E+00  -3.00488562471655E-14
     -9.84155325714967E-23  -1.34448088929697E-08  -1.34448389418260E-08  -2.90702367292626E-18
      1.50599140674305E-10
      0.00000000000000E+00  -1.34576419640701E-11   0.00000000000000E+00  -4.56867363713471E-16   1.86431991202441E-22
      1.34576735953121E-08   1.34576731384449E-08  -7.81181811511859E-19  -2.54234818793596E-01  -2.54234818793583E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27424703771128E-11   0.00000000000000E+00  -1.27424703771128E-11
      3.68798679514548E-18  -2.54234680765273E-01  -2.49998813556786E-01   0.00000000000000E+00  -2.94144454787514E-14
     -9.84178493559518E-23  -1.34449012536222E-08  -1.34449306680677E-08  -2.90680498363362E-18
      1.70599140674305E-10
      0.00000000000000E+00  -1.34574582745956E-11   0.00000000000000E+00  -4.87401558354482E-16   1.86225106239420E-22
      1.34574763812659E-08   1.34574758938645E-08  -7.81148217579441E-19  -2.54253008499432E-01  -2.54253008499419E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24736720984432E-11   0.00000000000000E+00  -1.24736720984432E-11
      3.68773732170351E-18  -2.54252880463419E-01  -2.50016990734936E-01   0.00000000000000E+00  -2.89039783441548E-14
     -9.84201450832365E-23  -1.34449733177877E-08  -1.34450022217661E-08  -2.90658910412407E-18
      1.90599140674305E-10
      0.00000000000000E+00  -1.34572745851212E-11   0.00000000000000E+00  -5.38128647238487E-16   1.86021949927004E-22
      1.34572578546996E-08   1.34572573165711E-08  -7.81117018201672E-19  -2.54270705673179E-01  -2.54270705673167E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22090794473291E-11   0.00000000000000E+00  -1.22090794473291E-11
      3.68749314011456E-18  -2.54270732839901E-01  -2.50034828636943E-01   0.00000000000000E+00  -2.85275492824088E-14
     -9.84224289094503E-23  -1.34450197095743E-08  -1.34450482371237E-08  -2.90637612191289E-18
      2.10599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00  -5.82188639436795E-16   1.85822380253632E-22
      1.34570263834710E-08   1.34570258012826E-08  -7.81087980892380E-19  -2.54287944221726E-01  -2.54287944221714E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19561561766735E-11   0.00000000000000E+00  -1.19561561766735E-11
      3.68725401699103E-18  -2.54288301066803E-01  -2.50052390137393E-01   0.00000000000000E+00  -2.82166013110224E-14
     -9.84247049860680E-23  -1.34450414285045E-08  -1.34450696451059E-08  -2.90616603609865E-18
      2.30599140674305E-10
      0.00000000000000E+00  -1.34568153614352E-11   0.00000000000000E+00  -5.09394409390613E-16   1.85626688037656E-22
      1.34568190797995E-08   1.34568185704052E-08  -7.81060720980987E-19  -2.54304834860635E-01  -2.54304834860623E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17357318696026E-11   0.00000000000000E+00  -1.17357318696026E-11
      3.68701930235364E-18  -2.54305582775725E-01  -2.50069667715644E-01   0.00000000000000E+00  -2.78514157428205E-14
     -9.84269628587321E-23  -1.34450549871197E-08  -1.34450828385356E-08  -2.90595858137265E-18
      2.50599140674305E-10
      0.00000000000000E+00  -1.34566316719608E-11   0.00000000000000E+00  -3.08379995768168E-16   1.85435638955605E-22
      1.34567006689617E-08   1.34567003605819E-08  -7.81034675762204E-19  -2.54321577646073E-01  -2.54321577646061E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15763453001812E-11   0.00000000000000E+00  -1.15763453001812E-11
      3.68678777544763E-18  -2.54322453725569E-01  -2.50086525708334E-01   0.00000000000000E+00  -2.71345464513934E-14
     -9.84291703359038E-23  -1.34450968807352E-08  -1.34451240152818E-08  -2.90575309968543E-18
      2.70599140674305E-10
      0.00000000000000E+00  -1.34567235166980E-11   0.00000000000000E+00   8.67615071157266E-17   1.85250096493865E-22
      1.34567323462266E-08   1.34567324329883E-08  -7.81009251604242E-19  -2.54338395848027E-01  -2.54338395848016E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14935009591451E-11   0.00000000000000E+00  -1.14935009591451E-11
      3.68655790542845E-18  -2.54338661350198E-01  -2.50102697156754E-01   0.00000000000000E+00  -2.59545940293198E-14
     -9.84312792709511E-23  -1.34452129774350E-08  -1.34452389320291E-08  -2.90554865382421E-18
      2.90599140674305E-10
      0.00000000000000E+00  -1.34569072061724E-11   0.00000000000000E+00   4.27387962305195E-16   1.85070072451534E-22
      1.34569036573941E-08   1.34569040847822E-08  -7.80984215219950E-19  -2.54355357254579E-01  -2.54355357254567E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14554658242157E-11   0.00000000000000E+00  -1.14554658242157E-11
      3.68632879611197E-18  -2.54353940405174E-01  -2.50117910167886E-01   0.00000000000000E+00  -2.43688822766598E-14
     -9.84332554775456E-23  -1.34454242500757E-08  -1.34454486189581E-08  -2.90534458089201E-18
      3.10599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00   3.72654020174485E-16   1.84893435851145E-22
      1.34570495118215E-08   1.34570498844757E-08  -7.80960240927700E-19  -2.54372120935373E-01  -2.54372120935361E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13533876881619E-11   0.00000000000000E+00  -1.13533876881619E-11
      3.68610172835820E-18  -2.54368290853094E-01  -2.50132182542596E-01   0.00000000000000E+00  -2.31342592093035E-14
     -9.84351330477770E-23  -1.34456733625282E-08  -1.34456964967875E-08  -2.90514148743050E-18
      3.30599140674305E-10
      0.00000000000000E+00  -1.34568153614352E-11   0.00000000000000E+00  -5.65536436632373E-16   1.84715162404744E-22
      1.34568188444574E-08   1.34568182789211E-08  -7.80939249522970E-19  -2.54387774578374E-01  -2.54387774578362E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10122774187538E-11   0.00000000000000E+00  -1.10122774187538E-11
      3.68588148280983E-18  -2.54382342696989E-01  -2.50146199902361E-01   0.00000000000000E+00  -2.35515543090530E-14
     -9.84370690015159E-23  -1.34457824499480E-08  -1.34458060015024E-08  -2.90494223328686E-18
      3.50599140674305E-10
      0.00000000000000E+00  -1.34558050693259E-11   0.00000000000000E+00  -2.46694154055258E-15   1.84528615641279E-22
      1.34557947871150E-08   1.34557923201737E-08  -7.80923914753442E-19  -2.54401048744471E-01  -2.54401048744461E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02848640651369E-11   0.00000000000000E+00  -1.02848640651369E-11
      3.68567578552852E-18  -2.54397543685930E-01  -2.50161494986449E-01   0.00000000000000E+00  -2.70645684884989E-14
     -9.84393420426036E-23  -1.34454803915399E-08  -1.34455074561084E-08  -2.90475187077508E-18
      3.70599140674305E-10
      0.00000000000000E+00  -1.34537844851073E-11   0.00000000000000E+00  -4.28914385637754E-15   1.84330170342303E-22
      1.34538400528970E-08   1.34538357637533E-08  -7.80915758073733E-19  -2.54411179660598E-01  -2.54411179660589E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.23950761951176E-12   0.00000000000000E+00  -9.23950761951176E-12
      3.68549099537613E-18  -2.54415744715170E-01  -2.50179983264520E-01   0.00000000000000E+00  -3.40546228638410E-14
     -9.84422236606313E-23  -1.34445622015109E-08  -1.34445962561339E-08  -2.90457523730240E-18
      3.90599140674305E-10
      0.00000000000000E+00  -1.34515802114144E-11   0.00000000000000E+00  -5.45973109738215E-15   1.84126756093277E-22
      1.34516042072486E-08   1.34515987475177E-08  -7.80911961648983E-19  -2.54419373188950E-01  -2.54419373188942E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37042070467122E-12   0.00000000000000E+00  -8.37042070467122E-12
      3.68532358696204E-18  -2.54437823298249E-01  -2.50202492695785E-01   0.00000000000000E+00  -4.00592385767749E-14
     -9.84456882536120E-23  -1.34431882675742E-08  -1.34432283268129E-08  -2.90441162531306E-18
      4.10599140674305E-10
      0.00000000000000E+00  -1.34508454535167E-11   0.00000000000000E+00  -1.72582857424504E-15   1.83942342930580E-22
      1.34508786926336E-08   1.34508769668052E-08  -7.80902508890584E-19  -2.54430146464597E-01  -2.54430146464589E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.64209204284491E-12   0.00000000000000E+00  -8.64209204284491E-12
      3.68515074512118E-18  -2.54461520581688E-01  -2.50226503001786E-01   0.00000000000000E+00  -3.94483088394360E-14
     -9.84490520009795E-23  -1.34421954264535E-08  -1.34422348747624E-08  -2.90424823623060E-18
      4.30599140674305E-10
      0.00000000000000E+00  -1.34542437087934E-11   0.00000000000000E+00   9.50428465086463E-15   1.83815260827601E-22
      1.34542341143529E-08   1.34542436186377E-08  -7.80871068522453E-19  -2.54450985469913E-01  -2.54450985469902E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11041748935519E-11   0.00000000000000E+00  -1.11041748935519E-11
      3.68492866162331E-18  -2.54479690107496E-01  -2.50244387930559E-01   0.00000000000000E+00  -2.39307092136208E-14
     -9.84508213155601E-23  -1.34431155130348E-08  -1.34431394437442E-08  -2.90405759310086E-18
      4.50599140674305E-10
      0.00000000000000E+00  -1.34634281825141E-11   0.00000000000000E+00   2.34765926804447E-14   1.83777259566214E-22
      1.34633785243781E-08   1.34634020009710E-08  -7.80803580134278E-19  -2.54488479994528E-01  -2.54488479994512E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59151921060739E-11   0.00000000000000E+00  -1.59151921060739E-11
      3.68461035778119E-18  -2.54481321838692E-01  -2.50244649920190E-01   0.00000000000000E+00   1.30919015469534E-14
     -9.84491828474092E-23  -1.34474999007663E-08  -1.34474868088648E-08  -2.90380677764691E-18
      4.70599140674305E-10
      0.00000000000000E+00  -1.34762864457232E-11   0.00000000000000E+00   3.22145374272648E-14   1.83811955716170E-22
      1.34762616449620E-08   1.34762938594996E-08  -7.80705692038458E-19  -2.54540347480886E-01  -2.54540347480865E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10167578543185E-11   0.00000000000000E+00  -2.10167578543185E-11
      3.68419002262411E-18  -2.54457891941348E-01  -2.50218765491688E-01   0.00000000000000E+00   5.87973415863965E-14
     -9.84434589866944E-23  -1.34553358989868E-08  -1.34552771016453E-08  -2.90348433058565E-18
      4.90599140674305E-10
      0.00000000000000E+00  -1.34842769378602E-11   0.00000000000000E+00   2.07085784113407E-14   1.83808953852707E-22
      1.34842847811365E-08   1.34843054897151E-08  -7.80622556345447E-19  -2.54586231800347E-01  -2.54586231800325E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13673321701050E-11   0.00000000000000E+00  -2.13673321701050E-11
      3.68376267598070E-18  -2.54415459375621E-01  -2.50173919394058E-01   0.00000000000000E+00   7.66008900045293E-14
     -9.84362981484398E-23  -1.34630147584349E-08  -1.34629381575450E-08  -2.90314011963525E-18
      5.00599140674305E-10
      0.00000000000000E+00  -1.34855627641812E-11   0.00000000000000E+00  -2.14183662101591E-15   1.83777508940213E-22
      1.34855465850722E-08   1.34855444432357E-08  -7.80593265364865E-19  -2.54603777041107E-01  -2.54603777041087E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95433192316204E-11   0.00000000000000E+00  -1.95433192316204E-11
      3.68356724278839E-18  -2.54391655263761E-01  -2.50149147355915E-01   0.00000000000000E+00   8.21484108398958E-14
     -9.84336397803758E-23  -1.34660832724150E-08  -1.34660011240042E-08  -2.90297397742352E-18
      5.03974140674305E-10
      0.00000000000000E+00  -1.34855627641812E-11   0.00000000000000E+00   6.94688726190546E-16   1.83762387289626E-22
      1.34855884787524E-08   1.34855891734414E-08  -7.80585174735927E-19  -2.54608904712978E-01  -2.54608904712959E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.86715794383925E-11   0.00000000000000E+00  -1.86715794383925E-11
      3.68350422620778E-18  -2.54383388576368E-01  -2.50140594563936E-01   0.00000000000000E+00   7.11672372231524E-14
     -9.84321866667718E-23  -1.34669887612400E-08  -1.34669175940029E-08  -2.90291905147185E-18
      5.08530390674305E-10
      0.00000000000000E+00  -1.34848280062835E-11   0.00000000000000E+00  -8.53966565500141E-15   1.83731560276933E-22
      1.34847955692537E-08   1.34847870295883E-08  -7.80578486965166E-19  -2.54613939582570E-01  -2.54613939582553E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69438858920377E-11   0.00000000000000E+00  -1.69438858920377E-11
      3.68342702562768E-18  -2.54372202140083E-01  -2.50129116506723E-01   0.00000000000000E+00   6.35001214909171E-14
     -9.84306505553599E-23  -1.34679066438178E-08  -1.34678431436964E-08  -2.90284853866252E-18
      5.14681328174305E-10
      0.00000000000000E+00  -1.34816134404812E-11   0.00000000000000E+00  -2.54834373610219E-14   1.83663673865535E-22
      1.34815955743532E-08   1.34815700909160E-08  -7.80580386631604E-19  -2.54615827832300E-01  -2.54615827832287E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33123323645789E-11   0.00000000000000E+00  -1.33123323645789E-11
      3.68334514230333E-18  -2.54358123795976E-01  -2.50114907564598E-01   0.00000000000000E+00   4.40872021781930E-14
     -9.84295292400516E-23  -1.34683018457536E-08  -1.34682577585515E-08  -2.90276475567173E-18
      5.22985093799305E-10
      0.00000000000000E+00  -1.34717860536000E-11   0.00000000000000E+00  -5.65709602506804E-14   1.83501141675254E-22
      1.34718459336325E-08   1.34717893626725E-08  -7.80612477771375E-19  -2.54605023272206E-01  -2.54605023272201E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37915680074222E-12   0.00000000000000E+00  -5.37915680074222E-12
      3.68330047504600E-18  -2.54344860904335E-01  -2.50102227104265E-01   0.00000000000000E+00  -4.84501501062971E-15
     -9.84299476969305E-23  -1.34664053608565E-08  -1.34664102058716E-08  -2.90268799727462E-18
      5.34195177393055E-10
      0.00000000000000E+00  -1.34445081666494E-11   0.00000000000000E+00  -1.20196112499237E-13   1.83087751319262E-22
      1.34446309028091E-08   1.34445107066968E-08  -7.80737376716693E-19  -2.54553275773497E-01  -2.54553275773509E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23185867787137E-11   0.00000000000000E+00   1.23185867787137E-11
      3.68343856743355E-18  -2.54351593543068E-01  -2.50111977686823E-01   0.00000000000000E+00  -1.20905223974618E-13
     -9.84367754929423E-23  -1.34567083882514E-08  -1.34568292934755E-08  -2.90270119071685E-18
      5.49328790244618E-10
      0.00000000000000E+00  -1.33746143216345E-11   0.00000000000000E+00  -2.28507004788290E-13   1.82038548987399E-22
      1.33748389744550E-08   1.33746104674504E-08  -7.81116115270614E-19  -2.54386805709442E-01  -2.54386805709492E-01
      0.00000000000000E+00   0.00000000000000E+00   4.96955879451177E-11   0.00000000000000E+00   4.96955879451177E-11
      3.68419064122194E-18  -2.54453129160515E-01  -2.50223759784806E-01   0.00000000000000E+00  -3.94838083546780E-13
     -9.84652881513371E-23  -1.34239112173119E-08  -1.34243060553955E-08  -2.90307452595132E-18
      5.69328790244618E-10
      0.00000000000000E+00  -1.32447458632230E-11   0.00000000000000E+00  -3.11633302435285E-13   1.79953328535970E-22
      1.32450661130325E-08   1.32447544797303E-08  -7.81931209975594E-19  -2.54018863868550E-01  -2.54018863868653E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02268918601739E-10   0.00000000000000E+00   1.02268918601739E-10
      3.68623601959397E-18  -2.54833501698480E-01  -2.50628483861539E-01   0.00000000000000E+00  -8.56085333000584E-13
     -9.85436122909764E-23  -1.33461673129989E-08  -1.33470233983320E-08  -2.90430480961838E-18
      5.79328790244618E-10
      0.00000000000000E+00  -1.31765052234778E-11   0.00000000000000E+00  -3.38724768934886E-13   1.78803524962337E-22
      1.31767962770867E-08   1.31764575523180E-08  -7.82392273857261E-19  -2.53808928991978E-01  -2.53808928992103E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24922915499469E-10   0.00000000000000E+00   1.24922915499469E-10
      3.68748524874897E-18  -2.55090837880152E-01  -2.50900196999960E-01   0.00000000000000E+00  -1.06749120387501E-12
     -9.85924744475701E-23  -1.33003129766137E-08  -1.33013804678176E-08  -2.90509297489171E-18
      5.92828790244618E-10
      0.00000000000000E+00  -1.31085401179443E-11   0.00000000000000E+00  -2.49673556489676E-13   1.77436945018645E-22
      1.31087304197958E-08   1.31084807462395E-08  -7.82951727635509E-19  -2.53550537996889E-01  -2.53550537997020E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30786791045921E-10   0.00000000000000E+00   1.30786791045921E-10
      3.68925087042809E-18  -2.55540941869418E-01  -2.51369870675240E-01   0.00000000000000E+00  -1.22774967028983E-12
     -9.86668535988806E-23  -1.32380397876150E-08  -1.32392675372854E-08  -2.90629914279258E-18
      6.11053790244618E-10
      0.00000000000000E+00  -1.31906493130078E-11   0.00000000000000E+00   3.05124277507602E-13   1.77753091990651E-22
      1.31904703616878E-08   1.31907754859655E-08  -7.82807553139095E-19  -2.53605824616081E-01  -2.53605824616113E-01
      0.00000000000000E+00   0.00000000000000E+00   3.19773150039508E-11   0.00000000000000E+00   3.19773150039508E-11
      3.68983365699403E-18  -2.56073959675872E-01  -2.51908118860624E-01   0.00000000000000E+00  -7.83013054475341E-13
     -9.87194991790896E-23  -1.32219697879148E-08  -1.32227528009694E-08  -2.90702610385494E-18
      6.31053790244618E-10
      0.00000000000000E+00  -1.36689767043846E-11   0.00000000000000E+00   1.73555081224650E-12   1.83585158041650E-22
      1.36677709195836E-08   1.36695064703960E-08  -7.80330312594486E-19  -2.54725853671574E-01  -2.54725853671316E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57620889498589E-10   0.00000000000000E+00  -2.57620889498589E-10
      3.68468123920406E-18  -2.55864191838943E-01  -2.51638913315810E-01   0.00000000000000E+00   7.59324644396117E-13
     -9.85885620819537E-23  -1.34126449055417E-08  -1.34118855808974E-08  -2.90435092660958E-18
      6.51053790244618E-10
      0.00000000000000E+00  -1.45524312315838E-11   0.00000000000000E+00   2.96665733914882E-12   1.96017357930234E-22
      1.45501882122207E-08   1.45531548695601E-08  -7.75155223159586E-19  -2.57096664605291E-01  -2.57096664604627E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64080785501994E-10   0.00000000000000E+00  -6.64080785501994E-10
      3.67139962349402E-18  -2.54018959089771E-01  -2.49643411545699E-01   0.00000000000000E+00   3.69831383177696E-12
     -9.81619063047394E-23  -1.38927723978898E-08  -1.38890740840581E-08  -2.89624440033443E-18
      6.71053790244618E-10
      0.00000000000000E+00  -1.54697764668126E-11   0.00000000000000E+00   2.27552235153965E-12   2.10819374804126E-22
      1.54675357046064E-08   1.54698112269581E-08  -7.69101323347209E-19  -2.59913925576722E-01  -2.59913925575787E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.35124970464935E-10   0.00000000000000E+00  -9.35124970464935E-10
      3.65269712408472E-18  -2.50231283978486E-01  -2.45652084951551E-01   0.00000000000000E+00   7.10470004769536E-12
     -9.74893556866425E-23  -1.45417909565407E-08  -1.45346862564931E-08  -2.88359580073751E-18
      6.91053790244618E-10
      0.00000000000000E+00  -1.55023813485212E-11   0.00000000000000E+00   8.99492384476658E-14   2.15187751875347E-22
      1.55022944227806E-08   1.55023843720193E-08  -7.66965433986503E-19  -2.61004800942000E-01  -2.61004800941374E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25370608107708E-10   0.00000000000000E+00  -6.25370608107708E-10
      3.64018971192257E-18  -2.45899577606757E-01  -2.41212519259950E-01   0.00000000000000E+00   6.12263332841901E-12
     -9.69287150324232E-23  -1.48831363972399E-08  -1.48770137639116E-08  -2.87322427793606E-18
      7.11053790244618E-10
      0.00000000000000E+00  -1.34285271823753E-11   0.00000000000000E+00  -5.12212243774814E-12   1.90589005985836E-22
      1.34336781219602E-08   1.34285559995226E-08  -7.76139445453938E-19  -2.56959132522265E-01  -2.56959132523025E-01
      0.00000000000000E+00   0.00000000000000E+00   7.59340275147049E-10   0.00000000000000E+00   7.59340275147049E-10
      3.65537651742551E-18  -2.44975979887542E-01  -2.40506022591061E-01   0.00000000000000E+00  -2.30000098980639E-12
     -9.72248912390427E-23  -1.41855962736798E-08  -1.41878962746697E-08  -2.87923707197157E-18
      7.31053790244618E-10
      0.00000000000000E+00  -8.89020318273976E-12   0.00000000000000E+00  -1.12442639406493E-11   1.30095828631169E-22
      8.90136183991327E-09   8.89011757597275E-09  -8.03849963255465E-19  -2.44335828648587E-01  -2.44335828651799E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21162494137180E-09   0.00000000000000E+00   3.21162494137180E-09
      3.71960901625295E-18  -2.51976224599558E-01  -2.48163509435893E-01   0.00000000000000E+00  -2.10866787474464E-11
     -9.92182002937167E-23  -1.20806558385971E-08  -1.21017425173446E-08  -2.91575905299748E-18
      7.51053790244618E-10
      0.00000000000000E+00  -3.86253042326254E-12   0.00000000000000E+00  -1.24968560313941E-11   5.86947972554898E-23
      3.87504928244999E-09   3.86255242641865E-09  -8.49319872421772E-19  -2.23218012941384E-01  -2.23218012946836E-01
      0.00000000000000E+00   0.00000000000000E+00   5.45146500604061E-09   0.00000000000000E+00   5.45146500604061E-09
      3.82863831637376E-18  -2.66644841705929E-01  -2.63710404926076E-01   0.00000000000000E+00  -4.64322805036647E-11
     -1.02993076541329E-22  -9.26758515195544E-09  -9.31401743245921E-09  -2.97931844395199E-18
      7.71053790244618E-10
      0.00000000000000E+00  -1.62886641437549E-12   0.00000000000000E+00  -5.63109023020100E-12   1.44768246172011E-23
      1.63447142689837E-09   1.62884033666819E-09  -8.91368105508506E-19  -2.03227848155235E-01  -2.03227848160484E-01
      0.00000000000000E+00   0.00000000000000E+00   5.24831042737422E-09   0.00000000000000E+00   5.24831042737422E-09
      3.93360452492124E-18  -2.83630934863580E-01  -2.81464244321963E-01   0.00000000000000E+00  -5.73871371947084E-11
     -1.07099780833921E-22  -6.81976362684759E-09  -6.87715076404240E-09  -3.04223641941274E-18
      7.91053790244618E-10
      0.00000000000000E+00  -3.33873988696801E-12   0.00000000000000E+00   4.17517824760134E-12   1.05703831946241E-23
      3.33455607521620E-09   3.33873125346381E-09  -8.96706114746289E-19  -2.00399919248631E-01  -2.00399919250430E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79866227993091E-09   0.00000000000000E+00   1.79866227993091E-09
      3.96957777051986E-18  -2.98449609898376E-01  -2.96831066697477E-01   0.00000000000000E+00  -2.98493141047167E-11
     -1.09138387925024E-22  -5.10754421928993E-09  -5.13739353339476E-09  -3.07287165577357E-18
      8.11053790244618E-10
      0.00000000000000E+00  -8.01336147661950E-12   0.00000000000000E+00   1.16094138280476E-11   5.25952597692930E-23
      8.00173327601506E-09   8.01334268984316E-09  -8.57513599631260E-19  -2.18482672812767E-01  -2.18482672810135E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.63262127050460E-09   0.00000000000000E+00  -2.63262127050460E-09
      3.91692534510977E-18  -3.07114695681390E-01  -3.05419545454756E-01   0.00000000000000E+00   1.68617058416507E-11
     -1.08040067846481E-22  -5.39758312518005E-09  -5.38072141933851E-09  -3.05941174547851E-18
      8.31053790244618E-10
      0.00000000000000E+00  -1.47329061401966E-11   0.00000000000000E+00   1.66941860120336E-11   1.50839168273172E-22
      1.47162388203031E-08   1.47329330063153E-08  -8.00284331003037E-19  -2.44517901604308E-01  -2.44517901599001E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30657334209352E-09   0.00000000000000E+00  -5.30657334209352E-09
      3.81079387826790E-18  -3.04413509434393E-01  -3.01443808798337E-01   0.00000000000000E+00   4.22779410992544E-11
     -1.04842441750698E-22  -9.46863760532087E-09  -9.42635966422172E-09  -3.01050954726486E-18
      8.51053790244618E-10
      0.00000000000000E+00  -2.25692828082172E-11   0.00000000000000E+00   1.94386599091303E-11   2.89365823719951E-22
      2.25498908358972E-08   2.25693294958066E-08  -7.49512383928319E-19  -2.67505308978334E-01  -2.67505308972050E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28420198770761E-09   0.00000000000000E+00  -6.28420198770761E-09
      3.68510983851375E-18  -2.86766890260176E-01  -2.81636300223769E-01   0.00000000000000E+00   4.85885267278728E-11
     -1.00592975483426E-22  -1.63337160348268E-08  -1.62851275080991E-08  -2.93559745458543E-18
      8.71053790244618E-10
      0.00000000000000E+00  -3.12262003584498E-11   0.00000000000000E+00   2.14632648603807E-11   4.45836286916915E-22
      3.12047614464548E-08   3.12262247113156E-08  -7.06639269580326E-19  -2.87397310190187E-01  -2.87397310182593E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.59373581692566E-09   0.00000000000000E+00  -7.59373581692566E-09
      3.53323512217523E-18  -2.50736325008538E-01  -2.43290843503236E-01   0.00000000000000E+00   5.55305382958480E-11
     -9.49605010935933E-23  -2.36880194326857E-08  -2.36324888943899E-08  -2.82659585259491E-18
      8.91053790244618E-10
      0.00000000000000E+00  -3.90605564422518E-11   0.00000000000000E+00   1.94497176848321E-11   5.89854479024409E-22
      3.90411150415112E-08   3.90605647591966E-08  -6.69778096513196E-19  -3.05479192312855E-01  -3.05479192303086E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76900513629120E-09   0.00000000000000E+00  -9.76900513629120E-09
      3.33785501944941E-18  -1.92726098017933E-01  -1.83497565171556E-01   0.00000000000000E+00   6.03065226799938E-11
     -8.73116144825247E-23  -2.93518661455853E-08  -2.92915596229054E-08  -2.66807692293621E-18
      9.11053790244618E-10
      0.00000000000000E+00  -4.20240187329899E-11   0.00000000000000E+00   7.40701214552616E-12   6.51004220925001E-22
      4.20166259752233E-08   4.20240329873695E-08  -6.43529056162058E-19  -3.19714428853575E-01  -3.19714428842476E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10993963077620E-08   0.00000000000000E+00  -1.10993963077620E-08
      3.11586709329417E-18  -1.22420124569398E-01  -1.12676953497088E-01   0.00000000000000E+00   5.19513932172394E-11
     -6.78807139421372E-23  -3.09765880728248E-08  -3.09246366796076E-08  -2.47233803713211E-18
      9.31053790244618E-10
      0.00000000000000E+00  -3.99834123617131E-11   0.00000000000000E+00  -4.99199485349761E-12   6.27113272613449E-22
      3.99884366126655E-08   3.99834446178127E-08  -6.20093480127614E-19  -3.32798283213296E-01  -3.32798283201840E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14560821782778E-08   0.00000000000000E+00  -1.14560821782778E-08
      2.88674544972861E-18  -6.26111736583686E-02  -5.36232173671708E-02   0.00000000000000E+00   3.74619651459721E-11
      1.22173795000794E-22  -2.85648244046810E-08  -2.85273624395349E-08  -2.26665196960100E-18
      9.51053790244618E-10
      0.00000000000000E+00  -3.45239774926233E-11   0.00000000000000E+00  -1.29816272317257E-11   6.22007679361353E-22
      3.45373819843598E-08   3.45244003571287E-08  -5.80069825641473E-19  -3.51449869064842E-01  -3.51449869053774E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10676856782105E-08   0.00000000000000E+00  -1.10676856782105E-08
      2.66539173616440E-18  -3.22148750342204E-02  -2.48246149227999E-02   0.00000000000000E+00   2.61032307281289E-11
      4.69839806191434E-22  -2.34828179096468E-08  -2.34567146789182E-08  -2.08532191052293E-18
      9.71053790244618E-10
      0.00000000000000E+00  -3.06270052929079E-11   0.00000000000000E+00  -9.59224367666586E-12   6.22635554962237E-22
      3.06366266526526E-08   3.06270344089766E-08  -5.28276261179118E-19  -3.74110860339148E-01  -3.74110860328391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07561966550482E-08   0.00000000000000E+00  -1.07561966550482E-08
      2.45026780306344E-18  -2.05953927805713E-02  -1.43347566947426E-02   0.00000000000000E+00   1.61470308437690E-11
      7.07919162002012E-22  -1.98869847847728E-08  -1.98708377539284E-08  -1.92199154188432E-18
      9.91053790244618E-10
      0.00000000000000E+00  -2.92296794610326E-11   0.00000000000000E+00  -3.41604901761631E-12   5.82776792002912E-22
      2.92330277921508E-08   2.92296117431338E-08  -4.72417880076903E-19  -3.98449921755641E-01  -3.98449921744522E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11191341451357E-08   0.00000000000000E+00  -1.11191341451357E-08
      2.22788512016073E-18  -1.57385472811474E-02  -1.00325321026042E-02   0.00000000000000E+00   9.70975438079221E-12
      7.73566265878676E-22  -1.81201873523796E-08  -1.81104775979981E-08  -1.75546724008382E-18
      1.01105379024462E-09
      0.00000000000000E+00  -2.90366218234224E-11   0.00000000000000E+00  -4.20316793794583E-13   4.94207573986551E-22
      2.90371444372433E-08   2.90367241204500E-08  -4.14842866237958E-19  -4.23725229863710E-01  -4.23725229851959E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17516374380803E-08   0.00000000000000E+00  -1.17516374380803E-08
      1.99285237139912E-18  -1.32776530904452E-02  -7.83168844576703E-03   0.00000000000000E+00   6.74943871094859E-12
      7.03067452624861E-22  -1.72918361210813E-08  -1.72850866823697E-08  -1.57800950516116E-18
      1.02105379024462E-09
      0.00000000000000E+00  -2.89828008074188E-11   0.00000000000000E+00  -2.21507083138456E-13   4.32541181245225E-22
      2.89830213854372E-08   2.89827998783545E-08  -3.86307907737778E-19  -4.36326174573406E-01  -4.36326174561404E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20019342328305E-08   0.00000000000000E+00  -1.20019342328305E-08
      1.87283302907082E-18  -1.24240575804487E-02  -7.07393593725788E-03   0.00000000000000E+00   5.83114033910348E-12
      6.26711116186403E-22  -1.69866967858637E-08  -1.69808656455239E-08  -1.48652512133304E-18
      1.03455379024462E-09
      0.00000000000000E+00  -2.89684730284144E-11   0.00000000000000E+00  -5.56281418780261E-15   3.45009463913133E-22
      2.89684077923824E-08   2.89684022295686E-08  -3.48216186086958E-19  -4.53210528382073E-01  -4.53210528369996E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20767279067947E-08   0.00000000000000E+00  -1.20767279067947E-08
      1.70979720232909E-18  -1.16397247735391E-02  -6.31770165137010E-03   0.00000000000000E+00   4.43784101587135E-12
      5.07100028681795E-22  -1.68961121637902E-08  -1.68916743227738E-08  -1.36158101624213E-18
      1.05277879024462E-09
      0.00000000000000E+00  -2.86308517744395E-11   0.00000000000000E+00  -8.75828047602436E-13   2.33367096237609E-22
      2.86317181363580E-08   2.86308423083106E-08  -3.00259865620232E-19  -4.74528872693521E-01  -4.74528872682013E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15083680621951E-08   0.00000000000000E+00  -1.15083680621951E-08
      1.50005719439558E-18  -1.09747642734574E-02  -5.58001748454739E-03   0.00000000000000E+00   3.01931052973431E-12
      3.44366310094307E-22  -1.71254935566456E-08  -1.71224742461155E-08  -1.19979732877535E-18
      1.07277879024462E-09
      0.00000000000000E+00  -2.47920172933765E-11   0.00000000000000E+00  -9.44390784126858E-12   1.34307764783537E-22
      2.48014659614184E-08   2.47920220535772E-08  -2.68865088750222E-19  -4.88547233192131E-01  -4.88547233184830E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30169810093138E-09   0.00000000000000E+00  -7.30169810093138E-09
      1.35402323237695E-18  -1.02779152851710E-02  -4.76726637943235E-03   0.00000000000000E+00   1.19032468352219E-12
      1.96693227219824E-22  -1.74915142773296E-08  -1.74903239526458E-08  -1.08515814362673E-18
      1.09277879024462E-09
      0.00000000000000E+00  -1.31037641916095E-11   0.00000000000000E+00  -2.88197510644568E-11   6.84899817484695E-23
      1.31325662233109E-08   1.31037464722465E-08  -2.95293055103385E-19  -4.77092558201220E-01  -4.77092558205764E-01
      0.00000000000000E+00   0.00000000000000E+00   4.54405446071384E-09   0.00000000000000E+00   4.54405446071384E-09
      1.44490432159123E-18  -9.10691583507327E-03  -3.54664934344894E-03   0.00000000000000E+00  -2.00702059039277E-12
      1.00010358943434E-22  -1.76457939123700E-08  -1.76478009329603E-08  -1.14961126648784E-18
      1.11277879024462E-09
      0.00000000000000E+00   2.50570812049575E-12   0.00000000000000E+00  -3.85341329019145E-11   2.22049381274357E-23
     -2.46718819761482E-09  -2.50572233051672E-09  -4.12216393643376E-19  -4.28403001437183E-01  -4.28403001457321E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01384023498894E-08   0.00000000000000E+00   2.01384023498894E-08
      1.84767236858902E-18  -7.81220421614498E-03  -2.25670312978363E-03   0.00000000000000E+00  -8.35586385645396E-12
      2.98980881599269E-23  -1.76243241555163E-08  -1.76326800193727E-08  -1.43545597494564E-18
      1.13277879024462E-09
      0.00000000000000E+00   1.15728042670972E-11   0.00000000000000E+00  -2.26141250632364E-11  -2.62351786368592E-23
     -1.15502135657525E-08  -1.15728276908158E-08  -6.24487050707173E-19  -3.43353160599791E-01  -3.43353160628711E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89196507873477E-08   0.00000000000000E+00   2.89196507873477E-08
      2.42606538433597E-18  -8.15354755639986E-03  -2.68811940432315E-03   0.00000000000000E+00  -2.14161561377108E-11
     -5.42130992453582E-23  -1.73254069403941E-08  -1.73468230965319E-08  -1.80157833362880E-18
      1.15277879024462E-09
      0.00000000000000E+00   1.18331840970805E-11   0.00000000000000E+00  -1.16096295511499E-12  -4.18021057945875E-23
     -1.18320021145250E-08  -1.18331630774801E-08  -8.63578493724192E-19  -2.39333830894548E-01  -2.39333830921867E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73191931022861E-08   0.00000000000000E+00   2.73191931022861E-08
      2.97244924638169E-18  -2.08020303657683E-02  -1.59228884832063E-02   0.00000000000000E+00  -4.86216895322877E-11
     -8.04374047755311E-23  -1.54374083352737E-08  -1.54860300248061E-08  -2.10887075265750E-18
      1.17277879024462E-09
      0.00000000000000E+00   9.59713212502609E-12   0.00000000000000E+00   4.81409139514192E-12  -4.49548843032883E-23
     -9.60190672215620E-09  -9.59709263076110E-09  -1.05537827140697E-18  -1.43082727969485E-01  -1.43082727991725E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22396874627924E-08   0.00000000000000E+00   2.22396874627924E-08
      3.41724299563754E-18  -5.09940492785374E-02  -4.70107828339123E-02   0.00000000000000E+00  -9.70065143330686E-11
     -9.29147062513044E-23  -1.25455883176982E-08  -1.26425948320313E-08  -2.36186472423057E-18
      1.18277879024462E-09
      0.00000000000000E+00   7.76675835721729E-12   0.00000000000000E+00   8.19640574662304E-12  -4.61397992664839E-23
     -7.77495870294722E-09  -7.76676229720064E-09  -1.13261900404308E-18  -1.00628573514320E-01  -1.00628573533046E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87261726926395E-08   0.00000000000000E+00   1.87261726926395E-08
      3.60450472256394E-18  -7.07908915919037E-02  -6.73379219590665E-02   0.00000000000000E+00  -1.46136211482348E-10
     -9.95344309157702E-23  -1.08132741839562E-08  -1.09594103954386E-08  -2.47188571852086E-18
      1.19627879024462E-09
      0.00000000000000E+00   5.31817766326463E-12   0.00000000000000E+00   8.25125923021798E-12  -4.72173320144632E-23
     -5.32641031741273E-09  -5.31815905818256E-09  -1.20351899397445E-18  -5.93262359248085E-02  -5.93262359391737E-02
      0.00000000000000E+00   0.00000000000000E+00   1.43652292312709E-08   0.00000000000000E+00   1.43652292312709E-08
      3.79843531718609E-18  -1.03775809243549E-01  -1.00925356124009E-01   0.00000000000000E+00  -1.73591438416742E-10
     -1.07969374402668E-22  -8.87347873467162E-09  -9.04707017308847E-09  -2.59491632321165E-18
      1.21450379024462E-09
      0.00000000000000E+00   2.41790455172535E-12   0.00000000000000E+00   7.48824024675810E-12  -4.77815507662389E-23
     -2.42540443236345E-09  -2.41791619211674E-09  -1.24632001868053E-18  -3.27640675029092E-02  -3.27640675120568E-02
      0.00000000000000E+00   0.00000000000000E+00   9.14761530436640E-09   0.00000000000000E+00   9.14761530436640E-09
      3.96515060610817E-18  -1.55686482419993E-01  -1.53566158975555E-01   0.00000000000000E+00  -1.83755499086474E-10
     -1.17877509029177E-22  -6.54594361316309E-09  -6.72969911224968E-09  -2.71883058742764E-18
      1.23450379024462E-09
      0.00000000000000E+00   8.75831414010975E-13   0.00000000000000E+00   3.68657799415659E-12  -4.79523448789520E-23
     -8.79559482671141E-10  -8.75872904677032E-10  -1.26248967341385E-18  -2.17853762035437E-02  -2.17853762093950E-02
      0.00000000000000E+00   0.00000000000000E+00   5.85137805283245E-09   0.00000000000000E+00   5.85137805283245E-09
      4.08217816716482E-18  -2.11128284477183E-01  -2.09560646845147E-01   0.00000000000000E+00  -1.87760218902449E-10
     -1.27220576307024E-22  -4.78774492925284E-09  -4.97550514815541E-09  -2.81968849375097E-18
      1.25450379024462E-09
      0.00000000000000E+00   3.91717804190102E-13   0.00000000000000E+00   1.15609186495246E-12  -4.80149523638936E-23
     -3.92907369068639E-10  -3.91751277203735E-10  -1.26901862136556E-18  -1.69149576579835E-02  -1.69149576619925E-02
      0.00000000000000E+00   0.00000000000000E+00   4.00892893943246E-09   0.00000000000000E+00   4.00892893943246E-09
      4.16235674595347E-18  -2.55958283792021E-01  -2.54818607928808E-01   0.00000000000000E+00  -1.73397467023519E-10
     -1.34732694605034E-22  -3.44378019520505E-09  -3.61717766222871E-09  -2.89333812458791E-18
      1.27450379024462E-09
      0.00000000000000E+00   2.48256324671945E-13   0.00000000000000E+00   3.37035335734846E-13  -4.80488688288014E-23
     -2.48555144914510E-10  -2.48218109578823E-10  -1.27270670894650E-18  -1.41458216138483E-02  -1.41458216165673E-02
      0.00000000000000E+00   0.00000000000000E+00   2.71900441618796E-09   0.00000000000000E+00   2.71900441618796E-09
      4.21673683427723E-18  -2.87361704822044E-01  -2.86583223303425E-01   0.00000000000000E+00  -1.36445335803492E-10
     -1.40118743398939E-22  -2.33434097080551E-09  -2.47078630660915E-09  -2.94403012533073E-18
      1.29450379024462E-09
      0.00000000000000E+00   1.93241327084636E-13   0.00000000000000E+00   1.26488238011161E-13  -4.80697660309154E-23
     -1.93342586563849E-10  -1.93216098325886E-10  -1.27531431299377E-18  -1.23563201836949E-02  -1.23563201854634E-02
      0.00000000000000E+00   0.00000000000000E+00   1.76848593333038E-09   0.00000000000000E+00   1.76848593333038E-09
      4.25210655294384E-18  -3.06869863707892E-01  -3.06373538071618E-01   0.00000000000000E+00  -9.10576216642843E-11
     -1.43520265233287E-22  -1.48421221334008E-09  -1.57526983500451E-09  -2.97679223995007E-18
      1.31450379024462E-09
      0.00000000000000E+00   1.63759166441020E-13   0.00000000000000E+00   6.78371150925580E-14  -4.80823295643375E-23
     -1.63831932672986E-10  -1.63764095557942E-10  -1.27734529335623E-18  -1.11520792170421E-02  -1.11520792181375E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09546419516248E-09   0.00000000000000E+00   1.09546419516248E-09
      4.27401583684709E-18  -3.17402469631182E-01  -3.17108920110964E-01   0.00000000000000E+00  -5.01877195977850E-11
     -1.45349369692145E-22  -8.81512380006598E-10  -9.31700099604528E-10  -2.99667054349086E-18
      1.33450379024462E-09
      0.00000000000000E+00   1.26562047871972E-13   0.00000000000000E+00   9.28129149023368E-14  -4.80814824273966E-23
     -1.26653093187319E-10  -1.26560280272464E-10  -1.27864334598145E-18  -1.04565518755430E-02  -1.04565518763841E-02
      0.00000000000000E+00   0.00000000000000E+00   8.41117412560437E-10   0.00000000000000E+00   8.41117412560437E-10
      4.29083818509830E-18  -3.25300972934616E-01  -3.25075840927787E-01   0.00000000000000E+00  -3.66604477833125E-11
     -1.46654723877997E-22  -6.77896684504452E-10  -7.14557132287911E-10  -3.01219483911685E-18
      1.35450379024462E-09
      0.00000000000000E+00   1.01029210928279E-13   0.00000000000000E+00   6.81163677132394E-14  -4.80727019470964E-23
     -1.01102453704066E-10  -1.01034337336401E-10  -1.27944353870274E-18  -1.00222096812595E-02  -1.00222096821252E-02
      0.00000000000000E+00   0.00000000000000E+00   8.65698476401791E-10   0.00000000000000E+00   8.65698476401791E-10
      4.30815215462633E-18  -3.34359650821165E-01  -3.34118730514204E-01   0.00000000000000E+00  -4.25534188903617E-11
     -1.48124723037949E-22  -7.22110720174894E-10  -7.64664139065404E-10  -3.02870861592360E-18
      1.35575379024462E-09
      0.00000000000000E+00   1.15448834669861E-13   0.00000000000000E+00  -5.40335501859554E-13  -4.80736121239440E-23
     -1.14877234594308E-10  -1.15417570096216E-10  -1.27951157343172E-18  -9.98498118478586E-03  -9.98498118560582E-03
      0.00000000000000E+00   0.00000000000000E+00   8.19952564863680E-10   0.00000000000000E+00   8.19952564863680E-10
      4.30917709533241E-18  -3.34838041931769E-01  -3.34616068017352E-01   0.00000000000000E+00  -3.60019616834760E-11
     -1.48203755619051E-22  -6.68533033084665E-10  -7.04534994768289E-10  -3.02966552190069E-18
      1.35744129024462E-09
      0.00000000000000E+00   9.12018240470741E-14   0.00000000000000E+00   6.79121326027552E-13  -4.80709034763125E-23
     -9.18475967281623E-11  -9.11684754021828E-11  -1.27956259054407E-18  -9.96040653373113E-03  -9.96040653454906E-03
      0.00000000000000E+00   0.00000000000000E+00   8.17938236217716E-10   0.00000000000000E+00   8.17938236217716E-10
      4.31055736610603E-18  -3.35572643955407E-01  -3.35343663081191E-01   0.00000000000000E+00  -4.07570459299145E-11
     -1.48320543416222E-22  -6.86012714884680E-10  -7.26769760814743E-10  -3.03099477556196E-18
      1.35971941524462E-09
      0.00000000000000E+00   6.48423844685139E-14   0.00000000000000E+00   5.83058734355203E-13  -4.80669879226630E-23
     -6.54235720392712E-11  -6.48405133049641E-11  -1.27957167914480E-18  -9.95794450481307E-03  -9.95794450569748E-03
      0.00000000000000E+00   0.00000000000000E+00   8.84405365169299E-10   0.00000000000000E+00   8.84405365169299E-10
      4.31257215207855E-18  -3.36779688392964E-01  -3.36521468498670E-01   0.00000000000000E+00  -4.98297193082781E-11
     -1.48510498416220E-22  -7.69735132556420E-10  -8.19564851864846E-10  -3.03300047293376E-18
      1.36279488399462E-09
      0.00000000000000E+00   4.81266422967440E-14   0.00000000000000E+00   2.87284575305518E-13  -4.80620471492934E-23
     -4.83901446880567E-11  -4.81028601127992E-11  -1.27953288357211E-18  -9.97410355075855E-03  -9.97410355177719E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01864111395621E-09   0.00000000000000E+00   1.01864111395621E-09
      4.31570495099199E-18  -3.38798574946294E-01  -3.38492785240210E-01   0.00000000000000E+00  -6.28154700229408E-11
     -1.48832623692013E-22  -9.07722783820221E-10  -9.70538253843310E-10  -3.03617206741989E-18
      1.36694676680712E-09
      0.00000000000000E+00   4.06872185829343E-14   0.00000000000000E+00   1.05544482454681E-13  -4.80557033843774E-23
     -4.08044469317739E-11  -4.06989024493673E-11  -1.27945063027561E-18  -9.99557931768411E-03  -9.99557931889272E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20861075860470E-09   0.00000000000000E+00   1.20861075860470E-09
      4.32072296122765E-18  -3.42162395062225E-01  -3.41794415693962E-01   0.00000000000000E+00  -7.94880851727890E-11
     -1.49381376344098E-22  -1.08842377098228E-09  -1.16791185615522E-09  -3.04127233095204E-18
      1.37255180860399E-09
      0.00000000000000E+00   4.20648896410473E-14   0.00000000000000E+00   4.00434283590133E-15  -4.80479926102073E-23
     -4.20549329541630E-11  -4.20509286113752E-11  -1.27934892290031E-18  -9.99329362433705E-03  -9.99329362575915E-03
      0.00000000000000E+00   0.00000000000000E+00   1.42209447855791E-09   0.00000000000000E+00   1.42209447855791E-09
      4.32869386021907E-18  -3.47591374120030E-01  -3.47156555120135E-01   0.00000000000000E+00  -9.78180412928909E-11
     -1.50287940935821E-22  -1.28222550865369E-09  -1.38004354994673E-09  -3.04934493731876E-18
      1.38011861502977E-09
      0.00000000000000E+00   5.15248975734225E-14   0.00000000000000E+00  -4.80948549756642E-14  -4.80394700365199E-23
     -5.14327771543713E-11  -5.14808720093950E-11  -1.27928638961712E-18  -9.91737100389129E-03  -9.91737100549475E-03
      0.00000000000000E+00   0.00000000000000E+00   1.60346453625320E-09   0.00000000000000E+00   1.60346453625320E-09
      4.34082696597550E-18  -3.55853530367391E-01  -3.55364535538812E-01   0.00000000000000E+00  -1.13971188846401E-10
     -1.51699067878939E-22  -1.43801247539724E-09  -1.55198366424380E-09  -3.06154057635838E-18
      1.39033380370458E-09
      0.00000000000000E+00   6.70466581614945E-14   0.00000000000000E+00  -6.51745147169571E-14  -4.80312266842397E-23
     -6.69760509878265E-11  -6.70412255025915E-11  -1.27936719357496E-18  -9.69548908455752E-03  -9.69548908626561E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70809191331593E-09   0.00000000000000E+00   1.70809191331593E-09
      4.35827544714393E-18  -3.67613411246428E-01  -3.67096352569851E-01   0.00000000000000E+00  -1.25050766739582E-10
     -1.53755023418833E-22  -1.51599992107360E-09  -1.64105068781334E-09  -3.07890825356897E-18
      1.40412430841556E-09
      0.00000000000000E+00   9.25794951051870E-14   0.00000000000000E+00  -8.63566544880695E-14  -4.80270125553253E-23
     -9.24902767623158E-11  -9.25766334168519E-11  -1.27983919774212E-18  -9.17340334590631E-03  -9.17340334765024E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74392358055582E-09   0.00000000000000E+00   1.74392358055582E-09
      4.38232503349719E-18  -3.83455098579726E-01  -3.82934795352348E-01   0.00000000000000E+00  -1.31631518941385E-10
     -1.56610254974175E-22  -1.51971542819740E-09  -1.65134694713894E-09  -3.10248583575506E-18
      1.42274148977540E-09
      0.00000000000000E+00   1.34552540009027E-13   0.00000000000000E+00  -1.14144974822104E-13  -4.80361311506386E-23
     -1.34434408604541E-10  -1.34548553579411E-10  -1.28127488948170E-18  -8.00153722438692E-03  -8.00153722614061E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75369462008083E-09   0.00000000000000E+00   1.75369462008083E-09
      4.41497388428899E-18  -4.04082407366485E-01  -4.03572249573878E-01   0.00000000000000E+00  -1.36846025924249E-10
     -1.60501250687507E-22  -1.48230004057702E-09  -1.61914606650143E-09  -3.13369899480729E-18
      1.44274148977540E-09
      0.00000000000000E+00   1.64861303287511E-13   0.00000000000000E+00  -8.36456998887205E-14  -4.80561271931522E-23
     -1.64760520515697E-10  -1.64844166215634E-10  -1.28344020109161E-18  -6.38795942694365E-03  -6.38795942868083E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73717802531237E-09   0.00000000000000E+00   1.73717802531237E-09
      4.44971744479524E-18  -4.25362953296373E-01  -4.24867544080826E-01   0.00000000000000E+00  -1.42120957838868E-10
     -1.64705228474517E-22  -1.43021290125776E-09  -1.57233385909680E-09  -3.16627724370363E-18
      1.46274148977540E-09
      0.00000000000000E+00   1.55217605880720E-13   0.00000000000000E+00   1.58362255315248E-14  -4.80706222063412E-23
     -1.55253734924605E-10  -1.55237898699121E-10  -1.28542980311646E-18  -4.89851697882290E-03  -4.89851698049158E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66868374449037E-09   0.00000000000000E+00   1.66868374449037E-09
      4.48309111968505E-18  -4.46008663723045E-01  -4.45531807876145E-01   0.00000000000000E+00  -1.45938419192699E-10
     -1.68892536973785E-22  -1.36750742659827E-09  -1.51344584579114E-09  -3.19766131656859E-18
      1.48274148977540E-09
      0.00000000000000E+00  -2.84718685343333E-14   0.00000000000000E+00   4.76071078598415E-13  -4.80100230955544E-23
      2.79818396150921E-11   2.84579106936425E-11  -1.28377016865987E-18  -5.62868493603097E-03  -5.62868493736070E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32972776630222E-09   0.00000000000000E+00   1.32972776630222E-09
      4.50968567501109E-18  -4.66378305493564E-01  -4.65950369683604E-01   0.00000000000000E+00  -1.36493052195683E-10
     -1.72702376293423E-22  -1.22169262480006E-09  -1.35818567699592E-09  -3.22591550635122E-18
      1.50274148977539E-09
      0.00000000000000E+00  -1.63474447755677E-12   0.00000000000000E+00   4.23902072212375E-12  -4.72992173739764E-23
      1.63053598196001E-09   1.63477500268208E-09  -1.25014236945649E-18  -2.54257016463102E-02  -2.54257016450365E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.27367761635938E-09   0.00000000000000E+00  -1.27367761635938E-09
      4.48421212268390E-18  -4.88290536717412E-01  -4.88176781755714E-01   0.00000000000000E+00  -1.11666806054454E-11
     -1.72989885985915E-22  -3.49930705717086E-10  -3.61097386322705E-10  -3.23406975322742E-18
      1.52274148977539E-09
      0.00000000000000E+00  -3.28519440517602E-12   0.00000000000000E+00   4.54348627605463E-12  -4.60389423800918E-23
      3.28068264975565E-09   3.28522613603166E-09  -1.18428387430451E-18  -6.29734895520480E-02  -6.29734895481883E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.85973700770487E-09   0.00000000000000E+00  -3.85973700770487E-09
      4.40701738252981E-18  -5.11215960129595E-01  -5.11397018533297E-01   0.00000000000000E+00   1.09783110166169E-10
     -1.69884882742769E-22   4.64727761507163E-10   5.74510871673162E-10  -3.22273350822529E-18
      1.52774148977539E-09
      0.00000000000000E+00  -4.09168304259532E-12   0.00000000000000E+00   8.42656569173657E-12  -4.56349328540847E-23
      4.08330031045688E-09   4.09172687614857E-09  -1.16390787619459E-18  -7.42708736219515E-02  -7.42708736168890E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.06251488675300E-09   0.00000000000000E+00  -5.06251488675300E-09
      4.38170480809604E-18  -5.17015905483705E-01  -5.17321831433215E-01   0.00000000000000E+00   1.58139637358510E-10
     -1.68761662905434E-22   8.12648373246296E-10   9.70788010604638E-10  -3.21779693190146E-18
      1.53449148977539E-09
      0.00000000000000E+00  -4.90689693004932E-12   0.00000000000000E+00   6.52530505656143E-12  -4.50277897342143E-23
      4.90038342514772E-09   4.90690873020424E-09  -1.13129361361638E-18  -9.19877617214866E-02  -9.19877617152489E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.23773831344779E-09   0.00000000000000E+00  -6.23773831344779E-09
      4.33960007448027E-18  -5.24987346806500E-01  -5.25406725674836E-01   0.00000000000000E+00   2.01482991493768E-10
     -1.66810284687656E-22   1.12934659174999E-09   1.33082958324359E-09  -3.20830646086389E-18
      1.53904773977540E-09
      0.00000000000000E+00  -5.51454171141432E-12   0.00000000000000E+00   7.13446365111809E-12  -4.45758241797784E-23
      5.50738954080960E-09   5.51452400446067E-09  -1.10682105155795E-18  -1.05014322250694E-01  -1.05014322243637E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.05684535072133E-09   0.00000000000000E+00  -7.05684535072133E-09
      4.30744732285105E-18  -5.30395484953739E-01  -5.30881509155839E-01   0.00000000000000E+00   2.26571214530550E-10
     -1.65315657002453E-22   1.31575013172991E-09   1.54232134626029E-09  -3.20062627129310E-18
      1.54519867727539E-09
      0.00000000000000E+00  -6.17113973771093E-12   0.00000000000000E+00   5.83591396752750E-12  -4.39144742572810E-23
      6.16533224366675E-09   6.17116815763423E-09  -1.07071453557520E-18  -1.23805078635932E-01  -1.23805078628110E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.82246771578127E-09   0.00000000000000E+00  -7.82246771578127E-09
      4.25933181283551E-18  -5.37644802014257E-01  -5.38165179189943E-01   0.00000000000000E+00   2.46078544681464E-10
     -1.63099278924164E-22   1.40522101346549E-09   1.65129955814680E-09  -3.18861727726031E-18
      1.55350244290040E-09
      0.00000000000000E+00  -6.97992449356041E-12   0.00000000000000E+00   5.32753099367982E-12  -4.27753384868460E-23
      6.97459192415779E-09   6.97991945515143E-09  -1.01882317783854E-18  -1.49974509563242E-01  -1.49974509554822E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.41994282857884E-09   0.00000000000000E+00  -8.41994282857884E-09
      4.18941458101109E-18  -5.47042321945737E-01  -5.47496168181298E-01   0.00000000000000E+00   2.52505592346983E-10
     -1.59978146778221E-22   1.18751778108069E-09   1.44002337342752E-09  -3.17059140317255E-18
      1.56471252649415E-09
      0.00000000000000E+00  -8.55120425770678E-12   0.00000000000000E+00   7.34909805904391E-12  -3.92574929102821E-23
      8.54385576771080E-09   8.55120486576980E-09  -9.46814424569087E-19  -1.84809566627620E-01  -1.84809566618802E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.81834245775880E-09   0.00000000000000E+00  -8.81834245775880E-09
      4.09056022490130E-18  -5.58121413117853E-01  -5.58205823125919E-01   0.00000000000000E+00   2.46592671480740E-10
     -1.55755941062625E-22   2.05449205085132E-11   2.67137591989097E-10  -3.14374580033221E-18
      1.57984613934571E-09
      0.00000000000000E+00  -1.34572745851212E-11   0.00000000000000E+00   1.63024114054635E-11  -2.09359148649414E-23
      1.34409603065457E-08   1.34572627179512E-08  -8.52555413291833E-19  -2.28181913577384E-01  -2.28181913568222E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.16117382530904E-09   0.00000000000000E+00  -9.16117382530904E-09
      3.95191856696320E-18  -5.66145383814134E-01  -5.64792401957554E-01   0.00000000000000E+00   2.42106084232025E-10
     -1.49864724730495E-22  -4.53819497687413E-09  -4.29608889264225E-09  -3.09936315367137E-18
      1.59984613934571E-09
      0.00000000000000E+00  -2.78952672741444E-11   0.00000000000000E+00   3.58105577752561E-11   4.96120032564504E-23
      2.78595088179004E-08   2.78953193756757E-08  -7.47668419477882E-19  -2.74427321296061E-01  -2.74427321286328E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73304628522202E-09   0.00000000000000E+00  -9.73304628522202E-09
      3.75725764125876E-18  -5.50683224785669E-01  -5.44962202140583E-01   0.00000000000000E+00   2.62753303719176E-10
     -1.40304806453060E-22  -1.84250263941728E-08  -1.81622730904538E-08  -3.00958922178088E-18
      1.61984613934571E-09
      0.00000000000000E+00  -4.72240840642057E-11   0.00000000000000E+00   4.79362701342254E-11   1.44676914441791E-22
      4.71761412688824E-08   4.72240775390167E-08  -6.73143293521470E-19  -3.07238966702262E-01  -3.07238966691811E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04513204553140E-08   0.00000000000000E+00  -1.04513204553140E-08
      3.54823123215248E-18  -4.98338138427265E-01  -4.86753998194150E-01   0.00000000000000E+00   2.74121990153528E-10
     -1.27624289804755E-22  -3.70468790738562E-08  -3.67727570837028E-08  -2.87508793863101E-18
      1.63984613934571E-09
      0.00000000000000E+00  -6.03706479033538E-11   0.00000000000000E+00   3.27275056231537E-11   2.09795076188510E-22
      6.03379465394694E-08   6.03706740450928E-08  -6.28284098669634E-19  -3.28229253315364E-01  -3.28229253304271E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10931860896433E-08   0.00000000000000E+00  -1.10931860896433E-08
      3.32636751035962E-18  -4.09923253282927E-01  -3.94398991886145E-01   0.00000000000000E+00   2.54035073965345E-10
     -1.12416662892133E-22  -4.95315230294147E-08  -4.92774879554495E-08  -2.69808341168998E-18
      1.65984613934571E-09
      0.00000000000000E+00  -5.99916965176356E-11   0.00000000000000E+00  -8.34049674125096E-13   2.11355896837021E-22
      5.99926084204924E-08   5.99917743708185E-08  -6.08616453817598E-19  -3.39467062883985E-01  -3.39467062872334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16510328267289E-08   0.00000000000000E+00  -1.16510328267289E-08
      3.09334685382504E-18  -2.93757509639169E-01  -2.78527761541990E-01   0.00000000000000E+00   2.10909456841101E-10
     -9.68506366867348E-23  -4.85516510009304E-08  -4.83407415440894E-08  -2.48473040000744E-18
      1.67984613934571E-09
      0.00000000000000E+00  -5.30000158977126E-11   0.00000000000000E+00  -1.73094222317041E-11   1.77242183249217E-22
      5.30173032668258E-08   5.29999938445942E-08  -5.99093650420062E-19  -3.46843232900212E-01  -3.46843232888349E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18636084708295E-08   0.00000000000000E+00  -1.18636084708295E-08
      2.85607468440845E-18  -1.80297393860358E-01  -1.67337043623423E-01   0.00000000000000E+00   1.34408409182838E-10
     -8.22233340383965E-23  -4.12707937829476E-08  -4.11363853737648E-08  -2.25698103398839E-18
      1.69984613934571E-09
      0.00000000000000E+00  -4.69739908447896E-11   0.00000000000000E+00  -1.49380697690995E-11   1.43169301132881E-22
      4.69889145944785E-08   4.69739765247095E-08  -5.86547757055722E-19  -3.55378928490518E-01  -3.55378928478789E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17295571199740E-08   0.00000000000000E+00  -1.17295571199740E-08
      2.62148354200897E-18  -8.93502131580151E-02  -7.82460065713189E-02   0.00000000000000E+00   7.24015831670324E-11
     -6.43568900018981E-23  -3.53168209879025E-08  -3.52444194047355E-08  -2.03493578495325E-18
      1.70984613934571E-09
      0.00000000000000E+00  -4.22402212443764E-11   0.00000000000000E+00  -2.33946242233338E-11   1.30391794968716E-22
      4.22635707138840E-08   4.22401760896608E-08  -5.75129221876334E-19  -3.61345462949482E-01  -3.61345462938005E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14768983063851E-08   0.00000000000000E+00  -1.14768983063851E-08
      2.50671455894512E-18  -5.59799325483809E-02  -4.62875199984190E-02   0.00000000000000E+00   5.40320609144452E-11
     -2.27600928582891E-23  -3.08173098441900E-08  -3.07632777832756E-08  -1.93158533706878E-18
      1.71659613934571E-09
      0.00000000000000E+00  -3.85857191508889E-11   0.00000000000000E+00  -2.67493019094751E-11   1.27945415345369E-22
      3.86124330290434E-08   3.85856837271341E-08  -5.62151922068928E-19  -3.67123691944988E-01  -3.67123691933871E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11172764811723E-08   0.00000000000000E+00  -1.11172764811723E-08
      2.43167294269720E-18  -4.08017660592807E-02  -3.21474300110787E-02   0.00000000000000E+00   4.50828498872592E-11
      2.32875217004478E-23  -2.75134900958489E-08  -2.74684072459616E-08  -1.86952102062828E-18
      1.72115238934571E-09
      0.00000000000000E+00  -3.63205523971397E-11   0.00000000000000E+00  -2.45833304576315E-11   1.29489748542102E-22
      3.63451735130381E-08   3.63205901825806E-08  -5.51005390301014E-19  -3.71822093186666E-01  -3.71822093175812E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08540587086404E-08   0.00000000000000E+00  -1.08540587086404E-08
      2.38221913770596E-18  -3.36511140770004E-02  -2.56274886052804E-02   0.00000000000000E+00   3.75504925854715E-11
      5.49551605370828E-23  -2.55040819665256E-08  -2.54665314739401E-08  -1.83121374740495E-18
      1.72730332684571E-09
      0.00000000000000E+00  -3.43183371260156E-11   0.00000000000000E+00  -1.61191935881218E-11   1.35522352228148E-22
      3.43344413377687E-08   3.43183221441807E-08  -5.33442054471375E-19  -3.79038953570291E-01  -3.79038953559702E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05886313534429E-08   0.00000000000000E+00  -1.05886313534429E-08
      2.31708912804039E-18  -2.75737653077322E-02  -2.00973469551797E-02   0.00000000000000E+00   2.62053199043421E-11
      9.23075360018080E-23  -2.37558961106423E-08  -2.37296907907379E-08  -1.78364707356902E-18
      1.73560709247071E-09
      0.00000000000000E+00  -3.27796622435779E-11   0.00000000000000E+00  -9.14875046462354E-12   1.45472744736132E-22
      3.27887634142959E-08   3.27796146638315E-08  -5.08026666608846E-19  -3.89368801127542E-01  -3.89368801117162E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03798808903339E-08   0.00000000000000E+00  -1.03798808903339E-08
      2.23089702991165E-18  -2.27503961417133E-02  -1.56929914733330E-02   0.00000000000000E+00   1.74417447533604E-11
      1.33173087975737E-22  -2.24171755182511E-08  -2.23997337734976E-08  -1.72287036330280E-18
      1.74681717606446E-09
      0.00000000000000E+00  -3.16230614679235E-11   0.00000000000000E+00  -5.06373870439293E-12   1.55136755434911E-22
      3.16281536598920E-08   3.16230899211877E-08  -4.73605629247921E-19  -4.03345297140268E-01  -4.03345297130042E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02259644381527E-08   0.00000000000000E+00  -1.02259644381527E-08
      2.11626311373324E-18  -1.89867957604245E-02  -1.22452699377008E-02   0.00000000000000E+00   1.19369103893409E-11
      1.71804590022661E-22  -2.14090623934245E-08  -2.13971254830350E-08  -1.64265748448532E-18
      1.76195078891602E-09
      0.00000000000000E+00  -3.05602341689580E-11   0.00000000000000E+00  -3.42778702969315E-12   1.55412298923474E-22
      3.05636348425671E-08   3.05602070555376E-08  -4.29146962575130E-19  -4.21532288659584E-01  -4.21532288649497E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00878275080580E-08   0.00000000000000E+00  -1.00878275080580E-08
      1.96359783771295E-18  -1.59716553501415E-02  -9.52147793234398E-03   0.00000000000000E+00   8.99015714339798E-12
      1.94532354118305E-22  -2.04813697046231E-08  -2.04723795474795E-08  -1.53445087513782E-18
      1.78195078891602E-09
      0.00000000000000E+00  -2.93001243744708E-11   0.00000000000000E+00  -3.07284921703766E-12   1.34993146294967E-22
      2.93031989512357E-08   2.93001261020188E-08  -3.74606256471275E-19  -4.44165177209824E-01  -4.44165177199896E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.92764480744801E-09   0.00000000000000E+00  -9.92764480744801E-09
      1.76504494156399E-18  -1.34905752367100E-02  -7.38693225056525E-03   0.00000000000000E+00   7.46550164253022E-12
      1.81497857342423E-22  -1.93799467962135E-08  -1.93724812945707E-08  -1.39043868509271E-18
      1.80195078891602E-09
      0.00000000000000E+00  -2.81331451435119E-11   0.00000000000000E+00  -2.84826611947943E-12   1.01484545581716E-22
      2.81359980123943E-08   2.81331497462749E-08  -3.24032367822138E-19  -4.65501515646822E-01  -4.65501515637036E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.78622744878550E-09   0.00000000000000E+00  -9.78622744878550E-09
      1.56932039258828E-18  -1.18358434521867E-02  -6.05531534997838E-03   0.00000000000000E+00   6.41839522040745E-12
      1.39304625713399E-22  -1.83533406927099E-08  -1.83469222974894E-08  -1.24528802476614E-18
      1.82195078891602E-09
      0.00000000000000E+00  -2.71932061029301E-11   0.00000000000000E+00  -2.29223409459638E-12   6.69915392663224E-23
      2.71955275635342E-08   2.71932353294397E-08  -2.76698249094650E-19  -4.85803107061942E-01  -4.85803107052285E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.65725133662914E-09   0.00000000000000E+00  -9.65725133662914E-09
      1.37617536585569E-18  -1.07073239683961E-02  -5.18229205957446E-03   0.00000000000000E+00   5.30337896771295E-12
      9.02339556599506E-23  -1.75412873717785E-08  -1.75359839928107E-08  -1.09947711676104E-18
      1.84195078891602E-09
      0.00000000000000E+00  -2.64596421868536E-11   0.00000000000000E+00  -1.78559706787585E-12   3.95805267190699E-23
      2.64614481830867E-08   2.64596625860189E-08  -2.32092039006919E-19  -5.05270153523976E-01  -5.05270153514415E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56105131865151E-09   0.00000000000000E+00  -9.56105131865151E-09
      1.18495433948266E-18  -9.90347015586820E-03  -4.57925048212534E-03   0.00000000000000E+00   4.44847318877944E-12
      4.96532309806645E-23  -1.69030597405562E-08  -1.68986112673673E-08  -9.52862300475745E-19
      1.86195078891602E-09
      0.00000000000000E+00  -2.69921579731828E-11   0.00000000000000E+00   1.33593112224569E-12   2.19781918826198E-23
      2.69908363698467E-08   2.69921723009690E-08  -1.86040313949760E-19  -5.25838494393820E-01  -5.25838494383459E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03609955502768E-08   0.00000000000000E+00  -1.03609955502768E-08
      9.77734428477127E-19  -9.49812387948807E-03  -4.25816103234730E-03   0.00000000000000E+00   3.42100449369379E-12
      2.30657660784537E-23  -1.66345977551859E-08  -1.66311767506921E-08  -7.91694114527368E-19
      1.88195078891602E-09
      0.00000000000000E+00  -2.78439260660454E-11   0.00000000000000E+00   2.12986756481089E-12   1.22728897953864E-23
      2.78418026132740E-08   2.78439324808388E-08  -1.39232768029583E-19  -5.47281345323707E-01  -5.47281345312558E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11492021380763E-08   0.00000000000000E+00  -1.11492021380763E-08
      7.54750385715602E-19  -9.32297175041815E-03  -4.06298238692486E-03   0.00000000000000E+00   2.48390054605787E-12
      8.53800200453138E-24  -1.66972142433087E-08  -1.66947303427626E-08  -6.15517617686019E-19
      1.89195078891602E-09
      0.00000000000000E+00  -2.85599476373153E-11   0.00000000000000E+00   3.55823901489839E-12   9.05851839639301E-24
      2.85563740559778E-08   2.85599322949927E-08  -1.15799728818078E-19  -5.58252732292946E-01  -5.58252732281284E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16616171601092E-08   0.00000000000000E+00  -1.16616171601092E-08
      6.38134214114510E-19  -9.34906754670461E-03  -4.02493344933527E-03   0.00000000000000E+00   1.53402054160831E-12
      3.71703108899663E-24  -1.68998491554250E-08  -1.68983151348834E-08  -5.22334485296432E-19
      1.89532578891602E-09
      0.00000000000000E+00  -2.89001405439320E-11   0.00000000000000E+00   4.98874826434702E-12   8.15832192060329E-24
      2.88952162673683E-08   2.89002050156327E-08  -1.07902757740337E-19  -5.61989726453451E-01  -5.61989726441588E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18631232529316E-08   0.00000000000000E+00  -1.18631232529316E-08
      5.98096173135866E-19  -9.39629883469497E-03  -4.02844289117267E-03   0.00000000000000E+00   4.71832865580632E-13
      2.34445731652195E-24  -1.70375535955668E-08  -1.70370817627012E-08  -4.90193415395529E-19
      1.89988203891602E-09
      0.00000000000000E+00  -2.92838678559850E-11   0.00000000000000E+00   4.19701509073162E-12   7.25481850065507E-24
      2.92796702039809E-08   2.92838672190716E-08  -9.72316962965493E-20  -5.67062476189925E-01  -5.67062476177910E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20144823220603E-08   0.00000000000000E+00  -1.20144823220603E-08
      5.43355188055979E-19  -9.47128549392341E-03  -4.03023729078320E-03   0.00000000000000E+00  -4.56869947819636E-14
      1.00641437190680E-24  -1.72693392100168E-08  -1.72693848970116E-08  -4.46123491759431E-19
      1.90603297641602E-09
      0.00000000000000E+00  -2.95128367858434E-11   0.00000000000000E+00   1.88402266518335E-12   6.39946348764869E-24
      2.95109829471139E-08   2.95128669697791E-08  -8.30640293364737E-20  -5.73831193142725E-01  -5.73831193130713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20124111979607E-08   0.00000000000000E+00  -1.20124111979607E-08
      4.69467597553022E-19  -9.51610484875307E-03  -4.00225284041955E-03   0.00000000000000E+00   5.43855753342331E-13
     -1.61527306249674E-25  -1.75009996275715E-08  -1.75004557718182E-08  -3.86403568216549E-19
      1.91433674204102E-09
      0.00000000000000E+00  -2.92911235902244E-11   0.00000000000000E+00  -1.27810713618751E-12   5.60372348704471E-24
      2.92924331166159E-08   2.92911550094797E-08  -6.49210579346710E-20  -5.82553614668712E-01  -5.82553614657073E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16398502242669E-08   0.00000000000000E+00  -1.16398502242669E-08
      3.72813009380606E-19  -9.47331977066796E-03  -3.91193923122566E-03   0.00000000000000E+00   1.35197883893739E-12
     -1.06449228141133E-24  -1.76526567640517E-08  -1.76513047852128E-08  -3.07891951445935E-19
      1.92554682563477E-09
      0.00000000000000E+00  -2.79357708032530E-11   0.00000000000000E+00  -5.93717436200177E-12   4.79793867170146E-24
      2.79416646121338E-08   2.79357274377718E-08  -4.39382243201515E-20  -5.92696155869734E-01  -5.92696155859502E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02328518158430E-08   0.00000000000000E+00  -1.02328518158430E-08
      2.58101885122550E-19  -9.28273756656270E-03  -3.70510753402435E-03   0.00000000000000E+00   1.67812848338937E-12
     -1.68873904231534E-24  -1.77045537504121E-08  -1.77028756219287E-08  -2.14163660802399E-19
      1.94068043848633E-09
      0.00000000000000E+00  -2.29812982993301E-11   0.00000000000000E+00  -1.61334288060416E-11   3.65705046477916E-24
      2.29974622556579E-08   2.29813288268519E-08  -2.98146560923909E-20  -5.99364981186509E-01  -5.99364981181225E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28434586541792E-09   0.00000000000000E+00  -5.28434586541792E-09
      1.78130640621560E-19  -8.77714831361518E-03  -3.20137336782297E-03   0.00000000000000E+00   9.80430939042076E-13
     -2.13577404302283E-24  -1.76979633923729E-08  -1.76969829614339E-08  -1.48315984529170E-19
      1.96068043848633E-09
      0.00000000000000E+00  -8.61659771059854E-12   0.00000000000000E+00  -3.54090550030106E-11   1.29125467710259E-24
      8.65198821571828E-09   8.61657916071528E-09  -6.37132084222965E-20  -5.81980806654515E-01  -5.81980806663590E-01
      0.00000000000000E+00   0.00000000000000E+00   9.07508530409692E-09   0.00000000000000E+00   9.07508530409692E-09
      3.59632346703499E-19  -7.54398644996490E-03  -1.96988698703877E-03   0.00000000000000E+00  -1.61541067346268E-12
     -2.82919491484187E-24  -1.76900490541386E-08  -1.76916644648121E-08  -2.95919138281201E-19
      1.98068043848633E-09
      0.00000000000000E+00   1.02889985304104E-11   0.00000000000000E+00  -4.64096654484461E-11  -3.01783718242611E-24
     -1.02423782525969E-08  -1.02887879180454E-08  -1.76839246199942E-19  -5.28025053226303E-01  -5.28025053254270E-01
      0.00000000000000E+00   0.00000000000000E+00   2.79663358539426E-08   0.00000000000000E+00   2.79663358539426E-08
      9.18959063782352E-19  -5.86694406603276E-03  -2.97357408340138E-04   0.00000000000000E+00  -6.07506483080504E-12
     -5.75950420184211E-24  -1.76714728710665E-08  -1.76775479358973E-08  -7.42119817582409E-19
      2.00068043848633E-09
      0.00000000000000E+00   2.30924304313512E-11   0.00000000000000E+00  -3.17682311464801E-11  -1.54478181399069E-23
     -2.30606853896657E-08  -2.30924536208122E-08  -3.84605831701960E-19  -4.38988856986377E-01  -4.38988857027090E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07137321462117E-08   0.00000000000000E+00   4.07137321462117E-08
      1.73323370670659E-18  -4.17513917282037E-03   1.37677805953288E-03   0.00000000000000E+00  -1.30562818158322E-11
     -2.47048428893641E-23  -1.76082222435837E-08  -1.76212785253996E-08  -1.34862787500463E-18
      2.02068043848633E-09
      0.00000000000000E+00   2.17400166759704E-11   0.00000000000000E+00   2.91795707390507E-12  -3.82838614591543E-23
     -2.17429311440392E-08  -2.17400131869654E-08  -6.79792986666734E-19  -3.20989214358102E-01  -3.20989214397493E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93909015998289E-08   0.00000000000000E+00   3.93909015998289E-08
      2.52105173870316E-18  -1.93512904728719E-03   3.62610577760402E-03   0.00000000000000E+00  -3.05206424100236E-11
     -6.92449286828713E-23  -1.76203677704534E-08  -1.76508884128635E-08  -1.84125875203643E-18
      2.04068043848633E-09
      0.00000000000000E+00   1.37621072679130E-11   0.00000000000000E+00   1.90239295365356E-11  -4.35097080240931E-23
     -1.37811948473068E-08  -1.37621709177703E-08  -9.46351216388689E-19  -2.00500699408936E-01  -2.00500699438318E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93817848556745E-08   0.00000000000000E+00   2.93817848556745E-08
      3.10868743581666E-18  -1.36625966318872E-02  -8.74136926674693E-03   0.00000000000000E+00  -6.32231218217555E-11
     -8.35774171919664E-23  -1.55563908160824E-08  -1.56196139379043E-08  -2.16233621942797E-18
      2.06068043848633E-09
      0.00000000000000E+00   9.28449263957167E-12   0.00000000000000E+00   1.02321655260132E-11  -4.62459096575915E-23
     -9.29474816073537E-09  -9.28451599520940E-09  -1.13071784797492E-18  -1.03019948540105E-01  -1.03019948561738E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16332250834255E-08   0.00000000000000E+00   2.16332250834255E-08
      3.54135193748517E-18  -4.63426681025166E-02  -4.24519959090627E-02   0.00000000000000E+00  -1.16959071410247E-10
     -9.67307258365647E-23  -1.22317500168057E-08  -1.23487090882160E-08  -2.41063408951025E-18
      2.07068043848633E-09
      0.00000000000000E+00   6.62007681318132E-12   0.00000000000000E+00   1.22764631140274E-11  -4.72039892729259E-23
     -6.63237291692039E-09  -6.62009645380641E-09  -1.19623428673173E-18  -6.51541709761463E-02  -6.51541709930235E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68771884445024E-08   0.00000000000000E+00   1.68771884445024E-08
      3.71012382193019E-18  -6.88476277548955E-02  -6.56159339656998E-02   0.00000000000000E+00  -1.63036007153327E-10
     -1.03296080843650E-22  -1.00940559835425E-08  -1.02570919906959E-08  -2.51388953519846E-18
      2.07743043848633E-09
      0.00000000000000E+00   4.56578557606057E-12   0.00000000000000E+00   1.43169280256878E-11  -4.76052850096560E-23
     -4.58012151122881E-09  -4.56580458320317E-09  -1.22656840794271E-18  -4.69087312373762E-02  -4.69087312507037E-02
      0.00000000000000E+00   0.00000000000000E+00   1.33274858762869E-08   0.00000000000000E+00   1.33274858762869E-08
      3.80008435159513E-18  -8.68110096131487E-02  -8.40504642118856E-02   0.00000000000000E+00  -1.76194840405542E-10
     -1.07470842506151E-22  -8.58548645267835E-09  -8.76168129308400E-09  -2.57351594365242E-18
      2.08198668848633E-09
      0.00000000000000E+00   3.23348581812819E-12   0.00000000000000E+00   1.39173332524112E-11  -4.77741709271154E-23
     -3.24739457888452E-09  -3.23347724563216E-09  -1.24096915890473E-18  -3.80241263217342E-02  -3.80241263327507E-02
      0.00000000000000E+00   0.00000000000000E+00   1.10165267247295E-08   0.00000000000000E+00   1.10165267247295E-08
      3.85027840148468E-18  -1.00050003250547E-01  -9.75977899933410E-02   0.00000000000000E+00  -1.79357797609827E-10
     -1.10132089995317E-22  -7.60369168148742E-09  -7.78304947909736E-09  -2.60930924257995E-18
      2.08813762598633E-09
      0.00000000000000E+00   2.02471723173993E-12   0.00000000000000E+00   9.40680477312188E-12  -4.79057302100858E-23
     -2.03407514386466E-09  -2.02466833909159E-09  -1.25297373384656E-18  -3.03629849189676E-02  -3.03629849278378E-02
      0.00000000000000E+00   0.00000000000000E+00   8.87020166818484E-09   0.00000000000000E+00   8.87020166818484E-09
      3.90483845755807E-18  -1.19094853693773E-01  -1.16938022759568E-01   0.00000000000000E+00  -1.78889105590459E-10
     -1.13472334659640E-22  -6.66664422350289E-09  -6.84553332909346E-09  -2.65186472371151E-18
      2.09644139161133E-09
      0.00000000000000E+00   1.13749707031522E-12   0.00000000000000E+00   5.12070929279913E-12  -4.79961772366141E-23
     -1.14263331095987E-09  -1.13751260166712E-09  -1.26181917706995E-18  -2.43840269009083E-02  -2.43840269080752E-02
      0.00000000000000E+00   0.00000000000000E+00   7.16682335947272E-09   0.00000000000000E+00   7.16682335947272E-09
      3.96435007901091E-18  -1.45504056322321E-01  -1.43604391573994E-01   0.00000000000000E+00  -1.82121597860808E-10
     -1.17715670781587E-22  -5.84718915994449E-09  -6.02931075780542E-09  -2.70253090194096E-18
      2.10765147520508E-09
      0.00000000000000E+00   6.04613905037149E-13   0.00000000000000E+00   2.27598154670313E-12  -4.80531120422946E-23
     -6.06893699327638E-10  -6.04617717780983E-10  -1.26780471989201E-18  -1.99200240049817E-02  -1.99200240109110E-02
      0.00000000000000E+00   0.00000000000000E+00   5.92928832035560E-09   0.00000000000000E+00   5.92928832035560E-09
      4.03081789673354E-18  -1.80582840108104E-01  -1.78905184769382E-01   0.00000000000000E+00  -1.90100370608661E-10
     -1.23179861716596E-22  -5.13457023196578E-09  -5.32467060257457E-09  -2.76301317684153E-18
      2.12278508805664E-09
      0.00000000000000E+00   3.28620469728531E-13   0.00000000000000E+00   8.71875851928664E-13  -4.80856863386945E-23
     -3.29491950057298E-10  -3.28620074205418E-10  -1.27174225821702E-18  -1.65289173597473E-02  -1.65289173646581E-02
      0.00000000000000E+00   0.00000000000000E+00   4.91083450335315E-09   0.00000000000000E+00   4.91083450335315E-09
      4.10513656488538E-18  -2.24379801548365E-01  -2.22936069802106E-01   0.00000000000000E+00  -1.97723134920145E-10
     -1.30089350153414E-22  -4.38449129422751E-09  -4.58221442914779E-09  -2.83339430666836E-18
      2.14278508805664E-09
      0.00000000000000E+00   2.05640366607652E-13   0.00000000000000E+00   2.93852205104917E-13  -4.81033308028880E-23
     -2.05977570155211E-10  -2.05683717950155E-10  -1.27453465678677E-18  -1.38495098035247E-02  -1.38495098073068E-02
      0.00000000000000E+00   0.00000000000000E+00   3.78206022832902E-09   0.00000000000000E+00   3.78206022832902E-09
      4.18077776945196E-18  -2.71524869513983E-01  -2.70398045950199E-01   0.00000000000000E+00  -1.87039938273867E-10
     -1.37811216046499E-22  -3.38933657210487E-09  -3.57637651037887E-09  -2.90624311266519E-18
      2.16278508805664E-09
      0.00000000000000E+00   1.60728290113172E-13   0.00000000000000E+00   1.07965346291300E-13  -4.81115923511883E-23
     -1.60845089362944E-10  -1.60737124016701E-10  -1.27646167047939E-18  -1.20802121720430E-02  -1.20802121747444E-02
      0.00000000000000E+00   0.00000000000000E+00   2.70138689545521E-09   0.00000000000000E+00   2.70138689545521E-09
      4.23480550736107E-18  -3.05415639354240E-01  -3.04615143229335E-01   0.00000000000000E+00  -1.53000697123447E-10
     -1.43577106741565E-22  -2.38764907431492E-09  -2.54064977143851E-09  -2.95834383688168E-18
      2.18278508805664E-09
      0.00000000000000E+00   1.38685553183365E-13   0.00000000000000E+00   5.45457169835046E-14  -4.81143902135240E-23
     -1.38720114927693E-10  -1.38665569210758E-10  -1.27797021036594E-18  -1.08821402213583E-02  -1.08821402231958E-02
      0.00000000000000E+00   0.00000000000000E+00   1.83751942591329E-09   0.00000000000000E+00   1.83751942591329E-09
      4.27155589587933E-18  -3.27660115130396E-01  -3.27124849303384E-01   0.00000000000000E+00  -1.08464321380815E-10
     -1.47433702153963E-22  -1.59038953532151E-09  -1.69885385670247E-09  -2.99358568551339E-18
      2.20278508805664E-09
      0.00000000000000E+00   1.30878750520726E-13   0.00000000000000E+00   2.00117380703080E-14  -4.81159574260592E-23
     -1.30933735897206E-10  -1.30913724159184E-10  -1.27933837434997E-18  -1.00262050914216E-02  -1.00262050925726E-02
      0.00000000000000E+00   0.00000000000000E+00   1.15101583554665E-09   0.00000000000000E+00   1.15101583554665E-09
      4.29457621259027E-18  -3.39999983412086E-01  -3.39678579792731E-01   0.00000000000000E+00  -6.16271418249657E-11
     -1.49559468987681E-22  -9.58474969562354E-10  -1.02010211138747E-09  -3.01523783824030E-18
      2.22278508805664E-09
      0.00000000000000E+00   1.14989610983824E-13   0.00000000000000E+00   4.24334049990731E-14  -4.81118086461705E-23
     -1.14990644274339E-10  -1.14948210869388E-10  -1.28039759668061E-18  -9.50337180079626E-03  -9.50337180152818E-03
      0.00000000000000E+00   0.00000000000000E+00   7.31921735397078E-10   0.00000000000000E+00   7.31921735397078E-10
      4.30921464729821E-18  -3.46537491020815E-01  -3.46343106765310E-01   0.00000000000000E+00  -3.09378608318017E-11
     -1.50612843793452E-22  -5.86035663695791E-10  -6.16973524527744E-10  -3.02881705061760E-18
      2.24278508805664E-09
      0.00000000000000E+00   8.55074503402074E-14   0.00000000000000E+00   8.02744801536148E-14  -4.80968698061940E-23
     -8.55953726985829E-11  -8.55150982184774E-11  -1.28087985961643E-18  -9.30352228782412E-03  -9.30352228854421E-03
      0.00000000000000E+00   0.00000000000000E+00   7.20093211805028E-10   0.00000000000000E+00   7.20093211805028E-10
      4.32361651153431E-18  -3.53834631364433E-01  -3.53634699650368E-01   0.00000000000000E+00  -3.44129738828617E-11
     -1.51750921042537E-22  -6.00165139703443E-10  -6.34578113586457E-10  -3.04273665191788E-18
      2.25278508805664E-09
      0.00000000000000E+00   6.94346213288902E-14   0.00000000000000E+00   8.94984579841733E-14  -4.80866005245335E-23
     -6.95435588833334E-11  -6.94540604253973E-11  -1.28096376334626E-18  -9.27323727493669E-03  -9.27323727574166E-03
      0.00000000000000E+00   0.00000000000000E+00   8.04965085582537E-10   0.00000000000000E+00   8.04965085582537E-10
      4.33166616239014E-18  -3.58385290414801E-01  -3.58153555692002E-01   0.00000000000000E+00  -4.44123812125882E-11
     -1.52471791375956E-22  -6.91098643944467E-10  -7.35511025157207E-10  -3.05070239904388E-18
      2.25953508805664E-09
      0.00000000000000E+00   4.05953738457268E-14   0.00000000000000E+00   2.25240786893370E-13  -4.80751221641684E-23
     -4.07875323544406E-11  -4.05622915675953E-11  -1.28082739294467E-18  -9.33299299465077E-03  -9.33299299567372E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02294833869587E-09   0.00000000000000E+00   1.02294833869587E-09
      4.33857106367633E-18  -3.62912891755475E-01  -3.62603369135636E-01   0.00000000000000E+00  -6.82866634954640E-11
     -1.53208597194141E-22  -9.14099383632770E-10  -9.82386047128388E-10  -3.05774367073166E-18
      2.26409133805664E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   2.29822100131340E-13  -4.80658526848031E-23
     -2.12582424005875E-11  -2.10284203005042E-11  -1.28064744522530E-18  -9.40330219504259E-03  -9.40330219627812E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23553310298513E-09   0.00000000000000E+00   1.23553310298513E-09
      4.34420046137681E-18  -3.66860137497515E-01  -3.66477476599067E-01   0.00000000000000E+00  -9.08006858816077E-11
     -1.53864595292126E-22  -1.12370399680317E-09  -1.21450468268493E-09  -3.06355301615151E-18
      2.27024227555664E-09
      0.00000000000000E+00   1.81852579670903E-14   0.00000000000000E+00   4.27473338190460E-14  -4.80546190205653E-23
     -1.82712123888171E-11  -1.82284650550462E-11  -1.28038960185767E-18  -9.47166060999694E-03  -9.47166061149333E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49639384598627E-09   0.00000000000000E+00   1.49639384598627E-09
      4.35340468639886E-18  -3.73441751726723E-01  -3.72976014512272E-01   0.00000000000000E+00  -1.16063611917108E-10
     -1.54990101154958E-22  -1.36210176901373E-09  -1.47816538093100E-09  -3.07301508454118E-18
      2.27854604118164E-09
      0.00000000000000E+00   3.00332290668612E-14   0.00000000000000E+00  -5.33143766355254E-14  -4.80423282284485E-23
     -3.00048405438145E-11  -3.00581549204981E-11  -1.28014422499500E-18  -9.46825311010388E-03  -9.46825311180140E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69751283892344E-09   0.00000000000000E+00   1.69751283892344E-09
      4.36750043515870E-18  -3.83459370149934E-01  -3.82933990228256E-01   0.00000000000000E+00  -1.36005910586439E-10
     -1.56751788193452E-22  -1.53144877341642E-09  -1.66745468400301E-09  -3.08735621016370E-18
      2.28975612477539E-09
      0.00000000000000E+00   4.70245054502537E-14   0.00000000000000E+00  -6.16453381766668E-14  -4.80294891395823E-23
     -4.69517538237894E-11  -4.70133991620141E-11  -1.28001116515281E-18  -9.32690667822843E-03  -9.32690668001242E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78399213758084E-09   0.00000000000000E+00   1.78399213758084E-09
      4.38749913615158E-18  -3.97482861428944E-01  -3.96935575113311E-01   0.00000000000000E+00  -1.47427310829686E-10
     -1.59285458023720E-22  -1.58955142758890E-09  -1.73697873841874E-09  -3.10748797099877E-18
      2.30488973762696E-09
      0.00000000000000E+00   7.16388950218709E-14   0.00000000000000E+00  -7.21131061151616E-14  -4.80193817642339E-23
     -7.15506992608332E-11  -7.16228123669963E-11  -1.28021778018640E-18  -8.90964266411402E-03  -8.90964266589759E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78356663572823E-09   0.00000000000000E+00   1.78356663572823E-09
      4.41449094311165E-18  -4.15985323188397E-01  -4.15445924512057E-01   0.00000000000000E+00  -1.52555016640154E-10
     -1.62741691794838E-22  -1.55938880672094E-09  -1.71194382336125E-09  -3.13427316292525E-18
      2.32488973762696E-09
      0.00000000000000E+00   1.18204176786087E-13   0.00000000000000E+00  -1.15358271078752E-13  -4.80240130254327E-23
     -1.18060477310997E-10  -1.18175835582124E-10  -1.28144239958936E-18  -7.81443721350068E-03  -7.81443721526538E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76470122231506E-09   0.00000000000000E+00   1.76470122231506E-09
      4.44978496755795E-18  -4.39059398349333E-01  -4.38540611294696E-01   0.00000000000000E+00  -1.56135511882890E-10
     -1.67280026325896E-22  -1.49038987484983E-09  -1.64652538673289E-09  -3.16834256796859E-18
      2.34488973762696E-09
      0.00000000000000E+00   1.64493924338680E-13   0.00000000000000E+00  -1.23522069522062E-13  -4.80454312709625E-23
     -1.64397447777163E-10  -1.64520969846733E-10  -1.28361060324463E-18  -6.18410920491317E-03  -6.18410920665655E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74338016524896E-09   0.00000000000000E+00   1.74338016524896E-09
      4.48465257086293E-18  -4.60735415124416E-01  -4.60237947031600E-01   0.00000000000000E+00  -1.60261134402403E-10
     -1.71796250133599E-22  -1.41859806099979E-09  -1.57885919540237E-09  -3.20104196761830E-18
      2.36488973762696E-09
      0.00000000000000E+00   1.71382279629245E-13   0.00000000000000E+00  -2.80009150918125E-14  -4.80671246460262E-23
     -1.71343357638985E-10  -1.71371358554125E-10  -1.28593082831286E-18  -4.49224242660685E-03  -4.49224242828156E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67471001021516E-09   0.00000000000000E+00   1.67471001021516E-09
      4.51814677106724E-18  -4.81303560892416E-01  -4.80829886734001E-01   0.00000000000000E+00  -1.62397975995406E-10
     -1.76242580205300E-22  -1.34094067566537E-09  -1.50333865166095E-09  -3.23221594275438E-18
      2.38488973762696E-09
      0.00000000000000E+00   2.13630858744707E-13   0.00000000000000E+00  -1.22594408865464E-13  -4.81062813611124E-23
     -2.13506155082725E-10  -2.13628749491639E-10  -1.28910798022680E-18  -2.30570381517327E-03  -2.30570381684688E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67361550643389E-09   0.00000000000000E+00   1.67361550643389E-09
      4.55161908119591E-18  -5.00869104130215E-01  -5.00409087660838E-01   0.00000000000000E+00  -1.68045812626529E-10
     -1.80718815241421E-22  -1.29194094431559E-09  -1.45998675694230E-09  -3.26251110096911E-18
      2.40488973762696E-09
      0.00000000000000E+00  -4.89899828264948E-13   0.00000000000000E+00   1.83289931190934E-12  -4.78516427702563E-23
      4.88028960627535E-10   4.89861859939396E-10  -1.27826620519615E-18  -8.60682215912161E-03  -8.60682215961036E-03
      0.00000000000000E+00   0.00000000000000E+00   4.88755156881692E-10   0.00000000000000E+00   4.88755156881692E-10
      4.56139418433355E-18  -5.20453626936487E-01  -5.20145289992990E-01   0.00000000000000E+00  -1.05202753988355E-10
     -1.83459009357486E-22  -8.73414262832505E-10  -9.78617016821044E-10  -3.28312797913740E-18
      2.42488973762696E-09
      0.00000000000000E+00  -2.40605658062558E-12   0.00000000000000E+00   5.11146929174494E-12  -4.68592110303064E-23
      2.40093277425753E-09   2.40604424354923E-09  -1.22941266647603E-18  -3.71825311153321E-02  -3.71825311127418E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.59028878284942E-09   0.00000000000000E+00  -2.59028878284942E-09
      4.50958840867656E-18  -5.41364836002926E-01  -5.41422925554652E-01   0.00000000000000E+00   7.00845882456920E-11
     -1.81613783437127E-22   1.14159951054588E-10   1.84244539300098E-10  -3.28017574220053E-18
      2.44488973762696E-09
      0.00000000000000E+00  -4.23762433001808E-12   0.00000000000000E+00   5.06123123663395E-12  -4.52931641021637E-23
      4.23255517432329E-09   4.23761640555988E-09  -1.14569836751361E-18  -8.39043127249165E-02  -8.39043127195744E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.34215015054928E-09   0.00000000000000E+00  -5.34215015054928E-09
      4.40274540566557E-18  -5.62943126958150E-01  -5.63291214241685E-01   0.00000000000000E+00   2.06152938811657E-10
     -1.76054989936703E-22   8.98380806178043E-10   1.10453374498952E-09  -3.25704703815196E-18
      2.44738973762696E-09
      0.00000000000000E+00  -4.86749553778730E-12   0.00000000000000E+00   1.28069093380432E-11  -4.50471147247258E-23
      4.85465859960938E-09   4.86746550894738E-09  -1.13372494556305E-18  -9.03903654304350E-02  -9.03903654242130E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.22193538840781E-09   0.00000000000000E+00  -6.22193538840781E-09
      4.38719056719455E-18  -5.65659709210239E-01  -5.66086551004425E-01   0.00000000000000E+00   2.35772843252968E-10
     -1.75249996044708E-22   1.11869703620740E-09   1.35446987946019E-09  -3.25346562163151E-18
      2.45076473762696E-09
      0.00000000000000E+00  -5.43252436108800E-12   0.00000000000000E+00   8.87889878147620E-12  -4.47098362583771E-23
      5.42366888073034E-09   5.43254777951177E-09  -1.11581578797065E-18  -9.99639965094210E-02  -9.99639965024016E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.01937024313602E-09   0.00000000000000E+00  -7.01937024313602E-09
      4.36350019262397E-18  -5.69373313722592E-01  -5.69873374105337E-01   0.00000000000000E+00   2.66741715737634E-10
     -1.74010656561438E-22   1.32008074788605E-09   1.58682246362351E-09  -3.24768440465331E-18
      2.45532098762696E-09
      0.00000000000000E+00  -6.00251280019791E-12   0.00000000000000E+00   6.76598896933010E-12  -4.42275730267639E-23
      5.99575029764183E-09   6.00251628661112E-09  -1.08948922264434E-18  -1.13800945122292E-01  -1.13800945114546E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.74546875049644E-09   0.00000000000000E+00  -7.74546875049644E-09
      4.32820990062952E-18  -5.74388173673317E-01  -5.74937440370097E-01   0.00000000000000E+00   2.90313227151182E-10
     -1.72169991299509E-22   1.45263923673450E-09   1.74295246388551E-09  -3.23872067798518E-18
      2.46147192512696E-09
      0.00000000000000E+00  -6.60758592892110E-12   0.00000000000000E+00   5.41534375452926E-12  -4.35048940898511E-23
      6.60213224803680E-09   6.60754759179128E-09  -1.05161954996811E-18  -1.33239453290415E-01  -1.33239453282088E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.32623075714875E-09   0.00000000000000E+00  -8.32623075714875E-09
      4.27699577563172E-18  -5.81026931324971E-01  -5.81568574782980E-01   0.00000000000000E+00   3.01225581209918E-10
     -1.69554545968652E-22   1.41745758414763E-09   1.71868316535737E-09  -3.22537622566362E-18
      2.46977569075196E-09
      0.00000000000000E+00  -7.45264935596755E-12   0.00000000000000E+00   5.51901242966441E-12  -4.20928569649385E-23
      7.44711901303900E-09   7.45263802546862E-09  -9.98503690302401E-19  -1.59646232864341E-01  -1.59646232855619E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.72248139863356E-09   0.00000000000000E+00  -8.72248139863356E-09
      4.20456633442905E-18  -5.89461349078658E-01  -5.89861630139804E-01   0.00000000000000E+00   2.97817255311691E-10
     -1.65997162676246E-22   9.72026117853296E-10   1.26984337316482E-09  -3.20606264412665E-18
      2.48098577434571E-09
      0.00000000000000E+00  -9.40288050583217E-12   0.00000000000000E+00   8.98418603195032E-12  -3.71291071755970E-23
      9.39389661182382E-09   9.40288079785573E-09  -9.26209032042402E-19  -1.94142010108189E-01  -1.94142010099199E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.99008860784676E-09   0.00000000000000E+00  -8.99008860784676E-09
      4.10378668961986E-18  -5.98864777225396E-01  -5.98735067849951E-01   0.00000000000000E+00   2.85833805671271E-10
     -1.61265069271168E-22  -6.98625995679971E-10  -4.12792190008861E-10  -3.17757765757746E-18
      2.49611938719727E-09
      0.00000000000000E+00  -1.55406806039368E-11   0.00000000000000E+00   2.02875009244287E-11  -1.29099954202404E-23
      1.55203514475660E-08   1.55406389484904E-08  -8.33470674666893E-19  -2.36332784763792E-01  -2.36332784754497E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.29525737741662E-09   0.00000000000000E+00  -9.29525737741662E-09
      3.96311586311441E-18  -6.03336318193432E-01  -6.01369411148111E-01   0.00000000000000E+00   2.82611200090742E-10
     -1.54654488591998E-22  -6.52799277116425E-09  -6.24538157107366E-09  -3.12964518844752E-18
      2.51611938719727E-09
      0.00000000000000E+00  -3.19466304771057E-11   0.00000000000000E+00   4.06594476640925E-11   6.55609924567664E-23
      3.19059770187107E-08   3.19466364663748E-08  -7.32957520613829E-19  -2.80431609760161E-01  -2.80431609750290E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87094356907328E-09   0.00000000000000E+00  -9.87094356907328E-09
      3.76569699173295E-18  -5.80875393336541E-01  -5.73921756330834E-01   0.00000000000000E+00   3.09478681319180E-10
     -1.44046328754924E-22  -2.23851715786206E-08  -2.20756928973015E-08  -3.03273947111912E-18
      2.53611938719727E-09
      0.00000000000000E+00  -5.20077253569225E-11   0.00000000000000E+00   4.97540573228069E-11   1.60995280961528E-22
      5.19579550625325E-08   5.20077091198555E-08  -6.62747540448748E-19  -3.11444833111643E-01  -3.11444833101085E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05578857607347E-08   0.00000000000000E+00  -1.05578857607347E-08
      3.55453927651825E-18  -5.21527131612815E-01  -5.08469732960005E-01   0.00000000000000E+00   3.15741565375107E-10
     -1.30350524528453E-22  -4.17655649244959E-08  -4.14498233591209E-08  -2.89179173606950E-18
      2.55611938719727E-09
      0.00000000000000E+00  -6.48033504552007E-11   0.00000000000000E+00   3.18824556384630E-11   2.20573292131930E-22
      6.47714493160419E-08   6.48033317716806E-08  -6.20706727698371E-19  -3.31313943182512E-01  -3.31313943171358E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11539329994178E-08   0.00000000000000E+00  -1.11539329994178E-08
      3.33146061652990E-18  -4.27917560752147E-01  -4.11016059751054E-01   0.00000000000000E+00   2.81599631423600E-10
     -1.14087236422196E-22  -5.39309984036862E-08  -5.36493987722627E-08  -2.71075388883152E-18
      2.57611938719727E-09
      0.00000000000000E+00  -6.32995765729019E-11   0.00000000000000E+00  -3.62985804568966E-12   2.15068827049342E-22
      6.33031668888043E-08   6.32995370307588E-08  -6.03192291166958E-19  -3.41697284362233E-01  -3.41697284350539E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16946387160929E-08   0.00000000000000E+00  -1.16946387160929E-08
      3.09756784220804E-18  -3.06977943880825E-01  -2.90719860132007E-01   0.00000000000000E+00   2.29436979625748E-10
     -9.77513434785844E-23  -5.18343352942916E-08  -5.16048983146660E-08  -2.49437555104108E-18
      2.59611938719727E-09
      0.00000000000000E+00  -5.44935031694442E-11   0.00000000000000E+00  -2.18225844133047E-11   1.73413451247408E-22
      5.45153139331663E-08   5.44934913487532E-08  -5.96394647205792E-19  -3.48010818356918E-01  -3.48010818344992E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19260493824136E-08   0.00000000000000E+00  -1.19260493824136E-08
      2.85904685455977E-18  -1.88111866575613E-01  -1.74700667391841E-01   0.00000000000000E+00   1.47143244075367E-10
     -8.20873184437639E-23  -4.27145852104149E-08  -4.25674419663396E-08  -2.26265220735397E-18
      2.61611938719727E-09
      0.00000000000000E+00  -4.77021359213708E-11   0.00000000000000E+00  -1.68481874313833E-11   1.35843853214232E-22
      4.77189886603527E-08   4.77021404729215E-08  -5.85627409392259E-19  -3.55877368853242E-01  -3.55877368841468E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17741012521958E-08   0.00000000000000E+00  -1.17741012521958E-08
      2.62356482951585E-18  -9.38215880642284E-02  -8.25020048180167E-02   0.00000000000000E+00   7.71100257025657E-11
     -6.67602770168120E-23  -3.60051492464281E-08  -3.59280392207256E-08  -2.03793742012359E-18
      2.62611938719727E-09
      0.00000000000000E+00  -4.28822159574570E-11   0.00000000000000E+00  -2.38340438590693E-11   1.21484538955762E-22
      4.29060708259128E-08   4.28822367820538E-08  -5.75397334300151E-19  -3.61428537488542E-01  -3.61428537477010E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15324654400839E-08   0.00000000000000E+00  -1.15324654400839E-08
      2.50824017511501E-18  -5.87361288792913E-02  -4.88589364249178E-02   0.00000000000000E+00   5.61415326962227E-11
     -3.15597768526908E-23  -3.14059128746662E-08  -3.13497713419700E-08  -1.93284284081486E-18
      2.62949438719727E-09
      0.00000000000000E+00  -4.06162226010729E-11   0.00000000000000E+00  -3.30935794828313E-11   1.17865700933904E-22
      4.06493385011052E-08   4.06162449216225E-08  -5.70480502145429E-19  -3.63764223791226E-01  -3.63764223779864E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13612870837531E-08   0.00000000000000E+00  -1.13612870837531E-08
      2.46989583120734E-18  -4.91141606109515E-02  -3.98969576936141E-02   0.00000000000000E+00   5.55379537335081E-11
     -1.08177522986615E-23  -2.93104957916026E-08  -2.92549578378691E-08  -1.89941532906191E-18
      2.63405063719727E-09
      0.00000000000000E+00  -3.80790117357150E-11   0.00000000000000E+00  -2.75926619051648E-11   1.16724614212829E-22
      3.81065921904578E-08   3.80789995285528E-08  -5.61074493960874E-19  -3.67873237191376E-01  -3.67873237180309E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10669789345029E-08   0.00000000000000E+00  -1.10669789345029E-08
      2.41947190843701E-18  -3.96561829693746E-02  -3.11456364616170E-02   0.00000000000000E+00   4.37570383792788E-11
      1.98906096803696E-23  -2.70557776324288E-08  -2.70120205940495E-08  -1.85839741447614E-18
      2.64020157469727E-09
      0.00000000000000E+00  -3.55991119863746E-11   0.00000000000000E+00  -1.99640571925616E-11   1.20306583429094E-22
      3.56190384440121E-08   3.55990743868196E-08  -5.44930343816790E-19  -3.74605528318934E-01  -3.74605528308190E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07442651672620E-08   0.00000000000000E+00  -1.07442651672620E-08
      2.35338460490976E-18  -3.14232154062257E-02  -2.35923176210646E-02   0.00000000000000E+00   3.19015967653296E-11
      5.80578437651641E-23  -2.48867108163232E-08  -2.48548092195578E-08  -1.80845426109297E-18
      2.64850534032227E-09
      0.00000000000000E+00  -3.35756805809556E-11   0.00000000000000E+00  -1.20445043808016E-11   1.29103805202937E-22
      3.35877110305578E-08   3.35756665261771E-08  -5.20164905236981E-19  -3.84709014357065E-01  -3.84709014346594E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04709429101420E-08   0.00000000000000E+00  -1.04709429101420E-08
      2.26643634911118E-18  -2.50043014993555E-02  -1.77247831478016E-02   0.00000000000000E+00   2.12803342345091E-11
      1.01141982806899E-22  -2.31260039502697E-08  -2.31047236160351E-08  -1.74627144387420E-18
      2.65971542391602E-09
      0.00000000000000E+00  -3.21115836251304E-11   0.00000000000000E+00  -6.42674520462667E-12   1.39866552706190E-22
      3.21179678188860E-08   3.21115410736815E-08  -4.85542943057026E-19  -3.98740816460958E-01  -3.98740816450684E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02738156910492E-08   0.00000000000000E+00  -1.02738156910492E-08
      2.15126601638774E-18  -2.02688759594461E-02  -1.33885349223655E-02   0.00000000000000E+00   1.38452496445059E-11
      1.43915340491185E-22  -2.18515706322769E-08  -2.18377253826323E-08  -1.66572307333072E-18
      2.67484903676758E-09
      0.00000000000000E+00  -3.09428593441646E-11   0.00000000000000E+00  -3.77507931511562E-12   1.43938750427455E-22
      3.09466086578847E-08   3.09428335785697E-08  -4.40212573372942E-19  -4.17194879755873E-01  -4.17194879745754E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01192419200977E-08   0.00000000000000E+00  -1.01192419200977E-08
      1.99812532681768E-18  -1.67321132539065E-02  -1.01712824104110E-02   0.00000000000000E+00   9.70806927170575E-12
      1.73832248236563E-22  -2.08332997277439E-08  -2.08235916584720E-08  -1.55791275344474E-18
      2.69484903676758E-09
      0.00000000000000E+00  -2.96723710943729E-11   0.00000000000000E+00  -3.09796245733683E-12   1.29116059269619E-22
      2.96753867168198E-08   2.96722887543626E-08  -3.84462638460021E-19  -4.40193100115051E-01  -4.40193100105096E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95504263199702E-09   0.00000000000000E+00  -9.95504263199702E-09
      1.79902447417774E-18  -1.39774468276008E-02  -7.76518088074451E-03   0.00000000000000E+00   7.73358989425008E-12
      1.70491372331864E-22  -1.97249797122600E-08  -1.97172461223656E-08  -1.41456183571772E-18
      2.71484903676758E-09
      0.00000000000000E+00  -2.84504687105639E-11   0.00000000000000E+00  -2.98240557371914E-12   9.98107158218221E-23
      2.84534902840733E-08   2.84505078784997E-08  -3.32940444266640E-19  -4.61806215048634E-01  -4.61806215038827E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80678439275068E-09   0.00000000000000E+00  -9.80678439275068E-09
      1.60288878632273E-18  -1.21669609805782E-02  -6.29292129375902E-03   0.00000000000000E+00   6.69326040419940E-12
      1.35644298757000E-22  -1.86504167461533E-08  -1.86437234857490E-08  -1.26994834205609E-18
      2.73484903676758E-09
      0.00000000000000E+00  -2.74553309829204E-11   0.00000000000000E+00  -2.42797316937888E-12   6.75764294334768E-23
      2.74577853954350E-08   2.74553574222657E-08  -2.84868284866041E-19  -4.82322762804222E-01  -4.82322762794544E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67717561203309E-09   0.00000000000000E+00  -9.67717561203309E-09
      1.40934527408207E-18  -1.09425830415548E-02  -5.34124305197655E-03   0.00000000000000E+00   5.54409378861779E-12
      9.05779431917003E-23  -1.77837259040214E-08  -1.77781818102327E-08  -1.12447698921603E-18
      2.75484903676758E-09
      0.00000000000000E+00  -2.66138495006250E-11   0.00000000000000E+00  -2.05155106145273E-12   4.08263416732048E-23
      2.66159120875685E-08   2.66138605365070E-08  -2.39947426857313E-19  -5.01837284922991E-01  -5.01837284913469E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52234140447869E-09   0.00000000000000E+00  -9.52234140447869E-09
      1.21889844599249E-18  -1.00712319893212E-02  -4.68623374867582E-03   0.00000000000000E+00   4.62991747808830E-12
      5.12846692605322E-23  -1.70961490495065E-08  -1.70915191320283E-08  -9.78951019135180E-19
      2.77484903676758E-09
      0.00000000000000E+00  -2.65066666923038E-11   0.00000000000000E+00  -2.42413903524900E-13   2.29596735675238E-23
      2.65069066387207E-08   2.65066642248172E-08  -1.95689655506665E-19  -5.21479689381431E-01  -5.21479689371573E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.85827532003137E-09   0.00000000000000E+00  -9.85827532003137E-09
      1.02173293959186E-18  -9.51986695922967E-03  -4.27448177050880E-03   0.00000000000000E+00   3.78656808104885E-12
      2.45688794648231E-23  -1.66521754728669E-08  -1.66483889047858E-08  -8.26043284085200E-19
      2.79484903676758E-09
      0.00000000000000E+00  -2.74225424117373E-11   0.00000000000000E+00   2.28369282980440E-12   1.29663177012604E-23
      2.74202635871716E-08   2.74225472800014E-08  -1.49716978400249E-19  -5.42420420768031E-01  -5.42420420757228E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08032933219131E-08   0.00000000000000E+00  -1.08032933219131E-08
      8.05667073153603E-19  -9.30969397089409E-03  -4.07348538562071E-03   0.00000000000000E+00   2.69675226189232E-12
      9.57607465177573E-24  -1.66219507103503E-08  -1.66192539580884E-08  -6.55950094753355E-19
      2.79984903676758E-09
      0.00000000000000E+00  -2.77654906604702E-11   0.00000000000000E+00   3.40482766329417E-12   1.08359099924730E-23
      2.77620756303132E-08   2.77654804579765E-08  -1.38247272254910E-19  -5.47739612654196E-01  -5.47739612643010E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11854634730428E-08   0.00000000000000E+00  -1.11854634730428E-08
      7.49739755788389E-19  -9.26470967189584E-03  -4.04086299753721E-03   0.00000000000000E+00   2.91501132022135E-12
      6.34380342932605E-24  -1.65829319962535E-08  -1.65800169849333E-08  -6.11492483533478E-19
      2.80659903676758E-09
      0.00000000000000E+00  -2.82359194044472E-11   0.00000000000000E+00   3.47036443611599E-12   8.83866070104875E-24
      2.82324468421781E-08   2.82359172066143E-08  -1.22578284696684E-19  -5.55061613856826E-01  -5.55061613845320E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15060755789638E-08   0.00000000000000E+00  -1.15060755789638E-08
      6.72073745630384E-19  -9.28645370672739E-03  -4.01540067795715E-03   0.00000000000000E+00   1.43188162980080E-12
      3.38735343325106E-24  -1.67312735092804E-08  -1.67298416276506E-08  -5.49495460933699E-19
      2.81571153676758E-09
      0.00000000000000E+00  -2.88920582070577E-11   0.00000000000000E+00   3.58437802175771E-12   7.19802855543567E-24
      2.88884627085507E-08   2.88920470865725E-08  -1.01314951661808E-19  -5.65105857660624E-01  -5.65105857648792E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18321636468374E-08   0.00000000000000E+00  -1.18321636468374E-08
      5.64253154398578E-19  -9.37228721046799E-03  -3.99724692432599E-03   0.00000000000000E+00   6.97151209954107E-13
      1.00405851561857E-24  -1.70605805909453E-08  -1.70598834397353E-08  -4.62938202736771E-19
      2.81878700551758E-09
      0.00000000000000E+00  -2.91624491133967E-11   0.00000000000000E+00   4.35903855303480E-12   6.73174704038010E-24
      2.91580777058763E-08   2.91624367444293E-08  -9.41806732480716E-20  -5.68507256925843E-01  -5.68507256913877E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19661259044294E-08   0.00000000000000E+00  -1.19661259044294E-08
      5.27451708120940E-19  -9.41689621471150E-03  -3.99887132630642E-03   0.00000000000000E+00   2.49594659300446E-13
      3.09755521412850E-25  -1.71965604346591E-08  -1.71963108399998E-08  -4.33271034872868E-19
      2.82293888833008E-09
      0.00000000000000E+00  -2.94358708960635E-11   0.00000000000000E+00   3.29411341728420E-12   6.24282116563603E-24
      2.94326287556944E-08   2.94359228691117E-08  -8.45863341346627E-20  -5.73099304636008E-01  -5.73099304623957E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20504686090946E-08   0.00000000000000E+00  -1.20504686090946E-08
      4.77419574620269E-19  -9.47142345751482E-03  -3.99380481413586E-03   0.00000000000000E+00   1.57440057655164E-13
     -3.79752838753813E-25  -1.73856117000746E-08  -1.73854542600169E-08  -3.92833240485606E-19
      2.82854393012695E-09
      0.00000000000000E+00  -2.95521463333682E-11   0.00000000000000E+00   1.06902426132076E-12   5.74451317080301E-24
      2.95510889261860E-08   2.95521579504474E-08  -7.18867252558006E-20  -5.79204207934769E-01  -5.79204207922778E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19913237949247E-08   0.00000000000000E+00  -1.19913237949247E-08
      4.10207703549855E-19  -9.49315236541645E-03  -3.96027651320065E-03   0.00000000000000E+00   7.89851103758124E-13
     -9.95925194055514E-25  -1.75616240066268E-08  -1.75608341555231E-08  -3.38320978294054E-19
      2.83611073655274E-09
      0.00000000000000E+00  -2.92747752270015E-11   0.00000000000000E+00  -1.77116966338791E-12   5.22795472583342E-24
      2.92765564305567E-08   2.92747852608933E-08  -5.56059836709446E-20  -5.87074077726086E-01  -5.87074077714483E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16038051239048E-08   0.00000000000000E+00  -1.16038051239048E-08
      3.22403956374778E-19  -9.44061291430999E-03  -3.87303284919344E-03   0.00000000000000E+00   1.47683272945856E-12
     -1.49319280392811E-24  -1.76724569697180E-08  -1.76709801369886E-08  -2.66797972703834E-19
      2.84632592522754E-09
      0.00000000000000E+00  -2.80397390457719E-11   0.00000000000000E+00  -5.93710927740280E-12   4.63160829750518E-24
      2.80457119879156E-08   2.80397748786382E-08  -3.64781375897799E-20  -5.96365187804476E-01  -5.96365187794142E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03338225478300E-08   0.00000000000000E+00  -1.03338225478300E-08
      2.16842009316744E-19  -9.26548926654386E-03  -3.68688957899510E-03   0.00000000000000E+00   1.72300465532925E-12
     -1.86360694340895E-24  -1.77076753354634E-08  -1.77059523308081E-08  -1.80363871726963E-19
      2.86011642993853E-09
      0.00000000000000E+00  -2.38753149713082E-11   0.00000000000000E+00  -1.48794066745954E-11   3.71046360898326E-24
      2.38901664701624E-08   2.38752870634878E-08  -2.14965537232782E-20  -6.03533460431704E-01  -6.03533460425526E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.17858693524565E-09   0.00000000000000E+00  -6.17858693524565E-09
      1.31636177079000E-19  -8.83140388171890E-03  -3.25571787440820E-03   0.00000000000000E+00   1.13654874702073E-12
     -2.15711188646593E-24  -1.76978366769894E-08  -1.76967001282424E-08  -1.10139623355723E-19
      2.87873361129836E-09
      0.00000000000000E+00  -1.14579983455878E-11   0.00000000000000E+00  -3.28855142124959E-11   1.73198884802887E-24
      1.14909195500627E-08   1.14580340358502E-08  -4.29755093102209E-20  -5.92241335147234E-01  -5.92241335153466E-01
      0.00000000000000E+00   0.00000000000000E+00   6.23212893616051E-09   0.00000000000000E+00   6.23212893616051E-09
      2.47660851741354E-19  -7.75779656452868E-03  -2.18416859780717E-03   0.00000000000000E+00  -1.06017769243246E-12
     -2.62171986679111E-24  -1.76891027943183E-08  -1.76901629720107E-08  -2.04685342431133E-19
      2.89873361129836E-09
      0.00000000000000E+00   7.50720512986882E-12   0.00000000000000E+00  -4.67521621743559E-11  -1.97149508241199E-24
     -7.46052525456478E-09  -7.50727741673914E-09  -1.41299432735228E-19  -5.44399003043674E-01  -5.44399003068863E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51891277439173E-08   0.00000000000000E+00   2.51891277439173E-08
      7.51443406619700E-19  -6.11548354971536E-03  -5.44474623536575E-04   0.00000000000000E+00  -4.96878027259080E-12
     -4.57630882873266E-24  -1.76768815469055E-08  -1.76818503271781E-08  -6.10143973884472E-19
      2.91873361129836E-09
      0.00000000000000E+00   2.22075063883567E-11   0.00000000000000E+00  -3.64112984508131E-11  -1.14530922202648E-23
     -2.21710455095075E-08  -2.22074568079583E-08  -3.31062541621935E-19  -4.60894916461450E-01  -4.60894916501286E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98362891086111E-08   0.00000000000000E+00   3.98362891086111E-08
      1.54816918879192E-18  -4.42313510870931E-03   1.13116515832142E-03   0.00000000000000E+00  -1.11922086180676E-11
     -1.75069356770712E-23  -1.76176400920348E-08  -1.76288323006528E-08  -1.21710664716999E-18
      2.93873361129836E-09
      0.00000000000000E+00   2.36533262414776E-11   0.00000000000000E+00  -3.93445566666571E-12  -3.52413644518247E-23
     -2.36493583190079E-08  -2.36532927746746E-08  -6.16061203776915E-19  -3.46928346894230E-01  -3.46928346935540E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13099938186940E-08   0.00000000000000E+00   4.13099938186940E-08
      2.37436906516580E-18  -2.18812126269262E-03   3.37494865420329E-03   0.00000000000000E+00  -2.57233275940557E-11
     -6.26612062542018E-23  -1.76309777164252E-08  -1.76567010440194E-08  -1.75830786138889E-18
      2.95873361129836E-09
      0.00000000000000E+00   1.51073571337917E-11   0.00000000000000E+00   2.04541036097224E-11  -4.28391254609771E-23
     -1.51278378192362E-08  -1.51073837156265E-08  -8.99945828136368E-19  -2.23129757199937E-01  -2.23129757231399E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14615167006338E-08   0.00000000000000E+00   3.14615167006338E-08
      3.00359939917848E-18  -8.82926268516656E-03  -3.67660744374306E-03   0.00000000000000E+00  -5.55404209001905E-11
     -8.10008077721488E-23  -1.62985925641070E-08  -1.63541329850073E-08  -2.10365357104211E-18
      2.96873361129836E-09
      0.00000000000000E+00   1.15139317905472E-11   0.00000000000000E+00   1.69381943252564E-11  -4.44796058814223E-23
     -1.15308898702770E-08  -1.15139516759518E-08  -1.01483582949802E-18  -1.65912070903785E-01  -1.65912070929426E-01
      0.00000000000000E+00   0.00000000000000E+00   2.56406631843035E-08   0.00000000000000E+00   2.56406631843035E-08
      3.26000603102151E-18  -1.99490408856371E-02  -1.54981638528756E-02   0.00000000000000E+00  -8.82937802855184E-11
     -8.75534422065913E-23  -1.40384177280661E-08  -1.41267115083517E-08  -2.24517020152350E-18
      2.97548361129836E-09
      0.00000000000000E+00   9.74610428877670E-12   0.00000000000000E+00   1.20615268558432E-11  -4.54380030017183E-23
     -9.75818886948446E-09  -9.74612734262866E-09  -1.08043730485848E-18  -1.31078798698274E-01  -1.31078798720790E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25154731698693E-08   0.00000000000000E+00   2.25154731698693E-08
      3.41198547491813E-18  -3.04286704005525E-02  -2.64054474696841E-02   0.00000000000000E+00  -1.16912336965687E-10
     -9.21341563642029E-23  -1.26524334902750E-08  -1.27693458272408E-08  -2.33154817005965E-18
      2.98003986129836E-09
      0.00000000000000E+00   8.65912182392562E-12   0.00000000000000E+00   1.08529925723973E-11  -4.60267059253251E-23
     -8.66993652366863E-09  -8.65908353109628E-09  -1.11968616524193E-18  -1.09434930424948E-01  -1.09434930445504E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05557209023380E-08   0.00000000000000E+00   2.05557209023380E-08
      3.50564247827941E-18  -3.87282594698265E-02  -3.49799922262423E-02   0.00000000000000E+00  -1.37387284306306E-10
     -9.52390994985849E-23  -1.17592500869353E-08  -1.18966373712417E-08  -2.38595631303748E-18
      2.98619079879836E-09
      0.00000000000000E+00   7.35676345032289E-12   0.00000000000000E+00   9.55847818085625E-12  -4.67093442122982E-23
     -7.36628618186067E-09  -7.35672770367986E-09  -1.16456013271140E-18  -8.38791514365589E-02  -8.38791514548040E-02
      0.00000000000000E+00   0.00000000000000E+00   1.82450811478985E-08   0.00000000000000E+00   1.82450811478985E-08
      3.61786683210256E-18  -5.17242368834895E-02  -4.82936469398218E-02   0.00000000000000E+00  -1.54256784701969E-10
     -9.93411079937372E-23  -1.07340966595164E-08  -1.08883534442184E-08  -2.45330669939116E-18
      2.99449456442336E-09
      0.00000000000000E+00   5.48900887447063E-12   0.00000000000000E+00   1.03275646666541E-11  -4.73692805289925E-23
     -5.49938728967202E-09  -5.48905972500541E-09  -1.20955746944060E-18  -5.73056784580755E-02  -5.73056784730624E-02
      0.00000000000000E+00   0.00000000000000E+00   1.49868492827980E-08   0.00000000000000E+00   1.49868492827980E-08
      3.74231411600412E-18  -7.24161654817128E-02  -6.94236986126377E-02   0.00000000000000E+00  -1.67697731912383E-10
     -1.04591813775578E-22  -9.33009182588011E-09  -9.49778955779259E-09  -2.53275664656351E-18
      3.00009960622023E-09
      0.00000000000000E+00   3.95841632890720E-12   0.00000000000000E+00   1.28443308389669E-11  -4.76526417042049E-23
     -3.97125209112648E-09  -3.95840776028756E-09  -1.23133921862022E-18  -4.40571140927038E-02  -4.40571141050269E-02
      0.00000000000000E+00   0.00000000000000E+00   1.23231112661012E-08   0.00000000000000E+00   1.23231112661012E-08
      3.81138566971815E-18  -8.80300064678232E-02  -8.53945342475730E-02   0.00000000000000E+00  -1.75226039504200E-10
     -1.07957899719507E-22  -8.18947746630951E-09  -8.36470350581381E-09  -2.58004645109794E-18
      3.00388300943312E-09
      0.00000000000000E+00   2.96318675652644E-12   0.00000000000000E+00   1.25089361212135E-11  -4.77810318299094E-23
     -2.97571299443696E-09  -2.96320405831579E-09  -1.24227419923639E-18  -3.72659260977416E-02  -3.72659261083204E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05787600222080E-08   0.00000000000000E+00   1.05787600222080E-08
      3.85140938437457E-18  -9.92400637459741E-02  -9.68406214428136E-02   0.00000000000000E+00  -1.77804153605140E-10
     -1.10131642438460E-22  -7.43775181028669E-09  -7.61555596389194E-09  -2.60913518513818E-18
      3.00899060377053E-09
      0.00000000000000E+00   2.00579721587518E-12   0.00000000000000E+00   8.96015095940260E-12  -4.78911298943135E-23
     -2.01478323971868E-09  -2.00582308875932E-09  -1.25214569984712E-18  -3.09554928592339E-02  -3.09554928681029E-02
      0.00000000000000E+00   0.00000000000000E+00   8.86904201390747E-09   0.00000000000000E+00   8.86904201390747E-09
      3.89670885314299E-18  -1.15133092857348E-01  -1.12970688773818E-01   0.00000000000000E+00  -1.77743078900798E-10
     -1.12900545063992E-22  -6.68547584624747E-09  -6.86321892514838E-09  -2.64456315329587E-18
      3.01588585612602E-09
      0.00000000000000E+00   1.23420957859474E-12   0.00000000000000E+00   5.35441244049160E-12  -4.79758749922183E-23
     -1.23959608649725E-09  -1.23424167405681E-09  -1.26015541137630E-18  -2.55868651679002E-02  -2.55868651752982E-02
      0.00000000000000E+00   0.00000000000000E+00   7.39803438519845E-09   0.00000000000000E+00   7.39803438519845E-09
      3.94772016716355E-18  -1.37135794617834E-01  -1.35193758030103E-01   0.00000000000000E+00  -1.80320525657135E-10
     -1.16449434319519E-22  -5.98347218548418E-09  -6.16379271114143E-09  -2.68756475578725E-18
      3.02519444680594E-09
      0.00000000000000E+00   7.11704868621125E-13   0.00000000000000E+00   2.68286174946500E-12  -4.80356807241538E-23
     -7.14412131252684E-10  -7.11729269503267E-10  -1.26611623049493E-18  -2.12648459329705E-02  -2.12648459392162E-02
      0.00000000000000E+00   0.00000000000000E+00   6.24560383557614E-09   0.00000000000000E+00   6.24560383557614E-09
      4.00585793681784E-18  -1.66671111982421E-01  -1.64927542562147E-01   0.00000000000000E+00  -1.86918652683747E-10
     -1.21046381175603E-22  -5.34695591338897E-09  -5.53387456607283E-09  -2.73974170632291E-18
      3.03776104422382E-09
      0.00000000000000E+00   4.04208688450325E-13   0.00000000000000E+00   1.16759168800256E-12  -4.80740694080738E-23
     -4.05345537918584E-10  -4.04177946230629E-10  -1.27032252372018E-18  -1.78239953844966E-02  -1.78239953897995E-02
      0.00000000000000E+00   0.00000000000000E+00   5.30297602303014E-09   0.00000000000000E+00   5.30297602303014E-09
      4.07249830161597E-18  -2.04677506404250E-01  -2.03134028836772E-01   0.00000000000000E+00  -1.95726572768165E-10
     -1.26975508220508E-22  -4.70307150403128E-09  -4.89879807679957E-09  -2.80217577789579E-18
      3.05472595073797E-09
      0.00000000000000E+00   2.44215156234814E-13   0.00000000000000E+00   4.49953862344923E-13  -4.80963483907183E-23
     -2.44636236336662E-10  -2.44186282474365E-10  -1.27332568045138E-18  -1.50144811125001E-02  -1.50144811168228E-02
      0.00000000000000E+00   0.00000000000000E+00   4.32271816206839E-09   0.00000000000000E+00   4.32271816206839E-09
      4.14583281112246E-18  -2.49629892818204E-01  -2.48344854881931E-01   0.00000000000000E+00  -1.96206042350836E-10
     -1.34196381642025E-22  -3.88232583724300E-09  -4.07853187959397E-09  -2.87250713067108E-18
      3.07472595073797E-09
      0.00000000000000E+00   1.76892963861697E-13   0.00000000000000E+00   1.60775146432329E-13  -4.81084701905282E-23
     -1.77062671043658E-10  -1.76901895897274E-10  -1.27556059338099E-18  -1.28723312830043E-02  -1.28723312862182E-02
      0.00000000000000E+00   0.00000000000000E+00   3.21395996923773E-09   0.00000000000000E+00   3.21395996923773E-09
      4.21011201050721E-18  -2.90078211974309E-01  -2.89121311190532E-01   0.00000000000000E+00  -1.72306759072759E-10
     -1.40958201115527E-22  -2.86475131426753E-09  -3.03705807334043E-09  -2.93455141712623E-18
      3.09472595073797E-09
      0.00000000000000E+00   1.47594492692495E-13   0.00000000000000E+00   7.13100886212807E-14  -4.81136668688738E-23
     -1.47631561069177E-10  -1.47560250980604E-10  -1.27723651722354E-18  -1.14248120114620E-02  -1.14248120137019E-02
      0.00000000000000E+00   0.00000000000000E+00   2.23985459409913E-09   0.00000000000000E+00   2.23985459409913E-09
      4.25490910238920E-18  -3.17854855277208E-01  -3.17195624943333E-01   0.00000000000000E+00  -1.31160475196761E-10
     -1.45740585543279E-22  -1.96113386792161E-09  -2.09229434311852E-09  -2.97767258516566E-18
      3.11472595073797E-09
      0.00000000000000E+00   1.33174868950914E-13   0.00000000000000E+00   3.63800882417056E-14  -4.81153572548670E-23
     -1.33166635086607E-10  -1.33130254998414E-10  -1.27864247481437E-18  -1.04232407533045E-02  -1.04232407547827E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47822509439870E-09   0.00000000000000E+00   1.47822509439870E-09
      4.28447360427717E-18  -3.34996076399643E-01  -3.34572273186015E-01   0.00000000000000E+00  -8.52342910337676E-11
     -1.48714650056997E-22  -1.25986054836641E-09  -1.34509483940033E-09  -3.00583112946280E-18
      3.13472595073797E-09
      0.00000000000000E+00   1.27480495244047E-13   0.00000000000000E+00   1.52264061586473E-14  -4.81160876646151E-23
     -1.27473618417910E-10  -1.27458392011800E-10  -1.27994655718836E-18  -9.70563424335932E-03  -9.70563424424273E-03
      0.00000000000000E+00   0.00000000000000E+00   8.83411534864958E-10   0.00000000000000E+00   8.83411534864958E-10
      4.30214183497447E-18  -3.43428713415610E-01  -3.43190538929276E-01   0.00000000000000E+00  -4.14006119940315E-11
     -1.50134267830503E-22  -7.14552530858914E-10  -7.55953142853096E-10  -3.02219527778611E-18
      3.15472595073797E-09
      0.00000000000000E+00   9.80901793376386E-14   0.00000000000000E+00   7.81539245448060E-14  -4.81053331585873E-23
     -9.81558937162980E-11  -9.80777397918013E-11  -1.28067376523990E-18  -9.38421923345847E-03  -9.38421923414943E-03
      0.00000000000000E+00   0.00000000000000E+00   6.90964206666297E-10   0.00000000000000E+00   6.90964206666297E-10
      4.31596111910779E-18  -3.49880211024057E-01  -3.49693415990328E-01   0.00000000000000E+00  -2.99596718682762E-11
     -1.51139768481322E-22  -5.62926795006056E-10  -5.92886466874483E-10  -3.03528735386790E-18
      3.17472595073797E-09
      0.00000000000000E+00   7.48534608241343E-14   0.00000000000000E+00   6.66789880686039E-14  -4.80873113439392E-23
     -7.49300952883877E-11  -7.48634163003672E-11  -1.28094997635335E-18  -9.25952459024253E-03  -9.25952459105316E-03
      0.00000000000000E+00   0.00000000000000E+00   8.10624346486215E-10   0.00000000000000E+00   8.10624346486215E-10
      4.33217360603752E-18  -3.58895857610072E-01  -3.58664044416578E-01   0.00000000000000E+00  -4.40388947587465E-11
     -1.52576177331031E-22  -6.91722035427103E-10  -7.35760930186002E-10  -3.05122362968417E-18
      3.17722595073797E-09
      0.00000000000000E+00   7.17307397590784E-14   0.00000000000000E+00   7.24675778799835E-14  -4.80849035500976E-23
     -7.17574595527266E-11  -7.16849919748947E-11  -1.28097676500277E-18  -9.24876722680507E-03  -9.24876722760348E-03
      0.00000000000000E+00   0.00000000000000E+00   7.98413470009522E-10   0.00000000000000E+00   7.98413470009522E-10
      4.33416963971255E-18  -3.60003291777540E-01  -3.59774324459670E-01   0.00000000000000E+00  -4.34343983736110E-11
     -1.52752100676128E-22  -6.83294079660060E-10  -7.26728478033824E-10  -3.05319287470977E-18
      3.18060095073797E-09
      0.00000000000000E+00   3.62786711969731E-14   0.00000000000000E+00   5.26653341317693E-13  -4.80775022910732E-23
     -3.67912228744889E-11  -3.62645695332193E-11  -1.28089386676855E-18  -9.29489435882086E-03  -9.29489435974896E-03
      0.00000000000000E+00   0.00000000000000E+00   9.28104899282208E-10   0.00000000000000E+00   9.28104899282208E-10
      4.33730199374762E-18  -3.62056364902094E-01  -3.61775371798122E-01   0.00000000000000E+00  -6.09159517554333E-11
     -1.53078762599296E-22  -8.30924377993404E-10  -8.91840329748990E-10  -3.05640812697908E-18
      3.18515720073797E-09
      0.00000000000000E+00   1.73586553322226E-14   0.00000000000000E+00   2.26878131570771E-13  -4.80680410054247E-23
     -1.76040506385453E-11  -1.73771725070226E-11  -1.28069697351678E-18  -9.38109812056613E-03  -9.38109812173722E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17109451505232E-09   0.00000000000000E+00   1.17109451505232E-09
      4.34263779313183E-18  -3.65808889426513E-01  -3.65445381787510E-01   0.00000000000000E+00  -8.54277780754708E-11
     -1.53695672714749E-22  -1.06828956446969E-09  -1.15371734254531E-09  -3.06194081961504E-18
      3.18823266948797E-09
      0.00000000000000E+00   1.18479710997710E-14   0.00000000000000E+00   1.11336264805411E-13  -4.80617789979527E-23
     -1.19155457913249E-11  -1.18042095265675E-11  -1.28054747384077E-18  -9.43770925754117E-03  -9.43770925887795E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33677604408218E-09   0.00000000000000E+00   1.33677604408218E-09
      4.34674900608115E-18  -3.68758295462600E-01  -3.68340827362639E-01   0.00000000000000E+00  -1.01770091256760E-10
     -1.54190132775805E-22  -1.22320174329887E-09  -1.32497183455578E-09  -3.06620153224038E-18
      3.19238455230047E-09
      0.00000000000000E+00   1.52462263764494E-14   0.00000000000000E+00  -1.99726024524684E-14  -4.80542904283228E-23
     -1.52294152240868E-11  -1.52493878265874E-11  -1.28036102594188E-18  -9.48842653488400E-03  -9.48842653640750E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52350377311680E-09   0.00000000000000E+00   1.52350377311680E-09
      4.35307441521153E-18  -3.73307964996201E-01  -3.72832746805656E-01   0.00000000000000E+00  -1.19248376378917E-10
     -1.54969714827414E-22  -1.38900600891094E-09  -1.50825438529002E-09  -3.07271338926965E-18
      3.19798959409734E-09
      0.00000000000000E+00   2.66349737901828E-14   0.00000000000000E+00  -8.26049210131228E-14  -4.80458106847266E-23
     -2.65641918383022E-11  -2.66467967593634E-11  -1.28017524903858E-18  -9.49974170841885E-03  -9.49974171010114E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68228552045440E-09   0.00000000000000E+00   1.68228552045440E-09
      4.36250369586796E-18  -3.80032161587994E-01  -3.79510504443069E-01   0.00000000000000E+00  -1.34321297129467E-10
     -1.56147264071416E-22  -1.52131742656542E-09  -1.65563872369504E-09  -3.08232844682938E-18
      3.20555640052312E-09
      0.00000000000000E+00   4.04116843713118E-14   0.00000000000000E+00  -7.56569502232419E-14  -4.80362801358015E-23
     -4.03714459095074E-11  -4.04471028597787E-11  -1.28003263107138E-18  -9.43709433864691E-03  -9.43709434042297E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77605627205346E-09   0.00000000000000E+00   1.77605627205346E-09
      4.37594276987988E-18  -3.89509339171598E-01  -3.88962484225129E-01   0.00000000000000E+00  -1.44809041941006E-10
     -1.57841528762439E-22  -1.59080012725265E-09  -1.73560916919382E-09  -3.09591013880850E-18
      3.21577158919793E-09
      0.00000000000000E+00   5.54742212733462E-14   0.00000000000000E+00  -6.13088304948897E-14  -4.80261923186980E-23
     -5.54052368232864E-11  -5.54665456538293E-11  -1.28000017452971E-18  -9.25323072345205E-03  -9.25323072525239E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80033608162244E-09   0.00000000000000E+00   1.80033608162244E-09
      4.39433354263171E-18  -4.02313012870979E-01  -4.01763239777431E-01   0.00000000000000E+00  -1.50645070169885E-10
     -1.60182018217256E-22  -1.59422446579843E-09  -1.74486953596847E-09  -3.11433336810200E-18
      3.22956209390892E-09
      0.00000000000000E+00   7.98130766333407E-14   0.00000000000000E+00  -8.03698011593581E-14  -4.80191626803913E-23
     -7.97076757176989E-11  -7.97880455189063E-11  -1.28030296653332E-18  -8.80674085741425E-03  -8.80674085919834E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78408917548160E-09   0.00000000000000E+00   1.78408917548160E-09
      4.41893703281101E-18  -4.19048516212464E-01  -4.18511525173758E-01   0.00000000000000E+00  -1.53725757466157E-10
     -1.63337507219946E-22  -1.55057537249631E-09  -1.70430112996263E-09  -3.13863406627769E-18
      3.24817927526875E-09
      0.00000000000000E+00   1.24908842602236E-13   0.00000000000000E+00  -1.21339793683684E-13  -4.80258231524695E-23
     -1.24803282910725E-10  -1.24924622704456E-10  -1.28156941765198E-18  -7.71404819568212E-03  -7.71404819744895E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76683397509859E-09   0.00000000000000E+00   1.76683397509859E-09
      4.45183050135814E-18  -4.40408099402857E-01  -4.39890766433264E-01   0.00000000000000E+00  -1.56802142354781E-10
     -1.67566782545336E-22  -1.48510721003920E-09  -1.64190935239415E-09  -3.17026108370615E-18
      3.26817927526875E-09
      0.00000000000000E+00   1.66422663820038E-13   0.00000000000000E+00  -1.11753123352261E-13  -4.80475715145965E-23
     -1.66228264143876E-10  -1.66340017267276E-10  -1.28377475072572E-18  -6.06372299645256E-03  -6.06372299819348E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74092253790626E-09   0.00000000000000E+00   1.74092253790626E-09
      4.48664895211626E-18  -4.62007861215759E-01  -4.61511740540331E-01   0.00000000000000E+00  -1.60490257940088E-10
     -1.72080997870108E-22  -1.41409226269871E-09  -1.57458252063897E-09  -3.20287420139053E-18
      3.28817927526875E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.38758699290342E-14  -4.80692112159457E-23
     -1.71486276321461E-10  -1.71510152191438E-10  -1.28609841981967E-18  -4.37168289828812E-03  -4.37168289995844E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67031622128562E-09   0.00000000000000E+00   1.67031622128562E-09
      4.52005527654197E-18  -4.82512291882255E-01  -4.82040045786324E-01   0.00000000000000E+00  -1.62523858477463E-10
     -1.76523012170109E-22  -1.33628221061650E-09  -1.49880606909414E-09  -3.23395685672229E-18
      3.30817927526875E-09
      0.00000000000000E+00   2.20519214035272E-13   0.00000000000000E+00  -1.40506045170609E-13  -4.81112366817911E-23
     -2.20412128522686E-10  -2.20552634567905E-10  -1.28941431833656E-18  -2.10262860345430E-03  -2.10262860513497E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68067532058238E-09   0.00000000000000E+00   1.68067532058238E-09
      4.55366878295362E-18  -5.02013672601492E-01  -5.01553613139086E-01   0.00000000000000E+00  -1.68804716303248E-10
     -1.81011776175143E-22  -1.29131796971108E-09  -1.46012268601451E-09  -3.26425446461706E-18
      3.32817927526875E-09
      0.00000000000000E+00  -5.71090575956401E-13   0.00000000000000E+00   2.06376389292285E-12  -4.78225530303308E-23
      5.69026380185049E-10   5.71090144077924E-10  -1.27695351560566E-18  -9.37956222870828E-03  -9.37956222906404E-03
      0.00000000000000E+00   0.00000000000000E+00   3.55758865856657E-10   0.00000000000000E+00   3.55758865856657E-10
      4.56078396027075E-18  -5.21646848501035E-01  -5.21354823969027E-01   0.00000000000000E+00  -9.76945120429474E-11
     -1.83553391307997E-22  -8.29154497891400E-10  -9.26849009934530E-10  -3.28383044466509E-18
      3.34817927526875E-09
      0.00000000000000E+00  -2.48375722830315E-12   0.00000000000000E+00   5.11242901111396E-12  -4.68042476084395E-23
      2.47868196213549E-09   2.48379439114655E-09  -1.22657339009091E-18  -3.88078383454625E-02  -3.88078383427487E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.71373331405941E-09   0.00000000000000E+00  -2.71373331405941E-09
      4.50650929398956E-18  -5.42583871693384E-01  -5.42656359892669E-01   0.00000000000000E+00   7.70359971533200E-11
     -1.81525497815199E-22   1.52902925759707E-10   2.29938922912845E-10  -3.27993590389865E-18
      3.35317927526875E-09
      0.00000000000000E+00  -3.27573439724365E-12   0.00000000000000E+00   8.25394353961649E-12  -4.64628011676330E-23
      3.26745579389200E-09   3.27570973743157E-09  -1.21006836616045E-18  -4.82544843897400E-02  -4.82544843857980E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.94197055150402E-09   0.00000000000000E+00  -3.94197055150402E-09
      4.48679944123205E-18  -5.47902758933196E-01  -5.48112735654243E-01   0.00000000000000E+00   1.41510719168095E-10
     -1.80591245406829E-22   5.24750094904247E-10   6.66260814072161E-10  -3.27673107507159E-18
      3.35655427526875E-09
      0.00000000000000E+00  -3.72549807534891E-12   0.00000000000000E+00   7.10327686101346E-12  -4.62134236753549E-23
      3.71845149094784E-09   3.72555476780881E-09  -1.19744189836221E-18  -5.54012368383652E-02  -5.54012368337306E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.63458229035299E-09   0.00000000000000E+00  -4.63458229035299E-09
      4.47115772600210E-18  -5.51537813856507E-01  -5.51824287701994E-01   0.00000000000000E+00   1.75050076687705E-10
     -1.79805487215806E-22   7.33977445857030E-10   9.09027522544555E-10  -3.27371582763989E-18
      3.36111052526875E-09
      0.00000000000000E+00  -4.26040182484554E-12   0.00000000000000E+00   6.35139052812969E-12  -4.58417820524723E-23
      4.25403761865947E-09   4.26038900918755E-09  -1.17804747058995E-18  -6.62463837108414E-02  -6.62463837054008E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.44054075459054E-09   0.00000000000000E+00  -5.44054075459054E-09
      4.44636926218900E-18  -5.56513093460598E-01  -5.56885000987420E-01   0.00000000000000E+00   2.12393844143765E-10
     -1.78508034207958E-22   9.67757901259196E-10   1.18015174540278E-09  -3.26832179159906E-18
      3.36726146276875E-09
      0.00000000000000E+00  -4.96080979079014E-12   0.00000000000000E+00   6.20732898439948E-12  -4.52761441386109E-23
      4.95463114548965E-09   4.96083847447401E-09  -1.14783389041450E-18  -8.28340355901686E-02  -8.28340355837165E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.45204422521401E-09   0.00000000000000E+00  -6.45204422521401E-09
      4.40668314141247E-18  -5.63314560609130E-01  -5.63784486183681E-01   0.00000000000000E+00   2.54838604947386E-10
     -1.76381867662899E-22   1.23636714579271E-09   1.49120575073992E-09  -3.25884925099797E-18
      3.37141334558125E-09
      0.00000000000000E+00  -5.49020285605433E-12   0.00000000000000E+00   6.87589923313245E-12  -4.48599907619523E-23
      5.48334456308441E-09   5.49022046231750E-09  -1.12545077462601E-18  -9.48927829158619E-02  -9.48927829086879E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.17392693971655E-09   0.00000000000000E+00  -7.17392693971655E-09
      4.37689783745333E-18  -5.67926087304428E-01  -5.68456673710366E-01   0.00000000000000E+00   2.79250403107814E-10
     -1.74791487335495E-22   1.40445607429182E-09   1.68370647739946E-09  -3.25144706282732E-18
      3.37701838737812E-09
      0.00000000000000E+00  -6.05541536882945E-12   0.00000000000000E+00   5.57616898132431E-12  -4.42661658289181E-23
      6.04984615163396E-09   6.05542232061524E-09  -1.09269104645928E-18  -1.12177247426756E-01  -1.12177247418894E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.86197935776867E-09   0.00000000000000E+00  -7.86197935776867E-09
      4.33283111454687E-18  -5.74123439398685E-01  -5.74692747152531E-01   0.00000000000000E+00   2.98731370719071E-10
     -1.72464814791077E-22   1.50782566643439E-09   1.80655703715329E-09  -3.24014006808759E-18
      3.38458519380390E-09
      0.00000000000000E+00  -6.70934989774704E-12   0.00000000000000E+00   4.82226507457114E-12  -4.33612450926608E-23
      6.70454735236314E-09   6.70936961743767E-09  -1.04569842976004E-18  -1.36259261355738E-01  -1.36259261347322E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.41606027241040E-09   0.00000000000000E+00  -8.41606027241040E-09
      4.26914841559783E-18  -5.82256191025278E-01  -5.82794061847829E-01   0.00000000000000E+00   3.04734456902960E-10
     -1.69204338892881E-22   1.40195619807014E-09   1.70669065497293E-09  -3.22344998583780E-18
      3.39480038247871E-09
      0.00000000000000E+00  -7.81148674423736E-12   0.00000000000000E+00   5.80020487276319E-12  -4.12941925122771E-23
      7.80571026934805E-09   7.81151047422077E-09  -9.80091348858370E-19  -1.68596383901199E-01  -1.68596383892408E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.79113625342417E-09   0.00000000000000E+00  -8.79113625342417E-09
      4.17934530010319E-18  -5.92296845017473E-01  -5.92605716861401E-01   0.00000000000000E+00   2.96270930647196E-10
     -1.64826199877104E-22   6.83354848556346E-10   9.79625779203378E-10  -3.19925395124482E-18
      3.40859088718969E-09
      0.00000000000000E+00  -1.09908760121503E-11   0.00000000000000E+00   1.17339560016851E-11  -3.17032618319726E-23
      1.09791030529389E-08   1.09908370089406E-08  -8.92133637490252E-19  -2.09890619815889E-01  -2.09890619806815E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.07367197830535E-09   0.00000000000000E+00  -9.07367197830535E-09
      4.05421478394043E-18  -6.01885690996584E-01  -6.01282130689497E-01   0.00000000000000E+00   2.83627680808541E-10
     -1.58974984080618E-22  -2.20079271144366E-09  -1.91716503063528E-09  -3.16208114645018E-18
      3.42720806854953E-09
      0.00000000000000E+00  -2.16929003257830E-11   0.00000000000000E+00   2.85909586118409E-11   1.65608916064998E-23
      2.16643178687915E-08   2.16929088274033E-08  -7.85515015470279E-19  -2.57491528249885E-01  -2.57491528240376E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50882038971708E-09   0.00000000000000E+00  -9.50882038971708E-09
      3.87718735022700E-18  -5.97487908398380E-01  -5.93650298976993E-01   0.00000000000000E+00   2.93655174631646E-10
     -1.50229888265694E-22  -1.24777436123177E-08  -1.21840884376862E-08  -3.09167233475672E-18
      3.44720806854953E-09
      0.00000000000000E+00  -4.10205231342605E-11   0.00000000000000E+00   4.79033903176036E-11   1.08737093336879E-22
      4.09725931109585E-08   4.10204965012762E-08  -6.98178958723328E-19  -2.95661359056599E-01  -2.95661359046418E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01809812308038E-08   0.00000000000000E+00  -1.01809812308038E-08
      3.67356772561092E-18  -5.58949206117575E-01  -5.49234659993779E-01   0.00000000000000E+00   3.16607058125211E-10
     -1.38393735309009E-22  -3.11561223285975E-08  -3.08395152704724E-08  -2.97538876688760E-18
      3.46720806854953E-09
      0.00000000000000E+00  -5.91018128588318E-11   0.00000000000000E+00   4.49376166708120E-11   1.94056975576337E-22
      5.90568810116848E-08   5.91018186283558E-08  -6.40924498685959E-19  -3.21490681319970E-01  -3.21490681309137E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08326164551729E-08   0.00000000000000E+00  -1.08326164551729E-08
      3.45691539650746E-18  -4.83853089994723E-01  -4.68647026795075E-01   0.00000000000000E+00   3.04343264376767E-10
     -1.23266516848716E-22  -4.85735454375595E-08  -4.82692021731829E-08  -2.81599089782150E-18
      3.48720806854953E-09
      0.00000000000000E+00  -6.59654619150875E-11   0.00000000000000E+00   1.71680249121555E-11   2.26021853959025E-22
      6.59482890956762E-08   6.59654571205886E-08  -6.10251853197284E-19  -3.36951600064782E-01  -3.36951600053382E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13998779662129E-08   0.00000000000000E+00  -1.13998779662129E-08
      3.22891783718321E-18  -3.76720970777935E-01  -3.59530485420627E-01   0.00000000000000E+00   2.60021789155448E-10
     -1.06854682692453E-22  -5.48256009435311E-08  -5.45655791543757E-08  -2.61866598398592E-18
      3.50720806854953E-09
      0.00000000000000E+00  -5.93093819649209E-11   0.00000000000000E+00  -1.64500998885808E-11   1.97044620167658E-22
      5.93258721139556E-08   5.93094220140672E-08  -6.00226604232285E-19  -3.44467235100963E-01  -3.44467235089099E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18635405263765E-08   0.00000000000000E+00  -1.18635405263765E-08
      2.99164702665568E-18  -2.51659094289941E-01  -2.36711106271480E-01   0.00000000000000E+00   1.96902205005976E-10
     -9.02141355187898E-23  -4.76427836926965E-08  -4.74458814876906E-08  -2.39142042242339E-18
      3.52720806854953E-09
      0.00000000000000E+00  -5.12724163908390E-11   0.00000000000000E+00  -1.99354434373395E-11   1.55375933522794E-22
      5.12923314930147E-08   5.12723960495775E-08  -5.92590046031731E-19  -3.51141107012242E-01  -3.51141107000355E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18866585376751E-08   0.00000000000000E+00  -1.18866585376751E-08
      2.75391385590217E-18  -1.42689776458579E-01  -1.30280896045134E-01   0.00000000000000E+00   1.10697026667003E-10
     -7.75163222421154E-23  -3.94964345385692E-08  -3.93857375119023E-08  -2.16132380987044E-18
      3.54720806854953E-09
      0.00000000000000E+00  -4.45453404588109E-11   0.00000000000000E+00  -1.66492586653987E-11   8.72244808111836E-23
      4.45620022338038E-08   4.45453529751385E-08  -5.75448427371130E-19  -3.61238594460818E-01  -3.61238594449232E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15865999007761E-08   0.00000000000000E+00  -1.15865999007761E-08
      2.52218185788665E-18  -6.42410143377307E-02  -5.38569037568567E-02   0.00000000000000E+00   5.88005334199257E-11
     -3.92915044451520E-23  -3.30175536077824E-08  -3.29587530743625E-08  -1.94673343051552E-18
      3.54970806854953E-09
      0.00000000000000E+00  -4.24696493979208E-11   0.00000000000000E+00  -4.06431763267584E-11   1.22568474979719E-22
      4.25103414656159E-08   4.24696982892893E-08  -5.72878027376873E-19  -3.62581498970475E-01  -3.62581498958932E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15426064056235E-08   0.00000000000000E+00  -1.15426064056235E-08
      2.49332534187259E-18  -5.56826018617252E-02  -4.59385799483520E-02   0.00000000000000E+00   6.88635801531472E-11
     -2.50109835368412E-23  -3.09959554638190E-08  -3.09270918836659E-08  -1.92044731449572E-18
      3.55308306854953E-09
      0.00000000000000E+00  -4.01331192833613E-11   0.00000000000000E+00  -3.43553545079797E-11   1.18440489936808E-22
      4.01674332519331E-08   4.01330778974252E-08  -5.67609800305942E-19  -3.65029937336214E-01  -3.65029937324894E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13202392156930E-08   0.00000000000000E+00  -1.13202392156930E-08
      2.45511953451963E-18  -4.65565597897352E-02  -3.74786495958708E-02   0.00000000000000E+00   5.45326627404286E-11
     -2.79004486417666E-24  -2.88673713444732E-08  -2.88128386817328E-08  -1.88750973421369E-18
      3.55763931854953E-09
      0.00000000000000E+00  -3.76050928917242E-11   0.00000000000000E+00  -2.75024271707137E-11   1.17336952689624E-22
      3.76326143795332E-08   3.76051119523626E-08  -5.57709363563894E-19  -3.69301564360978E-01  -3.69301564349967E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10116318129062E-08   0.00000000000000E+00  -1.10116318129062E-08
      2.40494778707207E-18  -3.77463627330653E-02  -2.93676809499842E-02   0.00000000000000E+00   4.23793104341724E-11
      2.78341340168231E-23  -2.66358594498905E-08  -2.65934801394563E-08  -1.84723842350818E-18
      3.56379025604953E-09
      0.00000000000000E+00  -3.52276918691073E-11   0.00000000000000E+00  -1.91424848829439E-11   1.21180674982969E-22
      3.52468444749806E-08   3.52277019900977E-08  -5.41105443267785E-19  -3.76186161098495E-01  -3.76186161087799E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06966813531302E-08   0.00000000000000E+00  -1.06966813531302E-08
      2.33915316861156E-18  -3.01729240940111E-02  -2.24440387749324E-02   0.00000000000000E+00   3.03801046514475E-11
      6.49852809014667E-23  -2.45614007416189E-08  -2.45310206369674E-08  -1.79804772534377E-18
      3.57209402167453E-09
      0.00000000000000E+00  -3.33410172773903E-11   0.00000000000000E+00  -1.12292445518235E-11   1.29992351006162E-22
      3.33522086609780E-08   3.33409794164263E-08  -5.16082829816441E-19  -3.86373673059505E-01  -3.86373673049065E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04401745917019E-08   0.00000000000000E+00  -1.04401745917019E-08
      2.25246040571798E-18  -2.42695114251290E-02  -1.70542393911875E-02   0.00000000000000E+00   2.01233214855739E-11
      1.06469613130126E-22  -2.29209281462099E-08  -2.29008048247243E-08  -1.73637757590154E-18
      3.58330410526828E-09
      0.00000000000000E+00  -3.19761126377493E-11   0.00000000000000E+00  -5.98741735413432E-12   1.40202536651694E-22
      3.19820837319294E-08   3.19760963145754E-08  -4.81454450185147E-19  -4.00404950419228E-01  -4.00404950408972E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02563276955540E-08   0.00000000000000E+00  -1.02563276955540E-08
      2.13748611488593E-18  -1.98565545216353E-02  -1.30133766541374E-02   0.00000000000000E+00   1.32250014724790E-11
      1.47108979917263E-22  -2.17329936204941E-08  -2.17197686190215E-08  -1.65603166470078E-18
      3.59843771811984E-09
      0.00000000000000E+00  -3.08495450911617E-11   0.00000000000000E+00  -3.63685656827432E-12   1.43157845022385E-22
      3.08531871627124E-08   3.08495503061443E-08  -4.36314383334651E-19  -4.18794129186108E-01  -4.18794129176001E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01074087971085E-08   0.00000000000000E+00  -1.01074087971085E-08
      1.98452450321801E-18  -1.64955188267797E-02  -9.96034954497890E-03   0.00000000000000E+00   9.45534399072854E-12
      1.74349860319522E-22  -2.07515968530267E-08  -2.07421415090358E-08  -1.54821011988336E-18
      3.61843771811984E-09
      0.00000000000000E+00  -2.95879657808792E-11   0.00000000000000E+00  -3.07607873104691E-12   1.27160868329728E-22
      2.95910122414671E-08   2.95879361627362E-08  -3.80857853817028E-19  -4.41695190488892E-01  -4.41695190478947E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94439757851163E-09   0.00000000000000E+00  -9.94439757851163E-09
      1.78563655164778E-18  -1.38327267088475E-02  -7.64368314503369E-03   0.00000000000000E+00   7.63697004789370E-12
      1.68410561026851E-22  -1.96511755542726E-08  -1.96435385842246E-08  -1.40477869783075E-18
      3.63843771811984E-09
      0.00000000000000E+00  -2.83791971944909E-11   0.00000000000000E+00  -2.95052666958042E-12   9.74270469847922E-23
      2.83821556816931E-08   2.83792051550236E-08  -3.29584937587317E-19  -4.63227999716781E-01  -4.63227999706983E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79737948859246E-09   0.00000000000000E+00  -9.79737948859246E-09
      1.58968896187593E-18  -1.20708407764259E-02  -6.21630274626083E-03   0.00000000000000E+00   6.61480758290956E-12
      1.32400957011226E-22  -1.85884404740142E-08  -1.85818256664311E-08  -1.26010402428862E-18
      3.65843771811984E-09
      0.00000000000000E+00  -2.73990301590122E-11   0.00000000000000E+00  -2.39130094863516E-12   6.54362824691467E-23
      2.74013995491151E-08   2.73990082481665E-08  -2.81724840527247E-19  -4.83677614754688E-01  -4.83677614745020E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66844169744212E-09   0.00000000000000E+00  -9.66844169744212E-09
      1.39632012792709E-18  -1.08765589577757E-02  -5.29022073172752E-03   0.00000000000000E+00   5.47377537690528E-12
      8.74523039406692E-23  -1.77360403261014E-08  -1.77305665507244E-08  -1.11459528739984E-18
      3.67843771811984E-09
      0.00000000000000E+00  -2.65637941188469E-11   0.00000000000000E+00  -2.03618497255116E-12   3.92806967069592E-23
      2.65658375967888E-08   2.65638014118162E-08  -2.37010872313690E-19  -5.03126209376022E-01  -5.03126209366512E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51078300755044E-09   0.00000000000000E+00  -9.51078300755044E-09
      1.20610446777608E-18  -1.00227565157311E-02  -4.64988840351837E-03   0.00000000000000E+00   4.57968975314818E-12
      4.89788615009647E-23  -1.70575980940190E-08  -1.70530184042658E-08  -9.69093595462389E-19
      3.69843771811984E-09
      0.00000000000000E+00  -2.65561710056587E-11   0.00000000000000E+00   3.14342227825727E-15   2.20493096595367E-23
      2.65562125985926E-08   2.65562157420149E-08  -1.92623263539595E-19  -5.22859601272394E-01  -5.22859601262473E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.92009229723965E-09   0.00000000000000E+00  -9.92009229723965E-09
      1.00770262183129E-18  -9.49861560020951E-03  -4.25709465792010E-03   0.00000000000000E+00   3.71724894542858E-12
      2.31925777565570E-23  -1.66398406937207E-08  -1.66361234447752E-08  -8.15079358291692E-19
      3.71843771811984E-09
      0.00000000000000E+00  -2.74744346882596E-11   0.00000000000000E+00   2.29004604547153E-12   1.24941928478548E-23
      2.74721638873969E-08   2.74744539334423E-08  -1.46633586841504E-19  -5.43844017181243E-01  -5.43844017170394E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08495331857848E-08   0.00000000000000E+00  -1.08495331857848E-08
      7.90711958115592E-19  -9.29954279348158E-03  -4.06154861542289E-03   0.00000000000000E+00   2.64355363581666E-12
      8.88005069693977E-24  -1.66275643012934E-08  -1.66249207476576E-08  -6.44078371274088E-19
      3.72843771811984E-09
      0.00000000000000E+00  -2.80922742354546E-11   0.00000000000000E+00   3.07558115420294E-12   9.25581114901035E-24
      2.80891658127645E-08   2.80922413939187E-08  -1.23539668884908E-19  -5.54602705552822E-01  -5.54602705541438E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13842572456921E-08   0.00000000000000E+00  -1.13842572456921E-08
      6.76869385658671E-19  -9.26869065767672E-03  -4.00452453103907E-03   0.00000000000000E+00   2.11250228493327E-12
      4.05734415413307E-24  -1.67100966505118E-08  -1.67079841482268E-08  -5.53329716773763E-19
      3.73518771811984E-09
      0.00000000000000E+00  -2.86497717903043E-11   0.00000000000000E+00   4.10090469712710E-12   7.73739688426490E-24
      2.86456588124779E-08   2.86497597171750E-08  -1.07854950200029E-19  -5.62000328437257E-01  -5.62000328425531E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17268025891647E-08   0.00000000000000E+00  -1.17268025891647E-08
      5.97713468181809E-19  -9.32756961526045E-03  -3.99567096368368E-03   0.00000000000000E+00   9.15909687604908E-13
      1.79980255017809E-24  -1.69238730376977E-08  -1.69229571280101E-08  -4.89858517981779E-19
      3.73974396811984E-09
      0.00000000000000E+00  -2.90627057287893E-11   0.00000000000000E+00   4.50126910528955E-12   6.96522708067567E-24
      2.90581856168982E-08   2.90626868860035E-08  -9.72560277573958E-20  -5.67040000226902E-01  -5.67040000214974E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19284696366844E-08   0.00000000000000E+00  -1.19284696366844E-08
      5.43364378399665E-19  -9.39788958992679E-03  -3.99942860881259E-03   0.00000000000000E+00   1.67679776319735E-13
      6.50835481284878E-25  -1.71343849290955E-08  -1.71342172493191E-08  -4.46108350642269E-19
      3.74281943686984E-09
      0.00000000000000E+00  -2.93170238061170E-11   0.00000000000000E+00   4.12029037930136E-12   6.53683236362408E-24
      2.93129432237454E-08   2.93170635141247E-08  -9.01206683674549E-20  -5.70449302601207E-01  -5.70449302589177E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20295818185076E-08   0.00000000000000E+00  -1.20295818185076E-08
      5.06367775441277E-19  -9.44783743780257E-03  -4.00108712730298E-03   0.00000000000000E+00  -3.40699622724609E-14
      2.29922906697704E-26  -1.72874476256555E-08  -1.72874816956178E-08  -4.16247107073824E-19
      3.74697131968234E-09
      0.00000000000000E+00  -2.95278074780082E-11   0.00000000000000E+00   2.55268351052753E-12   6.08475364041461E-24
      2.95252402328506E-08   2.95277929163611E-08  -8.05648962423907E-20  -5.75030484973580E-01  -5.75030484961513E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20665466057370E-08   0.00000000000000E+00  -1.20665466057370E-08
      4.56268887982687E-19  -9.49108557945271E-03  -3.98958705689189E-03   0.00000000000000E+00   3.18338669935182E-13
     -5.92189324066960E-25  -1.74615646492936E-08  -1.74612463106236E-08  -3.75703991740296E-19
      3.75257636147921E-09
      0.00000000000000E+00  -2.95530647807403E-11   0.00000000000000E+00   2.66530938603742E-13   5.61631931188708E-24
      2.95527573430546E-08   2.95530238739932E-08  -6.79783687798687E-20  -5.81090298993475E-01  -5.81090298981528E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19468995034549E-08   0.00000000000000E+00  -1.19468995034549E-08
      3.89306016922757E-19  -9.49368185828226E-03  -3.94653634320442E-03   0.00000000000000E+00   1.03067181615644E-12
     -1.13956019955284E-24  -1.76071550423548E-08  -1.76061243705387E-08  -3.21327648142889E-19
      3.76014316790499E-09
      0.00000000000000E+00  -2.91578568765363E-11   0.00000000000000E+00  -2.54132499878669E-12   5.11996063593304E-24
      2.91604178918005E-08   2.91578765668018E-08  -5.19648247274901E-20  -5.88841392031970E-01  -5.88841392020501E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14690565568515E-08   0.00000000000000E+00  -1.14690565568515E-08
      3.02521886070724E-19  -9.42182858781308E-03  -3.84862758161570E-03   0.00000000000000E+00   1.61497751728294E-12
     -1.58172553841696E-24  -1.76904349874673E-08  -1.76888200099500E-08  -2.50557061343233E-19
      3.77035835657980E-09
      0.00000000000000E+00  -2.77179150865967E-11   0.00000000000000E+00  -6.92843777351536E-12   4.52552222710403E-24
      2.77248317059143E-08   2.77179032681408E-08  -3.35198012826055E-20  -5.97803989333535E-01  -5.97803989323525E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00093077931142E-08   0.00000000000000E+00  -1.00093077931142E-08
      2.00274918459870E-19  -9.22619604071529E-03  -3.64676341897875E-03   0.00000000000000E+00   1.72635547369676E-12
     -1.91510378206481E-24  -1.77103218305004E-08  -1.77085954750267E-08  -1.66755117177265E-19
      3.78414886129078E-09
      0.00000000000000E+00  -2.30811335286747E-11   0.00000000000000E+00  -1.65694339376509E-11   3.56572188476932E-24
      2.30976910658683E-08   2.30811216319306E-08  -2.05436091473108E-20  -6.03961607623179E-01  -6.03961607617794E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38494870315662E-09   0.00000000000000E+00  -5.38494870315662E-09
      1.26013758000569E-19  -8.75647344306786E-03  -3.18095334822379E-03   0.00000000000000E+00   1.00552446103986E-12
     -2.19204526455512E-24  -1.76971784532350E-08  -1.76961729287740E-08  -1.05470148853258E-19
      3.80276604265062E-09
      0.00000000000000E+00  -9.91932346315010E-12   0.00000000000000E+00  -3.48563323016108E-11   1.48596852382887E-24
      9.95419831732080E-09   9.91934198501919E-09  -4.72560708730327E-20  -5.90059791493469E-01  -5.90059791501241E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77177834392484E-09   0.00000000000000E+00   7.77177834392484E-09
      2.70702364917830E-19  -7.62662437743375E-03  -2.05269464394992E-03   0.00000000000000E+00  -1.33961074857941E-12
     -2.68745208331818E-24  -1.76897807181955E-08  -1.76911203289441E-08  -2.23446294044797E-19
      3.82276604265062E-09
      0.00000000000000E+00   9.13203037580718E-12   0.00000000000000E+00  -4.69717377529972E-11  -2.42114180235244E-24
     -9.08511706869732E-09  -9.13208880645032E-09  -1.52928521706485E-19  -5.38961755482578E-01  -5.38961755509390E-01
      0.00000000000000E+00   0.00000000000000E+00   2.68113603750159E-08   0.00000000000000E+00   2.68113603750159E-08
      8.06929572418148E-19  -5.96217060747766E-03  -3.91974167379196E-04   0.00000000000000E+00  -5.37574887339719E-12
     -4.94592128557067E-24  -1.76738958196922E-08  -1.76792715685656E-08  -6.54001050711662E-19
      3.84276604265062E-09
      0.00000000000000E+00   2.29969119046554E-11   0.00000000000000E+00  -3.43699808481806E-11  -1.29557293948465E-23
     -2.29625222030346E-08  -2.29968921838828E-08  -3.51166338197964E-19  -4.52587416520154E-01  -4.52587416560775E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06212151323529E-08   0.00000000000000E+00   4.06212151323529E-08
      1.61935387506521E-18  -4.27027752876392E-03   1.28260139055789E-03   0.00000000000000E+00  -1.19477273616232E-11
     -2.00291495076039E-23  -1.76123752211085E-08  -1.76243229484701E-08  -1.26818753686724E-18
      3.86276604265062E-09
      0.00000000000000E+00   2.31062989866696E-11   0.00000000000000E+00  -6.58421957205208E-13  -3.66693222052269E-23
     -2.31056398819383E-08  -2.31062983038955E-08  -6.42043351069100E-19  -3.36437078460470E-01  -3.36437078501242E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07724182809230E-08   0.00000000000000E+00   4.07724182809230E-08
      2.43480224068367E-18  -1.94270711136235E-03   3.62332909055606E-03   0.00000000000000E+00  -2.76550984541373E-11
     -6.56383808997816E-23  -1.76384648785732E-08  -1.76661199770274E-08  -1.79275888961457E-18
      3.88276604265062E-09
      0.00000000000000E+00   1.45705246448137E-11   0.00000000000000E+00   2.04115824677616E-11  -4.31279351909673E-23
     -1.45909181809409E-08  -1.45705065984732E-08  -9.19714278036576E-19  -2.13585806430885E-01  -2.13585806461529E-01
      0.00000000000000E+00   0.00000000000000E+00   3.06438218682679E-08   0.00000000000000E+00   3.06438218682679E-08
      3.04767867804902E-18  -1.05315482264552E-02  -5.46737023439597E-03   0.00000000000000E+00  -5.86527387598133E-11
     -8.20419877640278E-23  -1.60146625310348E-08  -1.60733152697947E-08  -2.12796440001245E-18
      3.90276604265062E-09
      0.00000000000000E+00   9.75299264406727E-12   0.00000000000000E+00   1.10846984427531E-11  -4.59839045362550E-23
     -9.76404246798110E-09  -9.75295776953839E-09  -1.11342975384202E-18  -1.12745671977781E-01  -1.12745672000260E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24793196156150E-08   0.00000000000000E+00   2.24793196156150E-08
      3.49726507036132E-18  -4.09941717168265E-02  -3.69845139429218E-02   0.00000000000000E+00  -1.09266659103858E-10
     -9.51459028116859E-23  -1.26170951869727E-08  -1.27263618460766E-08  -2.38383531651931E-18
      3.90526604265062E-09
      0.00000000000000E+00   8.76492696118869E-12   0.00000000000000E+00   1.83518795919528E-11  -4.62876836669852E-23
     -8.78329800696539E-09  -8.76494612737348E-09  -1.13521467711245E-18  -1.00583335219333E-01  -1.00583335239955E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06218649368042E-08   0.00000000000000E+00   2.06218649368042E-08
      3.54881973270333E-18  -4.55062460331264E-02  -4.17704913030186E-02   0.00000000000000E+00  -1.45866238237612E-10
     -9.68865748267477E-23  -1.17110525711929E-08  -1.18569188094306E-08  -2.41360505559088E-18
      3.90864104265062E-09
      0.00000000000000E+00   7.76042107034997E-12   0.00000000000000E+00   1.37838392548174E-11  -4.66732287128678E-23
     -7.77423431217444E-09  -7.76045047291967E-09  -1.16120477641304E-18  -8.57608726421007E-02  -8.57608726609558E-02
      0.00000000000000E+00   0.00000000000000E+00   1.88550724113023E-08   0.00000000000000E+00   1.88550724113023E-08
      3.61245560209148E-18  -5.23702798125623E-02  -4.88746966370780E-02   0.00000000000000E+00  -1.60446989352535E-10
     -9.92088397618453E-23  -1.09341749490300E-08  -1.10946219383827E-08  -2.45125082567845E-18
      3.91319729265062E-09
      0.00000000000000E+00   6.49810700216972E-12   0.00000000000000E+00   1.28007092305072E-11  -4.71022606149094E-23
     -6.51090114459578E-09  -6.49810043536532E-09  -1.19050685361613E-18  -6.86694506453718E-02  -6.86694506620580E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66861579132441E-08   0.00000000000000E+00   1.66861579132441E-08
      3.68848190908370E-18  -6.28371094062557E-02  -5.96271558816877E-02   0.00000000000000E+00  -1.68930134557256E-10
     -1.02229055115064E-22  -1.00191273433214E-08  -1.01880574778788E-08  -2.49797505546757E-18
      3.91934823015062E-09
      0.00000000000000E+00   4.83911551399017E-12   0.00000000000000E+00   1.25964919238051E-11  -4.75087043283681E-23
     -4.85172845218131E-09  -4.83913196025756E-09  -1.21983369066153E-18  -5.11051238809812E-02  -5.11051238948243E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38431449304865E-08   0.00000000000000E+00   1.38431449304865E-08
      3.77363022835456E-18  -7.89622143247883E-02  -7.61253168789146E-02   0.00000000000000E+00  -1.73623671465511E-10
     -1.06057986432869E-22  -8.83038929876332E-09  -9.00401297022894E-09  -2.55379653769303E-18
      3.92350011296312E-09
      0.00000000000000E+00   3.65156306189685E-12   0.00000000000000E+00   1.35303160937889E-11  -4.76934246874000E-23
     -3.66505857201147E-09  -3.65152825591772E-09  -1.23469323408633E-18  -4.20075185637628E-02  -4.20075185755478E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17849970547368E-08   0.00000000000000E+00   1.17849970547368E-08
      3.82256015507149E-18  -9.07690134751381E-02  -8.82063939107499E-02   0.00000000000000E+00  -1.77118819526719E-10
     -1.08524533863972E-22  -7.95634997929239E-09  -8.13346879881922E-09  -2.58786692098515E-18
      3.92630263386156E-09
      0.00000000000000E+00   2.89963019837883E-12   0.00000000000000E+00   1.27846763446675E-11  -4.77844169694200E-23
     -2.91238791237075E-09  -2.89960323602614E-09  -1.24261491063866E-18  -3.70785132017824E-02  -3.70785132122507E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04683209023255E-08   0.00000000000000E+00   1.04683209023255E-08
      3.85189784317180E-18  -9.91104858073010E-02  -9.67257995744567E-02   0.00000000000000E+00  -1.78520905634667E-10
     -1.10131682657811E-22  -7.39019676066444E-09  -7.56871766629922E-09  -2.60928293253315E-18
      3.93008603707445E-09
      0.00000000000000E+00   2.13171635058670E-12   0.00000000000000E+00   9.70984701597980E-12  -4.78707361660234E-23
     -2.14145103525448E-09  -2.13174118823854E-09  -1.25040336873038E-18  -3.21224827062464E-02  -3.21224827153526E-02
      0.00000000000000E+00   0.00000000000000E+00   9.10621071972108E-09   0.00000000000000E+00   9.10621071972108E-09
      3.88635031006606E-18  -1.10835679556558E-01  -1.08638222663857E-01   0.00000000000000E+00  -1.78015554143930E-10
     -1.12201778328119E-22  -6.79645397733832E-09  -6.97446953148236E-09  -2.63594694133568E-18
      3.93519363141185E-09
      0.00000000000000E+00   1.44747305839062E-12   0.00000000000000E+00   6.41267127780043E-12  -4.79457206856541E-23
     -1.45387909906180E-09  -1.44746642778405E-09  -1.25742395550378E-18  -2.74954601000130E-02  -2.74954601078473E-02
      0.00000000000000E+00   0.00000000000000E+00   7.83428683394298E-09   0.00000000000000E+00   7.83428683394298E-09
      3.92636466913669E-18  -1.27095173629630E-01  -1.25082866902970E-01   0.00000000000000E+00  -1.79120436584779E-10
     -1.14872387158099E-22  -6.20769996957413E-09  -6.38682040615902E-09  -2.66894071363291E-18
      3.94208888376734E-09
      0.00000000000000E+00   9.18722906286890E-13   0.00000000000000E+00   3.66563534569843E-12  -4.80059916514800E-23
     -9.22402181314418E-10  -9.18736545968768E-10  -1.26326127242982E-18  -2.34270654656022E-02  -2.34270654723554E-02
      0.00000000000000E+00   0.00000000000000E+00   6.75315710525127E-09   0.00000000000000E+00   6.75315710525127E-09
      3.97292939157369E-18  -1.49196380528367E-01  -1.47358117702751E-01   0.00000000000000E+00  -1.83223282606781E-10
     -1.18342943839597E-22  -5.65119727667545E-09  -5.83442055928234E-09  -2.70966811914386E-18
      3.95139747444726E-09
      0.00000000000000E+00   5.60069207491498E-13   0.00000000000000E+00   1.83695009577085E-12  -4.80508405572139E-23
     -5.61938529218595E-10  -5.60101579122872E-10  -1.26781598870772E-18  -1.99648569275204E-02  -1.99648569333808E-02
      0.00000000000000E+00   0.00000000000000E+00   5.86041339632578E-09   0.00000000000000E+00   5.86041339632578E-09
      4.02748158109518E-18  -1.78456782323136E-01  -1.76786800007916E-01   0.00000000000000E+00  -1.90528813357888E-10
     -1.22873684923104E-22  -5.10978300384497E-09  -5.30031181720298E-09  -2.75966559238746E-18
      3.96396407186514E-09
      0.00000000000000E+00   3.40376596091094E-13   0.00000000000000E+00   8.32283409892265E-13  -4.80809403696324E-23
     -3.41198647919375E-10  -3.40366364509531E-10  -1.27122743087687E-18  -1.70365408575018E-02  -1.70365408625418E-02
      0.00000000000000E+00   0.00000000000000E+00   5.03995418550004E-09   0.00000000000000E+00   5.03995418550004E-09
      4.09081665634895E-18  -2.15594912386310E-01  -2.14114198601850E-01   0.00000000000000E+00  -1.98069820883596E-10
     -1.28698959832931E-22  -4.50151800010679E-09  -4.69958782099051E-09  -2.81958922547209E-18
      3.98092897837929E-09
      0.00000000000000E+00   2.21345816670139E-13   0.00000000000000E+00   3.34076570390755E-13  -4.80994036083069E-23
     -2.21711119664345E-10  -2.21377043094003E-10  -1.27385123074933E-18  -1.45180962922862E-02  -1.45180962963754E-02
      0.00000000000000E+00   0.00000000000000E+00   4.08917509278367E-09   0.00000000000000E+00   4.08917509278367E-09
      4.16018912951800E-18  -2.58599963923247E-01  -2.57381321093915E-01   0.00000000000000E+00  -1.93944640765208E-10
     -1.35666985615811E-22  -3.67385340892428E-09  -3.86779804968962E-09  -2.88633789876867E-18
      4.00092897837929E-09
      0.00000000000000E+00   1.68810626987434E-13   0.00000000000000E+00   1.25598998072936E-13  -4.81098802139475E-23
     -1.68929956052825E-10  -1.68804357054800E-10  -1.27593047110453E-18  -1.25449914719820E-02  -1.25449914749862E-02
      0.00000000000000E+00   0.00000000000000E+00   3.00421870111968E-09   0.00000000000000E+00   3.00421870111968E-09
      4.22027350354040E-18  -2.96432818043828E-01  -2.95539449486603E-01   0.00000000000000E+00  -1.65096783778723E-10
     -1.42037541008234E-22  -2.67031756028601E-09  -2.83541434406487E-09  -2.94434303243587E-18
      4.02092897837929E-09
      0.00000000000000E+00   1.43553324255364E-13   0.00000000000000E+00   6.17835826929820E-14  -4.81140603945578E-23
     -1.43595470076603E-10  -1.43533686493958E-10  -1.27753015328568E-18  -1.12032856420374E-02  -1.12032856441137E-02
      0.00000000000000E+00   0.00000000000000E+00   2.07636345727347E-09   0.00000000000000E+00   2.07636345727347E-09
      4.26180077268587E-18  -3.21986953155455E-01  -3.21377966504950E-01   0.00000000000000E+00  -1.22361473783770E-10
     -1.46452547745944E-22  -1.81046829699561E-09  -1.93282977077953E-09  -2.98427061940019E-18
      4.04092897837929E-09
      0.00000000000000E+00   1.31889042630008E-13   0.00000000000000E+00   2.95142336540698E-14  -4.81156028207953E-23
     -1.31950553886016E-10  -1.31921039652410E-10  -1.27891463247242E-18  -1.02633432925677E-02  -1.02633432939152E-02
      0.00000000000000E+00   0.00000000000000E+00   1.34742429165098E-09   0.00000000000000E+00   1.34742429165098E-09
      4.28874925851888E-18  -3.37225169450421E-01  -3.36842198235963E-01   0.00000000000000E+00  -7.60581812551819E-11
     -1.49092649040892E-22  -1.13944507074319E-09  -1.21550325199852E-09  -3.00983462604647E-18
      4.06092897837929E-09
      0.00000000000000E+00   1.23990395230161E-13   0.00000000000000E+00   2.12007290793863E-14  -4.81150504680314E-23
     -1.24034086731054E-10  -1.24012886002023E-10  -1.28015176357987E-18  -9.61184981595721E-03  -9.61184981676457E-03
      0.00000000000000E+00   0.00000000000000E+00   8.07366578296073E-10   0.00000000000000E+00   8.07366578296073E-10
      4.30489659008481E-18  -3.44618720037010E-01  -3.44403420499693E-01   0.00000000000000E+00  -3.58075896045573E-11
     -1.50318501935447E-22  -6.47546102689383E-10  -6.83353692294091E-10  -3.02474482650494E-18
      4.08092897837929E-09
      0.00000000000000E+00   9.24876503679794E-14   0.00000000000000E+00   8.42342614314214E-14  -4.81022877083099E-23
     -9.26004066988741E-11  -9.25161724374908E-11  -1.28077001229157E-18  -9.34882341223845E-03  -9.34882341293239E-03
      0.00000000000000E+00   0.00000000000000E+00   6.93947797001196E-10   0.00000000000000E+00   6.93947797001196E-10
      4.31877554602483E-18  -3.51293042404293E-01  -3.51103554815046E-01   0.00000000000000E+00  -3.10500656854956E-11
     -1.51354697233886E-22  -5.70381558878028E-10  -6.01431624563675E-10  -3.03800553373325E-18
      4.10092897837929E-09
      0.00000000000000E+00   6.89753976428526E-14   0.00000000000000E+00   6.83542972206004E-14  -4.80822997067867E-23
     -6.90600224046569E-11  -6.89916681074843E-11  -1.28093213732568E-18  -9.25975097285250E-03  -9.25975097372956E-03
      0.00000000000000E+00   0.00000000000000E+00   8.77055466008366E-10   0.00000000000000E+00   8.77055466008366E-10
      4.33631665534499E-18  -3.61508634119778E-01  -3.61254039193480E-01   0.00000000000000E+00  -5.08106181632606E-11
     -1.53002921367002E-22  -7.57253179737439E-10  -8.08063797900853E-10  -3.05538451801931E-18
      4.10342897837929E-09
      0.00000000000000E+00   5.64845133826290E-14   0.00000000000000E+00   2.55908383911392E-13  -4.80786075090107E-23
     -5.67101161833547E-11  -5.64542077994914E-11  -1.28092129960521E-18  -9.26558886715260E-03  -9.26558886805188E-03
      0.00000000000000E+00   0.00000000000000E+00   8.99282223464465E-10   0.00000000000000E+00   8.99282223464465E-10
      4.33856486090366E-18  -3.62876802780209E-01  -3.62611253535882E-01   0.00000000000000E+00  -5.50275037927693E-11
     -1.53223233849839E-22  -7.87800511872388E-10  -8.42828015665310E-10  -3.05764356129845E-18
      4.10680397837929E-09
      0.00000000000000E+00   2.17672027181838E-14   0.00000000000000E+00   5.20523214860384E-13  -4.80704676513158E-23
     -2.23301860202733E-11  -2.18096628054610E-11  -1.28079029290396E-18  -9.32934565048016E-03  -9.32934565154548E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06532658443914E-09   0.00000000000000E+00   1.06532658443914E-09
      4.34216033812614E-18  -3.65365287123428E-01  -3.65036502259172E-01   0.00000000000000E+00  -7.56484095171891E-11
     -1.53626777527264E-22  -9.67868512116431E-10  -1.04351692163377E-09  -3.06137004522218E-18
      4.11136022837929E-09
      0.00000000000000E+00   1.04703000416580E-14   0.00000000000000E+00   1.47023198184808E-13  -4.80609637745891E-23
     -1.06233116721269E-11  -1.04762884739902E-11  -1.28056298034363E-18  -9.41818351477576E-03  -9.41818351609503E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31927897776507E-09   0.00000000000000E+00   1.31927897776507E-09
      4.34817130296858E-18  -3.69685574258616E-01  -3.69273200915617E-01   0.00000000000000E+00  -1.00511926074320E-10
     -1.54349381505320E-22  -1.20829076321689E-09  -1.30880268929136E-09  -3.06760832262496E-18
      4.11751116587929E-09
      0.00000000000000E+00   1.80015684926752E-14   0.00000000000000E+00  -3.97947490431141E-14  -4.80503672934822E-23
     -1.79302409285275E-11  -1.79700356776187E-11  -1.28030458875415E-18  -9.47674718108395E-03  -9.47674718265250E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56855362330298E-09   0.00000000000000E+00   1.56855362330298E-09
      4.35781937827091E-18  -3.76612137073398E-01  -3.76123581624610E-01   0.00000000000000E+00  -1.23726013435885E-10
     -1.55544354109109E-22  -1.42685757418885E-09  -1.55058358762490E-09  -3.07751478951677E-18
      4.12581493150429E-09
      0.00000000000000E+00   3.36151738179548E-14   0.00000000000000E+00  -7.71178626540216E-14  -4.80388814266655E-23
     -3.35485818305123E-11  -3.36256996932143E-11  -1.28009027287613E-18  -9.44863994305621E-03  -9.44863994478963E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73341280704402E-09   0.00000000000000E+00   1.73341280704402E-09
      4.37221323195198E-18  -3.86820852258663E-01  -3.86285284621845E-01   0.00000000000000E+00  -1.40314324991114E-10
     -1.57353487013098E-22  -1.55947278235960E-09  -1.69978710735087E-09  -3.09212295907585E-18
      4.13702501509804E-09
      0.00000000000000E+00   5.12493633617999E-14   0.00000000000000E+00  -6.54515501053891E-14  -4.80269948227346E-23
     -5.11686075180554E-11  -5.12340590682088E-11  -1.28000640040764E-18  -9.27674994658923E-03  -9.27674994838013E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79090496769606E-09   0.00000000000000E+00   1.79090496769606E-09
      4.39228942634832E-18  -4.00850190088131E-01  -4.00302055283118E-01   0.00000000000000E+00  -1.49216156507380E-10
     -1.59905301632279E-22  -1.59045475212037E-09  -1.73967090862791E-09  -3.11228302594068E-18
      4.15215862794960E-09
      0.00000000000000E+00   7.76088029403601E-14   0.00000000000000E+00  -7.89034177654634E-14  -4.80186749220323E-23
     -7.75044261300554E-11  -7.75833295478689E-11  -1.28030548656943E-18  -8.80647733563588E-03  -8.80647733741689E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78099979586093E-09   0.00000000000000E+00   1.78099979586093E-09
      4.41924238774759E-18  -4.19220616126055E-01  -4.18683904069407E-01   0.00000000000000E+00  -1.53310196145987E-10
     -1.63362077382520E-22  -1.55010627016695E-09  -1.70341646631310E-09  -3.13893690117816E-18
      4.17215862794960E-09
      0.00000000000000E+00   1.25551755762689E-13   0.00000000000000E+00  -1.20300356393251E-13  -4.80260846495758E-23
     -1.25464469201765E-10  -1.25584769558206E-10  -1.28168070688973E-18  -7.62514184344879E-03  -7.62514184521177E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76297871954366E-09   0.00000000000000E+00   1.76297871954366E-09
      4.45450196213846E-18  -4.42094886450264E-01  -4.41578976345897E-01   0.00000000000000E+00  -1.56762444248627E-10
     -1.67898576635728E-22  -1.48063150573659E-09  -1.63739394998539E-09  -3.17282125524873E-18
      4.19215862794960E-09
      0.00000000000000E+00   1.67524800666529E-13   0.00000000000000E+00  -1.13180623833714E-13  -4.80483173191391E-23
     -1.67372455233749E-10  -1.67485635857631E-10  -1.28391028617618E-18  -5.96215999926790E-03  -5.96216000100439E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73648774213365E-09   0.00000000000000E+00   1.73648774213365E-09
      4.48923171698113E-18  -4.63605849335150E-01  -4.63111486852196E-01   0.00000000000000E+00  -1.60676724822557E-10
     -1.72408134141340E-22  -1.40832538145329E-09  -1.56900210627602E-09  -3.20532143080495E-18
      4.21215862794960E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.10495525281484E-14  -4.80699228235779E-23
     -1.71472112882774E-10  -1.71493162435350E-10  -1.28623485929195E-18  -4.27129024804365E-03  -4.27129024970865E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66499740635272E-09   0.00000000000000E+00   1.66499740635272E-09
      4.52253166510819E-18  -4.84037321110878E-01  -4.83566745434168E-01   0.00000000000000E+00  -1.62663912856494E-10
     -1.76844792681503E-22  -1.33084033106076E-09  -1.49350424391743E-09  -3.23629680581624E-18
      4.23215862794961E-09
      0.00000000000000E+00   2.24009314049158E-13   0.00000000000000E+00  -1.49590894702512E-13  -4.81134119453334E-23
     -2.23825114889631E-10  -2.23974705784382E-10  -1.28962019270608E-18  -1.96163025647461E-03  -1.96163025815602E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68141065278970E-09   0.00000000000000E+00   1.68141065278970E-09
      4.55615987816399E-18  -5.03468601999783E-01  -5.03009388941382E-01   0.00000000000000E+00  -1.69266861699567E-10
     -1.81336920799244E-22  -1.28816908530564E-09  -1.45743594700539E-09  -3.26653968545790E-18
      4.25215862794961E-09
      0.00000000000000E+00  -7.24195752881348E-13   0.00000000000000E+00   2.47452482770258E-12  -4.77612469067442E-23
      7.21727698867980E-10   7.24202223695635E-10  -1.27410891088717E-18  -1.10705784219695E-02  -1.10705784220772E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07615580710563E-10   0.00000000000000E+00   1.07615580710563E-10
      4.55831218977820E-18  -5.23224772400853E-01  -5.22962692713520E-01   0.00000000000000E+00  -8.35425931260978E-11
     -1.83507853206756E-22  -7.48275211279815E-10  -8.31817804406096E-10  -3.28420327889103E-18
      4.27215862794961E-09
      0.00000000000000E+00  -2.61279908407972E-12   0.00000000000000E+00   5.06887312112560E-12  -4.67016776456310E-23
      2.60772258241190E-09   2.61279145553298E-09  -1.22120603483618E-18  -4.18844922005535E-02  -4.18844921976375E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.91601949000436E-09   0.00000000000000E+00  -2.91601949000436E-09
      4.49999179997811E-18  -5.44219258036833E-01  -5.44314840484505E-01   0.00000000000000E+00   8.79630507431879E-11
     -1.81189148375076E-22   2.15264983728341E-10   3.03228034471347E-10  -3.27878576514193E-18
      4.27465862794961E-09
      0.00000000000000E+00  -3.15055002042979E-12   0.00000000000000E+00   1.09466075073662E-11  -4.65262073874179E-23
      3.13964811696382E-09   3.15059472447114E-09  -1.21326103868417E-18  -4.64370554717601E-02  -4.64370554680215E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.73860860582339E-09   0.00000000000000E+00  -3.73860860582339E-09
      4.49064527846355E-18  -5.46862105413483E-01  -5.47047426083336E-01   0.00000000000000E+00   1.31008527923310E-10
     -1.80757984721945E-22   4.57005353428724E-10   5.88013881351854E-10  -3.27738423977938E-18
      4.27803362794961E-09
      0.00000000000000E+00  -3.59443563535377E-12   0.00000000000000E+00   7.04314376475080E-12  -4.62854773049056E-23
      3.58735282221085E-09   3.59439596597556E-09  -1.20106715160548E-18  -5.33552461572914E-02  -5.33552461528586E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.43275836326967E-09   0.00000000000000E+00  -4.43275836326967E-09
      4.47568471898752E-18  -5.50482885920809E-01  -5.50747092691083E-01   0.00000000000000E+00   1.65127162444920E-10
     -1.80017899403063E-22   6.73235234849080E-10   8.38362397293820E-10  -3.27461756738204E-18
      4.28258987794961E-09
      0.00000000000000E+00  -4.12520637167606E-12   0.00000000000000E+00   6.29742417994782E-12  -4.59240694610706E-23
      4.11888266654609E-09   4.12518009072600E-09  -1.18226709993744E-18  -6.38977261046825E-02  -6.38977260994448E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.23766217206445E-09   0.00000000000000E+00  -5.23766217206445E-09
      4.45182062071605E-18  -5.55440667492012E-01  -5.55791251686726E-01   0.00000000000000E+00   2.03022446627967E-10
     -1.78779707479487E-22   9.09459634710733E-10   1.11248208133852E-09  -3.26955352077861E-18
      4.28874081544961E-09
      0.00000000000000E+00  -4.82735938762761E-12   0.00000000000000E+00   6.21464449867519E-12  -4.53705694947653E-23
      4.82117981252946E-09   4.82739445702809E-09  -1.15281895633205E-18  -8.01199434702607E-02  -8.01199434640000E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.26076621288583E-09   0.00000000000000E+00  -6.26076621288583E-09
      4.41331103903847E-18  -5.62225565691116E-01  -5.62677266841957E-01   0.00000000000000E+00   2.47005371160136E-10
     -1.76723135919945E-22   1.18636638469784E-09   1.43337175585780E-09  -3.26049208270642E-18
      4.29289269826211E-09
      0.00000000000000E+00  -5.36731459767066E-12   0.00000000000000E+00   6.99736062812123E-12  -4.49608199778727E-23
      5.36031473478599E-09   5.36731209541406E-09  -1.13088877196139E-18  -9.19806934966483E-02  -9.19806934896404E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.00791413932855E-09   0.00000000000000E+00  -7.00791413932855E-09
      4.38421500077192E-18  -5.66832908035633E-01  -5.67349910983791E-01   0.00000000000000E+00   2.73517555098259E-10
     -1.75169185715388E-22   1.36708448881638E-09   1.64060204391446E-09  -3.25332622881053E-18
      4.29849774005898E-09
      0.00000000000000E+00  -5.95006945525241E-12   0.00000000000000E+00   5.73296599927146E-12  -4.43744010835086E-23
      5.94437403964745E-09   5.95010700564668E-09  -1.09858333176150E-18  -1.09097287857372E-01  -1.09097287849632E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.73993207891122E-09   0.00000000000000E+00  -7.73993207891122E-09
      4.34083235796465E-18  -5.73039398568106E-01  -5.73603431731122E-01   0.00000000000000E+00   2.95751426677166E-10
     -1.72871658152204E-22   1.49407364658763E-09   1.78982507326462E-09  -3.24224902620315E-18
      4.30606454648476E-09
      0.00000000000000E+00  -6.61125971840940E-12   0.00000000000000E+00   4.87623788329001E-12  -4.34940959605692E-23
      6.60640323675224E-09   6.61127947463549E-09  -1.05195202481651E-18  -1.33098721632890E-01  -1.33098721624546E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34340999596994E-09   0.00000000000000E+00  -8.34340999596994E-09
      4.27769938959421E-18  -5.81212761163454E-01  -5.81758642750583E-01   0.00000000000000E+00   3.04407283708329E-10
     -1.69623123379230E-22   1.42772323762633E-09   1.73213052133449E-09  -3.22574736477771E-18
      4.31627973515957E-09
      0.00000000000000E+00  -7.66774973050758E-12   0.00000000000000E+00   5.58897348940449E-12  -4.15897776009425E-23
      7.66217121463718E-09   7.66776018812654E-09  -9.86531119309980E-19  -1.65482515545261E-01  -1.65482515536507E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75367332647671E-09   0.00000000000000E+00  -8.75367332647671E-09
      4.18827896496665E-18  -5.91378652569976E-01  -5.91721001817160E-01   0.00000000000000E+00   2.97349086154279E-10
     -1.65240447475157E-22   7.88564052196029E-10   1.08591313835014E-09  -3.20174784565667E-18
      4.33007023987055E-09
      0.00000000000000E+00  -1.06455398002500E-11   0.00000000000000E+00   1.10226421843505E-11  -3.29158701753329E-23
      1.06345425501833E-08   1.06455651923676E-08  -8.98415948390226E-19  -2.07010504551256E-01  -2.07010504542207E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.04827898613235E-09   0.00000000000000E+00  -9.04827898613235E-09
      4.06349863098207E-18  -6.01389549334059E-01  -6.00886745908749E-01   0.00000000000000E+00   2.84324482783921E-10
     -1.59393248089471E-22  -1.88161068901906E-09  -1.59728620623530E-09  -3.16508268259185E-18
      4.34868742123038E-09
      0.00000000000000E+00  -2.08746555620011E-11   0.00000000000000E+00   2.73433800402693E-11   1.26741731015314E-23
      2.08473058207454E-08   2.08746492007857E-08  -7.90805420361224E-19  -2.55174152387107E-01  -2.55174152377631E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.47600321010970E-09   0.00000000000000E+00  -9.47600321010970E-09
      3.88708216065312E-18  -5.98306559804028E-01  -5.94716369564386E-01   0.00000000000000E+00   2.92533115203695E-10
     -1.50726847649683E-22  -1.16911791058795E-08  -1.13986459906760E-08  -3.09627674029189E-18
      4.36868742123039E-09
      0.00000000000000E+00  -3.99548486484415E-11   0.00000000000000E+00   4.72881086302472E-11   1.03730017300518E-22
      3.99075464234743E-08   3.99548345321047E-08  -7.01902862744546E-19  -2.94024808333049E-01  -2.94024808322904E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01448358607949E-08   0.00000000000000E+00  -1.01448358607949E-08
      3.68418544343722E-18  -5.61684464390233E-01  -5.52294258713450E-01   0.00000000000000E+00   3.15783126328853E-10
     -1.39050442201396E-22  -3.01257817976386E-08  -2.98099986713099E-08  -2.98228258069267E-18
      4.38868742123039E-09
      0.00000000000000E+00  -5.83686163217042E-11   0.00000000000000E+00   4.57546265395514E-11   1.90756892522984E-22
      5.83228345739606E-08   5.83685892005003E-08  -6.43193253274789E-19  -3.20430203512066E-01  -3.20430203501264E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08018962513291E-08   0.00000000000000E+00  -1.08018962513291E-08
      3.46814751841063E-18  -4.88371156086416E-01  -4.73386448869705E-01   0.00000000000000E+00   3.05787767340541E-10
     -1.24077588177114E-22  -4.78724807165115E-08  -4.75666929491711E-08  -2.82495426513585E-18
      4.40868742123039E-09
      0.00000000000000E+00  -6.59705133756339E-11   0.00000000000000E+00   1.90011145069523E-11   2.26110236926832E-22
      6.59514636314383E-08   6.59704647459455E-08  -6.11238673511788E-19  -3.36387334326028E-01  -3.36387334314656E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13717547726131E-08   0.00000000000000E+00  -1.13717547726131E-08
      3.24071242295837E-18  -3.82741486814921E-01  -3.65540600526259E-01   0.00000000000000E+00   2.62398895203055E-10
     -1.07663674196863E-22  -5.48611088685354E-08  -5.45987099733324E-08  -2.62947374944659E-18
      4.42868742123039E-09
      0.00000000000000E+00  -5.97664013772655E-11   0.00000000000000E+00  -1.53247390936436E-11   1.99257253560254E-22
      5.97817018005060E-08   5.97663770614125E-08  -6.00563667863725E-19  -3.44150598558849E-01  -3.44150598547000E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18491702633633E-08   0.00000000000000E+00  -1.18491702633633E-08
      3.00372901769111E-18  -2.57747824871986E-01  -2.42651365103334E-01   0.00000000000000E+00   2.00954996948511E-10
     -9.10504937277980E-23  -4.81181617949977E-08  -4.79172067980492E-08  -2.40316534982738E-18
      4.44868742123039E-09
      0.00000000000000E+00  -5.16077415263837E-11   0.00000000000000E+00  -2.02353461169731E-11   1.57370044259487E-22
      5.16279900901244E-08   5.16077547440076E-08  -5.93088019866932E-19  -3.50759032376928E-01  -3.50759032365035E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18932408788371E-08   0.00000000000000E+00  -1.18932408788371E-08
      2.76586420011437E-18  -1.47593820784916E-01  -1.35081366317494E-01   0.00000000000000E+00   1.14377311279840E-10
     -7.79994039306990E-23  -3.98288911764503E-08  -3.97145138651706E-08  -2.17277618024743E-18
      4.45868742123039E-09
      0.00000000000000E+00  -4.74397355071689E-11   0.00000000000000E+00  -2.06631072701347E-11   1.36344620064999E-22
      4.74603650294727E-08   4.74397019222027E-08  -5.88798722951324E-19  -3.54278530388299E-01  -3.54278530376456E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18429986767151E-08   0.00000000000000E+00  -1.18429986767151E-08
      2.64743421334721E-18  -1.00138157877725E-01  -8.89229739864629E-02   0.00000000000000E+00   7.57216664798148E-11
     -6.99676332423349E-23  -3.56724249119673E-08  -3.55967032454876E-08  -2.05863549039589E-18
      4.46206242123039E-09
      0.00000000000000E+00  -4.57072682292234E-11   0.00000000000000E+00  -2.53677648563567E-11   1.29255664648519E-22
      4.57327217682811E-08   4.57073540034248E-08  -5.87105864234088E-19  -3.55542031635775E-01  -3.55542031623966E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18089125490270E-08   0.00000000000000E+00  -1.18089125490270E-08
      2.60757913349425E-18  -8.54557753910585E-02  -7.47756271550872E-02   0.00000000000000E+00   6.82167906466565E-11
     -6.36150932006206E-23  -3.39666582450444E-08  -3.38984414543978E-08  -2.02047326926016E-18
      4.46661867123039E-09
      0.00000000000000E+00  -4.35648060443834E-11   0.00000000000000E+00  -2.33098977157115E-11   1.21761176632039E-22
      4.35881297515121E-08   4.35648198537966E-08  -5.83160783645420E-19  -3.57836683075203E-01  -3.57836683063559E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16440296045970E-08   0.00000000000000E+00  -1.16440296045970E-08
      2.55452602360830E-18  -6.84970431637267E-02  -5.84399558653301E-02   0.00000000000000E+00   5.68691162833223E-11
     -4.87587582354561E-23  -3.19776593654828E-08  -3.19207902491995E-08  -1.97136523996288E-18
      4.47276960873039E-09
      0.00000000000000E+00  -4.06303666906029E-11   0.00000000000000E+00  -2.36001139308073E-11   1.16678436186154E-22
      4.06539858192271E-08   4.06303857052964E-08  -5.73994966435299E-19  -3.62238802354993E-01  -3.62238802343651E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13427461266021E-08   0.00000000000000E+00  -1.13427461266021E-08
      2.48475750110521E-18  -5.10366276325467E-02  -4.18091283701105E-02   0.00000000000000E+00   4.76485032571054E-11
     -1.70205585959637E-23  -2.93352880819515E-08  -2.92876395786944E-08  -1.91076253466991E-18
      4.47692149154289E-09
      0.00000000000000E+00  -3.84449211687498E-11   0.00000000000000E+00  -2.59952649568322E-11   1.15712056769734E-22
      3.84709455292634E-08   3.84449502643067E-08  -5.65722250767969E-19  -3.65895557951061E-01  -3.65895557939956E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11053174936290E-08   0.00000000000000E+00  -1.11053174936290E-08
      2.43864952427605E-18  -4.19808434750952E-02  -3.33670808390999E-02   0.00000000000000E+00   4.36615713589527E-11
      1.02724499696641E-23  -2.73832943420366E-08  -2.73396327706776E-08  -1.87292727350808E-18
      4.47972401244132E-09
      0.00000000000000E+00  -3.70211440525587E-11   0.00000000000000E+00  -2.51182986486693E-11   1.16239699553853E-22
      3.70462498175344E-08   3.70211315188858E-08  -5.59196999546564E-19  -3.68676971543076E-01  -3.68676971532138E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09387257845084E-08   0.00000000000000E+00  -1.09387257845084E-08
      2.40799351666269E-18  -3.70697252970797E-02  -2.88520640274273E-02   0.00000000000000E+00   3.93921796629907E-11
      2.91494066146980E-23  -2.61217979140407E-08  -2.60824057343776E-08  -1.84879651711613E-18
      4.48350741565421E-09
      0.00000000000000E+00  -3.55212276492226E-11   0.00000000000000E+00  -1.96388331542313E-11   1.18833123795899E-22
      3.55408105328373E-08   3.55211716996832E-08  -5.49117788070212E-19  -3.72870988625413E-01  -3.72870988614670E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07427302625452E-08   0.00000000000000E+00  -1.07427302625452E-08
      2.36734943647216E-18  -3.21259613131109E-02  -2.43191255481323E-02   0.00000000000000E+00   3.14757939115733E-11
      5.29132078767182E-23  -2.48099172310498E-08  -2.47784414371382E-08  -1.81823164840195E-18
      4.48861500999162E-09
      0.00000000000000E+00  -3.41101251067662E-11   0.00000000000000E+00  -1.36681709125445E-11   1.24325566243766E-22
      3.41238076893601E-08   3.41101395184476E-08  -5.34144656649660E-19  -3.79003344448607E-01  -3.79003344438055E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05515677503741E-08   0.00000000000000E+00  -1.05515677503741E-08
      2.31345630877963E-18  -2.75047055083424E-02  -2.00821999815421E-02   0.00000000000000E+00   2.36794382794951E-11
      8.15583652985874E-23  -2.35822512063530E-08  -2.35585717680734E-08  -1.77931165212997E-18
      4.49551026234711E-09
      0.00000000000000E+00  -3.29096225467266E-11   0.00000000000000E+00  -8.58910707270936E-12   1.32637119725199E-22
      3.29181716610405E-08   3.29095825539679E-08  -5.12883242472689E-19  -3.87635564951776E-01  -3.87635564941387E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03886052666644E-08   0.00000000000000E+00  -1.03886052666644E-08
      2.24182425384437E-18  -2.34370434623518E-02  -1.63414400563942E-02   0.00000000000000E+00   1.71390611105174E-11
      1.14316924799966E-22  -2.25381163484140E-08  -2.25209772873034E-08  -1.72894101137168E-18
      4.50481885302702E-09
      0.00000000000000E+00  -3.19202710375271E-11   0.00000000000000E+00  -5.21629772343694E-12   1.41676515809974E-22
      3.19254536827909E-08   3.19202373850676E-08  -4.83976856369501E-19  -3.99345379110203E-01  -3.99345379099947E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02564255757681E-08   0.00000000000000E+00  -1.02564255757681E-08
      2.14635138632053E-18  -1.99732031133255E-02  -1.31476554810136E-02   0.00000000000000E+00   1.24710893663635E-11
      1.48049857551744E-22  -2.16762828986662E-08  -2.16638118092997E-08  -1.66237452995103E-18
      4.51738545044491E-09
      0.00000000000000E+00  -3.10090793996912E-11   0.00000000000000E+00  -3.53916548984819E-12   1.45951926339287E-22
      3.10125831205966E-08   3.10090439551069E-08  -4.46132362708607E-19  -4.14743173425660E-01  -4.14743173415524E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01359788272698E-08   0.00000000000000E+00  -1.01359788272698E-08
      2.01897662096201E-18  -1.70430054291658E-02  -1.04665879535489E-02   0.00000000000000E+00   9.55607482043530E-12
      1.74299634351526E-22  -2.08826212026576E-08  -2.08730651278370E-08  -1.57284425825341E-18
      4.53435035695906E-09
      0.00000000000000E+00  -2.99444152059816E-11   0.00000000000000E+00  -3.05795687453063E-12   1.36241214341369E-22
      2.99475151979807E-08   2.99444572411063E-08  -3.98099855309295E-19  -4.34505544447052E-01  -4.34505544437055E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99642670406190E-09   0.00000000000000E+00  -9.99642670406190E-09
      1.84938817645208E-18  -1.45231890785747E-02  -8.23821219997450E-03   0.00000000000000E+00   7.90475077231102E-12
      1.77511807116101E-22  -1.99559352878169E-08  -1.99480305370444E-08  -1.45128832114279E-18
      4.55435035695906E-09
      0.00000000000000E+00  -2.87251763195517E-11   0.00000000000000E+00  -2.97463360402954E-12   1.09114132948359E-22
      2.87281916265678E-08   2.87252169929639E-08  -3.45626857201215E-19  -4.56434284525057E-01  -4.56434284515215E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.84253372856376E-09   0.00000000000000E+00  -9.84253372856376E-09
      1.65253750188081E-18  -1.25488561726561E-02  -6.59952929905143E-03   0.00000000000000E+00   6.86920200881686E-12
      1.48047010040333E-22  -1.88895524664091E-08  -1.88826832644001E-08  -1.30691064467959E-18
      4.57435035695906E-09
      0.00000000000000E+00  -2.76770441785394E-11   0.00000000000000E+00  -2.55772074908399E-12   7.62375227221443E-23
      2.76795635509740E-08   2.76770058302250E-08  -2.96766077841729E-19  -4.77203513611873E-01  -4.77203513602164E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70952254236564E-09   0.00000000000000E+00  -9.70952254236564E-09
      1.45834705103349E-18  -1.12060680959892E-02  -5.54508636072690E-03   0.00000000000000E+00   5.80436318736954E-12
      1.03124356281453E-22  -1.79732876510468E-08  -1.79674832878593E-08  -1.16158097319176E-18
      4.59435035695906E-09
      0.00000000000000E+00  -2.68151731645839E-11   0.00000000000000E+00  -2.10118070341560E-12   4.72557966454813E-23
      2.68172463978987E-08   2.68151452171954E-08  -2.51062242495506E-19  -4.96971433259571E-01  -4.96971433250004E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56771980006242E-09   0.00000000000000E+00  -9.56771980006242E-09
      1.26699265503225E-18  -1.02654813844367E-02  -4.83136291087576E-03   0.00000000000000E+00   4.82086885284851E-12
      6.08494634500171E-23  -1.72522462859859E-08  -1.72474254171330E-08  -1.01593041253674E-18
      4.61435035695906E-09
      0.00000000000000E+00  -2.63398766495350E-11   0.00000000000000E+00  -1.14977071047922E-12   2.68404786012947E-23
      2.63410234941006E-08   2.63398737233902E-08  -2.07310435040241E-19  -5.16270293971928E-01  -5.16270293962301E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.62731393792779E-09   0.00000000000000E+00  -9.62731393792779E-09
      1.07444637627369E-18  -9.61274620775492E-03  -4.34714361000245E-03   0.00000000000000E+00   4.03056393713191E-12
      3.04340709587856E-23  -1.67165903493996E-08  -1.67125597854624E-08  -8.67135941233449E-19
      4.63435035695906E-09
      0.00000000000000E+00  -2.71944000845138E-11   0.00000000000000E+00   2.13043009691686E-12   1.50140444386439E-23
      2.71923036382665E-08   2.71944340683634E-08  -1.61561244594610E-19  -5.36973676777485E-01  -5.36973676766890E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05942569584794E-08   0.00000000000000E+00  -1.05942569584794E-08
      8.62561237104102E-19  -9.34883027773319E-03  -4.11863283480642E-03   0.00000000000000E+00   2.92880757290556E-12
      1.26202016637215E-23  -1.66031059174568E-08  -1.66001771098839E-08  -7.00999992509491E-19
      4.64435035695906E-09
      0.00000000000000E+00  -2.77708176552282E-11   0.00000000000000E+00   2.87184692529746E-12   1.08746659832688E-23
      2.77679204309376E-08   2.77707922778629E-08  -1.38501775930864E-19  -5.47621916865714E-01  -5.47621916854558E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11564595209879E-08   0.00000000000000E+00  -1.11564595209879E-08
      7.50996641894222E-19  -9.28006448677121E-03  -4.04540601399699E-03   0.00000000000000E+00   2.49107660943196E-12
      6.40666019424101E-24  -1.66168238334845E-08  -1.66143327568750E-08  -6.12494865963358E-19
      4.65110035695906E-09
      0.00000000000000E+00  -2.82347254228635E-11   0.00000000000000E+00   3.41942981342590E-12   8.87146333408737E-24
      2.82313375410000E-08   2.82347569708134E-08  -1.22836311783420E-19  -5.54940823811981E-01  -5.54940823800480E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15003958033502E-08   0.00000000000000E+00  -1.15003958033502E-08
      6.73368970221608E-19  -9.28946054757198E-03  -4.01698363958399E-03   0.00000000000000E+00   1.64635320530220E-12
      3.43417048620574E-24  -1.67360075206686E-08  -1.67343611674633E-08  -5.50532658438189E-19
      4.66021285695906E-09
      0.00000000000000E+00  -2.88910479149484E-11   0.00000000000000E+00   3.58516295616702E-12   7.21808662683354E-24
      2.88874959366381E-08   2.88910810995942E-08  -1.01564750048133E-19  -5.64987478854273E-01  -5.64987478842440E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18331522414576E-08   0.00000000000000E+00  -1.18331522414576E-08
      5.65539370421327E-19  -9.37265076695903E-03  -3.99822633529465E-03   0.00000000000000E+00   7.34868318659672E-13
      1.03121618447904E-24  -1.70586637264553E-08  -1.70579288581366E-08  -4.63974620373194E-19
      4.66328832570906E-09
      0.00000000000000E+00  -2.91630001818199E-11   0.00000000000000E+00   4.38309424437849E-12   6.74831531605568E-24
      2.91586063021164E-08   2.91629893963608E-08  -9.44265016829646E-20  -5.68390352386320E-01  -5.68390352374351E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19690417669468E-08   0.00000000000000E+00  -1.19690417669468E-08
      5.28728956499637E-19  -9.41720114603623E-03  -3.99992084852661E-03   0.00000000000000E+00   2.58516469343993E-13
      3.31296636802393E-25  -1.71942061458839E-08  -1.71939476294145E-08  -4.34302454816672E-19
      4.66744020852156E-09
      0.00000000000000E+00  -2.94393609960774E-11   0.00000000000000E+00   3.32830738613253E-12   6.25607557948981E-24
      2.94360268331811E-08   2.94393551405672E-08  -8.48248915285570E-20  -5.72985371399047E-01  -5.72985371386991E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20558407489173E-08   0.00000000000000E+00  -1.20558407489173E-08
      4.78674518503970E-19  -9.47209855886821E-03  -3.99509112005441E-03   0.00000000000000E+00   1.54837230295025E-13
     -3.63862181558463E-25  -1.73836692288801E-08  -1.73835143916498E-08  -3.93849626975412E-19
      4.67304525031843E-09
      0.00000000000000E+00  -2.95602286702425E-11   0.00000000000000E+00   1.10990024918637E-12   5.75498656500773E-24
      2.95591174549546E-08   2.95602273552038E-08  -7.21116262830227E-20  -5.79096254719538E-01  -5.79096254707537E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20006309079565E-08   0.00000000000000E+00  -1.20006309079565E-08
      4.11410480676004E-19  -9.49442470536474E-03  -3.96193882821097E-03   0.00000000000000E+00   7.86600127131926E-13
     -9.85149803847567E-25  -1.75603830473743E-08  -1.75595964472472E-08  -3.39298854392981E-19
      4.68061205674421E-09
      0.00000000000000E+00  -2.92913991244361E-11   0.00000000000000E+00  -1.71519096629027E-12   5.23670793296798E-24
      2.92931462372118E-08   2.92914310462455E-08  -5.58020499613744E-20  -5.86979597671897E-01  -5.86979597660276E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16211350186253E-08   0.00000000000000E+00  -1.16211350186253E-08
      3.23475601542199E-19  -9.44270432931140E-03  -3.87533981827239E-03   0.00000000000000E+00   1.47739487319512E-12
     -1.48644872749439E-24  -1.76717734224934E-08  -1.76702960276202E-08  -2.67673551580823E-19
      4.69082724541902E-09
      0.00000000000000E+00  -2.80771198538153E-11   0.00000000000000E+00  -5.83707241009043E-12   4.64088913065711E-24
      2.80829624609660E-08   2.80771253885559E-08  -3.65993160986120E-20  -5.96307665532640E-01  -5.96307665522268E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03716816936026E-08   0.00000000000000E+00  -1.03716816936026E-08
      2.17526916167030E-19  -9.26916679916902E-03  -3.69072737912788E-03   0.00000000000000E+00   1.72959370635761E-12
     -1.85940272977940E-24  -1.77071732886598E-08  -1.77054436949534E-08  -1.80927600068418E-19
      4.70461775013001E-09
      0.00000000000000E+00  -2.39670678637785E-11   0.00000000000000E+00  -1.46845715560829E-11   3.72527224325467E-24
      2.39817806119252E-08   2.39670960403691E-08  -2.13869176993924E-20  -6.03593053810620E-01  -6.03593053804348E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.27116392520110E-09   0.00000000000000E+00  -6.27116392520110E-09
      1.31044400513177E-19  -8.83905518898125E-03  -3.26361117302215E-03   0.00000000000000E+00   1.15369018724266E-12
     -2.15345434047741E-24  -1.76970858053553E-08  -1.76959321151681E-08  -1.09657482813785E-19
      4.72323493148984E-09
      0.00000000000000E+00  -1.16411367515796E-11   0.00000000000000E+00  -3.26420055088255E-11   1.76045085168524E-24
      1.16737329028857E-08   1.16410908973769E-08  -4.22359041159664E-20  -5.92614154050122E-01  -5.92614154056170E-01
      0.00000000000000E+00   0.00000000000000E+00   6.04802796815384E-09   0.00000000000000E+00   6.04802796815384E-09
      2.43641634065630E-19  -7.77243222942250E-03  -2.19913385312973E-03   0.00000000000000E+00  -1.02811585080517E-12
     -2.61279883228620E-24  -1.76880907496799E-08  -1.76891188655307E-08  -2.01405729949664E-19
      4.74323493148984E-09
      0.00000000000000E+00   7.31130030540517E-12   0.00000000000000E+00  -4.67194908018416E-11  -1.91633031939154E-24
     -7.26456880926678E-09  -7.31128830006863E-09  -1.39651712134853E-19  -5.45170691185097E-01  -5.45170691210090E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49926425320263E-08   0.00000000000000E+00   2.49926425320263E-08
      7.43494484706157E-19  -6.13308107113463E-03  -5.62228431341727E-04   0.00000000000000E+00  -4.91829545349530E-12
     -4.52811764572602E-24  -1.76764359365042E-08  -1.76813542319577E-08  -6.03842772571303E-19
      4.76323493148984E-09
      0.00000000000000E+00   2.21151105827260E-11   0.00000000000000E+00  -3.66644583418553E-11  -1.12640731568660E-23
     -2.20784859057229E-08  -2.21151503640647E-08  -3.28350954897742E-19  -4.62020626475585E-01  -4.62020626515328E-01
      0.00000000000000E+00   0.00000000000000E+00   3.97439398760082E-08   0.00000000000000E+00   3.97439398760082E-08
      1.53837328222632E-18  -4.44027080305946E-03   1.11401601712108E-03   0.00000000000000E+00  -1.10977642052933E-11
     -1.71871345391331E-23  -1.76176917477382E-08  -1.76287895119435E-08  -1.21002232732858E-18
      4.78323493148984E-09
      0.00000000000000E+00   2.37319453365273E-11   0.00000000000000E+00  -4.35351048996141E-12  -3.50329326309184E-23
     -2.37275829303255E-08  -2.37319364408155E-08  -6.12573024996916E-19  -3.48328701499274E-01  -3.48328701540661E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13869990518945E-08   0.00000000000000E+00   4.13869990518945E-08
      2.36611326326421E-18  -2.21605341665096E-03   3.34650046112818E-03   0.00000000000000E+00  -2.54778219105030E-11
     -6.22261262618785E-23  -1.76295847891683E-08  -1.76550626110789E-08  -1.75354023826729E-18
      4.80323493148984E-09
      0.00000000000000E+00   1.51852414709436E-11   0.00000000000000E+00   2.04583470837196E-11  -4.28004681117212E-23
     -1.52056981514841E-08  -1.51852398044005E-08  -8.97292586225491E-19  -2.24401481134443E-01  -2.24401481166020E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15767744544276E-08   0.00000000000000E+00   3.15767744544276E-08
      2.99764875235276E-18  -8.59416103216397E-03  -3.42972160298158E-03   0.00000000000000E+00  -5.51375187479300E-11
     -8.08627632848720E-23  -1.63363971312791E-08  -1.63915346500271E-08  -2.10035616612727E-18
      4.82323493148984E-09
      0.00000000000000E+00   1.01219329534299E-11   0.00000000000000E+00   1.17043563265142E-11  -4.57542095143780E-23
     -1.01335702418909E-08  -1.01218658855645E-08  -1.09834748064110E-18  -1.21109958213321E-01  -1.21109958236462E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31411352495828E-08   0.00000000000000E+00   2.31411352495828E-08
      3.46047145734442E-18  -3.72908641192226E-02  -3.31889209435340E-02   0.00000000000000E+00  -1.03303264987814E-10
     -9.38903096679071E-23  -1.29159660990305E-08  -1.30192693640184E-08  -2.36212397670332E-18
      4.84323493148984E-09
      0.00000000000000E+00   5.98304171590991E-12   0.00000000000000E+00   9.45295868237204E-12  -4.75148899934242E-23
     -5.99252205079089E-09  -5.98306909210856E-09  -1.21656994516792E-18  -5.28280770951091E-02  -5.28280771108828E-02
      0.00000000000000E+00   0.00000000000000E+00   1.57736384693710E-08   0.00000000000000E+00   1.57736384693710E-08
      3.77594422673184E-18  -8.41794303065865E-02  -8.10947379339458E-02   0.00000000000000E+00  -1.58373677640448E-10
     -1.06471787960439E-22  -9.63219569962189E-09  -9.79056937726244E-09  -2.55937428156392E-18
      4.84573493148984E-09
      0.00000000000000E+00   4.78318206903079E-12   0.00000000000000E+00   2.26777851687734E-11  -4.76441585722317E-23
     -4.80583559144139E-09  -4.78315780627266E-09  -1.22834801966509E-18  -4.57386927077279E-02  -4.57386927213566E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36286410852040E-08   0.00000000000000E+00   1.36286410852040E-08
      3.81001582944485E-18  -9.06852504021369E-02  -8.78982979984523E-02   0.00000000000000E+00  -1.83155398465122E-10
     -1.08065608841803E-22  -8.66232788046645E-09  -8.84548327893168E-09  -2.58166780977976E-18
      4.84910993148984E-09
      0.00000000000000E+00   3.52656237455740E-12   0.00000000000000E+00   1.78733448065868E-11  -4.77733252283800E-23
     -3.54445181897096E-09  -3.52657847416443E-09  -1.24000475260368E-18  -3.85861313840197E-02  -3.85861313954998E-02
      0.00000000000000E+00   0.00000000000000E+00   1.14800791927902E-08   0.00000000000000E+00   1.14800791927902E-08
      3.84876109672051E-18  -1.00282964991597E-01  -9.77770465053823E-02   0.00000000000000E+00  -1.83338128061790E-10
     -1.10089887766958E-22  -7.77016259056353E-09  -7.95350071862542E-09  -2.60875634411683E-18
      4.85366618148984E-09
      0.00000000000000E+00   2.36178741729155E-12   0.00000000000000E+00   1.22902176284509E-11  -4.78836876348296E-23
     -2.37405665398291E-09  -2.36176643635451E-09  -1.25043278072973E-18  -3.20130275769295E-02  -3.20130275863847E-02
      0.00000000000000E+00   0.00000000000000E+00   9.45526776065550E-09   0.00000000000000E+00   9.45526776065550E-09
      3.89184166045500E-18  -1.14143555432414E-01  -1.11908596207883E-01   0.00000000000000E+00  -1.80962760974163E-10
     -1.12631311322343E-22  -6.91253856332683E-09  -7.09350132430110E-09  -2.64140887972527E-18
      4.85981711898984E-09
      0.00000000000000E+00   1.43828858466987E-12   0.00000000000000E+00   7.21948388778907E-12  -4.79679200810928E-23
     -1.44548375580553E-09  -1.43826427191779E-09  -1.25883223707985E-18  -2.64844784964114E-02  -2.64844785041745E-02
      0.00000000000000E+00   0.00000000000000E+00   7.76304853595554E-09   0.00000000000000E+00   7.76304853595554E-09
      3.93959168680913E-18  -1.33598310461117E-01  -1.31605550113938E-01   0.00000000000000E+00  -1.81302700672047E-10
     -1.15851763112365E-22  -6.14348156336573E-09  -6.32478426403789E-09  -2.68075944972929E-18
      4.86812088461484E-09
      0.00000000000000E+00   8.21918553270157E-13   0.00000000000000E+00   3.56297986677018E-12  -4.80278107987851E-23
     -8.25494140005988E-10  -8.21931160139266E-10  -1.26506216391049E-18  -2.20786812182330E-02  -2.20786812247251E-02
      0.00000000000000E+00   0.00000000000000E+00   6.49204522273275E-09   0.00000000000000E+00   6.49204522273275E-09
      3.99350010876561E-18  -1.60008369778947E-01  -1.58221875267610E-01   0.00000000000000E+00  -1.86008886003115E-10
     -1.19997586259305E-22  -5.48410517659035E-09  -5.67011406259358E-09  -2.72843794485512E-18
      4.87933096820859E-09
      0.00000000000000E+00   4.64091457109633E-13   0.00000000000000E+00   1.52729373855460E-12  -4.80677055040644E-23
     -4.65599941190073E-10  -4.64072647451566E-10  -1.26948000021107E-18  -1.85855261289618E-02  -1.85855261344866E-02
      0.00000000000000E+00   0.00000000000000E+00   5.52482211010874E-09   0.00000000000000E+00   5.52482211010874E-09
      4.05543382646052E-18  -1.94489547529838E-01  -1.92895043987336E-01   0.00000000000000E+00  -1.94109284109595E-10
     -1.25362946409528E-22  -4.86664017854759E-09  -5.06074946265731E-09  -2.78595382624945E-18
      4.89446458106015E-09
      0.00000000000000E+00   2.75258677410958E-13   0.00000000000000E+00   5.95822261890393E-13  -4.80919382852470E-23
     -2.75813676489367E-10  -2.75217854227525E-10  -1.27261873128452E-18  -1.57342250232166E-02  -1.57342250278263E-02
      0.00000000000000E+00   0.00000000000000E+00   4.60965318868076E-09   0.00000000000000E+00   4.60965318868076E-09
      4.12519453319799E-18  -2.36636205635288E-01  -2.35270540156688E-01   0.00000000000000E+00  -1.98393090043174E-10
     -1.32068029018557E-22  -4.13604224440998E-09  -4.33443533445329E-09  -2.85257580191346E-18
      4.91446458106015E-09
      0.00000000000000E+00   1.88373556012637E-13   0.00000000000000E+00   2.07213618037844E-13  -4.81062457708506E-23
     -1.88628411250833E-10  -1.88421197632843E-10  -1.27507482532494E-18  -1.33520714705180E-02  -1.33520714740243E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50630761672976E-09   0.00000000000000E+00   3.50630761672976E-09
      4.19532068553258E-18  -2.80654267788621E-01  -2.79608886343511E-01   0.00000000000000E+00  -1.80788241521108E-10
     -1.39347513506824E-22  -3.13709817757557E-09  -3.31788641909681E-09  -2.92024586020764E-18
      4.93446458106015E-09
      0.00000000000000E+00   1.53472555873777E-13   0.00000000000000E+00   8.43006457606209E-14  -4.81128415820762E-23
     -1.53554596832623E-10  -1.53470296186911E-10  -1.27686266224102E-18  -1.17488805321830E-02  -1.17488805346586E-02
      0.00000000000000E+00   0.00000000000000E+00   2.47560767460716E-09   0.00000000000000E+00   2.47560767460716E-09
      4.24483283902473E-18  -3.11594287784684E-01  -3.10862639396994E-01   0.00000000000000E+00  -1.42851763670755E-10
     -1.44644005105127E-22  -2.17928561474942E-09  -2.32213737842032E-09  -2.96797017678371E-18
      4.95446458106015E-09
      0.00000000000000E+00   1.35287297906687E-13   0.00000000000000E+00   4.53403714453617E-14  -4.81148585761070E-23
     -1.35345778099884E-10  -1.35300437728487E-10  -1.27830798763782E-18  -1.06529766076322E-02  -1.06529766092962E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66404408341545E-09   0.00000000000000E+00   1.66404408341545E-09
      4.27811372069303E-18  -3.31404453179002E-01  -3.30922785680684E-01   0.00000000000000E+00  -9.76247135127669E-11
     -1.48082406667872E-22  -1.43111893217394E-09  -1.52874364568685E-09  -2.99980573305522E-18
      4.97446458106015E-09
      0.00000000000000E+00   1.29776613674235E-13   0.00000000000000E+00   1.46573098849543E-14  -4.81162682902590E-23
     -1.29761187718151E-10  -1.29746530408314E-10  -1.27965528241896E-18  -9.86027268127552E-03  -9.86027268229050E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01497618922718E-09   0.00000000000000E+00   1.01497618922718E-09
      4.29841324447758E-18  -3.41741663213113E-01  -3.41462755726093E-01   0.00000000000000E+00  -5.13712569581729E-11
     -1.49848844250970E-22  -8.33858401860705E-10  -8.85229658819028E-10  -3.01875796205863E-18
      4.99446458106015E-09
      0.00000000000000E+00   1.06999118846769E-13   0.00000000000000E+00   6.03717943769851E-14  -4.81089749885888E-23
     -1.07059792640528E-10  -1.06999420846200E-10  -1.28055802864043E-18  -9.43692454124902E-03  -9.43692454194920E-03
      0.00000000000000E+00   0.00000000000000E+00   7.00179400099464E-10   0.00000000000000E+00   7.00179400099464E-10
      4.31241683247957E-18  -3.48048391028938E-01  -3.47861503656972E-01   0.00000000000000E+00  -2.94334244064206E-11
     -1.50845190610403E-22  -5.63746554846602E-10  -5.93179979253173E-10  -3.03185880383914E-18
      5.01446458106015E-09
      0.00000000000000E+00   8.09152134798311E-14   0.00000000000000E+00   7.27324134465590E-14  -4.80927618069948E-23
     -8.09962959690391E-11  -8.09235635556407E-11  -1.28095151965082E-18  -9.27292653302933E-03  -9.27292653377807E-03
      0.00000000000000E+00   0.00000000000000E+00   7.48743710186074E-10   0.00000000000000E+00   7.48743710186074E-10
      4.32739170668329E-18  -3.55927649620753E-01  -3.55717243724721E-01   0.00000000000000E+00  -3.76489246796538E-11
     -1.52082690283664E-22  -6.30171221950612E-10  -6.67820146630418E-10  -3.04644018703246E-18
      5.02446458106015E-09
      0.00000000000000E+00   5.76784949663268E-14   0.00000000000000E+00   1.26791228182085E-13  -4.80800158922970E-23
     -5.77698166690481E-11  -5.76430254409141E-11  -1.28091931942073E-18  -9.28589404728962E-03  -9.28589404820341E-03
      0.00000000000000E+00   0.00000000000000E+00   9.13789756118481E-10   0.00000000000000E+00   9.13789756118481E-10
      4.33652960424447E-18  -3.61503675436507E-01  -3.61233929740741E-01   0.00000000000000E+00  -5.58588508282185E-11
     -1.52982225189528E-22  -8.00287879849317E-10  -8.56146730677688E-10  -3.05561028482374E-18
      5.02783958106015E-09
      0.00000000000000E+00   3.34314843435397E-14   0.00000000000000E+00   3.66760206611364E-13  -4.80732068430778E-23
     -3.37818448156648E-11  -3.34150846091015E-11  -1.28082720373611E-18  -9.32877279936909E-03  -9.32877280040742E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03832543855372E-09   0.00000000000000E+00   1.03832543855372E-09
      4.34003395259959E-18  -3.63850411663816E-01  -3.63533791599797E-01   0.00000000000000E+00  -7.10924232417353E-11
     -1.53363720585894E-22  -9.33817930702448E-10  -1.00491035394434E-09  -3.05920674886348E-18
      5.03239583106015E-09
      0.00000000000000E+00   1.55217605880720E-14   0.00000000000000E+00   2.14992552922899E-13  -4.80636407854556E-23
     -1.57108745609210E-11  -1.54958820080462E-11  -1.28062234571833E-18  -9.40949923910713E-03  -9.40949924038081E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27368001028372E-09   0.00000000000000E+00   1.27368001028372E-09
      4.34583715714645E-18  -3.67973713166117E-01  -3.67577289256841E-01   0.00000000000000E+00  -9.52764518866548E-11
     -1.54050558654528E-22  -1.16290767638879E-09  -1.25818412827560E-09  -3.06521481142811E-18
      5.03854676856015E-09
      0.00000000000000E+00   1.79097237554677E-14   0.00000000000000E+00   1.54268275377358E-15  -4.80527093803768E-23
     -1.78676126358902E-11  -1.78660699531845E-11  -1.28036271285630E-18  -9.47404805457842E-03  -9.47404805610877E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53035196217420E-09   0.00000000000000E+00   1.53035196217420E-09
      4.35525025641878E-18  -3.74719123027054E-01  -3.74242571784597E-01   0.00000000000000E+00  -1.19589161632991E-10
     -1.55208492702715E-22  -1.39289673058756E-09  -1.51248589222070E-09  -3.07488754356248E-18
      5.04685053418515E-09
      0.00000000000000E+00   3.15945895993892E-14   0.00000000000000E+00  -6.48678625492186E-14  -4.80407751079306E-23
     -3.14929821978217E-11  -3.15578500604190E-11  -1.28013039989310E-18  -9.45976361690441E-03  -9.45976361861916E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71475653850424E-09   0.00000000000000E+00   1.71475653850424E-09
      4.36948919281846E-18  -3.84829882396788E-01  -3.84299541671641E-01   0.00000000000000E+00  -1.37968054928369E-10
     -1.56992398939735E-22  -1.54523063351526E-09  -1.68319868844378E-09  -3.08935879292536E-18
      5.05806061777890E-09
      0.00000000000000E+00   4.87695554571967E-14   0.00000000000000E+00  -6.29997449954467E-14  -4.80283265652057E-23
     -4.86668381449023E-11  -4.87298378899458E-11  -1.28001738184924E-18  -9.30563749557653E-03  -9.30563749736413E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78760153025202E-09   0.00000000000000E+00   1.78760153025202E-09
      4.38952835540490E-18  -3.98861934965491E-01  -3.98314052116894E-01   0.00000000000000E+00  -1.48215603932231E-10
     -1.59534625638735E-22  -1.59065608842967E-09  -1.73887169236206E-09  -3.10951097355566E-18
      5.07319423063047E-09
      0.00000000000000E+00   7.39350134520590E-14   0.00000000000000E+00  -7.45624171381628E-14  -4.80189237475448E-23
     -7.38780048854603E-11  -7.39525673026465E-11  -1.28026023106095E-18  -8.86743462343224E-03  -8.86743462521467E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78242807668677E-09   0.00000000000000E+00   1.78242807668677E-09
      4.41650293185323E-18  -4.17311066733047E-01  -4.16772760780677E-01   0.00000000000000E+00  -1.52854338197557E-10
     -1.62991003248213E-22  -1.55562117118641E-09  -1.70847550938413E-09  -3.13624270079228E-18
      5.09319423063047E-09
      0.00000000000000E+00   1.21143208376728E-13   0.00000000000000E+00  -1.17502942824554E-13  -4.80246850892107E-23
     -1.21031275750024E-10  -1.21148778692897E-10  -1.28154536633689E-18  -7.73745559470463E-03  -7.73745559646846E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76382103417547E-09   0.00000000000000E+00   1.76382103417547E-09
      4.45177935253674E-18  -4.40301852814246E-01  -4.39784279731366E-01   0.00000000000000E+00  -1.56369151496286E-10
     -1.67528090195905E-22  -1.48630310398609E-09  -1.64267225548254E-09  -3.17023398619986E-18
      5.11319423063047E-09
      0.00000000000000E+00   1.65779750659586E-13   0.00000000000000E+00  -1.19590779279773E-13  -4.80464733297558E-23
     -1.65670444229731E-10  -1.65790035009058E-10  -1.28373986412577E-18  -6.09287827404999E-03  -6.09287827579057E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74057844356900E-09   0.00000000000000E+00   1.74057844356900E-09
      4.48659092140812E-18  -4.61908849421617E-01  -4.61412663887177E-01   0.00000000000000E+00  -1.60417050431391E-10
     -1.72041348405705E-22  -1.41437135812838E-09  -1.57478840855994E-09  -3.20285105728235E-18
      5.13319423063047E-09
      0.00000000000000E+00   1.71382279629245E-13   0.00000000000000E+00  -2.48499612591081E-14  -4.80681083657913E-23
     -1.71329129248037E-10  -1.71353979209344E-10  -1.28606058617831E-18  -4.40203459827740E-03  -4.40203459994799E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67059450236972E-09   0.00000000000000E+00   1.67059450236972E-09
      4.52000281145551E-18  -4.82420383411350E-01  -4.81948000434645E-01   0.00000000000000E+00  -1.62486959492048E-10
     -1.76483332060934E-22  -1.33675356366813E-09  -1.49924052316035E-09  -3.23394222527721E-18
      5.15319423063047E-09
      0.00000000000000E+00   2.18406785079499E-13   0.00000000000000E+00  -1.35172212114987E-13  -4.81092644051314E-23
     -2.18243198334038E-10  -2.18378370546201E-10  -1.28933328169447E-18  -2.15868982331663E-03  -2.15868982499425E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67762248451255E-09   0.00000000000000E+00   1.67762248451255E-09
      4.55355526114577E-18  -5.01929936240530E-01  -5.01470153636065E-01   0.00000000000000E+00  -1.68577183837761E-10
     -1.80967080188462E-22  -1.29066693012848E-09  -1.45924411396642E-09  -3.26422197945130E-18
      5.17319423063047E-09
      0.00000000000000E+00  -5.78529999670211E-13   0.00000000000000E+00   2.07790766247373E-12  -4.78176886260389E-23
      5.76442996961373E-10   5.78520904623799E-10  -1.27672475437833E-18  -9.52310715175309E-03  -9.52310715209735E-03
      0.00000000000000E+00   0.00000000000000E+00   3.44259135744311E-10   0.00000000000000E+00   3.44259135744311E-10
      4.56044044386065E-18  -5.21576219706615E-01  -5.21285477336129E-01   0.00000000000000E+00  -9.70126740845920E-11
     -1.83491566818172E-22  -8.25767366283357E-10  -9.22780040368132E-10  -3.28371568948233E-18
      5.18319423063047E-09
      0.00000000000000E+00  -1.88649090224260E-12   0.00000000000000E+00   6.75402103720765E-12  -4.73851967951407E-23
      1.87978658963644E-09   1.88654061067360E-09  -1.25738808602247E-18  -2.09574766604531E-02  -2.09574766586901E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.76301132510205E-09   0.00000000000000E+00  -1.76301132510205E-09
      4.54281033060963E-18  -5.31898692517054E-01  -5.31859799960112E-01   0.00000000000000E+00   2.45707889443118E-11
     -1.83176117229815E-22  -1.48100074515517E-10  -1.23529285571388E-10  -3.28542224458716E-18
      5.18994423063047E-09
      0.00000000000000E+00  -2.66349737901828E-12   0.00000000000000E+00   6.11055825949453E-12  -4.70106932781631E-23
      2.65740323865020E-09   2.66351379690964E-09  -1.23913418849156E-18  -3.16156555722067E-02  -3.16156555692019E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.00476859622241E-09   0.00000000000000E+00  -3.00476859622241E-09
      4.52252814258513E-18  -5.39031553769719E-01  -5.39139118071507E-01   0.00000000000000E+00   9.38418864349459E-11
     -1.82349522328996E-22   2.47412912877594E-10   3.41254799312358E-10  -3.28339395409358E-18
      5.19450048063047E-09
      0.00000000000000E+00  -3.16405119679930E-12   0.00000000000000E+00   5.90055045233496E-12  -4.67208872180006E-23
      3.15811928080454E-09   3.16401983125682E-09  -1.22456354300544E-18  -4.00261007007667E-02  -4.00261006969762E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.79057679666980E-09   0.00000000000000E+00  -3.79057679666980E-09
      4.50525732705531E-18  -5.43904825714340E-01  -5.44102290572626E-01   0.00000000000000E+00   1.35249711492453E-10
     -1.81539502384997E-22   4.91307253921084E-10   6.26556965413356E-10  -3.28069378404986E-18
      5.20065141813047E-09
      0.00000000000000E+00  -3.73642759907660E-12   0.00000000000000E+00   5.12687677918686E-12  -4.62786116133767E-23
      3.73133962051537E-09   3.73646649729451E-09  -1.20146476108727E-18  -5.31722812879448E-02  -5.31722812832734E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.67135236766626E-09   0.00000000000000E+00  -4.67135236766626E-09
      4.47652413060131E-18  -5.50567100191046E-01  -5.50861722028671E-01   0.00000000000000E+00   1.78819478489907E-10
     -1.80079208297889E-22   7.56066391882112E-10   9.34885870371839E-10  -3.27505936951405E-18
      5.20895518375547E-09
      0.00000000000000E+00  -4.54466128650284E-12   0.00000000000000E+00   5.37725171866941E-12  -4.55747969360436E-23
      4.53928616308024E-09   4.54466341479887E-09  -1.16391074221128E-18  -7.40763355196531E-02  -7.40763355137908E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.86228206001860E-09   0.00000000000000E+00  -5.86228206001860E-09
      4.42784511434727E-18  -5.59690690011861E-01  -5.60105916056596E-01   0.00000000000000E+00   2.32027958425140E-10
     -1.77484353915307E-22   1.08559068679464E-09   1.31761864521960E-09  -3.26393437213600E-18
      5.21456022555234E-09
      0.00000000000000E+00  -5.24010963663823E-12   0.00000000000000E+00   6.70101158826120E-12  -4.50337951008426E-23
      5.23339171396705E-09   5.24009272555527E-09  -1.13496397942740E-18  -8.98124714747600E-02  -8.98124714679263E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.83366270466189E-09   0.00000000000000E+00  -6.83366270466189E-09
      4.38954214926190E-18  -5.65901846425681E-01  -5.66404029209881E-01   0.00000000000000E+00   2.68023812731741E-10
     -1.75432928111725E-22   1.32554616637528E-09   1.59356997910684E-09  -3.25457816983450E-18
      5.21834362876523E-09
      0.00000000000000E+00  -5.71485508326394E-12   0.00000000000000E+00   6.78061057094167E-12  -4.46440214113974E-23
      5.70808824628618E-09   5.71486885685708E-09  -1.11384512814823E-18  -1.01085749751652E-01  -1.01085749744192E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.45972441992499E-09   0.00000000000000E+00  -7.45972441992499E-09
      4.36131900392428E-18  -5.70101861792728E-01  -5.70651719009448E-01   0.00000000000000E+00   2.87029259163953E-10
     -1.73933962270100E-22   1.45782630390454E-09   1.74485556306832E-09  -3.24747387577604E-18
      5.22345122310264E-09
      0.00000000000000E+00  -6.21595996946820E-12   0.00000000000000E+00   5.43511664490209E-12  -4.40900857091527E-23
      6.21053484781622E-09   6.21596996446108E-09  -1.08339312260946E-18  -1.17027455387238E-01  -1.17027455379202E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.03549666017305E-09   0.00000000000000E+00  -8.03549666017305E-09
      4.32027694668456E-18  -5.75729574652959E-01  -5.76302972924502E-01   0.00000000000000E+00   3.01355431204102E-10
     -1.71783900994464E-22   1.51817126450826E-09   1.81952669571219E-09  -3.23688382407511E-18
      5.23034647545813E-09
      0.00000000000000E+00  -6.81194046920784E-12   0.00000000000000E+00   4.81430575681703E-12  -4.32324970289885E-23
      6.80717036897409E-09   6.81198467473086E-09  -1.04019910739837E-18  -1.39043330241783E-01  -1.39043330233287E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.49588256131721E-09   0.00000000000000E+00  -8.49588256131721E-09
      4.26169569244165E-18  -5.83104745276037E-01  -5.83635438605981E-01   0.00000000000000E+00   3.04340217636050E-10
     -1.68805791177551E-22   1.37955766895073E-09   1.68389788658661E-09  -3.22149658504327E-18
      5.23965506613804E-09
      0.00000000000000E+00  -7.82820248640913E-12   0.00000000000000E+00   5.85942210238889E-12  -4.12911372384236E-23
      7.82232958330751E-09   7.82818900540986E-09  -9.80242708430659E-19  -1.68537208013725E-01  -1.68537208004908E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.81694869796135E-09   0.00000000000000E+00  -8.81694869796135E-09
      4.17962232596650E-18  -5.92254524921853E-01  -5.92566273615761E-01   0.00000000000000E+00   2.95621312634301E-10
     -1.64818652179403E-22   6.93138379917347E-10   9.88759692551483E-10  -3.19937961753585E-18
      5.25222166355593E-09
      0.00000000000000E+00  -1.05944741263626E-11   0.00000000000000E+00   1.12259642600037E-11  -3.31494386672701E-23
      1.05832582502267E-08   1.05944842144867E-08  -8.99735387235350E-19  -2.06413406506160E-01  -2.06413406497093E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.06775456304014E-09   0.00000000000000E+00  -9.06775456304014E-09
      4.06567150488858E-18  -6.01443626582024E-01  -6.00963046892575E-01   0.00000000000000E+00   2.83091484224082E-10
     -1.59505514001757E-22  -1.80982113567060E-09  -1.52672965144668E-09  -3.16593611765323E-18
      5.26918657007008E-09
      0.00000000000000E+00  -1.95439171646012E-11   0.00000000000000E+00   2.62671742345612E-11   6.23505444303149E-24
      1.95176017868006E-08   1.95438689610352E-08  -8.00148029188397E-19  -2.51067774320525E-01  -2.51067774311082E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.44338441832438E-09   0.00000000000000E+00  -9.44338441832438E-09
      3.90546537105456E-18  -6.00572237865305E-01  -5.97390976583198E-01   0.00000000000000E+00   2.88604193710142E-10
     -1.51757175279801E-22  -1.03890887364208E-08  -1.01004845427108E-08  -3.10531734186616E-18
      5.28918657007008E-09
      0.00000000000000E+00  -3.81496403386276E-11   0.00000000000000E+00   4.61130056818848E-11   9.52412602527520E-23
      3.81035200276866E-08   3.81496330333686E-08  -7.08540715381674E-19  -2.91102769604050E-01  -2.91102769593966E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00838369230046E-08   0.00000000000000E+00  -1.00838369230046E-08
      3.70378863259447E-18  -5.67197625043310E-01  -5.58356919329315E-01   0.00000000000000E+00   3.15574326889795E-10
     -1.40329223733344E-22  -2.83813704372537E-08  -2.80657961103641E-08  -2.99524791721279E-18
      5.30918657007008E-09
      0.00000000000000E+00  -5.71019855508752E-11   0.00000000000000E+00   4.70771824439992E-11   1.85027089818999E-22
      5.70548583627269E-08   5.71019355451711E-08  -6.47263978167653E-19  -3.18524920959600E-01  -3.18524920948852E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07479072647000E-08   0.00000000000000E+00  -1.07479072647000E-08
      3.48883048730046E-18  -4.96968807170206E-01  -4.82366209062354E-01   0.00000000000000E+00   3.09397389407372E-10
     -1.25618677617365E-22  -4.66634256698782E-08  -4.63540282804710E-08  -2.84156650913281E-18
      5.32918657007008E-09
      0.00000000000000E+00  -6.59949440757311E-11   0.00000000000000E+00   2.22064878482139E-11   2.26283474761951E-22
      6.59727706209497E-08   6.59949771087981E-08  -6.13022352569389E-19  -3.35365737378412E-01  -3.35365737367090E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13217322375776E-08   0.00000000000000E+00  -1.13217322375776E-08
      3.26239584254892E-18  -3.93990121178725E-01  -3.76765824283529E-01   0.00000000000000E+00   2.67427039354588E-10
     -1.09183165978197E-22  -5.49406719105749E-08  -5.46732448712204E-08  -2.64937348997953E-18
      5.34918657007008E-09
      0.00000000000000E+00  -6.06762153440433E-11   0.00000000000000E+00  -1.31209553317967E-11   2.03513959620874E-22
      6.06893518311376E-08   6.06762308758060E-08  -6.01072962392730E-19  -3.43613829407351E-01  -3.43613829395530E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18205915910174E-08   0.00000000000000E+00  -1.18205915910174E-08
      3.02598401072857E-18  -2.69265580171978E-01  -2.53873505357014E-01   0.00000000000000E+00   2.08582786124173E-10
     -9.26293587057489E-23  -4.90642220709127E-08  -4.88556392847886E-08  -2.42491104833583E-18
      5.36918657007008E-09
      0.00000000000000E+00  -5.22658090684756E-11   0.00000000000000E+00  -2.08566082928294E-11   1.61175333953823E-22
      5.22866954915548E-08   5.22658388832621E-08  -5.93913996990788E-19  -3.50092343296953E-01  -3.50092343285048E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19054096449276E-08   0.00000000000000E+00  -1.19054096449276E-08
      2.78787581783001E-18  -1.56861691746887E-01  -1.44145755471301E-01   0.00000000000000E+00   1.21675053623055E-10
     -7.89005646431046E-23  -4.04821042919573E-08  -4.03604292383344E-08  -2.19396182083923E-18
      5.38918657007008E-09
      0.00000000000000E+00  -4.56357211789387E-11   0.00000000000000E+00  -1.64366114651037E-11   1.27930397916544E-22
      4.56521834963446E-08   4.56357468848796E-08  -5.79441231343167E-19  -3.59269797471708E-01  -3.59269797460046E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16618067532771E-08   0.00000000000000E+00  -1.16618067532771E-08
      2.55463968276447E-18  -7.27106093589398E-02  -6.20066569405685E-02   0.00000000000000E+00   6.40322254175989E-11
     -5.07425921116700E-23  -3.40379723570201E-08  -3.39739401316025E-08  -1.97519845142130E-18
      5.39168657007008E-09
      0.00000000000000E+00  -4.36681313737418E-11   0.00000000000000E+00  -3.85512543083923E-11   1.23216061449091E-22
      4.37066815765157E-08   4.36681303222075E-08  -5.77471395324640E-19  -3.60414248222577E-01  -3.60414248210924E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16527788598222E-08   0.00000000000000E+00  -1.16527788598222E-08
      2.52550773561492E-18  -6.32604022717093E-02  -5.31735187754880E-02   0.00000000000000E+00   7.14083895491639E-11
     -3.97600656229426E-23  -3.20867598519347E-08  -3.20153514623855E-08  -1.94803634029028E-18
      5.39506157007008E-09
      0.00000000000000E+00  -4.14215172569085E-11   0.00000000000000E+00  -3.30361123439884E-11   1.18550747413280E-22
      4.14545181427435E-08   4.14214820303996E-08  -5.73200910335551E-19  -3.62533409368679E-01  -3.62533409357219E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14600597920810E-08   0.00000000000000E+00  -1.14600597920810E-08
      2.48683003381664E-18  -5.28211939083456E-02  -4.33814138443789E-02   0.00000000000000E+00   5.71615411745940E-11
     -2.03552185229231E-23  -3.00185837794932E-08  -2.99614222383186E-08  -1.91362912348109E-18
      5.39961782007008E-09
      0.00000000000000E+00  -3.88139533228496E-11   0.00000000000000E+00  -2.83544747688956E-11   1.16279530078471E-22
      3.88423236232214E-08   3.88139691484526E-08  -5.64578729947735E-19  -3.66378761115302E-01  -3.66378761104145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11574587058077E-08   0.00000000000000E+00  -1.11574587058077E-08
      2.43599386258831E-18  -4.23618813346449E-02  -3.36482824689962E-02   0.00000000000000E+00   4.60641854408655E-11
      9.73045868282468E-24  -2.77025746280856E-08  -2.76565104426448E-08  -1.87141513264057E-18
      5.40269328882008E-09
      0.00000000000000E+00  -3.71468794977958E-11   0.00000000000000E+00  -2.68140144069378E-11   1.16423361579208E-22
      3.71736716236565E-08   3.71468576092497E-08  -5.57535312442477E-19  -3.69384029777532E-01  -3.69384029766574E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09579337776995E-08   0.00000000000000E+00  -1.09579337776995E-08
      2.40229307969042E-18  -3.68471694033069E-02  -2.85959479275353E-02   0.00000000000000E+00   4.08621857542421E-11
      3.05091274807501E-23  -2.62297860173045E-08  -2.61889238315502E-08  -1.84475776724795E-18
      5.40684517163258E-09
      0.00000000000000E+00  -3.54528033200030E-11   0.00000000000000E+00  -2.02186751246429E-11   1.19061595341115E-22
      3.54730092560589E-08   3.54527905809343E-08  -5.46449639365898E-19  -3.73988561806312E-01  -3.73988561795578E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07341299464912E-08   0.00000000000000E+00  -1.07341299464912E-08
      2.35772623005844E-18  -3.14909168719813E-02  -2.37029150487192E-02   0.00000000000000E+00   3.17051635688117E-11
      5.63242657824824E-23  -2.47503657980116E-08  -2.47186606344428E-08  -1.81127659069254E-18
      5.41245021342945E-09
      0.00000000000000E+00  -3.39320381613208E-11   0.00000000000000E+00  -1.34254498747684E-11   1.24991051825597E-22
      3.39454666406613E-08   3.39320411907866E-08  -5.29898916532197E-19  -3.80752801032549E-01  -3.80752801022022E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05267378850582E-08   0.00000000000000E+00  -1.05267378850582E-08
      2.29872342422794E-18  -2.66754937575139E-02  -1.93012763789298E-02   0.00000000000000E+00   2.30752734765659E-11
      8.69010241947126E-23  -2.34283785792052E-08  -2.34053033057286E-08  -1.76882450769575E-18
      5.42001701985523E-09
      0.00000000000000E+00  -3.26970019800911E-11   0.00000000000000E+00  -8.04924337997759E-12   1.33738963454615E-22
      3.27050117431139E-08   3.26969624997341E-08  -5.06489303161506E-19  -3.90245488052638E-01  -3.90245488042280E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03586700492445E-08   0.00000000000000E+00  -1.03586700492445E-08
      2.22034137313677E-18  -2.25800626469750E-02  -1.55420152087327E-02   0.00000000000000E+00   1.62646998094671E-11
      1.21013005189763E-22  -2.23545571502992E-08  -2.23382924504896E-08  -1.71385206997527E-18
      5.43023220853004E-09
      0.00000000000000E+00  -3.16999355129662E-11   0.00000000000000E+00  -4.78578241498365E-12   1.42337182834204E-22
      3.17047260540462E-08   3.16999402716314E-08  -4.74914709763942E-19  -4.03039361255754E-01  -4.03039361245528E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02255209929743E-08   0.00000000000000E+00  -1.02255209929743E-08
      2.11588574689536E-18  -1.91729927757484E-02  -1.24071143949503E-02   0.00000000000000E+00   1.17191563990716E-11
      1.54418874680794E-22  -2.14861384350562E-08  -2.14744192786570E-08  -1.64097103713142E-18
      5.44402271324103E-09
      0.00000000000000E+00  -3.07516386012985E-11   0.00000000000000E+00  -3.35403834337794E-12   1.43993342834691E-22
      3.07550274367827E-08   3.07516733984395E-08  -4.33943429771068E-19  -4.19745107332455E-01  -4.19745107322355E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01003062571911E-08   0.00000000000000E+00  -1.01003062571911E-08
      1.97659742587317E-18  -1.63211628969250E-02  -9.81459308572093E-03   0.00000000000000E+00   9.05308204556345E-12
      1.76602969348379E-22  -2.06604202232940E-08  -2.06513671412482E-08  -1.54265399610210E-18
      5.46263989460086E-09
      0.00000000000000E+00  -2.95942112230093E-11   0.00000000000000E+00  -3.03077298988890E-12   1.28774411203483E-22
      2.95971896407304E-08   2.95941588677407E-08  -3.82337479186214E-19  -4.41063170627257E-01  -4.41063170617308E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94939731703600E-09   0.00000000000000E+00  -9.94939731703600E-09
      1.79136769160088E-18  -1.38719906280458E-02  -7.68256188768775E-03   0.00000000000000E+00   7.57985652587000E-12
      1.70472646739120E-22  -1.96523414072307E-08  -1.96447615507046E-08  -1.40903021241467E-18
      5.48263989460086E-09
      0.00000000000000E+00  -2.84002296393114E-11   0.00000000000000E+00  -2.91385896190014E-12   9.90396942202077E-23
      2.84031040001044E-08   2.84001901411426E-08  -3.30983299865438E-19  -4.62626842157504E-01  -4.62626842147702E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80127699082536E-09   0.00000000000000E+00  -9.80127699082536E-09
      1.59534215178438E-18  -1.21052767177728E-02  -6.24535510395512E-03   0.00000000000000E+00   6.59351683166014E-12
      1.34689599956739E-22  -1.86055066671490E-08  -1.85989131503172E-08  -1.26435885191894E-18
      5.50263989460086E-09
      0.00000000000000E+00  -2.74183175538258E-11   0.00000000000000E+00  -2.39525761061241E-12   6.67357099987338E-23
      2.74207026306892E-08   2.74183073730786E-08  -2.83050823361464E-19  -4.83101661421213E-01  -4.83101661411540E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67231197961369E-09   0.00000000000000E+00  -9.67231197961369E-09
      1.40189591219210E-18  -1.09016481711076E-02  -5.31044892562542E-03   0.00000000000000E+00   5.49144086634436E-12
      8.93791449510200E-23  -1.77514868343314E-08  -1.77459953934650E-08  -1.11884508883064E-18
      5.52263989460086E-09
      0.00000000000000E+00  -2.65809690847047E-11   0.00000000000000E+00  -2.04128845403709E-12   4.01517063456104E-23
      2.65830389471700E-08   2.65809976587160E-08  -2.38264969791063E-19  -5.02573584189121E-01  -5.02573584179607E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51447805465961E-09   0.00000000000000E+00  -9.51447805465961E-09
      1.21160635109891E-18  -1.00416572031499E-02  -4.66453538663133E-03   0.00000000000000E+00   4.59522735872765E-12
      5.02907027840745E-23  -1.70711148314153E-08  -1.70665196040565E-08  -9.73341381307850E-19
      5.54263989460086E-09
      0.00000000000000E+00  -2.65245764160593E-11   0.00000000000000E+00  -1.17316423078159E-13   2.25352679020142E-23
      2.65246712565143E-08   2.65245539400912E-08  -1.93970572146990E-19  -5.22251876763352E-01  -5.22251876753466E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.88622196816252E-09   0.00000000000000E+00  -9.88622196816252E-09
      1.01388191173566E-18  -9.50554826735110E-03  -4.26333158007424E-03   0.00000000000000E+00   3.74492454467151E-12
      2.39335017519599E-23  -1.66420768964733E-08  -1.66383319719286E-08  -8.19911339588672E-19
      5.56263989460086E-09
      0.00000000000000E+00  -2.74469731118345E-11   0.00000000000000E+00   2.30012195223731E-12   1.27353277811856E-23
      2.74446933596766E-08   2.74469934816289E-08  -1.48000664905555E-19  -5.43212092640977E-01  -5.43212092630151E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08265020780493E-08   0.00000000000000E+00  -1.08265020780493E-08
      7.97351870174676E-19  -9.30280204139505E-03  -4.06620348235806E-03   0.00000000000000E+00   2.66311993238458E-12
      9.23877537190013E-24  -1.66231545235120E-08  -1.66204914035796E-08  -6.49351205269120E-19
      5.57263989460086E-09
      0.00000000000000E+00  -2.80601285774320E-11   0.00000000000000E+00   3.05279341374893E-12   9.40472227292635E-24
      2.80570813474244E-08   2.80601341408381E-08  -1.24909117803075E-19  -5.53960973370720E-01  -5.53960973359356E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13638652364509E-08   0.00000000000000E+00  -1.13638652364509E-08
      6.83713217810167E-19  -9.26807421168890E-03  -4.00759927402351E-03   0.00000000000000E+00   2.15197260045175E-12
      4.27418128346759E-24  -1.66984208769876E-08  -1.66962689043871E-08  -5.58804100007091E-19
      5.57938989460086E-09
      0.00000000000000E+00  -2.86119317585748E-11   0.00000000000000E+00   4.05933034072247E-12   7.83928939302685E-24
      2.86078951767671E-08   2.86119545071078E-08  -1.09222384885898E-19  -5.61353310758756E-01  -5.61353310747047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17087765087706E-08   0.00000000000000E+00  -1.17087765087706E-08
      6.04678976375966E-19  -9.32297732518290E-03  -3.99731055423126E-03   0.00000000000000E+00   9.78660873153015E-13
      1.94649691314866E-24  -1.69041566592104E-08  -1.69031779983373E-08  -4.95456591490067E-19
      5.58394614460086E-09
      0.00000000000000E+00  -2.90285394865481E-11   0.00000000000000E+00   4.54000645070781E-12   7.04317290396266E-24
      2.90239906188973E-08   2.90285306253480E-08  -9.86160809881342E-20  -5.66392620925801E-01  -5.66392620913885E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19164895107601E-08   0.00000000000000E+00  -1.19164895107601E-08
      5.50384471042565E-19  -9.39252790602235E-03  -4.00105401569955E-03   0.00000000000000E+00   1.98872427426277E-13
      7.60227002485011E-25  -1.71122399870154E-08  -1.71120411145880E-08  -4.51768390054431E-19
      5.58702161335086E-09
      0.00000000000000E+00  -2.92906643665384E-11   0.00000000000000E+00   4.24342152325979E-12   6.60217138183040E-24
      2.92864053252503E-08   2.92906487467736E-08  -9.14715147486847E-20  -5.69803990681861E-01  -5.69803990669837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20242644924753E-08   0.00000000000000E+00  -1.20242644924753E-08
      5.13404221354222E-19  -9.44348247371358E-03  -4.00337937976049E-03   0.00000000000000E+00  -4.48394683271042E-14
      1.11163299636044E-25  -1.72663394148297E-08  -1.72663842542981E-08  -4.21932706605538E-19
      5.59117349616336E-09
      0.00000000000000E+00  -2.95168779542805E-11   0.00000000000000E+00   2.73668710490931E-12   6.13816745448388E-24
      2.95141481828043E-08   2.95168848699092E-08  -8.18946139248339E-20  -5.74392479514570E-01  -5.74392479502498E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20722584898038E-08   0.00000000000000E+00  -1.20722584898038E-08
      4.63281618822349E-19  -9.48967264473187E-03  -3.99341060093472E-03   0.00000000000000E+00   2.73275764104082E-13
     -5.26191505659221E-25  -1.74448996558699E-08  -1.74446263801058E-08  -3.81387004897515E-19
      5.59677853796023E-09
      0.00000000000000E+00  -2.95661067334238E-11   0.00000000000000E+00   4.78133475469655E-13   5.65969628273100E-24
      2.95656412628378E-08   2.95661193963132E-08  -6.92625506419174E-20  -5.80470835749520E-01  -5.80470835737550E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19699630566705E-08   0.00000000000000E+00  -1.19699630566705E-08
      3.96189475582662E-19  -9.49663404727328E-03  -3.95262920081148E-03   0.00000000000000E+00   9.82726435592395E-13
     -1.09431707912438E-24  -1.75971390660784E-08  -1.75961563396428E-08  -3.26926924940745E-19
      5.60434534438601E-09
      0.00000000000000E+00  -2.92078204135772E-11   0.00000000000000E+00  -2.30070709399567E-12   5.15670597094252E-24
      2.92101057103989E-08   2.92078050033049E-08  -5.31485017033571E-20  -5.88267121811575E-01  -5.88267121800052E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15228488875937E-08   0.00000000000000E+00  -1.15228488875937E-08
      3.08998308576711E-19  -9.42975690258875E-03  -3.85777334676972E-03   0.00000000000000E+00   1.59040754772539E-12
     -1.55340526708162E-24  -1.76865465232587E-08  -1.76849561157110E-08  -2.55849806873354E-19
      5.61456053306082E-09
      0.00000000000000E+00  -2.78414462581408E-11   0.00000000000000E+00  -6.57252097372458E-12   4.56258104857021E-24
      2.78480296918365E-08   2.78414571708627E-08  -3.44478052367769E-20  -5.97353658207934E-01  -5.97353658197801E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01333172342437E-08   0.00000000000000E+00  -1.01333172342437E-08
      2.05484561127262E-19  -9.24070072740035E-03  -3.66141169160304E-03   0.00000000000000E+00   1.73592606173555E-12
     -1.89821555648778E-24  -1.77098758626806E-08  -1.77081399366189E-08  -1.71036755890484E-19
      5.62835103777181E-09
      0.00000000000000E+00  -2.33798126140736E-11   0.00000000000000E+00  -1.59426662795288E-11   3.61821028284412E-24
      2.33957966054367E-08   2.33798539391572E-08  -2.07204119756766E-20  -6.03890705623222E-01  -6.03890705617538E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68376531194496E-09   0.00000000000000E+00  -5.68376531194496E-09
      1.27102568816744E-19  -8.78396213784080E-03  -3.20846866884250E-03   0.00000000000000E+00   1.05733509767285E-12
     -2.17977539974702E-24  -1.76971459623098E-08  -1.76960886272122E-08  -1.06382156841066E-19
      5.64696821913164E-09
      0.00000000000000E+00  -1.04872913180414E-11   0.00000000000000E+00  -3.41437709093588E-11   1.57676575926724E-24
      1.05214211520316E-08   1.04872773811222E-08  -4.54926980896748E-20  -5.90954125390272E-01  -5.90954125397475E-01
      0.00000000000000E+00   0.00000000000000E+00   7.20312951114260E-09   0.00000000000000E+00   7.20312951114260E-09
      2.61204537284041E-19  -7.67457891199353E-03  -2.10087399757352E-03   0.00000000000000E+00  -1.23554077238903E-12
     -2.66185628370803E-24  -1.76891713514924E-08  -1.76904068922648E-08  -2.15711839194365E-19
      5.66696821913164E-09
      0.00000000000000E+00   8.54468328136504E-12   0.00000000000000E+00  -4.69209392682004E-11  -2.25175575658224E-24
     -8.49780764887167E-09  -8.54472858813987E-09  -1.48458781931363E-19  -5.41044910916219E-01  -5.41044910942444E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62246904078416E-08   0.00000000000000E+00   2.62246904078416E-08
      7.85698345440873E-19  -6.01765153161822E-03  -4.47237594599914E-04   0.00000000000000E+00  -5.22449901593504E-12
     -4.80009961684164E-24  -1.76747373206858E-08  -1.76799618197018E-08  -6.37239563509509E-19
      5.68696821913164E-09
      0.00000000000000E+00   2.27264291535792E-11   0.00000000000000E+00  -3.51445346223281E-11  -1.23788718777919E-23
     -2.26912443162530E-08  -2.27263888508753E-08  -3.43573800869901E-19  -4.55714510322433E-01  -4.55714510362785E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03520603604795E-08   0.00000000000000E+00   4.03520603604795E-08
      1.59273955265046E-18  -4.32577250066776E-03   1.22753153883051E-03   0.00000000000000E+00  -1.16619563598472E-11
     -1.90478790218378E-23  -1.76140095532443E-08  -1.76256715096042E-08  -1.24916575178056E-18
      5.70696821913164E-09
      0.00000000000000E+00   2.33272774243909E-11   0.00000000000000E+00  -1.86302059140954E-12  -3.61686007564126E-23
     -2.33253865685112E-08  -2.33272495891026E-08  -6.32401280379355E-19  -3.40342664427151E-01  -3.40342664468142E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09902480768244E-08   0.00000000000000E+00   4.09902480768244E-08
      2.41254451418695E-18  -2.02809792847329E-03   3.53695529621404E-03   0.00000000000000E+00  -2.69263551117235E-11
     -6.45848974135802E-23  -1.76360721326101E-08  -1.76629984877218E-08  -1.78014323380760E-18
      5.72696821913164E-09
      0.00000000000000E+00   1.47681745192843E-11   0.00000000000000E+00   2.04754367391881E-11  -4.30225051641289E-23
     -1.47886964740611E-08  -1.47682210373220E-08  -9.12476950708255E-19  -2.17095175027421E-01  -2.17095175058368E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09477215440677E-08   0.00000000000000E+00   3.09477215440677E-08
      3.03149894506831E-18  -9.87942382800338E-03  -4.78179020953895E-03   0.00000000000000E+00  -5.74933314447970E-11
     -8.16544414494679E-23  -1.61220071753008E-08  -1.61795005067456E-08  -2.11902199436005E-18
      5.74696821913164E-09
      0.00000000000000E+00   9.87340109454633E-12   0.00000000000000E+00   1.12794307872123E-11  -4.59102012319495E-23
     -9.88469863962203E-09  -9.87341920883487E-09  -1.10859283981834E-18  -1.15438294759422E-01  -1.15438294782117E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26955069911984E-08   0.00000000000000E+00   2.26955069911984E-08
      3.48540908489227E-18  -3.97674736741339E-02  -3.57276558622979E-02   0.00000000000000E+00  -1.07310749486436E-10
     -9.47369825067892E-23  -1.27147770328771E-08  -1.28220877823636E-08  -2.37681624507394E-18
      5.76696821913164E-09
      0.00000000000000E+00   5.69253681212251E-12   0.00000000000000E+00   9.57714910895478E-12  -4.75737479844769E-23
     -5.70208524911836E-09  -5.69250810000945E-09  -1.22099955613585E-18  -5.01255379688346E-02  -5.01255379840981E-02
      0.00000000000000E+00   0.00000000000000E+00   1.52635525725970E-08   0.00000000000000E+00   1.52635525725970E-08
      3.79068013634421E-18  -8.77912984355651E-02  -8.47757705579143E-02   0.00000000000000E+00  -1.60535813638518E-10
     -1.07213721041226E-22  -9.41050865894889E-09  -9.57104447258752E-09  -2.56968058020836E-18
      5.78696821913164E-09
      0.00000000000000E+00   1.98963254212665E-12   0.00000000000000E+00   8.82492881124445E-12  -4.80031699309965E-23
     -1.99846520026000E-09  -1.98964027144880E-09  -1.25935113171628E-18  -2.57789588245520E-02  -2.57789588331956E-02
      0.00000000000000E+00   0.00000000000000E+00   8.64356470298342E-09   0.00000000000000E+00   8.64356470298342E-09
      3.96355143040388E-18  -1.48042366809952E-01  -1.45945920019396E-01   0.00000000000000E+00  -1.77841553797960E-10
     -1.17876193213205E-22  -6.47608287773652E-09  -6.65392443153460E-09  -2.70420029868760E-18
      5.80696821913164E-09
      0.00000000000000E+00   6.04522060299941E-13   0.00000000000000E+00   3.34696709655303E-12  -4.80821263758598E-23
     -6.07863684168626E-10  -6.04516717072121E-10  -1.27005625172742E-18  -1.79238902781990E-02  -1.79238902838670E-02
      0.00000000000000E+00   0.00000000000000E+00   5.66797260642918E-09   0.00000000000000E+00   5.66797260642918E-09
      4.07691088253247E-18  -2.07787362104022E-01  -2.06192013118656E-01   0.00000000000000E+00  -1.92203658556791E-10
     -1.27407244034250E-22  -4.87125223080019E-09  -5.06345588935710E-09  -2.80685463080504E-18
      5.82696821913164E-09
      0.00000000000000E+00   2.56246816809000E-13   0.00000000000000E+00   8.45138526206171E-13  -4.81019821743909E-23
     -2.57064083607029E-10  -2.56218945080871E-10  -1.27384673469569E-18  -1.45310483687624E-02  -1.45310483729427E-02
      0.00000000000000E+00   0.00000000000000E+00   4.18026712057120E-09   0.00000000000000E+00   4.18026712057120E-09
      4.16051622494389E-18  -2.58658184498654E-01  -2.57421821215634E-01   0.00000000000000E+00  -1.92821482557526E-10
     -1.35665459887025E-22  -3.73122669293268E-09  -3.92404817549034E-09  -2.88666949024820E-18
      5.84696821913164E-09
      0.00000000000000E+00   1.72392571738528E-13   0.00000000000000E+00   2.02981931135487E-13  -4.81108011632971E-23
     -1.72619242017440E-10  -1.72416260086352E-10  -1.27599857738283E-18  -1.25148944591923E-02  -1.25148944622041E-02
      0.00000000000000E+00   0.00000000000000E+00   3.01174795068368E-09   0.00000000000000E+00   3.01174795068368E-09
      4.22075118395756E-18  -2.96490489455172E-01  -2.95595886684941E-01   0.00000000000000E+00  -1.65191612681384E-10
     -1.42039746525317E-22  -2.67414007791577E-09  -2.83933169059730E-09  -2.94475260657474E-18
      5.86696821913164E-09
      0.00000000000000E+00   1.43277790043742E-13   0.00000000000000E+00   7.16236885816889E-14  -4.81142283036187E-23
     -1.43311465305282E-10  -1.43239841616749E-10  -1.27759272927654E-18  -1.11771663746770E-02  -1.11771663767511E-02
      0.00000000000000E+00   0.00000000000000E+00   2.07417419522848E-09   0.00000000000000E+00   2.07417419522848E-09
      4.26223466786213E-18  -3.22018773656822E-01  -3.21410384206593E-01   0.00000000000000E+00  -1.22216672004985E-10
     -1.46447821898617E-22  -1.80871768160663E-09  -1.93093435361176E-09  -2.98464193858559E-18
      5.88696821913164E-09
      0.00000000000000E+00   1.31613508418386E-13   0.00000000000000E+00   2.96625639252759E-14  -4.81155201377305E-23
     -1.31625974698010E-10  -1.31596312134133E-10  -1.27897101222829E-18  -1.02425007587861E-02  -1.02425007601284E-02
      0.00000000000000E+00   0.00000000000000E+00   1.34234231972938E-09   0.00000000000000E+00   1.34234231972938E-09
      4.28908151425672E-18  -3.37188342783170E-01  -3.36806870488391E-01   0.00000000000000E+00  -7.56716329638448E-11
     -1.49073984835776E-22  -1.13507437463116E-09  -1.21074600759515E-09  -3.01011050202844E-18
      5.90696821913164E-09
      0.00000000000000E+00   1.23163792595293E-13   0.00000000000000E+00   2.27367779475948E-14  -4.81145829981684E-23
     -1.23145387705287E-10  -1.23122650927388E-10  -1.28019068115291E-18  -9.60071746947609E-03  -9.60071747028343E-03
      0.00000000000000E+00   0.00000000000000E+00   8.07337399797180E-10   0.00000000000000E+00   8.07337399797180E-10
      4.30522826225266E-18  -3.44607619294486E-01  -3.44392048429624E-01   0.00000000000000E+00  -3.58997567321373E-11
     -1.50302430598480E-22  -6.48314992137477E-10  -6.84214748869765E-10  -3.02503758109976E-18
      5.92696821913164E-09
      0.00000000000000E+00   9.18447372075268E-14   0.00000000000000E+00   8.38201487157120E-14  -4.81015988359388E-23
     -9.19222511392531E-11  -9.18384309905855E-11  -1.28079581592865E-18  -9.34261688234907E-03  -9.34261688304854E-03
      0.00000000000000E+00   0.00000000000000E+00   6.99471346406723E-10   0.00000000000000E+00   6.99471346406723E-10
      4.31921768918080E-18  -3.51386597857713E-01  -3.51195156308733E-01   0.00000000000000E+00  -3.16031277119773E-11
     -1.51356370023626E-22  -5.76029787704088E-10  -6.07632915416216E-10  -3.03842187325214E-18
      5.94696821913164E-09
      0.00000000000000E+00   6.82406397451924E-14   0.00000000000000E+00   6.86014538556400E-14  -4.80813680663655E-23
     -6.83266550728369E-11  -6.82580536190293E-11  -1.28094387081474E-18  -9.25698081002175E-03  -9.25698081090938E-03
      0.00000000000000E+00   0.00000000000000E+00   8.87633265278589E-10   0.00000000000000E+00   8.87633265278589E-10
      4.33697035448637E-18  -3.61786307404416E-01  -3.61528148390052E-01   0.00000000000000E+00  -5.18419954744533E-11
     -1.53037177317602E-22  -7.67533216184914E-10  -8.19375211659521E-10  -3.05602648367163E-18
      5.96696821913164E-09
      0.00000000000000E+00   3.19619685482193E-14   0.00000000000000E+00   1.05457130078295E-13  -4.80482771159435E-23
     -3.20782490083294E-11  -3.19727918782992E-11  -1.28038903903176E-18  -9.34069829810516E-03  -9.34069829953856E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43339974345513E-09   0.00000000000000E+00   1.43339974345513E-09
      4.36563834935547E-18  -3.81754408692769E-01  -3.81312852282880E-01   0.00000000000000E+00  -1.08890392142273E-10
     -1.56463484956886E-22  -1.29253655943436E-09  -1.40142695157679E-09  -3.08524931032371E-18
      5.96946821913164E-09
      0.00000000000000E+00   2.34204079879193E-14   0.00000000000000E+00   1.83926426523126E-13  -4.80435082949646E-23
     -2.36353245837534E-11  -2.34513981572783E-11  -1.28029876227934E-18  -9.35887514498840E-03  -9.35887514650467E-03
      0.00000000000000E+00   0.00000000000000E+00   1.51627031993347E-09   0.00000000000000E+00   1.51627031993347E-09
      4.36942902515531E-18  -3.84459079829015E-01  -3.83988724589050E-01   0.00000000000000E+00  -1.22019266571987E-10
     -1.56934814956117E-22  -1.37079965520455E-09  -1.49281892177669E-09  -3.08913026287596E-18
      5.97284321913164E-09
      0.00000000000000E+00   2.15835132437688E-14   0.00000000000000E+00   4.72143090742565E-14  -4.80376432836594E-23
     -2.16145508402944E-11  -2.15673365312682E-11  -1.28017126496957E-18  -9.37741529793595E-03  -9.37741529957388E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63792721634920E-09   0.00000000000000E+00   1.63792721634920E-09
      4.37495702951049E-18  -3.88442974630847E-01  -3.87933692666939E-01   0.00000000000000E+00  -1.35430934454305E-10
     -1.57637654595076E-22  -1.48092894536387E-09  -1.61635987981833E-09  -3.09478576454091E-18
      5.97739946913164E-09
      0.00000000000000E+00   3.56357580365204E-14   0.00000000000000E+00  -1.35359330751726E-13  -4.80319393886289E-23
     -3.55081498199413E-11  -3.56435091507410E-11  -1.28006462888569E-18  -9.35426033133850E-03  -9.35426033307595E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73744768250779E-09   0.00000000000000E+00   1.73744768250779E-09
      4.38287327551391E-18  -3.94069968888665E-01  -3.93533764400417E-01   0.00000000000000E+00  -1.45069904013313E-10
     -1.58649012891867E-22  -1.55673426934380E-09  -1.70180417335727E-09  -3.10280864662822E-18
      5.98355040663164E-09
      0.00000000000000E+00   5.29025686315354E-14   0.00000000000000E+00  -1.27385233338127E-13  -4.80260760565643E-23
     -5.28522246483473E-11  -5.29796098817334E-11  -1.28002971182565E-18  -9.25362363439127E-03  -9.25362363617751E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78623726462158E-09   0.00000000000000E+00   1.78623726462158E-09
      4.39386030928877E-18  -4.01748397719103E-01  -4.01202282518759E-01   0.00000000000000E+00  -1.50720690250359E-10
     -1.60054944020188E-22  -1.58253696448933E-09  -1.73325765473985E-09  -3.11383059746312E-18
      5.99185417225664E-09
      0.00000000000000E+00   7.17307397590784E-14   0.00000000000000E+00  -1.03185196266769E-13  -4.80208195869765E-23
     -7.15983480753276E-11  -7.17015332716424E-11  -1.28014221753782E-18  -9.02389653720715E-03  -9.02389653900042E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79327003628285E-09   0.00000000000000E+00   1.79327003628285E-09
      4.40875120337240E-18  -4.11967461971284E-01  -4.11425029642147E-01   0.00000000000000E+00  -1.53670254443738E-10
     -1.61965056118104E-22  -1.56789824856713E-09  -1.72156850301103E-09  -3.12860898583457E-18
      6.00306425585039E-09
      0.00000000000000E+00   9.93760056585439E-14   0.00000000000000E+00  -1.18863652882780E-13  -4.80196134086740E-23
     -9.92833897830428E-11  -9.94022534359736E-11  -1.28061158918114E-18  -8.53171329931483E-03  -8.53171330109914E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78431335214103E-09   0.00000000000000E+00   1.78431335214103E-09
      4.42875350520734E-18  -4.25318057733021E-01  -4.24787175254587E-01   0.00000000000000E+00  -1.55734775395875E-10
     -1.64534560330455E-22  -1.52917632330915E-09  -1.68491109870519E-09  -3.14814191602621E-18
      6.01819786870196E-09
      0.00000000000000E+00   1.40246913715893E-13   0.00000000000000E+00  -1.38137303312245E-13  -4.80294438386390E-23
     -1.40195099441204E-10  -1.40333236744564E-10  -1.28187557400806E-18  -7.50600742795955E-03  -7.50600742973605E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77649684105609E-09   0.00000000000000E+00   1.77649684105609E-09
      4.45563832063191E-18  -4.42511988205962E-01  -4.41996464752785E-01   0.00000000000000E+00  -1.58374059396660E-10
     -1.67987024358243E-22  -1.47778954491465E-09  -1.63616360431148E-09  -3.17376274662385E-18
      6.03819786870196E-09
      0.00000000000000E+00   1.69545384885094E-13   0.00000000000000E+00  -8.23785979135101E-14  -4.80515780741963E-23
     -1.69453846647501E-10  -1.69536225245463E-10  -1.28414629312343E-18  -5.81942302022648E-03  -5.81942302196531E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73882659017169E-09   0.00000000000000E+00   1.73882659017169E-09
      4.49041485243534E-18  -4.64010705877750E-01  -4.63516252507194E-01   0.00000000000000E+00  -1.60968909511876E-10
     -1.72502011825113E-22  -1.40832145541409E-09  -1.56929036492614E-09  -3.20626855931191E-18
      6.05819786870196E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -1.73116405036037E-14  -4.80732507572387E-23
     -1.71999330673018E-10  -1.72016642313570E-10  -1.28648141316362E-18  -4.12288696569695E-03  -4.12288696736150E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66455620802650E-09   0.00000000000000E+00   1.66455620802650E-09
      4.52370597659587E-18  -4.84425129426727E-01  -4.83954857662218E-01   0.00000000000000E+00  -1.62783416729310E-10
     -1.76939464813270E-22  -1.32975614898344E-09  -1.49253956571292E-09  -3.23722456343225E-18
      6.07819786870196E-09
      0.00000000000000E+00   2.35122527251268E-13   0.00000000000000E+00  -1.77662990153121E-13  -4.81213143006443E-23
     -2.34935202522248E-10  -2.35112865512449E-10  -1.29008903443627E-18  -1.67905198110144E-03  -1.67905198279942E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69798684633151E-09   0.00000000000000E+00   1.69798684633151E-09
      4.55766571352250E-18  -5.03826087411183E-01  -5.03365160747887E-01   0.00000000000000E+00  -1.70336237707036E-10
     -1.81457216811630E-22  -1.29253774311190E-09  -1.46287398081912E-09  -3.26757667908623E-18
      6.09819786870196E-09
      0.00000000000000E+00  -7.33196537127686E-13   0.00000000000000E+00   2.52568807977284E-12  -4.77646135146340E-23
      7.30677793689698E-10   7.33203481769423E-10  -1.27439742942427E-18  -1.09003044401444E-02  -1.09003044402365E-02
      0.00000000000000E+00   0.00000000000000E+00   9.20720965508565E-11   0.00000000000000E+00   9.20720965508565E-11
      4.55950715545352E-18  -5.23579079450692E-01  -5.23319061231759E-01   0.00000000000000E+00  -8.26864605453911E-11
     -1.83604921737407E-22  -7.42589117774736E-10  -8.25275578320311E-10  -3.28510972602925E-18
      6.11819786870196E-09
      0.00000000000000E+00  -2.63429075258628E-12   0.00000000000000E+00   5.10326520514364E-12  -4.66967486271246E-23
      2.62919242868874E-09   2.63429569389383E-09  -1.22106727806678E-18  -4.19658860001124E-02  -4.19658859971614E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.95101955255806E-09   0.00000000000000E+00  -2.95101955255806E-09
      4.50048676440236E-18  -5.44582528086474E-01  -5.44682363281229E-01   0.00000000000000E+00   9.00807778399219E-11
     -1.81232157874243E-22   2.26643080824515E-10   3.16723858664256E-10  -3.27941948633557E-18
      6.12319786870196E-09
      0.00000000000000E+00  -3.43912618473584E-12   0.00000000000000E+00   8.39330762017761E-12  -4.63411695598753E-23
      3.43075295726651E-09   3.43914626488664E-09  -1.20376810895720E-18  -5.18251869019042E-02  -5.18251868977125E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.19169232745899E-09   0.00000000000000E+00  -4.19169232745899E-09
      4.47952830276507E-18  -5.49918416538482E-01  -5.50155582507066E-01   0.00000000000000E+00   1.53850471690620E-10
     -1.80213909016289E-22   5.98695590881959E-10   7.52546062572399E-10  -3.27576019380787E-18
      6.12994786870196E-09
      0.00000000000000E+00  -4.21852062467891E-12   0.00000000000000E+00   6.26112421606719E-12  -4.57972505511553E-23
      4.21225755692491E-09   4.21851868114093E-09  -1.17533994118677E-18  -6.77388805609826E-02  -6.77388805556096E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.37294268787077E-09   0.00000000000000E+00  -5.37294268787077E-09
      4.44326093962194E-18  -5.57268918657084E-01  -5.57632720042508E-01   0.00000000000000E+00   2.09496472902327E-10
     -1.78318632193153E-22   9.44927533827610E-10   1.15442400672976E-09  -3.26792099843517E-18
      6.13906036870196E-09
      0.00000000000000E+00  -5.21255621547597E-12   0.00000000000000E+00   5.97516864358945E-12  -4.49339624546198E-23
      5.20656227713100E-09   5.21253744577454E-09  -1.12866547382238E-18  -9.31499580454881E-02  -9.31499580387127E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.77537014079631E-09   0.00000000000000E+00  -6.77537014079631E-09
      4.38152037921393E-18  -5.67331726764636E-01  -5.67824227035109E-01   0.00000000000000E+00   2.66434095957786E-10
     -1.75007435254279E-22   1.29639859906429E-09   1.56283269502190E-09  -3.25285490539155E-18
      6.14213583745196E-09
      0.00000000000000E+00  -5.68335233840176E-12   0.00000000000000E+00   8.09684547683685E-12  -4.46137143061000E-23
      5.67521029751906E-09   5.68330714299586E-09  -1.11161736407173E-18  -1.02230248997227E-01  -1.02230248989833E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.39337068024254E-09   0.00000000000000E+00  -7.39337068024254E-09
      4.35878229872968E-18  -5.70731778535681E-01  -5.71270673331903E-01   0.00000000000000E+00   2.82628881697190E-10
     -1.73807333934374E-22   1.42743465554982E-09   1.71006353724684E-09  -3.24716493465795E-18
      6.14628772026446E-09
      0.00000000000000E+00  -6.14689272708814E-12   0.00000000000000E+00   6.11062174414999E-12  -4.41656426524018E-23
      6.14078871737620E-09   6.14689933912031E-09  -1.08707743768483E-18  -1.15090544668941E-01  -1.15090544660989E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.95219359140413E-09   0.00000000000000E+00  -7.95219359140413E-09
      4.32576572283586E-18  -5.75307130022007E-01  -5.75876041516021E-01   0.00000000000000E+00   2.98321953444860E-10
     -1.72080350880025E-22   1.50697229883906E-09   1.80529425228375E-09  -3.23868828515102E-18
      6.15189276206133E-09
      0.00000000000000E+00  -6.65874344754569E-12   0.00000000000000E+00   5.06893596591916E-12  -4.34994667475115E-23
      6.65367962207704E-09   6.65874855804292E-09  -1.05226148239839E-18  -1.32942329907473E-01  -1.32942329899062E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.41106993951586E-09   0.00000000000000E+00  -8.41106993951586E-09
      4.27862132426843E-18  -5.81361883408864E-01  -5.81914125501051E-01   0.00000000000000E+00   3.04581188042946E-10
     -1.69668355345231E-22   1.44774019343024E-09   1.75232138147301E-09  -3.22635984187004E-18
      6.15945956848711E-09
      0.00000000000000E+00  -7.39083784782689E-12   0.00000000000000E+00   5.27544237710156E-12  -4.22509642635618E-23
      7.38553424224100E-09   7.39080968461806E-09  -1.00373423114168E-18  -1.57106759386703E-01  -1.57106759377961E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.74192643678375E-09   0.00000000000000E+00  -8.74192643678375E-09
      4.21247285913287E-18  -5.89104739513760E-01  -5.89530620707244E-01   0.00000000000000E+00   2.99829716335571E-10
     -1.66407217439691E-22   1.05128703583027E-09   1.35111675216567E-09  -3.20873862799118E-18
      6.16967475716192E-09
      0.00000000000000E+00  -9.00647862004449E-12   0.00000000000000E+00   8.21671883061728E-12  -3.83163640246251E-23
      8.99828704087114E-09   9.00650375970172E-09  -9.37626892368701E-19  -1.88805532676599E-01  -1.88805532667621E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.97782001077608E-09   0.00000000000000E+00  -8.97782001077608E-09
      4.12076273383435E-18  -5.98047368866792E-01  -5.98038646545525E-01   0.00000000000000E+00   2.87695382530989E-10
     -1.62081996374114E-22  -3.16379131456612E-10  -2.86837489257849E-11  -3.18313584146565E-18
      6.18346526187290E-09
      0.00000000000000E+00  -1.38555133656531E-11   0.00000000000000E+00   1.76459074380337E-11  -2.03301139391126E-23
      1.38379064681027E-08   1.38555523755407E-08  -8.51612392468823E-19  -2.28232511113894E-01  -2.28232511104657E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.23762017877463E-09   0.00000000000000E+00  -9.23762017877463E-09
      3.99337128924066E-18  -6.04147586096676E-01  -6.02693315671460E-01   0.00000000000000E+00   2.80972724017624E-10
     -1.56152755589020E-22  -4.89890492078339E-09  -4.61793219676592E-09  -3.14175889677183E-18
      6.20208244323274E-09
      0.00000000000000E+00  -2.76901779759600E-11   0.00000000000000E+00   3.68660763832149E-11   4.54312209374144E-23
      2.76533208767380E-08   2.76901869531213E-08  -7.52545801905643E-19  -2.71872514831390E-01  -2.71872514821655E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73472255699498E-09   0.00000000000000E+00  -9.73472255699498E-09
      3.81213819390944E-18  -5.90104599699852E-01  -5.84448937131563E-01   0.00000000000000E+00   3.02358948961063E-10
     -1.46787386127444E-22  -1.82578233450871E-08  -1.79554643961262E-08  -3.05959239200379E-18
      6.22208244323274E-09
      0.00000000000000E+00  -4.79277065959525E-11   0.00000000000000E+00   5.01577303166558E-11   1.42113321382963E-22
      4.78775520491028E-08   4.79277097794196E-08  -6.75631034584682E-19  -3.05631433788951E-01  -3.05631433778536E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04144259762941E-08   0.00000000000000E+00  -1.04144259762941E-08
      3.60384967438356E-18  -5.38836297147961E-01  -5.27019173080983E-01   0.00000000000000E+00   3.19447981532578E-10
     -1.33829049157937E-22  -3.78327317846582E-08  -3.75132838031257E-08  -2.92821863979887E-18
      6.24208244323274E-09
      0.00000000000000E+00  -6.31786170539995E-11   0.00000000000000E+00   3.79581230554731E-11   2.13615260669570E-22
      6.31406581316840E-08   6.31786162547397E-08  -6.27699728879276E-19  -3.27794363625582E-01  -3.27794363614553E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10293871831066E-08   0.00000000000000E+00  -1.10293871831066E-08
      3.38326193072143E-18  -4.52318556533153E-01  -4.35889863131185E-01   0.00000000000000E+00   2.92696264524102E-10
     -1.17860105258955E-22  -5.24419253361570E-08  -5.21492290716331E-08  -2.75556220184215E-18
      6.26208244323274E-09
      0.00000000000000E+00  -6.49851111901344E-11   0.00000000000000E+00   4.60169283467408E-12   2.22783637462994E-22
      6.49805156475854E-08   6.49851173404203E-08  -6.05212032576808E-19  -3.40090824552583E-01  -3.40090824541001E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15821811595678E-08   0.00000000000000E+00  -1.15821811595678E-08
      3.15161830753007E-18  -3.36066581528623E-01  -3.19242160234403E-01   0.00000000000000E+00   2.43341593764683E-10
     -1.01512663516524E-22  -5.36462777746172E-08  -5.34029361808526E-08  -2.54640627495326E-18
      6.28208244323274E-09
      0.00000000000000E+00  -5.64071801139002E-11   0.00000000000000E+00  -2.11594868799787E-11   1.83578642463367E-22
      5.64284109375522E-08   5.64072514506724E-08  -5.97981822347493E-19  -3.46550684462723E-01  -3.46550684450801E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19224592961195E-08   0.00000000000000E+00  -1.19224592961195E-08
      2.91316912160768E-18  -2.13244099786372E-01  -1.99228922697733E-01   0.00000000000000E+00   1.67989908290579E-10
     -8.47673792119733E-23  -4.46527820628435E-08  -4.44847921545530E-08  -2.31518729926019E-18
      6.30208244323274E-09
      0.00000000000000E+00  -4.91647633614007E-11   0.00000000000000E+00  -1.79699862218512E-11   1.43664821089567E-22
      4.91827745111733E-08   4.91648045249516E-08  -5.88901227632073E-19  -3.53789749223965E-01  -3.53789749212133E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18314039478350E-08   0.00000000000000E+00  -1.18314039478350E-08
      2.67654104265098E-18  -1.12484402356507E-01  -1.00722075006419E-01   0.00000000000000E+00   8.93067600897847E-11
     -7.29146019023345E-23  -3.74227073372063E-08  -3.73334005771166E-08  -2.08763981501891E-18
      6.30458244323274E-09
      0.00000000000000E+00  -4.75068740100676E-11   0.00000000000000E+00  -3.25913007635387E-11   1.37608941807297E-22
      4.75395038594791E-08   4.75069125587157E-08  -5.88266012140412E-19  -3.54484256533699E-01  -3.54484256521789E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19096328168506E-08   0.00000000000000E+00  -1.19096328168506E-08
      2.64676696060885E-18  -1.00334777914362E-01  -8.91194138016095E-02   0.00000000000000E+00   8.47756574262821E-11
     -7.00006750192994E-23  -3.56820553992907E-08  -3.55972797418645E-08  -2.05850094846844E-18
      6.30795744323274E-09
      0.00000000000000E+00  -4.58117875401655E-11   0.00000000000000E+00  -2.49859562192600E-11   1.29988121662813E-22
      4.58367726623158E-08   4.58117867060967E-08  -5.86726971949674E-19  -3.55697786325982E-01  -3.55697786314147E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18348961701624E-08   0.00000000000000E+00  -1.18348961701624E-08
      2.60682418603455E-18  -8.55329121391976E-02  -7.48280529975734E-02   0.00000000000000E+00   6.73028886501780E-11
     -6.33481370336915E-23  -3.40441934245847E-08  -3.39768905359346E-08  -2.02009721408488E-18
      6.31251369323274E-09
      0.00000000000000E+00  -4.36313934788588E-11   0.00000000000000E+00  -2.37138376251151E-11   1.22180907084642E-22
      4.36551233203556E-08   4.36314094827306E-08  -5.82874300602676E-19  -3.57958732720457E-01  -3.57958732708802E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16557458815106E-08   0.00000000000000E+00  -1.16557458815106E-08
      2.55371769386192E-18  -6.84762593862486E-02  -5.84018834335805E-02   0.00000000000000E+00   5.71894137285542E-11
     -4.97787761242015E-23  -3.20328530149488E-08  -3.19756636012203E-08  -1.97084339325925E-18
      6.31866463073274E-09
      0.00000000000000E+00  -4.06537870985908E-11   0.00000000000000E+00  -2.39489232431608E-11   1.16903344858482E-22
      4.06777246419987E-08   4.06537757187556E-08  -5.73757836755595E-19  -3.62341038678226E-01  -3.62341038666879E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13473471655746E-08   0.00000000000000E+00  -1.13473471655746E-08
      2.48392087065567E-18  -5.09651105059278E-02  -4.17316914547682E-02   0.00000000000000E+00   4.79350524708727E-11
     -1.66641967310573E-23  -2.93543636056518E-08  -2.93064285531810E-08  -1.91016303390007E-18
      6.32281651354524E-09
      0.00000000000000E+00  -3.84478602003404E-11   0.00000000000000E+00  -2.62407995053825E-11   1.15865055025951E-22
      3.84741127882761E-08   3.84478719887708E-08  -5.65494513709490E-19  -3.65992955517210E-01  -3.65992955506103E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11068060381743E-08   0.00000000000000E+00  -1.11068060381743E-08
      2.43780671356400E-18  -4.19014016529931E-02  -3.32871874072458E-02   0.00000000000000E+00   4.38409626392182E-11
      1.06997151325203E-23  -2.73849069132361E-08  -2.73410659505968E-08  -1.87231219985451E-18
      6.32561903444368E-09
      0.00000000000000E+00  -3.70150822999030E-11   0.00000000000000E+00  -2.52788996836150E-11   1.16363919645655E-22
      3.70403284062627E-08   3.70150495065792E-08  -5.58968679633330E-19  -3.68773686853133E-01  -3.68773686842194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09387629646056E-08   0.00000000000000E+00  -1.09387629646056E-08
      2.40715060175264E-18  -3.69927131607317E-02  -2.87769797591607E-02   0.00000000000000E+00   3.94928424150007E-11
      2.95848633895823E-23  -2.61157793843880E-08  -2.60762865419729E-08  -1.84818192211931E-18
      6.32940243765657E-09
      0.00000000000000E+00  -3.55095633675972E-11   0.00000000000000E+00  -1.97117429956685E-11   1.18938704621054E-22
      3.55293149729375E-08   3.55096032299420E-08  -5.48883852741198E-19  -3.72968766883790E-01  -3.72968766873048E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07417914413178E-08   0.00000000000000E+00  -1.07417914413178E-08
      2.36651007350136E-18  -3.20583918210915E-02  -2.42549050089038E-02   0.00000000000000E+00   3.15025668345218E-11
      5.33350199312068E-23  -2.47993143554590E-08  -2.47678117886244E-08  -1.81762622076016E-18
      6.33451003199397E-09
      0.00000000000000E+00  -3.40972668435571E-11   0.00000000000000E+00  -1.36811334762037E-11   1.24419227810233E-22
      3.41109728723711E-08   3.40972917388950E-08  -5.33903006133259E-19  -3.79102977674445E-01  -3.79102977663895E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05502784156608E-08   0.00000000000000E+00  -1.05502784156608E-08
      2.31262353120751E-18  -2.74514051743369E-02  -2.00325412367016E-02   0.00000000000000E+00   2.36618218860687E-11
      8.19395599170104E-23  -2.35706751451206E-08  -2.35470133232344E-08  -1.77872052507425E-18
      6.34140528434946E-09
      0.00000000000000E+00  -3.28983256440500E-11   0.00000000000000E+00  -8.57770487818055E-12   1.32716260900142E-22
      3.29069272272260E-08   3.28983495223479E-08  -5.12636378424535E-19  -3.87736287469088E-01  -3.87736287458701E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03874378678035E-08   0.00000000000000E+00  -1.03874378678035E-08
      2.24099952578200E-18  -2.33987866119270E-02  -1.63063544763761E-02   0.00000000000000E+00   1.71094680371473E-11
      1.14630946616746E-22  -2.25280211225818E-08  -2.25109116545446E-08  -1.72836314735747E-18
      6.35071387502938E-09
      0.00000000000000E+00  -3.19111784085435E-11   0.00000000000000E+00  -5.20463819833966E-12   1.41727630910682E-22
      3.19164088994645E-08   3.19112042612664E-08  -4.83731089743998E-19  -3.99445168921189E-01  -3.99445168910934E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02555193645831E-08   0.00000000000000E+00  -1.02555193645831E-08
      2.14553509380715E-18  -1.99474010943963E-02  -1.31244139261201E-02   0.00000000000000E+00   1.24486912335030E-11
      1.48271154563550E-22  -2.16681335879167E-08  -2.16556848966831E-08  -1.66180400406315E-18
      6.36328047244726E-09
      0.00000000000000E+00  -3.10010889075542E-11   0.00000000000000E+00  -3.53501893289745E-12   1.45954965225748E-22
      3.10046012937941E-08   3.10010662748614E-08  -4.45895637350857E-19  -4.14839548981768E-01  -4.14839548971633E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01352219792018E-08   0.00000000000000E+00  -1.01352219792018E-08
      2.01816983945360E-18  -1.70258192747953E-02  -1.04516768055234E-02   0.00000000000000E+00   9.54500735369897E-12
      1.74402214097071E-22  -2.08753893030138E-08  -2.08658442956599E-08  -1.57227420210275E-18
      6.38024537896141E-09
      0.00000000000000E+00  -2.99362410243701E-11   0.00000000000000E+00  -3.05867395638315E-12   1.36183102260878E-22
      2.99392986116650E-08   2.99362399377088E-08  -3.97879163598541E-19  -4.34596414419917E-01  -4.34596414409922E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99569006828713E-09   0.00000000000000E+00  -9.99569006828713E-09
      1.84859389190073E-18  -1.45113402672280E-02  -8.22872027532622E-03   0.00000000000000E+00   7.90074124644864E-12
      1.77481563606461E-22  -1.99484506106682E-08  -1.99405498694216E-08  -1.45071472830219E-18
      6.40024537896141E-09
      0.00000000000000E+00  -2.87176450511006E-11   0.00000000000000E+00  -2.97301940019657E-12   1.09014594592519E-22
      2.87206375768903E-08   2.87176645574902E-08  -3.45423099975135E-19  -4.56519660991816E-01  -4.56519660981974E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.84190041882595E-09   0.00000000000000E+00  -9.84190041882595E-09
      1.65175588352421E-18  -1.25406243862200E-02  -6.59347748464795E-03   0.00000000000000E+00   6.86463672936118E-12
      1.47922747396665E-22  -1.88826287753937E-08  -1.88757641386642E-08  -1.30633278354908E-18
      6.42024537896141E-09
      0.00000000000000E+00  -2.76711661153581E-11   0.00000000000000E+00  -2.55357348571775E-12   7.61331031343993E-23
      2.76736943419844E-08   2.76711407684988E-08  -2.96576079706926E-19  -4.77284644575594E-01  -4.77284644565885E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70902837060303E-09   0.00000000000000E+00  -9.70902837060303E-09
      1.45757531611215E-18  -1.12004238976437E-02  -5.54113434032102E-03   0.00000000000000E+00   5.79828292803692E-12
      1.02975796576097E-22  -1.79679106808239E-08  -1.79621123978958E-08  -1.16099923640523E-18
      6.44024537896141E-09
      0.00000000000000E+00  -2.68100298593003E-11   0.00000000000000E+00  -2.09932008382681E-12   4.71714756600000E-23
      2.68121268847833E-08   2.68100275646995E-08  -2.50886216997373E-19  -4.97048060442385E-01  -4.97048060432818E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56686242745378E-09   0.00000000000000E+00  -9.56686242745378E-09
      1.26623806756308E-18  -1.02613631497031E-02  -4.82858694783594E-03   0.00000000000000E+00   4.81626680088324E-12
      6.07253277111832E-23  -1.72479814040466E-08  -1.72431651372457E-08  -1.01535185056570E-18
      6.46024537896141E-09
      0.00000000000000E+00  -2.63415298548047E-11   0.00000000000000E+00  -1.13309598523343E-12   2.67864863417061E-23
      2.63426519134868E-08   2.63415188175016E-08  -2.07125123906884E-19  -5.16353001368694E-01  -5.16353001359063E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63126746868422E-09   0.00000000000000E+00  -9.63126746868422E-09
      1.07361271818939E-18  -9.61059570219789E-03  -4.34572040696699E-03   0.00000000000000E+00   4.02552618435851E-12
      3.03529240554807E-23  -1.67142768750018E-08  -1.67102513488174E-08  -8.66487594282506E-19
      6.48024537896141E-09
      0.00000000000000E+00  -2.71995433897974E-11   0.00000000000000E+00   2.13893560231459E-12   1.49841243261135E-23
      2.71973732427633E-08   2.71995121783656E-08  -1.61365008602882E-19  -5.37063657659199E-01  -5.37063657648600E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05992952897061E-08   0.00000000000000E+00  -1.05992952897061E-08
      8.61626812395269E-19  -9.34818121397477E-03  -4.11797122991537E-03   0.00000000000000E+00   2.92296236080887E-12
      1.25753916447999E-23  -1.66031398510203E-08  -1.66002168886595E-08  -7.00261803792385E-19
      6.50024537896141E-09
      0.00000000000000E+00  -2.81305734908701E-11   0.00000000000000E+00   2.32639414441043E-12   8.96808232514065E-24
      2.81282240867384E-08   2.81305504808828E-08  -1.15157696335076E-19  -5.58530795419882E-01  -5.58530795408537E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13456246790792E-08   0.00000000000000E+00  -1.13456246790792E-08
      6.34714318813685E-19  -9.25957798975624E-03  -3.97116951135441E-03   0.00000000000000E+00   2.07768344912602E-12
      3.74355835742621E-24  -1.67870034852527E-08  -1.67849258018036E-08  -5.19556622478608E-19
      6.50274537896141E-09
      0.00000000000000E+00  -2.83946271103418E-11   0.00000000000000E+00   5.19042388223511E-12   8.26864725325657E-24
      2.83894702320668E-08   2.83946606559490E-08  -1.09441163553525E-19  -5.61236398741611E-01  -5.61236398730024E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15872786992734E-08   0.00000000000000E+00  -1.15872786992734E-08
      6.05746122065502E-19  -9.26556145740149E-03  -3.97007740186881E-03   0.00000000000000E+00   1.99291349066281E-12
      2.65759503031057E-24  -1.68093748701664E-08  -1.68073819566757E-08  -4.96304958511978E-19
      6.50612037896141E-09
      0.00000000000000E+00  -2.87839569513645E-11   0.00000000000000E+00   5.71993200898094E-12   7.51513741975846E-24
      2.87782651913545E-08   2.87839851233635E-08  -1.01635669715160E-19  -5.64946720560075E-01  -5.64946720548264E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18109400977721E-08   0.00000000000000E+00  -1.18109400977721E-08
      5.65884199235521E-19  -9.32944684683446E-03  -3.98176640985433E-03   0.00000000000000E+00   4.29579152874014E-14
      1.50398465051585E-24  -1.69730879835068E-08  -1.69730450255915E-08  -4.64248529520362E-19
      6.51067662896141E-09
      0.00000000000000E+00  -2.92103920662190E-11   0.00000000000000E+00   4.66284667719911E-12   6.77300512121202E-24
      2.92056895527704E-08   2.92103523994476E-08  -9.10676956360053E-20  -5.69991280556977E-01  -5.69991280544992E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19842277315216E-08   0.00000000000000E+00  -1.19842277315216E-08
      5.11281061633776E-19  -9.41827675329483E-03  -3.99085809203274E-03   0.00000000000000E+00  -3.12608071110901E-13
      3.98953881191970E-25  -1.72258120598547E-08  -1.72261246679258E-08  -4.20213365997770E-19
      6.51682756646141E-09
      0.00000000000000E+00  -2.94907940489136E-11   0.00000000000000E+00   2.29779875881151E-12   6.07098741963948E-24
      2.94885178359167E-08   2.94908156346755E-08  -7.69950945373975E-20  -5.76741717572320E-01  -5.76741717560303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20162988071446E-08   0.00000000000000E+00  -1.20162988071446E-08
      4.37369558689705E-19  -9.47665946608486E-03  -3.97097965045602E-03   0.00000000000000E+00   3.72983150616272E-13
     -5.54612270137248E-25  -1.74748898106817E-08  -1.74745168275311E-08  -3.60374464152307E-19
      6.52513133208641E-09
      0.00000000000000E+00  -2.93435669351699E-11   0.00000000000000E+00  -8.35282126415986E-13   5.40581976195330E-24
      2.93443658309412E-08   2.93435305488148E-08  -5.88758264682823E-20  -5.85487925363874E-01  -5.85487925352170E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17042950422166E-08   0.00000000000000E+00  -1.17042950422166E-08
      3.40179835853289E-19  -9.44828823898848E-03  -3.89071002388883E-03   0.00000000000000E+00   1.25268055277411E-12
     -1.28480997705678E-24  -1.76404881871509E-08  -1.76392355065981E-08  -2.81304009385007E-19
      6.53634141568016E-09
      0.00000000000000E+00  -2.81430643751303E-11   0.00000000000000E+00  -5.25484601248356E-12   4.70710309927851E-24
      2.81483057880507E-08   2.81430509420383E-08  -3.75974258288179E-20  -5.95820313728119E-01  -5.95820313717674E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04448973456697E-08   0.00000000000000E+00  -1.04448973456697E-08
      2.23091663480194E-19  -9.27611198200113E-03  -3.69996947453842E-03   0.00000000000000E+00   1.66016734385411E-12
     -1.78783457688289E-24  -1.76998137637124E-08  -1.76981535963686E-08  -1.85494237651378E-19
      6.55147502853172E-09
      0.00000000000000E+00  -2.35894023043812E-11   0.00000000000000E+00  -1.48268939292326E-11   3.67723300315462E-24
      2.36042131556970E-08   2.35893862617677E-08  -2.19049243412379E-20  -6.03314639168834E-01  -6.03314639162938E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.89651827864289E-09   0.00000000000000E+00  -5.89651827864289E-09
      1.33856038679051E-19  -8.80536501427770E-03  -3.23088635501086E-03   0.00000000000000E+00   1.07217903848294E-12
     -2.14966752245100E-24  -1.76939401621634E-08  -1.76928679831249E-08  -1.11951114337815E-19
      6.57147502853172E-09
      0.00000000000000E+00  -9.80727288375691E-12   0.00000000000000E+00  -3.39740250672898E-11   1.47280725825894E-24
      9.84122120502065E-09   9.80724717995336E-09  -5.10554619189885E-20  -5.88198303855697E-01  -5.88198303863577E-01
      0.00000000000000E+00   0.00000000000000E+00   7.87943780864922E-09   0.00000000000000E+00   7.87943780864922E-09
      2.91444794852036E-19  -7.62329933250429E-03  -2.05076817706485E-03   0.00000000000000E+00  -1.36781436328838E-12
     -2.71335926840673E-24  -1.76853171742391E-08  -1.76866849886024E-08  -2.40389332933046E-19
      6.59147502853173E-09
      0.00000000000000E+00   9.19356634973622E-12   0.00000000000000E+00  -4.66907362454604E-11  -2.49854882511807E-24
     -9.14667976919944E-09  -9.19337050544490E-09  -1.57530757296484E-19  -5.36852899937226E-01  -5.36852899964096E-01
      0.00000000000000E+00   0.00000000000000E+00   2.68703158772692E-08   0.00000000000000E+00   2.68703158772692E-08
      8.28851112397419E-19  -5.96007306566928E-03  -3.90658475286857E-04   0.00000000000000E+00  -5.59793789355309E-12
     -5.08426008779304E-24  -1.76713474339308E-08  -1.76769453718244E-08  -6.71320355100936E-19
      6.61147502853173E-09
      0.00000000000000E+00   2.29164559148616E-11   0.00000000000000E+00  -3.40213329319151E-11  -1.33408203828099E-23
     -2.28824173840878E-08  -2.29164387170198E-08  -3.56968187035813E-19  -4.50219890022948E-01  -4.50219890063487E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05386475284594E-08   0.00000000000000E+00   4.05386475284594E-08
      1.63962406296661E-18  -4.26916962848490E-03   1.28304265671000E-03   0.00000000000000E+00  -1.21102636219121E-11
     -2.07854315400032E-23  -1.76100985478177E-08  -1.76222088114396E-08  -1.28265587593080E-18
      6.63147502853173E-09
      0.00000000000000E+00   2.28299381724121E-11   0.00000000000000E+00  -1.79589398360962E-13  -3.69627613608926E-23
     -2.28297356313144E-08  -2.28299152207128E-08  -6.48341984284170E-19  -3.33880918320466E-01  -3.33880918360958E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04918082127103E-08   0.00000000000000E+00   4.04918082127103E-08
      2.44946022722081E-18  -1.95837686613628E-03   3.60632712599736E-03   0.00000000000000E+00  -2.80924153563583E-11
     -6.63066153000293E-23  -1.76338005766410E-08  -1.76618929919975E-08  -1.80111824293664E-18
      6.65147502853173E-09
      0.00000000000000E+00   1.44187052942096E-11   0.00000000000000E+00   2.01010693936481E-11  -4.31889898045130E-23
     -1.44387959552772E-08  -1.44186948858836E-08  -9.24026634735693E-19  -2.11481343198010E-01  -2.11481343228423E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04125260762241E-08   0.00000000000000E+00   3.04125260762241E-08
      3.05771074874530E-18  -1.10885615626838E-02  -6.04942666493335E-03   0.00000000000000E+00  -5.93564411826058E-11
     -8.22916607016672E-23  -1.59344747491577E-08  -1.59938311903404E-08  -2.13368411400960E-18
      6.67147502853173E-09
      0.00000000000000E+00   9.67437354901762E-12   0.00000000000000E+00   1.09018494694972E-11  -4.60251422498148E-23
     -9.68527387422502E-09  -9.67437202475557E-09  -1.11617913338618E-18  -1.11203597484016E-01  -1.11203597506352E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23367039051891E-08   0.00000000000000E+00   2.23367039051891E-08
      3.50444482684908E-18  -4.19192171546185E-02  -3.79297330608895E-02   0.00000000000000E+00  -1.10505634066160E-10
     -9.54042411470398E-23  -1.25518262463672E-08  -1.26623318804335E-08  -2.38826569346289E-18
      6.67397502853173E-09
      0.00000000000000E+00   8.68924689772969E-12   0.00000000000000E+00   1.82938421917401E-11  -4.63262544677854E-23
     -8.70749757711493E-09  -8.68920373492323E-09  -1.13777239241639E-18  -9.91247089261374E-02  -9.91247089466207E-02
      0.00000000000000E+00   0.00000000000000E+00   2.04833737573830E-08   0.00000000000000E+00   2.04833737573830E-08
      3.55565326124253E-18  -4.64738175722538E-02  -4.27578327585143E-02   0.00000000000000E+00  -1.47203052577743E-10
     -9.71441314538620E-23  -1.16469669698820E-08  -1.17941700224599E-08  -2.41788086882615E-18
      6.67735002853173E-09
      0.00000000000000E+00   7.68079168319105E-12   0.00000000000000E+00   1.38414830257870E-11  -4.67073145832624E-23
     -7.69468101458953E-09  -7.68083953156379E-09  -1.16349167850424E-18  -8.44304597188902E-02  -8.44304597376017E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87114929033573E-08   0.00000000000000E+00   1.87114929033573E-08
      3.61880454979136E-18  -5.33948980860917E-02  -4.99194691580412E-02   0.00000000000000E+00  -1.61577698447626E-10
     -9.94637352251023E-23  -1.08690756733455E-08  -1.10306533717932E-08  -2.45531287128713E-18
      6.68190627853173E-09
      0.00000000000000E+00   6.40984420971329E-12   0.00000000000000E+00   1.29005859622130E-11  -4.71291939479611E-23
     -6.42272870122270E-09  -6.40982811526053E-09  -1.19239006321692E-18  -6.75471774248054E-02  -6.75471774413352E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65298182391053E-08   0.00000000000000E+00   1.65298182391053E-08
      3.69411853414329E-18  -6.39416395293136E-02  -6.07531317455677E-02   0.00000000000000E+00  -1.69720133459250E-10
     -1.02477375472844E-22  -9.95026999038581E-09  -1.01199901238452E-08  -2.50172847092637E-18
      6.68805721603173E-09
      0.00000000000000E+00   4.74782184520589E-12   0.00000000000000E+00   1.26313291141593E-11  -4.75258757276793E-23
     -4.76049572728435E-09  -4.74786439817024E-09  -1.22115474903922E-18  -5.02935170573997E-02  -5.02935170710821E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36823612019594E-08   0.00000000000000E+00   1.36823612019594E-08
      3.77827788274897E-18  -8.01695557767309E-02  -7.73545605924693E-02   0.00000000000000E+00  -1.74022049707776E-10
     -1.06293336631891E-22  -8.76047475408119E-09  -8.93449680378908E-09  -2.55712313370975E-18
      6.69220909884423E-09
      0.00000000000000E+00   3.56908648788449E-12   0.00000000000000E+00   1.34378895718899E-11  -4.77051716529058E-23
     -3.58255905213528E-09  -3.56912116256344E-09  -1.23567192622817E-18  -4.13920789229915E-02  -4.13920789346296E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16380963021938E-08   0.00000000000000E+00   1.16380963021938E-08
      3.82659789475626E-18  -9.20335607159521E-02  -8.94912610147468E-02   0.00000000000000E+00  -1.77350119160812E-10
     -1.08750566088290E-22  -7.89162502046944E-09  -8.06897513963036E-09  -2.59092596852809E-18
      6.69781414064110E-09
      0.00000000000000E+00   2.38300355158649E-12   0.00000000000000E+00   1.00885231745690E-11  -4.78549297539237E-23
     -2.39309711792059E-09  -2.38300859474607E-09  -1.24861906989637E-18  -3.32283394313257E-02  -3.32283394408751E-02
      0.00000000000000E+00   0.00000000000000E+00   9.54941552406977E-09   0.00000000000000E+00   9.54941552406977E-09
      3.88012276790440E-18  -1.09153039676135E-01  -1.06895111521527E-01   0.00000000000000E+00  -1.76993507464356E-10
     -1.11853382615326E-22  -6.98941342185921E-09  -7.16640692932368E-09  -2.63150369800803E-18
      6.70538094706688E-09
      0.00000000000000E+00   1.40908195823788E-12   0.00000000000000E+00   6.15392033393560E-12  -4.79635912252366E-23
     -1.41523655445947E-09  -1.40908263412558E-09  -1.25873103147934E-18  -2.65510539486960E-02  -2.65510539564288E-02
      0.00000000000000E+00   0.00000000000000E+00   7.73280251609405E-09   0.00000000000000E+00   7.73280251609405E-09
      3.93863538767248E-18  -1.33155906595070E-01  -1.31163483042071E-01   0.00000000000000E+00  -1.79176073787404E-10
     -1.15789275166797E-22  -6.14454380818061E-09  -6.32371988196814E-09  -2.67990435619313E-18
      6.71559613574169E-09
      0.00000000000000E+00   7.64607437252660E-13   0.00000000000000E+00   3.01783033985450E-12  -4.80343891017151E-23
     -7.67584351653551E-10  -7.64566521313745E-10  -1.26581168634254E-18  -2.14839237157042E-02  -2.14839237220590E-02
      0.00000000000000E+00   0.00000000000000E+00   6.35481457248116E-09   0.00000000000000E+00   6.35481457248116E-09
      4.00355101752377E-18  -1.65538874588076E-01  -1.63777544688431E-01   0.00000000000000E+00  -1.86005660754945E-10
     -1.20849958241577E-22  -5.40424239041232E-09  -5.59024805116738E-09  -2.73773933118123E-18
      6.72938664045267E-09
      0.00000000000000E+00   4.07515098989796E-13   0.00000000000000E+00   1.23708159478076E-12  -4.80760790162764E-23
     -4.08785290325168E-10  -4.07548208730435E-10  -1.27047589933159E-18  -1.76847868846177E-02  -1.76847868899059E-02
      0.00000000000000E+00   0.00000000000000E+00   5.28817563405987E-09   0.00000000000000E+00   5.28817563405987E-09
      4.07647762851780E-18  -2.07062657326593E-01  -2.05524905639260E-01   0.00000000000000E+00  -1.95402102952997E-10
     -1.27338443667983E-22  -4.68522532237633E-09  -4.88062742532945E-09  -2.80600172918621E-18
      6.74800382181251E-09
      0.00000000000000E+00   2.36867577258211E-13   0.00000000000000E+00   4.38171481192156E-13  -4.80984863399315E-23
     -2.37315485902254E-10  -2.36877314421110E-10  -1.27364078233674E-18  -1.47166399317623E-02  -1.47166399359704E-02
      0.00000000000000E+00   0.00000000000000E+00   4.20811097777007E-09   0.00000000000000E+00   4.20811097777007E-09
      4.15482079377324E-18  -2.55216083389717E-01  -2.53964852572033E-01   0.00000000000000E+00  -1.94119213568589E-10
     -1.35104918398237E-22  -3.77711444978026E-09  -3.97123366334898E-09  -2.88118001143650E-18
      6.76800382181251E-09
      0.00000000000000E+00   1.73035484898980E-13   0.00000000000000E+00   1.52817164482551E-13  -4.81094609190674E-23
     -1.73204270620242E-10  -1.73051453455807E-10  -1.27580270601055E-18  -1.26647246267670E-02  -1.26647246298540E-02
      0.00000000000000E+00   0.00000000000000E+00   3.08700379226431E-09   0.00000000000000E+00   3.08700379226431E-09
      4.21656086961853E-18  -2.94054265905463E-01  -2.93136152240950E-01   0.00000000000000E+00  -1.67980644785599E-10
     -1.41629142751023E-22  -2.74597169402278E-09  -2.91395233880852E-09  -2.94075816360797E-18
      6.78800382181251E-09
      0.00000000000000E+00   1.45022840050685E-13   0.00000000000000E+00   6.83270186169117E-14  -4.81138735624454E-23
     -1.45124710900605E-10  -1.45056383882036E-10  -1.27743132953044E-18  -1.12828751319873E-02  -1.12828751341254E-02
      0.00000000000000E+00   0.00000000000000E+00   2.13810037901894E-09   0.00000000000000E+00   2.13810037901894E-09
      4.25932287719891E-18  -3.20449121175640E-01  -3.19821162364154E-01   0.00000000000000E+00  -1.25735320877753E-10
     -1.46183574286096E-22  -1.86730867425894E-09  -1.99304399513684E-09  -2.98189154766846E-18
      6.80800382181251E-09
      0.00000000000000E+00   1.32348266316046E-13   0.00000000000000E+00   3.22919913777500E-14  -4.81154161144067E-23
     -1.32342151648316E-10  -1.32309859656987E-10  -1.27882266218836E-18  -1.03205236992029E-02  -1.03205237005989E-02
      0.00000000000000E+00   0.00000000000000E+00   1.39606816630676E-09   0.00000000000000E+00   1.39606816630676E-09
      4.28724424052504E-18  -3.36397261561384E-01  -3.35999086027009E-01   0.00000000000000E+00  -7.94989182917934E-11
     -1.48948328050194E-22  -1.18425938835778E-09  -1.26375830664972E-09  -3.00842157833668E-18
      6.82800382181251E-09
      0.00000000000000E+00   1.25368066288274E-13   0.00000000000000E+00   1.86991379249670E-14  -4.81153568124150E-23
     -1.25360453113614E-10  -1.25341753975737E-10  -1.28008570616657E-18  -9.64425151198064E-03  -9.64425151281497E-03
      0.00000000000000E+00   0.00000000000000E+00   8.34332977761118E-10   0.00000000000000E+00   8.34332977761118E-10
      4.30393090008026E-18  -3.44155808748043E-01  -3.43932431222764E-01   0.00000000000000E+00  -3.77793650804126E-11
     -1.50242508829433E-22  -6.71211858704872E-10  -7.08991223785434E-10  -3.02384519391370E-18
      6.84800382181251E-09
      0.00000000000000E+00   9.43245451121300E-14   0.00000000000000E+00   8.26986250937415E-14  -4.81032404409825E-23
     -9.44338995908306E-11  -9.43512009657850E-11  -1.28073989485851E-18  -9.36172903210862E-03  -9.36172903280218E-03
      0.00000000000000E+00   0.00000000000000E+00   6.93559636518076E-10   0.00000000000000E+00   6.93559636518076E-10
      4.31780209281063E-18  -3.50765282979935E-01  -3.50576495916474E-01   0.00000000000000E+00  -3.07308336279560E-11
     -1.51270107305618E-22  -5.68477601924157E-10  -5.99208435552264E-10  -3.03706219795212E-18
      6.85800382181251E-09
      0.00000000000000E+00   8.17418161146988E-14   0.00000000000000E+00   7.04799979209454E-14  -4.80952577370541E-23
     -8.18461078393044E-11  -8.17756278414315E-11  -1.28094413769989E-18  -9.28681051070312E-03  -9.28681051139929E-03
      0.00000000000000E+00   0.00000000000000E+00   6.96168479608412E-10   0.00000000000000E+00   6.96168479608412E-10
      4.32476377760671E-18  -3.54286308060881E-01  -3.54092736305924E-01   0.00000000000000E+00  -3.29867324127357E-11
     -1.51812368703345E-22  -5.81406119354223E-10  -6.14392851767110E-10  -3.04381963990683E-18
      6.86137882181251E-09
      0.00000000000000E+00   7.46697713497193E-14   0.00000000000000E+00   1.12988831506318E-13  -4.80919596524554E-23
     -7.47660445057217E-11  -7.46530556742634E-11  -1.28098937767242E-18  -9.27387748139686E-03  -9.27387748210748E-03
      0.00000000000000E+00   0.00000000000000E+00   7.10618156494846E-10   0.00000000000000E+00   7.10618156494846E-10
      4.32716211388488E-18  -3.55550699863861E-01  -3.55350330779447E-01   0.00000000000000E+00  -3.53797894663938E-11
     -1.52007009108331E-22  -6.00585311354594E-10  -6.35965100821140E-10  -3.04617273621247E-18
      6.86593507181251E-09
      0.00000000000000E+00   5.38210160036107E-14   0.00000000000000E+00   2.37283220684719E-13  -4.80851378404797E-23
     -5.40462312216055E-11  -5.38089480009689E-11  -1.28095624579953E-18  -9.29912102848500E-03  -9.29912102931693E-03
      0.00000000000000E+00   0.00000000000000E+00   8.31925752623606E-10   0.00000000000000E+00   8.31925752623606E-10
      4.33095257559527E-18  -3.57847375501054E-01  -3.57602215685640E-01   0.00000000000000E+00  -4.92795964755238E-11
     -1.52368342848136E-22  -7.28837208146476E-10  -7.78116804622152E-10  -3.04999632979574E-18
      6.87208600931251E-09
      0.00000000000000E+00   3.51765343504827E-14   0.00000000000000E+00   1.66335441783948E-13  -4.80745981494642E-23
     -3.53177077037342E-11  -3.51513722619984E-11  -1.28079850897469E-18  -9.36637654442604E-03  -9.36637654549679E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07075184013978E-09   0.00000000000000E+00   1.07075184013978E-09
      4.33753870324198E-18  -3.62253258938429E-01  -3.61926968976311E-01   0.00000000000000E+00  -7.31413682209019E-11
     -1.53088064370561E-22  -9.62459099656791E-10  -1.03560046787785E-09  -3.05674019426729E-18
      6.87623789212501E-09
      0.00000000000000E+00   2.23182711414290E-14   0.00000000000000E+00   1.70809797684929E-13  -4.80665429291682E-23
     -2.24759154041384E-11  -2.23051056065015E-11  -1.28063962499345E-18  -9.42536616430732E-03  -9.42536616556611E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25879658846234E-09   0.00000000000000E+00   1.25879658846234E-09
      4.34276507916205E-18  -3.65912568572611E-01  -3.65522979941076E-01   0.00000000000000E+00  -9.24138858761636E-11
     -1.53697872870825E-22  -1.14407759697998E-09  -1.23649148285629E-09  -3.06212545416860E-18
      6.87904041302344E-09
      0.00000000000000E+00   1.63483632229398E-14   0.00000000000000E+00   1.24085951813059E-13  -4.80610069567751E-23
     -1.65173871122056E-11  -1.63933011604406E-11  -1.28051626856352E-18  -9.46643023060702E-03  -9.46643023199862E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39159928307620E-09   0.00000000000000E+00   1.39159928307620E-09
      4.34666506523512E-18  -3.68695506833606E-01  -3.68262210639616E-01   0.00000000000000E+00  -1.05994385507945E-10
     -1.54167814255131E-22  -1.26921159640804E-09  -1.37520598191614E-09  -3.06614879667161E-18
      6.88282381623633E-09
      0.00000000000000E+00   1.82771027042978E-14   0.00000000000000E+00  -3.25914337730176E-15  -4.80543176090642E-23
     -1.82115663080581E-11  -1.82148254514835E-11  -1.28035752376132E-18  -9.50444541483550E-03  -9.50444541638282E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54731773202241E-09   0.00000000000000E+00   1.54731773202241E-09
      4.35251919211382E-18  -3.72891051858006E-01  -3.72409264587373E-01   0.00000000000000E+00  -1.20868772710873E-10
     -1.54888526484883E-22  -1.40823413385973E-09  -1.52910290657076E-09  -3.07216166835250E-18
      6.88793141057374E-09
      0.00000000000000E+00   2.75534211622580E-14   0.00000000000000E+00  -7.27944555487795E-14  -4.80466175940468E-23
     -2.75068913661003E-11  -2.75796858216972E-11  -1.28019274820177E-18  -9.51180814140713E-03  -9.51180814309343E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68630423683895E-09   0.00000000000000E+00   1.68630423683895E-09
      4.36113215008504E-18  -3.79024589518391E-01  -3.78501960074082E-01   0.00000000000000E+00  -1.34228186856758E-10
     -1.55962185762141E-22  -1.52449636416057E-09  -1.65872455101749E-09  -3.08093940188327E-18
      6.89482666292923E-09
      0.00000000000000E+00   3.96769264736516E-14   0.00000000000000E+00  -7.22301327948556E-14  -4.80377964391245E-23
     -3.96323413882206E-11  -3.97045715210635E-11  -1.28005703013676E-18  -9.45832812715875E-03  -9.45832812893362E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77486539252842E-09   0.00000000000000E+00   1.77486539252842E-09
      4.37337029486355E-18  -3.87657355270613E-01  -3.87110641603266E-01   0.00000000000000E+00  -1.44093035266004E-10
     -1.57501925399573E-22  -1.59106778574119E-09  -1.73516082100735E-09  -3.09331326472679E-18
      6.90413525360914E-09
      0.00000000000000E+00   5.29944133687429E-14   0.00000000000000E+00  -5.86234397467494E-14  -4.80281243760805E-23
     -5.29194341364879E-11  -5.29780575762826E-11  -1.28000293765607E-18  -9.30466500654210E-03  -9.30466500834519E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80308824580064E-09   0.00000000000000E+00   1.80308824580064E-09
      4.39015450530348E-18  -3.99366998829170E-01  -3.98815574514647E-01   0.00000000000000E+00  -1.49994817340741E-10
     -1.59633273118241E-22  -1.60011537088344E-09  -1.75011018822434E-09  -3.11015156764741E-18
      6.91670185102703E-09
      0.00000000000000E+00   7.32921002916063E-14   0.00000000000000E+00  -7.18102106689959E-14  -4.80200761752174E-23
     -7.31983191239840E-11  -7.32701293347010E-11  -1.28019443082174E-18  -8.94537398467787E-03  -8.94537398646767E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78979834753867E-09   0.00000000000000E+00   1.78979834753867E-09
      4.41264618059619E-18  -4.14764012597448E-01  -4.14223169053511E-01   0.00000000000000E+00  -1.53163146286936E-10
     -1.62513464161146E-22  -1.56336507191685E-09  -1.71652821820395E-09  -3.13245174977445E-18
      6.93366675754118E-09
      0.00000000000000E+00   1.13060871502465E-13   0.00000000000000E+00  -1.14993729765741E-13  -4.80223724679318E-23
     -1.12868276280159E-10  -1.12983270009973E-10  -1.28114177912396E-18  -8.06715835703820E-03  -8.06715835880964E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77144055863584E-09   0.00000000000000E+00   1.77144055863584E-09
      4.44269850406882E-18  -4.34525194532675E-01  -4.34002647693216E-01   0.00000000000000E+00  -1.55960686210152E-10
     -1.66374548086080E-22  -1.50249660241555E-09  -1.65845728862587E-09  -3.16155672494485E-18
      6.95366675754118E-09
      0.00000000000000E+00   1.58891395369021E-13   0.00000000000000E+00  -1.21506006027405E-13  -4.80417050684914E-23
     -1.58815365470566E-10  -1.58936871476641E-10  -1.28319493704113E-18  -6.49988649431851E-03  -6.49988649607051E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75199933640938E-09   0.00000000000000E+00   1.75199933640938E-09
      4.47773849079700E-18  -4.56452762619633E-01  -4.55950819605486E-01   0.00000000000000E+00  -1.59591389133685E-10
     -1.70899161298369E-22  -1.43347107579889E-09  -1.59306246493274E-09  -3.19454355375588E-18
      6.97366675754118E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -4.33299765631592E-14  -4.80639331805428E-23
     -1.71960587159998E-10  -1.72003917136609E-10  -1.28552466521999E-18  -4.79672365725134E-03  -4.79672365894172E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69037808904834E-09   0.00000000000000E+00   1.69037808904834E-09
      4.51154605257797E-18  -4.77221068812957E-01  -4.76742657470517E-01   0.00000000000000E+00  -1.62051832690514E-10
     -1.75361298801293E-22  -1.35632233922111E-09  -1.51837417191180E-09  -3.22602138735798E-18
      6.99366675754118E-09
      0.00000000000000E+00   1.96272203412485E-13   0.00000000000000E+00  -7.52672885388422E-14  -4.80957692616953E-23
     -1.96194986889295E-10  -1.96270254177882E-10  -1.28835257248802E-18  -2.81718395282634E-03  -2.81718395448517E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65882548863606E-09   0.00000000000000E+00   1.65882548863606E-09
      4.54472256235069E-18  -4.96988082530701E-01  -4.96527257245099E-01   0.00000000000000E+00  -1.66082266711239E-10
     -1.79809570585150E-22  -1.29647296774667E-09  -1.46255523445809E-09  -3.25636998986267E-18
      7.01366675754118E-09
      0.00000000000000E+00  -1.22520879434841E-13   0.00000000000000E+00   8.23907357796017E-13  -4.79943098226883E-23
      1.21674973954860E-10   1.22498881312608E-10  -1.28483375311231E-18  -4.70014685108435E-03  -4.70014685217106E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08671231299345E-09   0.00000000000000E+00   1.08671231299345E-09
      4.56645680861056E-18  -5.16287710462792E-01  -5.15906712453764E-01   0.00000000000000E+00  -1.38882175530874E-10
     -1.83438732785485E-22  -1.07032901877505E-09  -1.20921119430611E-09  -3.28162305549825E-18
      7.03366675754118E-09
      0.00000000000000E+00  -2.03050345018400E-12   0.00000000000000E+00   5.04153951311031E-12  -4.71288454422542E-23
      2.02546474482463E-09   2.03050628433769E-09  -1.24337248885930E-18  -2.91135014672435E-02  -2.91135014652481E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.99541734957610E-09   0.00000000000000E+00  -1.99541734957610E-09
      4.52654846161904E-18  -5.36991979579068E-01  -5.36980955200120E-01   0.00000000000000E+00   3.70814625432789E-11
     -1.82463746416117E-22  -7.21703973047472E-11  -3.50889347616507E-11  -3.28317597275974E-18
      7.04366675754118E-09
      0.00000000000000E+00  -3.19876850746374E-12   0.00000000000000E+00   6.23374706326171E-12  -4.64855508865835E-23
      3.19254393529725E-09   3.19877768236046E-09  -1.21112433082114E-18  -4.76599243702944E-02  -4.76599243664622E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.83226936475113E-09   0.00000000000000E+00  -3.83226936475113E-09
      4.48822576797153E-18  -5.47640526006302E-01  -5.47840177400209E-01   0.00000000000000E+00   1.36624418946912E-10
     -1.80660445124158E-22   4.96867263443992E-10   6.33491682390723E-10  -3.27710143715039E-18
      7.05041675754118E-09
      0.00000000000000E+00  -4.00204257908077E-12   0.00000000000000E+00   6.40592402442430E-12  -4.59622804267341E-23
      3.99563415880568E-09   4.00204008283006E-09  -1.18409007645132E-18  -6.28838023228846E-02  -6.28838023178319E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.05268271118089E-09   0.00000000000000E+00  -5.05268271118089E-09
      4.45412015967106E-18  -5.54959671668375E-01  -5.55290770425303E-01   0.00000000000000E+00   1.95159955481275E-10
     -1.78900655809884E-22   8.55482672869830E-10   1.05064262835093E-09  -3.27003008321974E-18
      7.05952925754118E-09
      0.00000000000000E+00  -4.99038379617097E-12   0.00000000000000E+00   5.94044935456954E-12  -4.51271572588976E-23
      4.98445374218906E-09   4.99039419154358E-09  -1.13921555407933E-18  -8.74873696199253E-02  -8.74873696134512E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.47411789679574E-09   0.00000000000000E+00  -6.47411789679574E-09
      4.39512476033651E-18  -5.65006501569794E-01  -5.65474072040780E-01   0.00000000000000E+00   2.55301720239061E-10
     -1.75739978701942E-22   1.22842198501342E-09   1.48372370525230E-09  -3.25590920625717E-18
      7.06260472629118E-09
      0.00000000000000E+00  -5.47367080335697E-12   0.00000000000000E+00   8.29462639903230E-12  -4.48145335674517E-23
      5.46537784326391E-09   5.47367246966290E-09  -1.12270930697277E-18  -9.63494052181635E-02  -9.63494052110363E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.12714199664606E-09   0.00000000000000E+00  -7.12714199664606E-09
      4.37320545784901E-18  -5.68409371100858E-01  -5.68930430078514E-01   0.00000000000000E+00   2.74755842213805E-10
     -1.74578559472883E-22   1.37871368476928E-09   1.65346952698291E-09  -3.25049615087624E-18
      7.06675660910368E-09
      0.00000000000000E+00  -5.95732518949181E-12   0.00000000000000E+00   6.35557695407695E-12  -4.43769814300254E-23
      5.95100198663505E-09   5.95735756358909E-09  -1.09874735459699E-18  -1.09011961623065E-01  -1.09011961615322E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.74327471783220E-09   0.00000000000000E+00  -7.74327471783220E-09
      4.34105628863557E-18  -5.73004254472747E-01  -5.73567055383681E-01   0.00000000000000E+00   2.94021284996607E-10
     -1.72884381547321E-22   1.49189586924657E-09   1.78591715424301E-09  -3.24230893403859E-18
      7.07236165090055E-09
      0.00000000000000E+00  -6.47973805472822E-12   0.00000000000000E+00   5.17444760720157E-12  -4.37410903871102E-23
      6.47448914525072E-09   6.47966359285787E-09  -1.06445101964149E-18  -1.26748235452107E-01  -1.26748235443836E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.27099177448284E-09   0.00000000000000E+00  -8.27099177448284E-09
      4.29469703403799E-18  -5.79114705012239E-01  -5.79679229150637E-01   0.00000000000000E+00   3.04004130879323E-10
     -1.70488213486837E-22   1.48732405074543E-09   1.79132818162459E-09  -3.23024601439650E-18
      7.07992845732633E-09
      0.00000000000000E+00  -7.17031863379161E-12   0.00000000000000E+00   5.02332835041029E-12  -4.26397676283561E-23
      7.16529701973345E-09   7.17032034808382E-09  -1.01628215304399E-18  -1.50938462391487E-01  -1.50938462382827E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.66015545155652E-09   0.00000000000000E+00  -8.66015545155652E-09
      4.22916731411889E-18  -5.86996925816177E-01  -5.87466498287703E-01   0.00000000000000E+00   3.01817305966367E-10
     -1.67220745307622E-22   1.18801779750666E-09   1.48983510347286E-09  -3.21288516107490E-18
      7.09014364600114E-09
      0.00000000000000E+00  -8.59584079998964E-12   0.00000000000000E+00   7.31768438875702E-12  -3.94353075490729E-23
      8.58856804777363E-09   8.59588573216235E-09  -9.50219167501635E-19  -1.82871800120871E-01  -1.82871800111943E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.92771352514781E-09   0.00000000000000E+00  -8.92771352514781E-09
      4.13796903602490E-18  -5.96321870121408E-01  -5.96426701178802E-01   0.00000000000000E+00   2.90142151646447E-10
     -1.62880861021909E-22   4.16856413392966E-11   3.31827792985581E-10  -3.18774986852326E-18
      7.10393415071213E-09
      0.00000000000000E+00  -1.28881127486462E-11   0.00000000000000E+00   1.56713686150186E-11  -2.44092278869443E-23
      1.28723678711439E-08   1.28880392397589E-08  -8.63470318778301E-19  -2.22907735230763E-01  -2.22907735221576E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.18750349414751E-09   0.00000000000000E+00  -9.18750349414751E-09
      4.01126872580665E-18  -6.03597467010638E-01  -6.02432167387719E-01   0.00000000000000E+00   2.81224140563806E-10
     -1.56987859989967E-22  -3.98175988617487E-09  -3.70053574561122E-09  -3.14779840702835E-18
      7.12255133207196E-09
      0.00000000000000E+00  -2.58031360052942E-11   0.00000000000000E+00   3.44345457696952E-11   3.62443669018839E-23
      2.57686605995134E-08   2.58030951452831E-08  -7.61991741399815E-19  -2.67763466957741E-01  -2.67763466948075E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66556390020484E-09   0.00000000000000E+00  -9.66556390020484E-09
      3.83132316973150E-18  -5.92592428517373E-01  -5.87509442770744E-01   0.00000000000000E+00   2.99471906569648E-10
     -1.47826982764395E-22  -1.64370031516478E-08  -1.61375312450783E-08  -3.06933142833168E-18
      7.14255133207196E-09
      0.00000000000000E+00  -4.59041833457963E-11   0.00000000000000E+00   4.98393077078944E-11   1.32122239829224E-22
      4.58543108094706E-08   4.59041501171787E-08  -6.81976920498697E-19  -3.02815751591694E-01  -3.02815751581348E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03458694318964E-08   0.00000000000000E+00  -1.03458694318964E-08
      3.62440578109357E-18  -5.45115550117620E-01  -5.33914368152874E-01   0.00000000000000E+00   3.18970276560939E-10
     -1.35214728334636E-22  -3.58772509618432E-08  -3.55582806852824E-08  -2.94242886059487E-18
      7.16255133207196E-09
      0.00000000000000E+00  -6.21048602313063E-11   0.00000000000000E+00   4.03039063278643E-11   2.08164658451019E-22
      6.20646303927642E-08   6.21049342990923E-08  -6.31323895991560E-19  -3.26045354183467E-01  -3.26045354172495E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09717664398012E-08   0.00000000000000E+00  -1.09717664398012E-08
      3.40497045229755E-18  -4.61935823530441E-01  -4.45827311135654E-01   0.00000000000000E+00   2.96390714295852E-10
     -1.19462884926566E-22  -5.14295585735867E-08  -5.11331678592910E-08  -2.77364655630598E-18
      7.18255133207196E-09
      0.00000000000000E+00  -6.54286294261095E-11   0.00000000000000E+00   8.37318370513872E-12   2.24139564822903E-22
      6.54202928352614E-08   6.54286660189668E-08  -6.06467462398281E-19  -3.39256933836240E-01  -3.39256933824711E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15289118715807E-08   0.00000000000000E+00  -1.15289118715807E-08
      3.17439221486593E-18  -3.48220706501604E-01  -3.31239826057764E-01   0.00000000000000E+00   2.48444140028611E-10
     -1.03101605389261E-22  -5.41481982874147E-08  -5.38997541473862E-08  -2.56792475246765E-18
      7.20255133207196E-09
      0.00000000000000E+00  -5.72362625566726E-11   0.00000000000000E+00  -2.02796358037727E-11   1.87325808266855E-22
      5.72565245196119E-08   5.72362448838083E-08  -5.98662867972415E-19  -3.45931329422459E-01  -3.45931329410548E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19111315747899E-08   0.00000000000000E+00  -1.19111315747899E-08
      2.93616958337013E-18  -2.24301815006060E-01  -2.10021895950037E-01   0.00000000000000E+00   1.76846643650688E-10
     -8.64689500719197E-23  -4.55019599526689E-08  -4.53251133090183E-08  -2.33750671539772E-18
      7.22255133207196E-09
      0.00000000000000E+00  -4.97746124164587E-11   0.00000000000000E+00  -1.85130535731264E-11   1.46829808006167E-22
      4.97932006739045E-08   4.97746876203315E-08  -5.90084428232150E-19  -3.52977649290787E-01  -3.52977649278937E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18499586421935E-08   0.00000000000000E+00  -1.18499586421935E-08
      2.69917041052627E-18  -1.21032261916998E-01  -1.09083645394789E-01   0.00000000000000E+00   9.51167174978664E-11
     -7.46287253459069E-23  -3.80198456956358E-08  -3.79247289781380E-08  -2.10908598229411E-18
      7.24255133207196E-09
      0.00000000000000E+00  -4.26740957829448E-11   0.00000000000000E+00  -1.75778404705514E-11   1.22863606824429E-22
      4.26916803899026E-08   4.26741025494322E-08  -5.67372414355922E-19  -3.64963211387769E-01  -3.64963211376334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14352785281773E-08   0.00000000000000E+00  -1.14352785281773E-08
      2.47046483996272E-18  -5.27902566199884E-02  -4.29480108167528E-02   0.00000000000000E+00   5.16761772533988E-11
     -1.56816550711732E-23  -3.12905001985084E-08  -3.12388240212550E-08  -1.90309242560680E-18
      7.24505133207196E-09
      0.00000000000000E+00  -4.05043557111542E-11   0.00000000000000E+00  -4.24699325815227E-11   1.19887199933159E-22
      4.05467516094074E-08   4.05042816768260E-08  -5.63727122352095E-19  -3.66661897182202E-01  -3.66661897170862E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13394890442755E-08   0.00000000000000E+00  -1.13394890442755E-08
      2.44211611735203E-18  -4.57063187583484E-02  -3.65175214289745E-02   0.00000000000000E+00   6.41449202417783E-11
      1.62082169716114E-24  -2.92289375527918E-08  -2.91647926325500E-08  -1.87838899499994E-18
      7.24842633207196E-09
      0.00000000000000E+00  -3.81797654124317E-11   0.00000000000000E+00  -3.41868946297611E-11   1.18186000231329E-22
      3.82139794723269E-08   3.81797925776972E-08  -5.56923210768989E-19  -3.69619342214897E-01  -3.69619342203806E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10915857541558E-08   0.00000000000000E+00  -1.10915857541558E-08
      2.40468201543175E-18  -3.85606468425220E-02  -3.00260965668472E-02   0.00000000000000E+00   4.93210951372080E-11
      2.56391541940555E-23  -2.71375279186783E-08  -2.70882068235411E-08  -1.84775880466277E-18
      7.25298258207196E-09
      0.00000000000000E+00  -3.59316817798030E-11   0.00000000000000E+00  -2.44783195167608E-11   1.19683010371300E-22
      3.59561536565012E-08   3.59316753369845E-08  -5.45342887178027E-19  -3.74453197480450E-01  -3.74453197469649E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08013840948133E-08   0.00000000000000E+00  -1.08013840948133E-08
      2.35546820914976E-18  -3.19948901806875E-02  -2.40771993386936E-02   0.00000000000000E+00   3.60682680629477E-11
      5.49386359407328E-23  -2.51663595102344E-08  -2.51302912421714E-08  -1.81012532197174E-18
      7.25913351957196E-09
      0.00000000000000E+00  -3.40374759196350E-11   0.00000000000000E+00  -1.52542003023433E-11   1.25349231005015E-22
      3.40527676002365E-08   3.40375133999343E-08  -5.27421957277602E-19  -3.81779559317024E-01  -3.81779559306481E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05426291206966E-08   0.00000000000000E+00  -1.05426291206966E-08
      2.29062115634268E-18  -2.64727425849615E-02  -1.90703012798051E-02   0.00000000000000E+00   2.46925995151837E-11
      8.86631288376691E-23  -2.35195768787530E-08  -2.34948842792378E-08  -1.76319919906508E-18
      7.26743728519696E-09
      0.00000000000000E+00  -3.26169133692462E-11   0.00000000000000E+00  -8.44429542786408E-12   1.34245346702653E-22
      3.26253192873916E-08   3.26168749919638E-08  -5.01818993114962E-19  -3.92157456226308E-01  -3.92157456215960E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03476497153092E-08   0.00000000000000E+00  -1.03476497153092E-08
      2.20469669833715E-18  -2.20715354004112E-02  -1.50552477077327E-02   0.00000000000000E+00   1.64006673513786E-11
      1.24986009745710E-22  -2.22856259440061E-08  -2.22692252766546E-08  -1.70287770522219E-18
      7.27864736879071E-09
      0.00000000000000E+00  -3.15406767386484E-11   0.00000000000000E+00  -4.70820386792988E-12   1.42278416804935E-22
      3.15454119028398E-08   3.15407036989720E-08  -4.67375107174583E-19  -4.06121082492471E-01  -4.06121082482268E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02030355430839E-08   0.00000000000000E+00  -1.02030355430839E-08
      2.09031981698918E-18  -1.85812306341382E-02  -1.18584364842240E-02   0.00000000000000E+00   1.13827549941769E-11
      1.58511687257521E-22  -2.13490509108824E-08  -2.13376681558881E-08  -1.62294470981460E-18
      7.29378098164227E-09
      0.00000000000000E+00  -3.05194551056379E-11   0.00000000000000E+00  -3.29154509230254E-12   1.41143106263127E-22
      3.05227813417016E-08   3.05194897966094E-08  -4.22992757948198E-19  -4.24256162859801E-01  -4.24256162849733E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00682380043169E-08   0.00000000000000E+00  -1.00682380043169E-08
      1.93795100093446E-18  -1.57315620279576E-02  -9.28804027855710E-03   0.00000000000000E+00   8.72718757446629E-12
      1.76636050369563E-22  -2.04599789798671E-08  -2.04512517922925E-08  -1.51495824298626E-18
      7.31378098164227E-09
      0.00000000000000E+00  -2.92799185322851E-11   0.00000000000000E+00  -3.02253441219685E-12   1.21041516182004E-22
      2.92829207413358E-08   2.92798982069237E-08  -3.68576092915167E-19  -4.46816113757394E-01  -4.46816113747486E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90810805836736E-09   0.00000000000000E+00  -9.90810805836736E-09
      1.73978883976711E-18  -1.33503598896260E-02  -7.24693390615459E-03   0.00000000000000E+00   7.33272751380752E-12
      1.61927152335751E-22  -1.93791228760703E-08  -1.93717901485563E-08  -1.37121274685194E-18
      7.33378098164227E-09
      0.00000000000000E+00  -2.81233177566307E-11   0.00000000000000E+00  -2.82292540450051E-12   8.98607033281053E-23
      2.81261574467668E-08   2.81233345213624E-08  -3.18158417410667E-19  -4.68076288237080E-01  -4.68076288227313E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76602568755397E-09   0.00000000000000E+00  -9.76602568755397E-09
      1.54446832601603E-18  -1.17477308380519E-02  -5.96392967092950E-03   0.00000000000000E+00   6.33326674808146E-12
      1.22103244816473E-22  -1.83636421005567E-08  -1.83573088338085E-08  -1.22630990860537E-18
      7.35378098164227E-09
      0.00000000000000E+00  -2.71944000845138E-11   0.00000000000000E+00  -2.26558054998600E-12   5.86900805907575E-23
      2.71966401922164E-08   2.71943746116664E-08  -2.71032853571783E-19  -4.88295128602968E-01  -4.88295128593330E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63749022780924E-09   0.00000000000000E+00  -9.63749022780924E-09
      1.35171852145985E-18  -1.06521714792958E-02  -5.12055401744878E-03   0.00000000000000E+00   5.23022290630662E-12
      7.76170389516896E-23  -1.75621146067636E-08  -1.75568843838572E-08  -1.08068566788807E-18
      7.37378098164227E-09
      0.00000000000000E+00  -2.64002186418803E-11   0.00000000000000E+00  -1.93541766688446E-12   3.44815589485402E-23
      2.64021514892461E-08   2.64002160715793E-08  -2.26964716751255E-19  -5.07547813243914E-01  -5.07547813234430E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48432300665442E-09   0.00000000000000E+00  -9.48432300665442E-09
      1.16203206132676E-18  -9.85970012299999E-03  -4.53003509195048E-03   0.00000000000000E+00   4.40016497568238E-12
      4.18414725657100E-23  -1.69202932299006E-08  -1.69158930649249E-08  -9.35067344575504E-19
      7.39378098164227E-09
      0.00000000000000E+00  -2.67697100196662E-11   0.00000000000000E+00   9.32897942530615E-13   1.92741023745954E-23
      2.67687766314326E-08   2.67697095293751E-08  -1.82010585586366E-19  -5.27654622789245E-01  -5.27654622779081E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01639715224652E-08   0.00000000000000E+00  -1.01639715224652E-08
      9.58752630877456E-19  -9.43671976036503E-03  -4.20477157841777E-03   0.00000000000000E+00   3.44552672012329E-12
      1.90043762229755E-23  -1.66091835336300E-08  -1.66057380069099E-08  -7.76742045291089E-19
      7.41378098164227E-09
      0.00000000000000E+00  -2.76786055390719E-11   0.00000000000000E+00   2.27405316962981E-12   1.10728002778590E-23
      2.76763767237880E-08   2.76786507769576E-08  -1.35920077545870E-19  -5.48811457521615E-01  -5.48811457510593E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10224432622781E-08   0.00000000000000E+00  -1.10224432622781E-08
      7.38303765631893E-19  -9.27286886013639E-03  -4.02501804922944E-03   0.00000000000000E+00   2.45922754074994E-12
      6.79599310138347E-24  -1.66586667422204E-08  -1.66562075146796E-08  -6.02383688086024E-19
      7.42378098164227E-09
      0.00000000000000E+00  -2.83762581629003E-11   0.00000000000000E+00   3.46803027096708E-12   8.36745150762873E-24
      2.83727992170673E-08   2.83762672473382E-08  -1.12787868987947E-19  -5.59660139624727E-01  -5.59660139613172E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15548840368542E-08   0.00000000000000E+00  -1.15548840368542E-08
      6.22754925263352E-19  -9.28597138910210E-03  -3.98607604508193E-03   0.00000000000000E+00   1.68185759075838E-12
      2.77313682174818E-24  -1.68230650680747E-08  -1.68213832104839E-08  -5.09967056275405E-19
      7.42715598164227E-09
      0.00000000000000E+00  -2.87195737905820E-11   0.00000000000000E+00   5.03130741310588E-12   7.61304397634448E-24
      2.87145805072428E-08   2.87196118146559E-08  -1.04977038375416E-19  -5.63362832853980E-01  -5.63362832842207E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17739685552101E-08   0.00000000000000E+00  -1.17739685552101E-08
      5.83017781389518E-19  -9.32892148341750E-03  -3.98987488667973E-03   0.00000000000000E+00   6.48844965741981E-13
      1.62634580392201E-24  -1.69462921044117E-08  -1.69456432594459E-08  -4.78040743014101E-19
      7.43171223164227E-09
      0.00000000000000E+00  -2.91422432712110E-11   0.00000000000000E+00   4.61579194394601E-12   6.86143056262134E-24
      2.91376636772043E-08   2.91422794691482E-08  -9.43854680242138E-20  -5.68408293633944E-01  -5.68408293621982E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19620439835170E-08   0.00000000000000E+00  -1.19620439835170E-08
      5.28515718489618E-19  -9.40965702954084E-03  -3.99669687710082E-03   0.00000000000000E+00  -9.46070787825259E-14
      5.08366683849964E-25  -1.71801408785529E-08  -1.71802354856317E-08  -4.34130250465406E-19
      7.43786316914227E-09
      0.00000000000000E+00  -2.94664551935536E-11   0.00000000000000E+00   2.64610662991403E-12   6.15128944134404E-24
      2.94638042294432E-08   2.94664503360731E-08  -8.02369410919899E-20  -5.75184132764479E-01  -5.75184132752449E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20303378788927E-08   0.00000000000000E+00  -1.20303378788927E-08
      4.54517862092667E-19  -9.47410400179235E-03  -3.98052437145437E-03   0.00000000000000E+00   3.34173182323017E-13
     -4.68080163026101E-25  -1.74364466303624E-08  -1.74361124571800E-08  -3.74280921000676E-19
      7.44616693476727E-09
      0.00000000000000E+00  -2.94066642696315E-11   0.00000000000000E+00  -3.15264155155085E-13   5.48135247247140E-24
      2.94069390470318E-08   2.94066237828767E-08  -6.19170573603745E-20  -5.84015637887943E-01  -5.84015637876156E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17862195177900E-08   0.00000000000000E+00  -1.17862195177900E-08
      3.56647857612138E-19  -9.45964584354600E-03  -3.90800091473600E-03   0.00000000000000E+00   1.16660884698639E-12
     -1.22444627915165E-24  -1.76215708739335E-08  -1.76204042650865E-08  -2.94730800251763E-19
      7.45737701836102E-09
      0.00000000000000E+00  -2.83744212681561E-11   0.00000000000000E+00  -4.51312911782172E-12   4.78747475931932E-24
      2.83789679946253E-08   2.83744548655075E-08  -4.00803098236334E-20  -5.94613261648490E-01  -5.94613261637810E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06798576385894E-08   0.00000000000000E+00  -1.06798576385894E-08
      2.36925760714201E-19  -9.30531240384003E-03  -3.73029052640581E-03   0.00000000000000E+00   1.64620072414639E-12
     -1.74926890442110E-24  -1.76962434276422E-08  -1.76945972269180E-08  -1.96845450890567E-19
      7.47251063121259E-09
      0.00000000000000E+00  -2.42407651806570E-11   0.00000000000000E+00  -1.34570924848824E-11   3.79534031565560E-24
      2.42542713350553E-08   2.42408142425704E-08  -2.25771337747160E-20  -6.03017998579252E-01  -6.03017998572705E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.54706739689520E-09   0.00000000000000E+00  -6.54706739689520E-09
      1.37844977416501E-19  -8.86674864698496E-03  -3.29199323724649E-03   0.00000000000000E+00   1.17520588745385E-12
     -2.12100830738940E-24  -1.76949220515627E-08  -1.76937468456752E-08  -1.15267843641785E-19
      7.49251063121259E-09
      0.00000000000000E+00  -1.11384705048428E-11   0.00000000000000E+00  -3.22974458401289E-11   1.68683642905085E-24
      1.11708124052300E-08   1.11385149593899E-08  -4.68405462403944E-20  -5.90331403109852E-01  -5.90331403116400E-01
      0.00000000000000E+00   0.00000000000000E+00   6.54794206610552E-09   0.00000000000000E+00   6.54794206610552E-09
      2.68803818738612E-19  -7.73617614459657E-03  -2.16371732665275E-03   0.00000000000000E+00  -1.12605291985031E-12
     -2.65144971474089E-24  -1.76853309725755E-08  -1.76864570254954E-08  -2.21963272498217E-19
      7.51251063121259E-09
      0.00000000000000E+00   7.80496576789562E-12   0.00000000000000E+00  -4.66977852149407E-11  -2.09531552044332E-24
     -7.75825051839478E-09  -7.80494830360972E-09  -1.46907540579156E-19  -5.41798876360905E-01  -5.41798876386390E-01
      0.00000000000000E+00   0.00000000000000E+00   2.54845708678921E-08   0.00000000000000E+00   2.54845708678921E-08
      7.78495236096453E-19  -6.09136924703954E-03  -5.21062314846052E-04   0.00000000000000E+00  -5.08352354367442E-12
     -4.73391610840841E-24  -1.76745390407389E-08  -1.76796225642825E-08  -6.31587695517299E-19
      7.53251063121258E-09
      0.00000000000000E+00   2.22702363438695E-11   0.00000000000000E+00  -3.58361709315845E-11  -1.19666951962031E-23
     -2.22343463608462E-08  -2.22701825317778E-08  -3.38924308808385E-19  -4.57650088973779E-01  -4.57650089013676E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98967083841479E-08   0.00000000000000E+00   3.98967083841479E-08
      1.57642940377941E-18  -4.40053931081259E-03   1.15303386567536E-03   0.00000000000000E+00  -1.14297391885301E-11
     -1.84472549409880E-23  -1.76150961131815E-08  -1.76265258523701E-08  -1.23750509497103E-18
      7.55251063121258E-09
      0.00000000000000E+00   2.33460137507812E-11   0.00000000000000E+00  -3.02829069130402E-12  -3.57654056954635E-23
     -2.33429385844439E-08  -2.33459668751353E-08  -6.25402881282961E-19  -3.43172513954006E-01  -3.43172513995008E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10020882337350E-08   0.00000000000000E+00   4.10020882337350E-08
      2.39647116845411E-18  -2.15631311867255E-03   3.40657361348758E-03   0.00000000000000E+00  -2.63592752444717E-11
     -6.37939501146330E-23  -1.76297620833552E-08  -1.76561213585997E-08  -1.77106828717115E-18
      7.57251063121258E-09
      0.00000000000000E+00   1.48855520934355E-11   0.00000000000000E+00   2.02375145580256E-11  -4.29369964312402E-23
     -1.49058058179476E-08  -1.48855683033897E-08  -9.06750528099786E-19  -2.19854579761473E-01  -2.19854579792605E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11317652804208E-08   0.00000000000000E+00   3.11317652804208E-08
      3.01910647406253E-18  -9.54035155713711E-03  -4.42170380489899E-03   0.00000000000000E+00  -5.65848002503932E-11
     -8.13679404514538E-23  -1.61896121767806E-08  -1.62461969770311E-08  -2.11235594596274E-18
      7.59251063121258E-09
      0.00000000000000E+00   9.96019437120745E-12   0.00000000000000E+00   1.13586642666873E-11  -4.58485731945235E-23
     -9.97150998003461E-09  -9.96015131576797E-09  -1.10459863746321E-18  -1.17646749356246E-01  -1.17646749379096E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28501596771696E-08   0.00000000000000E+00   2.28501596771696E-08
      3.47610966760592E-18  -3.90088930036427E-02  -3.49476756704549E-02   0.00000000000000E+00  -1.05837899403829E-10
     -9.44285532426713E-23  -1.27841704619977E-08  -1.28900083614017E-08  -2.37151103014271E-18
      7.59751063121258E-09
      0.00000000000000E+00   8.36990274645912E-12   0.00000000000000E+00   1.46921374485072E-11  -4.64521307963744E-23
     -8.38461255411307E-09  -8.36992041666461E-09  -1.14617037016492E-18  -9.43596404279889E-02  -9.43596404479286E-02
      0.00000000000000E+00   0.00000000000000E+00   1.99397750031320E-08   0.00000000000000E+00   1.99397750031320E-08
      3.57580854262158E-18  -4.84599990706784E-02  -4.48146912406421E-02   0.00000000000000E+00  -1.48463730709204E-10
     -9.78661821398884E-23  -1.14213908557580E-08  -1.15698545864673E-08  -2.42963817245666E-18
      7.60426063121258E-09
      0.00000000000000E+00   6.61842360791159E-12   0.00000000000000E+00   1.19478648440276E-11  -4.71062428243732E-23
     -6.63036164359263E-09  -6.61841377874865E-09  -1.19039209451224E-18  -6.87008831401826E-02  -6.87008831570762E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68936287852740E-08   0.00000000000000E+00   1.68936287852740E-08
      3.68984053692218E-18  -6.37494002237682E-02  -6.05119901537314E-02   0.00000000000000E+00  -1.65609941868316E-10
     -1.02327686800499E-22  -1.01096050646569E-08  -1.02752150065253E-08  -2.49944844240994E-18
      7.61337313121258E-09
      0.00000000000000E+00   4.33314285671390E-12   0.00000000000000E+00   1.17301165792673E-11  -4.76384554580291E-23
     -4.34490631478396E-09  -4.33317619820474E-09  -1.22922078240889E-18  -4.52983563347521E-02  -4.52983563477055E-02
      0.00000000000000E+00   0.00000000000000E+00   1.29533755838012E-08   0.00000000000000E+00   1.29533755838012E-08
      3.80787817192957E-18  -8.83978789181877E-02  -8.56819127737788E-02   0.00000000000000E+00  -1.73077360100489E-10
     -1.07852132644907E-22  -8.44712202549596E-09  -8.62019938559655E-09  -2.57865738952067E-18
      7.61644859996258E-09
      0.00000000000000E+00   3.36252767390476E-12   0.00000000000000E+00   1.49819027746393E-11  -4.77540766759694E-23
     -3.37755085081178E-09  -3.36256894803719E-09  -1.23933847450729E-18  -3.90677085367864E-02  -3.90677085480313E-02
      0.00000000000000E+00   0.00000000000000E+00   1.12449038035915E-08   0.00000000000000E+00   1.12449038035915E-08
      3.84246152217427E-18  -9.72695115807681E-02  -9.47860153026187E-02   0.00000000000000E+00  -1.79952780708989E-10
     -1.09665252866711E-22  -7.70238207484452E-09  -7.88233485555362E-09  -2.60312304766697E-18
      7.62060048277508E-09
      0.00000000000000E+00   2.38089112263072E-12   0.00000000000000E+00   1.13236380185541E-11  -4.78595627881783E-23
     -2.39226513210587E-09  -2.38094149408737E-09  -1.24892041068694E-18  -3.30264138454667E-02  -3.30264138549916E-02
      0.00000000000000E+00   0.00000000000000E+00   9.52492390384914E-09   0.00000000000000E+00   9.52492390384914E-09
      3.88200789002103E-18  -1.09937175050537E-01  -1.07686310518361E-01   0.00000000000000E+00  -1.79159231903896E-10
     -1.11976614614687E-22  -6.96482317785834E-09  -7.14398240976235E-09  -2.63308747933409E-18
      7.62620552457196E-09
      0.00000000000000E+00   1.53839934822607E-12   0.00000000000000E+00   7.20801100628099E-12  -4.79460011627702E-23
     -1.54556191238308E-09  -1.53835390137684E-09  -1.25713442361056E-18  -2.76509489491474E-02  -2.76509489571293E-02
      0.00000000000000E+00   0.00000000000000E+00   7.98196136231283E-09   0.00000000000000E+00   7.98196136231283E-09
      3.92674711707783E-18  -1.27669284671493E-01  -1.25639086671300E-01   0.00000000000000E+00  -1.79722958909212E-10
     -1.14927597617535E-22  -6.26388450202636E-09  -6.44360746093569E-09  -2.66961269346728E-18
      7.63377233099774E-09
      0.00000000000000E+00   9.23958056307719E-13   0.00000000000000E+00   3.88934777631614E-12  -4.80110761369344E-23
     -9.27828526152837E-10  -9.23939178376568E-10  -1.26358055929010E-18  -2.31671205711766E-02  -2.31671205779169E-02
      0.00000000000000E+00   0.00000000000000E+00   6.74024627923818E-09   0.00000000000000E+00   6.74024627923818E-09
      3.97774925593492E-18  -1.51840689854743E-01  -1.50008134490548E-01   0.00000000000000E+00  -1.83873576507215E-10
     -1.18736774076572E-22  -5.63243352435425E-09  -5.81630710086158E-09  -2.71416869664482E-18
      7.64398751967254E-09
      0.00000000000000E+00   5.36281420554749E-13   0.00000000000000E+00   1.81289475033627E-12  -4.80565460129965E-23
     -5.38090090934893E-10  -5.36277196184605E-10  -1.26833828028074E-18  -1.95226446816620E-02  -1.95226446874294E-02
      0.00000000000000E+00   0.00000000000000E+00   5.76748637837327E-09   0.00000000000000E+00   5.76748637837327E-09
      4.03666521746937E-18  -1.83731629601140E-01  -1.82083419711501E-01   0.00000000000000E+00  -1.91613550196333E-10
     -1.23686257759959E-22  -5.03959563199212E-09  -5.23120918218857E-09  -2.76832693718863E-18
      7.65777802438353E-09
      0.00000000000000E+00   3.16405119679930E-13   0.00000000000000E+00   7.60368533024512E-13  -4.80853058431148E-23
     -3.17126272768967E-10  -3.16365904235990E-10  -1.27175677547732E-18  -1.65344476399330E-02  -1.65344476448196E-02
      0.00000000000000E+00   0.00000000000000E+00   4.88668506387140E-09   0.00000000000000E+00   4.88668506387140E-09
      4.10405507086380E-18  -2.23677133560697E-01  -2.22237148554112E-01   0.00000000000000E+00  -1.98482892123716E-10
     -1.29984598590648E-22  -4.37183626751164E-09  -4.57031915963549E-09  -2.83229829538647E-18
      7.67639520574336E-09
      0.00000000000000E+00   2.06742503454143E-13   0.00000000000000E+00   2.80737693498221E-13  -4.81024304473462E-23
     -2.07060156410648E-10  -2.06779418717198E-10  -1.27437346299829E-18  -1.40064547494322E-02  -1.40064547532808E-02
      0.00000000000000E+00   0.00000000000000E+00   3.84859257727057E-09   0.00000000000000E+00   3.84859257727057E-09
      4.17570501685495E-18  -2.68357978686161E-01  -2.67210537333545E-01   0.00000000000000E+00  -1.89163676359972E-10
     -1.37286069186012E-22  -3.45264948219317E-09  -3.64181315855328E-09  -2.90133155385665E-18
      7.69639520574336E-09
      0.00000000000000E+00   1.62105961171285E-13   0.00000000000000E+00   1.06963710398872E-13  -4.81112424890649E-23
     -1.62256285879803E-10  -1.62149322169452E-10  -1.27632642206624E-18  -1.21941310153058E-02  -1.21941310180804E-02
      0.00000000000000E+00   0.00000000000000E+00   2.77454496783794E-09   0.00000000000000E+00   2.77454496783794E-09
      4.23119591621170E-18  -3.03223344079115E-01  -3.02400242696050E-01   0.00000000000000E+00  -1.56108910826281E-10
     -1.43202473599839E-22  -2.45628673484203E-09  -2.61239564566846E-09  -2.95486949414547E-18
      7.71639520574336E-09
      0.00000000000000E+00   1.39695845292648E-13   0.00000000000000E+00   5.53255774151318E-14  -4.81143773655054E-23
     -1.39760905749184E-10  -1.39705580171817E-10  -1.27785418578021E-18  -1.09624215484092E-02  -1.09624215503060E-02
      0.00000000000000E+00   0.00000000000000E+00   1.89680764609276E-09   0.00000000000000E+00   1.89680764609276E-09
      4.26913206913356E-18  -3.26298442548336E-01  -3.25744823917632E-01   0.00000000000000E+00  -1.12042389143283E-10
     -1.47200309208169E-22  -1.64505967677762E-09  -1.75710206592105E-09  -2.99127788335335E-18
      7.73639520574336E-09
      0.00000000000000E+00   1.31062439995141E-13   0.00000000000000E+00   2.21500312631391E-14  -4.81159265773865E-23
     -1.31112837870644E-10  -1.31090687839429E-10  -1.27922491836389E-18  -1.00861764895845E-02  -1.00861764907853E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20072797444507E-09   0.00000000000000E+00   1.20072797444507E-09
      4.29314662862246E-18  -3.39376300930052E-01  -3.39039289595909E-01   0.00000000000000E+00  -6.53537975095924E-11
     -1.49457615060663E-22  -1.00428348909583E-09  -1.06963728660557E-09  -3.01392171025857E-18
      7.75639520574336E-09
      0.00000000000000E+00   1.17836797837257E-13   0.00000000000000E+00   3.52123520732036E-14  -4.81129565385045E-23
     -1.17906749417646E-10  -1.17871537065621E-10  -1.28034164231593E-18  -9.52617060762270E-03  -9.52617060836752E-03
      0.00000000000000E+00   0.00000000000000E+00   7.44819917504718E-10   0.00000000000000E+00   7.44819917504718E-10
      4.30804302697256E-18  -3.46017412337945E-01  -3.45819885195271E-01   0.00000000000000E+00  -3.15932643404930E-11
     -1.50535437140104E-22  -5.95355116098513E-10  -6.26948380439157E-10  -3.02770138465662E-18
      7.76639520574336E-09
      0.00000000000000E+00   9.77228003888085E-14   0.00000000000000E+00   1.05005945273288E-13  -4.81071148601601E-23
     -9.78203549906054E-11  -9.77153490453802E-11  -1.28070092141193E-18  -9.38317587245470E-03  -9.38317587307284E-03
      0.00000000000000E+00   0.00000000000000E+00   6.18143031640748E-10   0.00000000000000E+00   6.18143031640748E-10
      4.31422445728896E-18  -3.48686112596221E-01  -3.48522148309666E-01   0.00000000000000E+00  -2.37437384343231E-11
     -1.50935289635589E-22  -4.96683944160806E-10  -5.20427682595281E-10  -3.03352353587703E-18
      7.77314520574336E-09
      0.00000000000000E+00   8.26602634867741E-14   0.00000000000000E+00   1.18591671917266E-13  -4.81013263756259E-23
     -8.27446162257664E-11  -8.26260245538972E-11  -1.28084283152087E-18  -9.33966517136420E-03  -9.33966517200551E-03
      0.00000000000000E+00   0.00000000000000E+00   6.41309894183994E-10   0.00000000000000E+00   6.41309894183994E-10
      4.31855329907470E-18  -3.50780950672313E-01  -3.50604931984533E-01   0.00000000000000E+00  -2.80851629046361E-11
     -1.51248696603071E-22  -5.30598706725446E-10  -5.58683869630234E-10  -3.03771046755384E-18
      7.77770145574336E-09
      0.00000000000000E+00   7.65985108310773E-14   0.00000000000000E+00   7.50509756914817E-14  -4.80972296464957E-23
     -7.66807079641849E-11  -7.66056569885415E-11  -1.28091179882261E-18  -9.32118678994222E-03  -9.32118679062191E-03
      0.00000000000000E+00   0.00000000000000E+00   6.79689398733953E-10   0.00000000000000E+00   6.79689398733953E-10
      4.32165013389769E-18  -3.52371896202828E-01  -3.52181887559472E-01   0.00000000000000E+00  -3.23201605496262E-11
     -1.51490473333695E-22  -5.70763581195719E-10  -6.03083741745497E-10  -3.04073833507508E-18
      7.78385239324336E-09
      0.00000000000000E+00   6.65874344754569E-14   0.00000000000000E+00   9.08094416380368E-14  -4.80905385735293E-23
     -6.67237660522010E-11  -6.66329566106111E-11  -1.28094483582885E-18  -9.31657972535867E-03  -9.31657972614216E-03
      0.00000000000000E+00   0.00000000000000E+00   7.83485193205353E-10   0.00000000000000E+00   7.83485193205353E-10
      4.32646930235327E-18  -3.55109154016205E-01  -3.54883298187046E-01   0.00000000000000E+00  -4.28812424466189E-11
     -1.51919726458424E-22  -6.73970994148082E-10  -7.16852236594853E-10  -3.04552446652442E-18
      7.79215615886836E-09
      0.00000000000000E+00   4.95043133548569E-14   0.00000000000000E+00   1.15440783604254E-13  -4.80788747295253E-23
     -4.95962617737816E-11  -4.94808209902255E-11  -1.28084992999632E-18  -9.35110223482633E-03  -9.35110223583049E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00416621504431E-09   0.00000000000000E+00   1.00416621504431E-09
      4.33480766325154E-18  -3.60431640910952E-01  -3.60130846669249E-01   0.00000000000000E+00  -6.48444530324238E-11
     -1.52787070782249E-22  -8.89840941021499E-10  -9.54685394054075E-10  -3.05395773325522E-18
      7.79776120066523E-09
      0.00000000000000E+00   2.99413843296537E-14   0.00000000000000E+00   1.88299667186213E-13  -4.80686113233127E-23
     -3.01180733286747E-11  -2.99297736615366E-11  -1.28067789858665E-18  -9.41120626898119E-03  -9.41120627020009E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21890206512990E-09   0.00000000000000E+00   1.21890206512990E-09
      4.34163966027289E-18  -3.65127596799483E-01  -3.64752981162336E-01   0.00000000000000E+00  -8.74534264255472E-11
     -1.53568376091969E-22  -1.10151886504251E-09  -1.18897229146821E-09  -3.06096176168624E-18
      7.80154460387812E-09
      0.00000000000000E+00   1.94710842879957E-14   0.00000000000000E+00   1.55326994270488E-13  -4.80611957913696E-23
     -1.96319445941706E-11  -1.94766175999482E-11  -1.28052305522020E-18  -9.46049354997413E-03  -9.46049355135989E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38576853241945E-09   0.00000000000000E+00   1.38576853241945E-09
      4.34688258139077E-18  -3.68848054506843E-01  -3.68417567183393E-01   0.00000000000000E+00  -1.04942488670935E-10
     -1.54196884685468E-22  -1.26134942614814E-09  -1.36629191481923E-09  -3.06635952617057E-18
      7.80665219821553E-09
      0.00000000000000E+00   2.11242895577312E-14   0.00000000000000E+00   3.92241997047998E-15  -4.80523997182712E-23
     -2.11135721253354E-11  -2.11096497054130E-11  -1.28032399798859E-18  -9.49996142764154E-03  -9.49996142921682E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57526924832368E-09   0.00000000000000E+00   1.57526924832368E-09
      4.35492841768339E-18  -3.74597433561282E-01  -3.74107751384136E-01   0.00000000000000E+00  -1.23334899100592E-10
     -1.55188509217489E-22  -1.43082469951742E-09  -1.55415959861817E-09  -3.07460441969479E-18
      7.81354745057102E-09
      0.00000000000000E+00   3.22375027598419E-14   0.00000000000000E+00  -6.32148646352699E-14  -4.80425462282335E-23
     -3.21853272126977E-11  -3.22485420773811E-11  -1.28013518491457E-18  -9.48497290165244E-03  -9.48497290337469E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72224722612731E-09   0.00000000000000E+00   1.72224722612731E-09
      4.36680374692609E-18  -3.83022092182196E-01  -3.82489608761093E-01   0.00000000000000E+00  -1.38136736357059E-10
     -1.56673930098694E-22  -1.55186194769274E-09  -1.68999868404996E-09  -3.08666856201152E-18
      7.82285604125094E-09
      0.00000000000000E+00   4.63815922898010E-14   0.00000000000000E+00  -6.16062988345485E-14  -4.80317333885825E-23
     -4.62835412664506E-11  -4.63451475653332E-11  -1.28001714336878E-18  -9.37097641784194E-03  -9.37097641963298E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79104079769040E-09   0.00000000000000E+00   1.79104079769040E-09
      4.38347581260281E-18  -3.94718736902608E-01  -3.94169018935947E-01   0.00000000000000E+00  -1.47396791361717E-10
     -1.58782607987622E-22  -1.59729885876300E-09  -1.74469565012488E-09  -3.10345866923403E-18
      7.83542263866882E-09
      0.00000000000000E+00   6.51179186801365E-14   0.00000000000000E+00  -6.42941189319046E-14  -4.80216756056117E-23
     -6.50427086530632E-11  -6.51070027720431E-11  -1.28010331795937E-18  -9.07216737415160E-03  -9.07216737594438E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79277419860157E-09   0.00000000000000E+00   1.79277419860157E-09
      4.40600488421782E-18  -4.10261020267360E-01  -4.09716667300518E-01   0.00000000000000E+00  -1.52060259350335E-10
     -1.61661067996758E-22  -1.57560693647909E-09  -1.72766719582959E-09  -3.12590156625844E-18
      7.85238754518297E-09
      0.00000000000000E+00   1.01580279351525E-13   0.00000000000000E+00  -1.03290181772398E-13  -4.80202371919541E-23
     -1.01411022999511E-10  -1.01514313181331E-10  -1.28085301660427E-18  -8.30742799108456E-03  -8.30742799285730E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77274763528335E-09   0.00000000000000E+00   1.77274763528335E-09
      4.43607938212357E-18  -4.30269388198776E-01  -4.29742816134588E-01   0.00000000000000E+00  -1.55081702029870E-10
     -1.65524153379886E-22  -1.51615162007207E-09  -1.67123332210210E-09  -3.15522636551930E-18
      7.87238754518297E-09
      0.00000000000000E+00   1.51268282180797E-13   0.00000000000000E+00  -1.29470268916603E-13  -4.80370500256821E-23
     -1.51165086415114E-10  -1.51294556684079E-10  -1.28275035756955E-18  -6.82760024566259E-03  -6.82760024741966E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75706744584504E-09   0.00000000000000E+00   1.75706744584504E-09
      4.47122073104047E-18  -4.52448219336085E-01  -4.51942271763423E-01   0.00000000000000E+00  -1.58852711940965E-10
     -1.70053532021889E-22  -1.44692017721970E-09  -1.60577288916083E-09  -3.18847037347092E-18
      7.89238754518297E-09
      0.00000000000000E+00   1.72117037526905E-13   0.00000000000000E+00  -6.24943554432949E-14  -4.80597683168924E-23
     -1.72098369701298E-10  -1.72160864056789E-10  -1.28508048618506E-18  -5.11858118566385E-03  -5.11858118736891E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70506743615262E-09   0.00000000000000E+00   1.70506743615262E-09
      4.50532207976352E-18  -4.73415148610231E-01  -4.72932158588772E-01   0.00000000000000E+00  -1.61745424432991E-10
     -1.74530966441844E-22  -1.37116114766272E-09  -1.53290657209588E-09  -3.22024159357847E-18
      7.91238754518297E-09
      0.00000000000000E+00   1.82954716517393E-13   0.00000000000000E+00  -3.97956086817898E-14  -4.80860109835741E-23
     -1.82919019328946E-10  -1.82958814937676E-10  -1.28764029261726E-18  -3.29693341771306E-03  -3.29693341936315E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65008487747969E-09   0.00000000000000E+00   1.65008487747969E-09
      4.53832377731312E-18  -4.93372798574379E-01  -4.92910533488445E-01   0.00000000000000E+00  -1.64551367546604E-10
     -1.78960834331970E-22  -1.30257469499525E-09  -1.46712606254204E-09  -3.25068348469586E-18
      7.93238754518297E-09
      0.00000000000000E+00   8.57829845518300E-14   0.00000000000000E+00   2.42782269256606E-13  -4.80716336030428E-23
     -8.59718023219628E-11  -8.57290200527543E-11  -1.28827310642535E-18  -2.66495168552876E-03  -2.66495168695948E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43072158301472E-09   0.00000000000000E+00   1.43072158301472E-09
      4.56693820897341E-18  -5.12570072309638E-01  -5.12146289364311E-01   0.00000000000000E+00  -1.57717288089443E-10
     -1.83097515135586E-22  -1.18727527487225E-09  -1.34499256296188E-09  -3.27866510254807E-18
      7.95238754518297E-09
      0.00000000000000E+00  -1.69462724621608E-12   0.00000000000000E+00   4.67797743528927E-12  -4.73292128507242E-23
      1.68993952050395E-09   1.69461749793919E-09  -1.25346045558704E-18  -2.32355120478939E-02  -2.32355120464363E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.45764400387600E-09   0.00000000000000E+00  -1.45764400387600E-09
      4.53778532889589E-18  -5.33068590128709E-01  -5.32993950106802E-01   0.00000000000000E+00   6.38306227954625E-12
     -1.82924299645221E-22  -2.43356556342649E-10  -2.36973494063285E-10  -3.28432487330886E-18
      7.97238754518297E-09
      0.00000000000000E+00  -3.46732251905855E-12   0.00000000000000E+00   4.87019321965357E-12  -4.59993675066285E-23
      3.46245698815808E-09   3.46732718137769E-09  -1.18404607502681E-18  -6.28511439130830E-02  -6.28511439088554E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.22761527883897E-09   0.00000000000000E+00  -4.22761527883897E-09
      4.45323302331911E-18  -5.54416913039397E-01  -5.54656520920433E-01   0.00000000000000E+00   1.55540923381833E-10
     -1.78782401531191E-22   6.04747174079589E-10   7.60288097461244E-10  -3.26918694829230E-18
      7.97488754518296E-09
      0.00000000000000E+00  -4.05779233456574E-12   0.00000000000000E+00   1.20180984149526E-11  -4.57844738026810E-23
      4.04575358294618E-09   4.05777168136109E-09  -1.17392304509012E-18  -6.84938033702656E-02  -6.84938033651723E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.09323808184041E-09   0.00000000000000E+00  -5.09323808184041E-09
      4.44049992811451E-18  -5.57106654566407E-01  -5.57432971895566E-01   0.00000000000000E+00   1.93080717234120E-10
     -1.78134958277580E-22   8.42385683246941E-10   1.03546640048088E-09  -3.26657688302439E-18
      7.97826254518297E-09
      0.00000000000000E+00  -4.59517589196698E-12   0.00000000000000E+00   8.45868374618902E-12  -4.54861268938155E-23
      4.58671542575706E-09   4.59517410950321E-09  -1.15851668526320E-18  -7.69822582054917E-02  -7.69822581995935E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.89812657318910E-09   0.00000000000000E+00  -5.89812657318910E-09
      4.42059375093000E-18  -5.60798805031099E-01  -5.61209409358842E-01   0.00000000000000E+00   2.28692382952318E-10
     -1.77091619012872E-22   1.07426008073421E-09   1.30295246368635E-09  -3.26207706566680E-18
      7.98281879518297E-09
      0.00000000000000E+00  -5.20401465491567E-12   0.00000000000000E+00   7.18900750820006E-12  -4.50481654866950E-23
      5.19681564751043E-09   5.20400465501858E-09  -1.13514805141046E-18  -8.96685123699525E-02  -8.96685123631822E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.77035697418572E-09   0.00000000000000E+00  -6.77035697418572E-09
      4.38974631196637E-18  -5.65841764375223E-01  -5.66335370464832E-01   0.00000000000000E+00   2.64043175116459E-10
     -1.75449617232330E-22   1.30230914405089E-09   1.56635231916717E-09  -3.25459826055591E-18
      7.98589426393297E-09
      0.00000000000000E+00  -5.62200005394713E-12   0.00000000000000E+00   7.29060857246253E-12  -4.47336967196003E-23
      5.61470374155307E-09   5.62199435012549E-09  -1.11822476057446E-18  -9.87229948340522E-02  -9.87229948267171E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.33512648470781E-09   0.00000000000000E+00  -7.33512648470781E-09
      4.36718735968535E-18  -5.69255936454133E-01  -5.69795796164276E-01   0.00000000000000E+00   2.82487741287032E-10
     -1.74253472420009E-22   1.43064439329617E-09   1.71313213458303E-09  -3.24896259911089E-18
      7.99004614674547E-09
      0.00000000000000E+00  -6.06845732151292E-12   0.00000000000000E+00   5.90816605209677E-12  -4.42912794409622E-23
      6.06256363756454E-09   6.06847180361659E-09  -1.09388333190398E-18  -1.11542813848943E-01  -1.11542813841059E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.88363181058848E-09   0.00000000000000E+00  -7.88363181058848E-09
      4.33445544427089E-18  -5.73850622969097E-01  -5.74422640119444E-01   0.00000000000000E+00   2.98252510219915E-10
     -1.72531863365136E-22   1.51690749675200E-09   1.81516000697175E-09  -3.24057211236690E-18
      7.99565118854234E-09
      0.00000000000000E+00  -6.56809269192186E-12   0.00000000000000E+00   4.96968195050865E-12  -4.36442763020467E-23
      6.56316638933065E-09   6.56813607128111E-09  -1.05928414842917E-18  -1.29373131607804E-01  -1.29373131599450E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.35393032477078E-09   0.00000000000000E+00  -8.35393032477078E-09
      4.28763131563237E-18  -5.79942887563607E-01  -5.80505671459429E-01   0.00000000000000E+00   3.05260763640591E-10
     -1.70121479899642E-22   1.48053348984932E-09   1.78579425348974E-09  -3.22834716720320E-18
      8.00321799496812E-09
      0.00000000000000E+00  -7.26537793680140E-12   0.00000000000000E+00   5.05897032751690E-12  -4.24883720239101E-23
      7.26035200174568E-09   7.26541097207315E-09  -1.01092341331224E-18  -1.53574400105408E-01  -1.53574400096705E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.70286074888147E-09   0.00000000000000E+00  -8.70286074888147E-09
      4.22177845299505E-18  -5.87771107758041E-01  -5.88224181135424E-01   0.00000000000000E+00   3.01229778329105E-10
     -1.66854384569761E-22   1.13621999847944E-09   1.43744977680838E-09  -3.21085503968281E-18
      8.01343318364293E-09
      0.00000000000000E+00  -8.76446773750266E-12   0.00000000000000E+00   7.66461115758578E-12  -3.90002353603787E-23
      8.75683385326192E-09   8.76449846441946E-09  -9.44824220998543E-19  -1.85417812785730E-01  -1.85417812776779E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.95062543197763E-09   0.00000000000000E+00  -8.95062543197763E-09
      4.13034612544990E-18  -5.96942116022600E-01  -5.97001054485324E-01   0.00000000000000E+00   2.89056814761527E-10
     -1.62521735126094E-22  -1.02929847203183E-10   1.86126967558181E-10  -3.18552190445135E-18
      8.02722368835391E-09
      0.00000000000000E+00  -1.32868107528641E-11   0.00000000000000E+00   1.64871073472830E-11  -2.27844342440559E-23
      1.32703084096796E-08   1.32867955170269E-08  -8.58372714457104E-19  -2.25201323380242E-01  -2.25201323371033E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.20856277199868E-09   0.00000000000000E+00  -9.20856277199868E-09
      4.00335539716124E-18  -6.03734820613798E-01  -6.02450550169016E-01   0.00000000000000E+00   2.80978049237608E-10
     -1.56616290646714E-22  -4.35921079426554E-09  -4.07823274502809E-09  -3.14498268270413E-18
      8.04584086971374E-09
      0.00000000000000E+00  -2.65957560873951E-11   0.00000000000000E+00   3.54757593403188E-11   4.00112291631027E-23
      2.65602436571801E-08   2.65957194165204E-08  -7.57908534448864E-19  -2.69542639010253E-01  -2.69542639000559E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.69467750504940E-09   0.00000000000000E+00  -9.69467750504940E-09
      3.82286782782465E-18  -5.91454310601689E-01  -5.86130807467618E-01   0.00000000000000E+00   3.00583430482390E-10
     -1.47371803222521E-22  -1.72016253419533E-08  -1.69010419114711E-08  -3.06495929337578E-18
      8.06584086971374E-09
      0.00000000000000E+00  -4.67676157202842E-11   0.00000000000000E+00   4.99859394714572E-11   1.36215690308298E-22
      4.67175613579378E-08   4.67675472974094E-08  -6.79219407269110E-19  -3.04040946435697E-01  -3.04040946425322E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03751055855533E-08   0.00000000000000E+00  -1.03751055855533E-08
      3.61536571611358E-18  -5.42361641742539E-01  -5.30897643328254E-01   0.00000000000000E+00   3.19139047444184E-10
     -1.34614005534760E-22  -3.67115807593002E-08  -3.63924417118561E-08  -2.93614630884447E-18
      8.08584086971374E-09
      0.00000000000000E+00  -6.25705130489485E-11   0.00000000000000E+00   3.93215964647251E-11   2.10302449223152E-22
      6.25311556860498E-08   6.25704772825148E-08  -6.29737175006710E-19  -3.26811893491072E-01  -3.26811893480076E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09964295596494E-08   0.00000000000000E+00  -1.09964295596494E-08
      3.39543712492059E-18  -4.57749965466782E-01  -4.41502523129670E-01   0.00000000000000E+00   2.94753575741345E-10
     -1.18767346335682E-22  -5.18688012986066E-08  -5.15740477228653E-08  -2.76569994991389E-18
      8.10584086971374E-09
      0.00000000000000E+00  -6.52409906279946E-11   0.00000000000000E+00   6.74954419009995E-12   2.23352899232590E-22
      6.52342406392210E-08   6.52409901834114E-08  -6.05906874345563E-19  -3.39627300109029E-01  -3.39627300097478E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15518847980635E-08   0.00000000000000E+00  -1.15518847980635E-08
      3.16439942895932E-18  -3.42926268385679E-01  -3.26011724911852E-01   0.00000000000000E+00   2.46227913547400E-10
     -1.02415565156911E-22  -5.39353332988951E-08  -5.36891053853478E-08  -2.55849255461376E-18
      8.12584086971374E-09
      0.00000000000000E+00  -5.68690672973169E-11   0.00000000000000E+00  -2.07279269463634E-11   1.85515165733380E-22
      5.68898161752025E-08   5.68690882482564E-08  -5.98367673320178E-19  -3.46202522085034E-01  -3.46202522073118E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19163969308041E-08   0.00000000000000E+00  -1.19163969308041E-08
      2.92607149034324E-18  -2.19453994905855E-01  -2.05291394749726E-01   0.00000000000000E+00   1.73045907997688E-10
     -8.58352082891350E-23  -4.51257372254499E-08  -4.49526913174523E-08  -2.32770381702306E-18
      8.14584086971374E-09
      0.00000000000000E+00  -4.95078952996080E-11   0.00000000000000E+00  -1.82644844763146E-11   1.45310608697509E-22
      4.95261453319790E-08   4.95078808475028E-08  -5.89576288946796E-19  -3.53331079236616E-01  -3.53331079224774E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18420055494180E-08   0.00000000000000E+00  -1.18420055494180E-08
      2.68923137935488E-18  -1.17268040027740E-01  -1.05400971362418E-01   0.00000000000000E+00   9.25390969834971E-11
     -7.39481911224143E-23  -3.77584143950683E-08  -3.76658752980849E-08  -2.09965509040809E-18
      8.16584086971374E-09
      0.00000000000000E+00  -4.23232488868120E-11   0.00000000000000E+00  -1.77828005211423E-11   1.22647389858651E-22
      4.23410745657237E-08   4.23232917652027E-08  -5.65696901234790E-19  -3.65709222777159E-01  -3.65709222765755E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14040725073274E-08   0.00000000000000E+00  -1.14040725073274E-08
      2.46114992920833E-18  -5.09854537644180E-02  -4.12439013747790E-02   0.00000000000000E+00   5.05220383074588E-11
     -1.08809205895020E-23  -3.09697412961828E-08  -3.09192192578753E-08  -1.89545302797354E-18
      8.17584086971374E-09
      0.00000000000000E+00  -3.70092960814589E-11   0.00000000000000E+00  -2.62272904130723E-11   1.22364294709995E-22
      3.70355206266660E-08   3.70092933362530E-08  -5.43118509813761E-19  -3.75355812930253E-01  -3.75355812919353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08999696572525E-08   0.00000000000000E+00  -1.08999696572525E-08
      2.35215023263581E-18  -3.32107254955349E-02  -2.49845775218302E-02   0.00000000000000E+00   4.08355521077320E-11
      5.28158636098852E-23  -2.61501592311084E-08  -2.61093236790006E-08  -1.80903172282205E-18
      8.18934086971374E-09
      0.00000000000000E+00  -3.33858375091476E-11   0.00000000000000E+00  -1.32722402922642E-11   1.33365657997460E-22
      3.33990725724200E-08   3.33858003321278E-08  -5.03490319441034E-19  -3.91521352776240E-01  -3.91521352765809E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04307373881692E-08   0.00000000000000E+00  -1.04307373881692E-08
      2.21133527789553E-18  -2.30317050137818E-02  -1.57993358969108E-02   0.00000000000000E+00   2.19320364797295E-11
      1.18678934610553E-22  -2.29769949804385E-08  -2.29550629439587E-08  -1.70784495845449E-18
      8.20756586971374E-09
      0.00000000000000E+00  -3.13321891851873E-11   0.00000000000000E+00  -5.54012055045613E-12   1.41262483446163E-22
      3.13377428753611E-08   3.13322027548108E-08  -4.48615072188982E-19  -4.13819897001656E-01  -4.13819896991500E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01557447754447E-08   0.00000000000000E+00  -1.01557447754447E-08
      2.02624682936305E-18  -1.74275679493654E-02  -1.07555628486466E-02   0.00000000000000E+00   1.18259692688830E-11
      1.65686442122626E-22  -2.11882839486352E-08  -2.11764579793661E-08  -1.57763175717406E-18
      8.22756586971374E-09
      0.00000000000000E+00  -2.98956456505244E-11   0.00000000000000E+00  -3.51082385448392E-12   1.29638527414793E-22
      2.98991330063721E-08   2.98956221825178E-08  -3.92176051388312E-19  -4.37027482746079E-01  -4.37027482736100E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97894867517980E-09   0.00000000000000E+00  -9.97894867517980E-09
      1.82666785585945E-18  -1.43299272253805E-02  -8.05482937690567E-03   0.00000000000000E+00   8.32121048146039E-12
      1.69260322980618E-22  -1.99249947178195E-08  -1.99166735073379E-08  -1.43449180447114E-18
      8.24756586971374E-09
      0.00000000000000E+00  -2.86278208981117E-11   0.00000000000000E+00  -3.09608586469242E-12   1.02396569418500E-22
      2.86309236218553E-08   2.86278275359907E-08  -3.40031282257424E-19  -4.58831952066501E-01  -4.58831952056674E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.82606393742376E-09   0.00000000000000E+00  -9.82606393742376E-09
      1.63014657711097E-18  -1.23929195271584E-02  -6.46908728077303E-03   0.00000000000000E+00   6.91713287485951E-12
      1.38615581709935E-22  -1.88086807314420E-08  -1.88017635985670E-08  -1.29011529485355E-18
      8.26756586971374E-09
      0.00000000000000E+00  -2.75928225545201E-11   0.00000000000000E+00  -2.52585878445468E-12   7.06847629034859E-23
      2.75953784909432E-08   2.75928526321589E-08  -2.91457018883788E-19  -4.79501127621361E-01  -4.79501127611667E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.69424751696302E-09   0.00000000000000E+00  -9.69424751696302E-09
      1.43626162677171E-18  -1.10957196031925E-02  -5.45643868695859E-03   0.00000000000000E+00   5.71883291458240E-12
      9.49168949598808E-23  -1.79043239481105E-08  -1.78986051151958E-08  -1.14480460788793E-18
      8.28756586971374E-09
      0.00000000000000E+00  -2.67371969826947E-11   0.00000000000000E+00  -2.08618905007804E-12   4.34067818311163E-23
      2.67392825720242E-08   2.67371963829742E-08  -2.46060575937932E-19  -4.99165704112152E-01  -4.99165704102604E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.54840682867184E-09   0.00000000000000E+00  -9.54840682867184E-09
      1.24529349019828E-18  -1.01834004075444E-02  -4.76775583354935E-03   0.00000000000000E+00   4.74983957947077E-12
      5.50485519945549E-23  -1.71935393938819E-08  -1.71887895543024E-08  -9.99232914260345E-19
      8.30756586971374E-09
      0.00000000000000E+00  -2.64042598103175E-11   0.00000000000000E+00  -7.99121736714028E-13   2.46040879431066E-23
      2.64049764910657E-08   2.64041773693290E-08  -2.02122737366800E-19  -5.18594224072582E-01  -5.18594224062865E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71729596353349E-09   0.00000000000000E+00  -9.71729596353349E-09
      1.05094757092761E-18  -9.57079225385435E-03  -4.31327974792135E-03   0.00000000000000E+00   3.93910092382677E-12
      2.70290426746356E-23  -1.66908205067193E-08  -1.66868814057955E-08  -8.48824833560807E-19
      8.32756586971374E-09
      0.00000000000000E+00  -2.72927657980631E-11   0.00000000000000E+00   2.21553557179165E-12   1.38753176613436E-23
      2.72905662038266E-08   2.72927817393984E-08  -1.56279240357176E-19  -5.39398859920686E-01  -5.39398859910003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06836436759718E-08   0.00000000000000E+00  -1.06836436759718E-08
      8.37274697408172E-19  -9.33080538979935E-03  -4.09778446033800E-03   0.00000000000000E+00   2.83060961087733E-12
      1.09121789642809E-23  -1.66119686730376E-08  -1.66091380634267E-08  -6.80995457050996E-19
      8.34756586971374E-09
      0.00000000000000E+00  -2.82345417333890E-11   0.00000000000000E+00   2.35278567830425E-12   8.47206577360280E-24
      2.82321438436295E-08   2.82344966293079E-08  -1.10116422911311E-19  -5.60908877413729E-01  -5.60908877402323E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14066554773407E-08   0.00000000000000E+00  -1.14066554773407E-08
      6.09141587861358E-19  -9.26139043221911E-03  -3.95946037629449E-03   0.00000000000000E+00   1.97728265249860E-12
      3.02686810627896E-24  -1.68298184346196E-08  -1.68278411519671E-08  -4.99025164950046E-19
      8.35006586971374E-09
      0.00000000000000E+00  -2.85071369134210E-11   0.00000000000000E+00   5.35634699441725E-12   7.84711270572773E-24
      2.85017854541314E-08   2.85071418011258E-08  -1.04408111022518E-19  -5.63618939415940E-01  -5.63618939404300E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16402387208660E-08   0.00000000000000E+00  -1.16402387208660E-08
      5.80040991059192E-19  -9.27499530950568E-03  -3.96075762200476E-03   0.00000000000000E+00   1.65325136151874E-12
      2.05427690049011E-24  -1.68685563316205E-08  -1.68669030802589E-08  -4.75632880036675E-19
      8.35344086971374E-09
      0.00000000000000E+00  -2.88973852018158E-11   0.00000000000000E+00   5.73516799097920E-12   7.17612500459419E-24
      2.88916256720655E-08   2.88973608400564E-08  -9.66229481733128E-20  -5.67330572701734E-01  -5.67330572689881E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18523761451934E-08   0.00000000000000E+00  -1.18523761451934E-08
      5.40039221569165E-19  -9.34426574597188E-03  -3.97391901847382E-03   0.00000000000000E+00  -1.59093796030031E-13
      1.02596317631034E-24  -1.70448256010677E-08  -1.70449846948637E-08  -4.43416273395853E-19
      8.35799711971374E-09
      0.00000000000000E+00  -2.92900214533779E-11   0.00000000000000E+00   4.30115383776407E-12   6.51268534579455E-24
      2.92857312213408E-08   2.92900323751786E-08  -8.61112271785377E-20  -5.72361326372178E-01  -5.72361326360183E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19956163232174E-08   0.00000000000000E+00  -1.19956163232174E-08
      4.85384194696506E-19  -9.42929658173283E-03  -3.98036117120462E-03   0.00000000000000E+00  -2.98583469336011E-13
      4.92861559943734E-26  -1.72941174684921E-08  -1.72944160519615E-08  -3.99272967517969E-19
      8.36414805721374E-09
      0.00000000000000E+00  -2.94918961857601E-11   0.00000000000000E+00   1.66806184631073E-12   5.87632361989880E-24
      2.94902539612372E-08   2.94919220230835E-08  -7.21793623505480E-20  -5.79059410416985E-01  -5.79059410405015E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19706298224652E-08   0.00000000000000E+00  -1.19706298224652E-08
      4.11753598822887E-19  -9.47350640818112E-03  -3.95308891835840E-03   0.00000000000000E+00   5.12017604740061E-13
     -7.85214443566420E-25  -1.75218042182230E-08  -1.75212922006183E-08  -3.39574236472338E-19
      8.37245182283874E-09
      0.00000000000000E+00  -2.92155353715026E-11   0.00000000000000E+00  -1.60360143634885E-12   5.25694202884913E-24
      2.92171424078157E-08   2.92155388063794E-08  -5.43947777044244E-20  -5.87660216897236E-01  -5.87660216885680E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15560391234624E-08   0.00000000000000E+00  -1.15560391234624E-08
      3.15794958388324E-19  -9.42574900164066E-03  -3.86178596804316E-03   0.00000000000000E+00   1.36173029164568E-12
     -1.42034480855242E-24  -1.76608614132085E-08  -1.76594996829168E-08  -2.61400180683899E-19
      8.38366190643249E-09
      0.00000000000000E+00  -2.77596125972889E-11   0.00000000000000E+00  -6.38024184872045E-12   4.57202143839975E-24
      2.77660308073687E-08   2.77596505655200E-08  -3.40140274928127E-20  -5.97562689850050E-01  -5.97562689839992E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00580607830927E-08   0.00000000000000E+00  -1.00580607830927E-08
      2.03043256218836E-19  -9.22910942780407E-03  -3.65188408548460E-03   0.00000000000000E+00   1.64961774269559E-12
     -1.86111716422022E-24  -1.77032394001701E-08  -1.77015897824274E-08  -1.69029228726024E-19
      8.39879551928405E-09
      0.00000000000000E+00  -2.25723136845450E-11   0.00000000000000E+00  -1.68930768187101E-11   3.49364026339934E-24
      2.25892203717070E-08   2.25723272948883E-08  -2.11349531265791E-20  -6.03639272775915E-01  -6.03639272771036E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.87922768883242E-09   0.00000000000000E+00  -4.87922768883242E-09
      1.29202913361422E-19  -8.71115598509043E-03  -3.13660411930678E-03   0.00000000000000E+00   9.00723494556148E-13
     -2.19663216455424E-24  -1.76940003295504E-08  -1.76930996060559E-08  -1.08067960234844E-19
      8.41879551928405E-09
      0.00000000000000E+00  -7.86181766022708E-12   0.00000000000000E+00  -3.62634351077783E-11   1.15361490038598E-24
      7.89808597251432E-09   7.86182253740654E-09  -5.74766757746334E-20  -5.84963221141378E-01  -5.84963221151205E-01
      0.00000000000000E+00   0.00000000000000E+00   9.82674331456655E-09   0.00000000000000E+00   9.82674331456655E-09
      3.25737779652754E-19  -7.45811596171504E-03  -1.88499139290378E-03   0.00000000000000E+00  -1.72501826984821E-12
     -2.81220795633847E-24  -1.76868408337033E-08  -1.76885658519731E-08  -2.68261103878121E-19
      8.43879551928405E-09
      0.00000000000000E+00   1.11099986363085E-11   0.00000000000000E+00  -4.65761584981234E-11  -3.11318708009804E-24
     -1.10632272998067E-08  -1.11098034583049E-08  -1.73122518985208E-19  -5.29659273286878E-01  -5.29659273315662E-01
      0.00000000000000E+00   0.00000000000000E+00   2.87836528564630E-08   0.00000000000000E+00   2.87836528564630E-08
      9.01410836782013E-19  -5.77454835563857E-03  -2.06126650447653E-04   0.00000000000000E+00  -6.17773938961917E-12
     -5.66211868263166E-24  -1.76676716587684E-08  -1.76738493981581E-08  -7.28288317796804E-19
      8.45879551928405E-09
      0.00000000000000E+00   2.37031979337813E-11   0.00000000000000E+00  -3.12547582381717E-11  -1.54778748877325E-23
     -2.36719103612233E-08  -2.37031651194615E-08  -3.83092500978377E-19  -4.39568724182055E-01  -4.39568724223377E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13213788818016E-08   0.00000000000000E+00   4.13213788818016E-08
      1.72783841441804E-18  -4.07838668368171E-03   1.47256512295199E-03   0.00000000000000E+00  -1.31456514518223E-11
     -2.45174188971684E-23  -1.76050681108882E-08  -1.76182137623401E-08  -1.34474591343967E-18
      8.47879551928405E-09
      0.00000000000000E+00   2.20120607875791E-11   0.00000000000000E+00   3.75175186915108E-12  -3.83305146486021E-23
     -2.20158142188578E-08  -2.20120624669887E-08  -6.80200635552969E-19  -3.20814369071905E-01  -3.20814369111580E-01
      0.00000000000000E+00   0.00000000000000E+00   3.96750162510896E-08   0.00000000000000E+00   3.96750162510896E-08
      2.52133873943984E-18  -1.73224248131080E-03   3.83279395013831E-03   0.00000000000000E+00  -3.06699587868715E-11
     -6.92442328174370E-23  -1.76322838253139E-08  -1.76629537841009E-08  -1.84113810388687E-18
      8.49879551928405E-09
      0.00000000000000E+00   1.38055498286122E-11   0.00000000000000E+00   1.95774859185001E-11  -4.35339314465279E-23
     -1.38251098313893E-08  -1.38055323454709E-08  -9.47436782957125E-19  -1.99977902202112E-01  -1.99977902231551E-01
      0.00000000000000E+00   0.00000000000000E+00   2.94396971761621E-08   0.00000000000000E+00   2.94396971761621E-08
      3.11013268296308E-18  -1.33506150286044E-02  -8.42480045444616E-03   0.00000000000000E+00  -6.33727759022913E-11
     -8.36047695624843E-23  -1.55707920547889E-08  -1.56341648306912E-08  -2.16269590000595E-18
      8.51879551928405E-09
      0.00000000000000E+00   9.27668583690903E-12   0.00000000000000E+00   1.03577902323559E-11  -4.62613891317395E-23
     -9.28702930666537E-09  -9.27667151643306E-09  -1.13163808750111E-18  -1.02518965830560E-01  -1.02518965852183E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16227513181059E-08   0.00000000000000E+00   2.16227513181059E-08
      3.54258770932519E-18  -4.60577271120476E-02  -4.21678833316618E-02   0.00000000000000E+00  -1.17040698799064E-10
     -9.67525890372317E-23  -1.22290391028737E-08  -1.23460798016729E-08  -2.41094962182409E-18
      8.52004551928405E-09
      0.00000000000000E+00   8.67629678978343E-12   0.00000000000000E+00   2.22106326426959E-11  -4.64019716713288E-23
     -8.69846832667198E-09  -8.67625769402932E-09  -1.14241623743105E-18  -9.64639577352255E-02  -9.64639577556833E-02
      0.00000000000000E+00   0.00000000000000E+00   2.04577175928636E-08   0.00000000000000E+00   2.04577175928636E-08
      3.56815985631627E-18  -4.83335065939308E-02  -4.46215268933023E-02   0.00000000000000E+00  -1.47142737070075E-10
     -9.76214841639277E-23  -1.16343171617625E-08  -1.17814598988326E-08  -2.42574361888523E-18
      8.52173301928405E-09
      0.00000000000000E+00   8.06947861105330E-12   0.00000000000000E+00   1.68866714651797E-11  -4.65978249371668E-23
     -8.08637693373275E-09  -8.06949026226762E-09  -1.15593622156692E-18  -8.87616876177406E-02  -8.87616876371005E-02
      0.00000000000000E+00   0.00000000000000E+00   1.93598931746478E-08   0.00000000000000E+00   1.93598931746478E-08
      3.60082967604849E-18  -5.16558377879066E-02  -4.80985681194297E-02   0.00000000000000E+00  -1.61352070677781E-10
     -9.88042529200813E-23  -1.11290508417018E-08  -1.12904029123796E-08  -2.44489345448158E-18
      8.52401114428405E-09
      0.00000000000000E+00   7.34390518711384E-12   0.00000000000000E+00   1.47988400823597E-11  -4.68414448990483E-23
     -7.35862751660986E-09  -7.34382867652755E-09  -1.17252369863425E-18  -7.91920701729818E-02  -7.91920701910901E-02
      0.00000000000000E+00   0.00000000000000E+00   1.81083395479574E-08   0.00000000000000E+00   1.81083395479574E-08
      3.64208273708118E-18  -5.64993751804693E-02  -5.31077963807257E-02   0.00000000000000E+00  -1.67960322842957E-10
     -1.00369423676863E-22  -1.05965505485866E-08  -1.07645108714296E-08  -2.46955903844693E-18
      8.52708661303405E-09
      0.00000000000000E+00   6.41021158866212E-12   0.00000000000000E+00   1.41035130452944E-11  -4.71229970439048E-23
     -6.42428268230313E-09  -6.41017916925788E-09  -1.19203168750194E-18  -6.77668304255932E-02  -6.77668304421115E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65183876687416E-08   0.00000000000000E+00   1.65183876687416E-08
      3.69288452215678E-18  -6.36294418939958E-02  -6.04446435157439E-02   0.00000000000000E+00  -1.72360820286920E-10
     -1.02417170987423E-22  -9.93584767919666E-09  -1.01082084994837E-08  -2.50085283465485E-18
      8.53123849584655E-09
      0.00000000000000E+00   5.19501387066934E-12   0.00000000000000E+00   1.36847054353333E-11  -4.74180209417870E-23
     -5.20866400316405E-09  -5.19497929772877E-09  -1.21330807304196E-18  -5.50738367495815E-02  -5.50738367640305E-02
      0.00000000000000E+00   0.00000000000000E+00   1.44490094580626E-08   0.00000000000000E+00   1.44490094580626E-08
      3.75287511618336E-18  -7.42500102813664E-02  -7.13343375016331E-02   0.00000000000000E+00  -1.75018699365680E-10
     -1.05054124527894E-22  -9.07901146096807E-09  -9.25403016033385E-09  -2.53956704314140E-18
      8.53684353764342E-09
      0.00000000000000E+00   3.72669205693261E-12   0.00000000000000E+00   1.23602713740686E-11  -4.76829335093378E-23
     -3.73902933027589E-09  -3.72666905890187E-09  -1.23378994923946E-18  -4.25617045767107E-02  -4.25617045886344E-02
      0.00000000000000E+00   0.00000000000000E+00   1.19237151439191E-08   0.00000000000000E+00   1.19237151439191E-08
      3.81970803793906E-18  -9.01131874203522E-02  -8.75305383109367E-02   0.00000000000000E+00  -1.75584625610592E-10
     -1.08380151304920E-22  -8.02146145940647E-09  -8.19704608501717E-09  -2.58591808869961E-18
      8.54062694085631E-09
      0.00000000000000E+00   2.78243631370202E-12   0.00000000000000E+00   1.18736289288963E-11  -4.78017063671427E-23
     -2.79432484430204E-09  -2.78245121537319E-09  -1.24404082386145E-18  -3.61671062555803E-02  -3.61671062658431E-02
      0.00000000000000E+00   0.00000000000000E+00   1.02627760549786E-08   0.00000000000000E+00   1.02627760549786E-08
      3.85853625783864E-18  -1.01441156578230E-01  -9.90843212188079E-02   0.00000000000000E+00  -1.77733465005410E-10
     -1.10529756691383E-22  -7.30259137460022E-09  -7.48032483960574E-09  -2.61449543397719E-18
      8.54573453519372E-09
      0.00000000000000E+00   1.88346002591475E-12   0.00000000000000E+00   8.41494580579131E-12  -4.79035949661341E-23
     -1.89191488652125E-09  -1.88349994071550E-09  -1.25328766313333E-18  -3.02239457893944E-02  -3.02239457980408E-02
      0.00000000000000E+00   0.00000000000000E+00   8.64640942865374E-09   0.00000000000000E+00   8.64640942865374E-09
      3.90269860967530E-18  -1.17423116436912E-01  -1.15292316545492E-01   0.00000000000000E+00  -1.77911180340498E-10
     -1.13276110414400E-22  -6.58499830759729E-09  -6.76290948793791E-09  -2.64941094654197E-18
      8.55262978754921E-09
      0.00000000000000E+00   1.16514233621468E-12   0.00000000000000E+00   4.98433423867057E-12  -4.79826651177522E-23
     -1.17011906931863E-09  -1.16513473508000E-09  -1.26082142935266E-18  -2.51389780647888E-02  -2.51389780720496E-02
      0.00000000000000E+00   0.00000000000000E+00   7.26076856172387E-09   0.00000000000000E+00   7.26076856172387E-09
      3.95276344120322E-18  -1.39459667604752E-01  -1.37539105538707E-01   0.00000000000000E+00  -1.80817211276837E-10
     -1.16807465735031E-22  -5.91481661536685E-09  -6.09563382664380E-09  -2.69194201185055E-18
      8.56193837822912E-09
      0.00000000000000E+00   6.79008142175245E-13   0.00000000000000E+00   2.49505332604289E-12  -4.80390652200337E-23
     -6.81469687167878E-10  -6.78974633841883E-10  -1.26647838603821E-18  -2.10015996793533E-02  -2.10015996855195E-02
      0.00000000000000E+00   0.00000000000000E+00   6.16621751878635E-09   0.00000000000000E+00   6.16621751878635E-09
      4.01016223612892E-18  -1.68953314819949E-01  -1.67224437350614E-01   0.00000000000000E+00  -1.87599146617301E-10
     -1.21391070652854E-22  -5.29964373832703E-09  -5.48724288494445E-09  -2.74368385009071E-18
      8.57450497564701E-09
      0.00000000000000E+00   3.90707512080819E-13   0.00000000000000E+00   1.09395907832212E-12  -4.80755840688868E-23
     -3.91771284345106E-10  -3.90677325266832E-10  -1.27051642524347E-18  -1.76678568332063E-02  -1.76678568384574E-02
      0.00000000000000E+00   0.00000000000000E+00   5.25118574360446E-09   0.00000000000000E+00   5.25118574360446E-09
      4.07615177333535E-18  -2.06804151875147E-01  -2.05272737957008E-01   0.00000000000000E+00  -1.96217767044285E-10
     -1.27301788331201E-22  -4.66429065129325E-09  -4.86050841833766E-09  -2.80563534809188E-18
      8.59146988216116E-09
      0.00000000000000E+00   2.39439229900022E-13   0.00000000000000E+00   4.25188477733641E-13  -4.80969757290716E-23
     -2.39858102906632E-10  -2.39432914428947E-10  -1.27344047801515E-18  -1.49173230209485E-02  -1.49173230252263E-02
      0.00000000000000E+00   0.00000000000000E+00   4.27772368373931E-09   0.00000000000000E+00   4.27772368373931E-09
      4.14872295572333E-18  -2.51391947784359E-01  -2.50119588445330E-01   0.00000000000000E+00  -1.95844934297070E-10
     -1.34476859917982E-22  -3.84244583501309E-09  -4.03829076931030E-09  -2.87528247770818E-18
      8.61146988216116E-09
      0.00000000000000E+00   1.75239758591961E-13   0.00000000000000E+00   1.53303452898806E-13  -4.81087079187375E-23
     -1.75413626869486E-10  -1.75260323416635E-10  -1.27564384405826E-18  -1.28083093484161E-02  -1.28083093515891E-02
      0.00000000000000E+00   0.00000000000000E+00   3.17299986886725E-09   0.00000000000000E+00   3.17299986886725E-09
      4.21218295310068E-18  -2.91332648462492E-01  -2.90388135817468E-01   0.00000000000000E+00  -1.70944408869652E-10
     -1.41164236930612E-22  -2.82679513658087E-09  -2.99773954545066E-09  -2.93653910904242E-18
      8.63146988216116E-09
      0.00000000000000E+00   1.46767890057628E-13   0.00000000000000E+00   6.93879609668016E-14  -4.81136602389439E-23
     -1.46802737807109E-10  -1.46733349846190E-10  -1.27730412138237E-18  -1.13815089139217E-02  -1.13815089161294E-02
      0.00000000000000E+00   0.00000000000000E+00   2.20768592460797E-09   0.00000000000000E+00   2.20768592460797E-09
      4.25633667159284E-18  -3.18673413807302E-01  -3.18024058545507E-01   0.00000000000000E+00  -1.29454855243775E-10
     -1.45875462566717E-22  -1.93149771951781E-09  -2.06095257476173E-09  -2.97903255021047E-18
      8.65146988216116E-09
      0.00000000000000E+00   1.32807490002084E-13   0.00000000000000E+00   3.50756465053409E-14  -4.81152834494965E-23
     -1.32870847146705E-10  -1.32835771500247E-10  -1.27870477211899E-18  -1.03921786661233E-02  -1.03921786675759E-02
      0.00000000000000E+00   0.00000000000000E+00   1.45267715003194E-09   0.00000000000000E+00   1.45267715003194E-09
      4.28539021459348E-18  -3.35444701802887E-01  -3.35028855496747E-01   0.00000000000000E+00  -8.34617805879603E-11
     -1.48785066098142E-22  -1.23637959794359E-09  -1.31984137853170E-09  -3.00668544247449E-18
      8.67146988216115E-09
      0.00000000000000E+00   1.26929426820802E-13   0.00000000000000E+00   1.59543608949291E-14  -4.81158048984457E-23
     -1.26907546709307E-10  -1.26891592348460E-10  -1.27999793301293E-18  -9.68636424577567E-03  -9.68636424664295E-03
      0.00000000000000E+00   0.00000000000000E+00   8.67280410632919E-10   0.00000000000000E+00   8.67280410632919E-10
      4.30273582280614E-18  -3.43651445834381E-01  -3.43418175422150E-01   0.00000000000000E+00  -4.01931826910261E-11
     -1.50163169056709E-22  -7.00195635593290E-10  -7.40388818284466E-10  -3.02273788979321E-18
      8.69146988216115E-09
      0.00000000000000E+00   9.68961977539407E-14   0.00000000000000E+00   7.98116218194791E-14  -4.81046158454289E-23
     -9.69861119806653E-11  -9.69063003588939E-11  -1.28070218312909E-18  -9.37725581119399E-03  -9.37725581188482E-03
      0.00000000000000E+00   0.00000000000000E+00   6.90823494713128E-10   0.00000000000000E+00   6.90823494713128E-10
      4.31655229270040E-18  -3.50137617447925E-01  -3.49950497625154E-01   0.00000000000000E+00  -3.01171015823097E-11
     -1.51173033451325E-22  -5.63800092771765E-10  -5.93917194354226E-10  -3.03585010957130E-18
      8.71146988216115E-09
      0.00000000000000E+00   7.38431687148515E-14   0.00000000000000E+00   6.65315217690539E-14  -4.80862602148770E-23
     -7.38793335676966E-11  -7.38128020459756E-11  -1.28095803476878E-18  -9.25885222507214E-03  -9.25885222589383E-03
      0.00000000000000E+00   0.00000000000000E+00   8.21685714796802E-10   0.00000000000000E+00   8.21685714796802E-10
      4.33298600699633E-18  -3.59354711007698E-01  -3.59119081477630E-01   0.00000000000000E+00  -4.51689873256330E-11
     -1.52645002341554E-22  -7.02703925425104E-10  -7.47872912750890E-10  -3.05202797222756E-18
      8.71396988216115E-09
      0.00000000000000E+00   6.87917081684375E-14   0.00000000000000E+00   1.07668495153033E-13  -4.80836097976865E-23
     -6.89443224379987E-11  -6.88366539428937E-11  -1.28097778987508E-18  -9.25122784124839E-03  -9.25122784206425E-03
      0.00000000000000E+00   0.00000000000000E+00   8.15860078328254E-10   0.00000000000000E+00   8.15860078328254E-10
      4.33502565719216E-18  -3.60508087772750E-01  -3.60272725695838E-01   0.00000000000000E+00  -4.54553990591320E-11
     -1.52828696241558E-22  -7.01568025325513E-10  -7.47023424384798E-10  -3.05404786731707E-18
      8.71734488216115E-09
      0.00000000000000E+00   3.32477948691247E-14   0.00000000000000E+00   5.29814098135813E-13  -4.80760338630570E-23
     -3.37954173617443E-11  -3.32656032636566E-11  -1.28088490110080E-18  -9.30121336248406E-03  -9.30121336343733E-03
      0.00000000000000E+00   0.00000000000000E+00   9.53269813336650E-10   0.00000000000000E+00   9.53269813336650E-10
      4.33824294281217E-18  -3.62642879756056E-01  -3.62353012494738E-01   0.00000000000000E+00  -6.36384224243395E-11
     -1.53169638117855E-22  -8.56365787648634E-10  -9.20004210073127E-10  -3.05735804171136E-18
      8.72190113216115E-09
      0.00000000000000E+00   1.56136053252795E-14   0.00000000000000E+00   2.13995092756391E-13  -4.80665183881324E-23
     -1.58241449222254E-11  -1.56101498295171E-11  -1.28068015629817E-18  -9.38895255721591E-03  -9.38895255841610E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20018651859553E-09   0.00000000000000E+00   1.20018651859553E-09
      4.34371129263752E-18  -3.66509737233901E-01  -3.66136506250748E-01   0.00000000000000E+00  -8.83963875092126E-11
     -1.53807523460684E-22  -1.09617998125653E-09  -1.18457636876590E-09  -3.06303113633935E-18
      8.72497660091115E-09
      0.00000000000000E+00   1.12969026765258E-14   0.00000000000000E+00   9.18790382762429E-14  -4.80603103914793E-23
     -1.13528745351674E-11  -1.12609954969392E-11  -1.28052912897622E-18  -9.44448392570447E-03  -9.44448392706930E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36482847028268E-09   0.00000000000000E+00   1.36482847028268E-09
      4.34790877994698E-18  -3.69527771738405E-01  -3.69101293464601E-01   0.00000000000000E+00  -1.04561128000909E-10
     -1.54315159977477E-22  -1.24900634678451E-09  -1.35356747478557E-09  -3.06737965097076E-18
      8.72912848372365E-09
      0.00000000000000E+00   1.58891395369021E-14   0.00000000000000E+00  -3.39259004130541E-14  -4.80529475050111E-23
     -1.58288035972666E-11  -1.58627294977277E-11  -1.28034543012199E-18  -9.49150051584203E-03  -9.49150051738790E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54586398403390E-09   0.00000000000000E+00   1.54586398403390E-09
      4.35432702605275E-18  -3.74144650616881E-01  -3.73662580223777E-01   0.00000000000000E+00  -1.21465098499774E-10
     -1.55108525997836E-22  -1.40853615603580E-09  -1.53000125453573E-09  -3.07398159593076E-18
      8.73473352552053E-09
      0.00000000000000E+00   2.78289553738806E-14   0.00000000000000E+00  -8.76885832268991E-14  -4.80446297482497E-23
     -2.77128537556497E-11  -2.78005423389247E-11  -1.28016639995057E-18  -9.49715716511373E-03  -9.49715716680951E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69578233375338E-09   0.00000000000000E+00   1.69578233375338E-09
      4.36383195691184E-18  -3.80917706304860E-01  -3.80392159973236E-01   0.00000000000000E+00  -1.35759723732811E-10
     -1.56297406122798E-22  -1.53222206768179E-09  -1.66798179141476E-09  -3.08366555696128E-18
      8.74230033194631E-09
      0.00000000000000E+00   4.16056659550096E-14   0.00000000000000E+00  -7.60359136909789E-14  -4.80352766684204E-23
     -4.15395545190143E-11  -4.16155904327533E-11  -1.28003299896178E-18  -9.42815000172712E-03  -9.42815000350831E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78118738100016E-09   0.00000000000000E+00   1.78118738100016E-09
      4.37730985703192E-18  -3.90413555693560E-01  -3.89865452122688E-01   0.00000000000000E+00  -1.45547856517857E-10
     -1.57998275528631E-22  -1.59402393404917E-09  -1.73957179056718E-09  -3.09727685807014E-18
      8.75251552062111E-09
      0.00000000000000E+00   5.66682028570440E-14   0.00000000000000E+00  -6.18695373651316E-14  -4.80254402470566E-23
     -5.66360715931790E-11  -5.66979411305922E-11  -1.28001360599387E-18  -9.23639266218683E-03  -9.23639266398740E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80057596509330E-09   0.00000000000000E+00   1.80057596509330E-09
      4.39570308023866E-18  -4.03204810108154E-01  -4.02655349367042E-01   0.00000000000000E+00  -1.50953477634386E-10
     -1.60340695560194E-22  -1.59292454632830E-09  -1.74387802396285E-09  -3.11568947424480E-18
      8.76630602533210E-09
      0.00000000000000E+00   8.16499713774913E-14   0.00000000000000E+00  -8.28428815059104E-14  -4.80189209318921E-23
     -8.15306141669564E-11  -8.16134570485103E-11  -1.28034215888651E-18  -8.77492385082400E-03  -8.77492385260738E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78337719301053E-09   0.00000000000000E+00   1.78337719301053E-09
      4.42029675182034E-18  -4.19903375348579E-01  -4.19367183746911E-01   0.00000000000000E+00  -1.53883468605725E-10
     -1.63495738682832E-22  -1.54788026735606E-09  -1.70176373596195E-09  -3.13995459293383E-18
      8.78492320669193E-09
      0.00000000000000E+00   1.27113116295217E-13   0.00000000000000E+00  -1.22686442613128E-13  -4.80263471100728E-23
     -1.26979153510840E-10  -1.27101839953501E-10  -1.28164979336711E-18  -7.65832133364050E-03  -7.65832133540714E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76663117889589E-09   0.00000000000000E+00   1.76663117889589E-09
      4.45318644487378E-18  -4.41211600080987E-01  -4.40695016958126E-01   0.00000000000000E+00  -1.56957140817761E-10
     -1.67724611061391E-22  -1.48257219812443E-09  -1.63952933894236E-09  -3.17153665150667E-18
      8.80492320669193E-09
      0.00000000000000E+00   1.67157421717699E-13   0.00000000000000E+00  -1.08577270526726E-13  -4.80483209317722E-23
     -1.67047363136910E-10  -1.67155940407484E-10  -1.28387204918398E-18  -5.99871240211548E-03  -5.99871240385460E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73912397061475E-09   0.00000000000000E+00   1.73912397061475E-09
      4.48796892428607E-18  -4.62766822303551E-01  -4.62271525359993E-01   0.00000000000000E+00  -1.60584255841602E-10
     -1.72236921162182E-22  -1.41138377436554E-09  -1.57196803020732E-09  -3.20409687510210E-18
      8.82492320669193E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.19082488446154E-14  -4.80699364817331E-23
     -1.71498049670683E-10  -1.71519957919576E-10  -1.28619647277593E-18  -4.30695193183001E-03  -4.30695193349772E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66771024238108E-09   0.00000000000000E+00   1.66771024238108E-09
      4.52132312913369E-18  -4.83234775929912E-01  -4.82763353978687E-01   0.00000000000000E+00  -1.62577326455434E-10
     -1.76676172985158E-22  -1.33361295800581E-09  -1.49619028446142E-09  -3.23512665635776E-18
      8.84492320669193E-09
      0.00000000000000E+00   2.23733779837535E-13   0.00000000000000E+00  -1.48925108454239E-13  -4.81133100919890E-23
     -2.23601210257175E-10  -2.23750135365677E-10  -1.28957668395937E-18  -1.99951922985415E-03  -1.99951923153763E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68348405906160E-09   0.00000000000000E+00   1.68348405906160E-09
      4.55499281031493E-18  -5.02699912283101E-01  -5.02239975227466E-01   0.00000000000000E+00  -1.69155671567024E-10
     -1.81170090400520E-22  -1.29057825212868E-09  -1.45973392369588E-09  -3.26541612635555E-18
      8.86492320669193E-09
      0.00000000000000E+00  -6.41259955182952E-13   0.00000000000000E+00   2.25601074612322E-12  -4.77954278300913E-23
      6.38987280784811E-10   6.41243291530887E-10  -1.27571796561468E-18  -1.01167964830685E-02  -1.01167964833105E-02
      0.00000000000000E+00   0.00000000000000E+00   2.41933205264469E-10   0.00000000000000E+00   2.41933205264469E-10
      4.55983147442022E-18  -5.22388445311502E-01  -5.22110182214875E-01   0.00000000000000E+00  -9.12097101898219E-11
     -1.83541703022357E-22  -7.91966786605370E-10  -8.83176496795375E-10  -3.28411350880553E-18
      8.88492320669193E-09
      0.00000000000000E+00  -2.54529320223219E-12   0.00000000000000E+00   5.09903664241381E-12  -4.67571971908145E-23
      2.54020915242810E-09   2.54530818907047E-09  -1.22413306080627E-18  -4.02103730124397E-02  -4.02103730096292E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.81043625759115E-09   0.00000000000000E+00  -2.81043625759115E-09
      4.50362274926839E-18  -5.43353934051069E-01  -5.43437510798974E-01   0.00000000000000E+00   8.22922857620136E-11
     -1.81374154661320E-22   1.82835782758862E-10   2.65128068520694E-10  -3.27948968846212E-18
      8.90492320669193E-09
      0.00000000000000E+00  -4.40983321228219E-12   0.00000000000000E+00   5.14995690002826E-12  -4.51028796749916E-23
      4.40463881005334E-09   4.40978876695332E-09  -1.13732050798198E-18  -8.84243923711403E-02  -8.84243923655580E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.58234060453841E-09   0.00000000000000E+00  -5.58234060453841E-09
      4.39197593717763E-18  -5.64962228634965E-01  -5.65331750710935E-01   0.00000000000000E+00   2.16645572920713E-10
     -1.75518884757600E-22   9.55906264664526E-10   1.17255183758506E-09  -3.25465542919565E-18
      8.92492320669193E-09
      0.00000000000000E+00  -6.58554319199129E-12   0.00000000000000E+00   5.90330289873424E-12  -4.27636905251579E-23
      6.57963560217810E-09   6.58553890507679E-09  -1.02053873490683E-18  -1.48728558724082E-01  -1.48728558716200E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.88224163568838E-09   0.00000000000000E+00  -7.88224163568838E-09
      4.23433110446386E-18  -5.85767590393306E-01  -5.86176309886758E-01   0.00000000000000E+00   2.88198265565023E-10
     -1.67409733422749E-22   1.00850446504674E-09   1.29670273061159E-09  -3.21379236955703E-18
      8.94492320669193E-09
      0.00000000000000E+00  -1.06730932214123E-11   0.00000000000000E+00   1.04726772020232E-11  -3.22988695965708E-23
      1.06625962687303E-08   1.06730689459323E-08  -8.95270319857895E-19  -2.08412830283769E-01  -2.08412830274904E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.86583535917163E-09   0.00000000000000E+00  -8.86583535917163E-09
      4.05701439728042E-18  -6.00074308202536E-01  -5.99505372359542E-01   0.00000000000000E+00   2.87168283980591E-10
     -1.58912258635902E-22  -2.09440187074108E-09  -1.80723358676065E-09  -3.16174407742253E-18
      8.96492320669193E-09
      0.00000000000000E+00  -2.22277122305424E-11   0.00000000000000E+00   2.87321323385166E-11   1.91784944419707E-23
      2.21989803550537E-08   2.22277124873922E-08  -7.81723918380145E-19  -2.59151167059373E-01  -2.59151167049877E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.49681591745558E-09   0.00000000000000E+00  -9.49681591745558E-09
      3.86707807893131E-18  -5.94436943570748E-01  -5.90427075427423E-01   0.00000000000000E+00   2.94316477244153E-10
     -1.49467751335847E-22  -1.30252130471808E-08  -1.27308965699368E-08  -3.08535416055117E-18
      8.98492320669193E-09
      0.00000000000000E+00  -4.16770293158199E-11   0.00000000000000E+00   4.82051195270457E-11   1.11792534671780E-22
      4.16287833364129E-08   4.16769884559400E-08  -6.95542434306071E-19  -2.96836511006377E-01  -2.96836510996173E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02035524021501E-08   0.00000000000000E+00  -1.02035524021501E-08
      3.66300703088831E-18  -5.54635449403164E-01  -5.44721170071984E-01   0.00000000000000E+00   3.13962435110129E-10
     -1.37555595482102E-22  -3.17873984888999E-08  -3.14734360537899E-08  -2.96746459658224E-18
      9.00492320669193E-09
      0.00000000000000E+00  -5.94374135285882E-11   0.00000000000000E+00   4.41460907749695E-11   1.96341686113654E-22
      5.93932738406387E-08   5.94374199314138E-08  -6.39384139937592E-19  -3.22241679253901E-01  -3.22241679243045E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08554285049905E-08   0.00000000000000E+00  -1.08554285049905E-08
      3.44589846078850E-18  -4.78327905139909E-01  -4.63023253945831E-01   0.00000000000000E+00   3.00416692778758E-10
     -1.22368253269527E-22  -4.88824081192019E-08  -4.85819914264233E-08  -2.80651432085091E-18
      9.02492320669193E-09
      0.00000000000000E+00  -6.56594352507120E-11   0.00000000000000E+00   1.55737925895832E-11   2.25469062888092E-22
      6.56438444662241E-08   6.56594182588139E-08  -6.09753997499629E-19  -3.37305756137783E-01  -3.37305756126360E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14233483383161E-08   0.00000000000000E+00  -1.14233483383161E-08
      3.21743149402218E-18  -3.70123229236088E-01  -3.53036516306722E-01   0.00000000000000E+00   2.56257911981726E-10
     -1.06027990961870E-22  -5.44923278324795E-08  -5.42360699204979E-08  -2.60767749652255E-18
      9.04492320669193E-09
      0.00000000000000E+00  -5.87344339100017E-11   0.00000000000000E+00  -1.71165143289396E-11   1.94280706164054E-22
      5.87515135803175E-08   5.87343970659887E-08  -6.00120919466509E-19  -3.44677921187066E-01  -3.44677921175194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18723874285037E-08   0.00000000000000E+00  -1.18723874285037E-08
      2.97998374545211E-18  -2.45462647304655E-01  -2.30698590907889E-01   0.00000000000000E+00   1.91892079591543E-10
     -8.93861180575014E-23  -4.70539017170765E-08  -4.68620096374850E-08  -2.37986282598560E-18
      9.06492320669193E-09
      0.00000000000000E+00  -5.09016391867322E-11   0.00000000000000E+00  -1.94291977261447E-11   1.53499065219026E-22
      5.09211064089953E-08   5.09016772112693E-08  -5.92191034080367E-19  -3.51470293558843E-01  -3.51470293546966E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18770792527426E-08   0.00000000000000E+00  -1.18770792527426E-08
      2.74244216039725E-18  -1.37875229567532E-01  -1.25580120044010E-01   0.00000000000000E+00   1.06819578425754E-10
     -7.69729429249900E-23  -3.91314175369524E-08  -3.90245979585268E-08  -2.15025112631689E-18
      9.07492320669192E-09
      0.00000000000000E+00  -4.67605436755193E-11   0.00000000000000E+00  -2.05224268122731E-11   1.32965063626662E-22
      4.67810313636598E-08   4.67605089368477E-08  -5.87331448477200E-19  -3.55195718487708E-01  -3.55195718475899E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18095451256227E-08   0.00000000000000E+00  -1.18095451256227E-08
      2.62434670914103E-18  -9.21030407484889E-02  -8.10912924964029E-02   0.00000000000000E+00   7.14480894946591E-11
     -6.66718324744471E-23  -3.50224119007196E-08  -3.49509638112250E-08  -2.03701526066383E-18
      9.08842320669193E-09
      0.00000000000000E+00  -4.14284974569363E-11   0.00000000000000E+00  -1.95478007681983E-11   1.20184746576675E-22
      4.14480405647265E-08   4.14284927639584E-08  -5.69322163929126E-19  -3.64188095978549E-01  -3.64188095967179E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13696283174681E-08   0.00000000000000E+00  -1.13696283174681E-08
      2.47085672685521E-18  -5.06538150077436E-02  -4.11833291051425E-02   0.00000000000000E+00   4.78131676508932E-11
     -1.26986431631010E-23  -3.01066776141413E-08  -3.00588644464904E-08  -1.90153456292608E-18
      9.10664820669192E-09
      0.00000000000000E+00  -3.52692056903251E-11   0.00000000000000E+00  -1.66869619028807E-11   1.29295409518685E-22
      3.52859150499124E-08   3.52692280880096E-08  -5.22040244726351E-19  -3.83984897372711E-01  -3.83984897362064E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06478535520042E-08   0.00000000000000E+00  -1.06478535520042E-08
      2.27679959586993E-18  -2.73057643641297E-02  -1.95484058049748E-02   0.00000000000000E+00   2.90101230405036E-11
      8.98946167307666E-23  -2.46503846590460E-08  -2.46213745360054E-08  -1.75475935114358E-18
      9.12664820669192E-09
      0.00000000000000E+00  -3.19291799770362E-11   0.00000000000000E+00  -8.22730203772203E-12   1.40722743770249E-22
      3.19374423838675E-08   3.19292150818299E-08  -4.62091592998593E-19  -4.08347609244568E-01  -4.08347609234343E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02243918102833E-08   0.00000000000000E+00  -1.02243918102833E-08
      2.07231175966427E-18  -1.86209238220675E-02  -1.17824520127686E-02   0.00000000000000E+00   1.51421247289788E-11
      1.57165709813202E-22  -2.17199653962758E-08  -2.17048232715466E-08  -1.61022016666567E-18
      9.14664820669192E-09
      0.00000000000000E+00  -3.02332669044992E-11   0.00000000000000E+00  -4.15566453278213E-12   1.33506754686369E-22
      3.02374181605678E-08   3.02332624960352E-08  -4.04708728341139E-19  -4.31855125301865E-01  -4.31855125291845E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00193394402932E-08   0.00000000000000E+00  -1.00193394402932E-08
      1.87192497085840E-18  -1.49224500505562E-02  -8.55370052945549E-03   0.00000000000000E+00   9.23771469321613E-12
      1.71415675196924E-22  -2.02231607704353E-08  -2.02139230557420E-08  -1.46721624251726E-18
      9.16664820669192E-09
      0.00000000000000E+00  -2.89024366623622E-11   0.00000000000000E+00  -3.25171614925761E-12   1.08906216788433E-22
      2.89057175268719E-08   2.89024658107227E-08  -3.51626510437272E-19  -4.53958403699594E-01  -4.53958403689735E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.85946801175483E-09   0.00000000000000E+00  -9.85946801175483E-09
      1.67473561062330E-18  -1.27702235607586E-02  -6.77038751936370E-03   0.00000000000000E+00   7.25354570300461E-12
      1.46804095305564E-22  -1.90502513446710E-08  -1.90429977989679E-08  -1.32310910018603E-18
      9.18664820669192E-09
      0.00000000000000E+00  -2.78070963264252E-11   0.00000000000000E+00  -2.67403645564506E-12   7.74098112431900E-23
      2.78098042686227E-08   2.78071302321671E-08  -3.02278121532431E-19  -4.74869256030041E-01  -4.74869256020318E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.72280121624613E-09   0.00000000000000E+00  -9.72280121624613E-09
      1.48027958629838E-18  -1.13502396888326E-02  -5.65244414863052E-03   0.00000000000000E+00   5.98938159254335E-12
      1.04496330408345E-22  -1.80903183975136E-08  -1.80843290159209E-08  -1.17800146476595E-18
      9.20664820669192E-09
      0.00000000000000E+00  -2.69262134518678E-11   0.00000000000000E+00  -2.14798335924850E-12   4.87309055792162E-23
      2.69283648926166E-08   2.69262169092574E-08  -2.56143589439984E-19  -4.94768643253904E-01  -4.94768643244316E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.58779979527179E-09   0.00000000000000E+00  -9.58779979527179E-09
      1.28852359039295E-18  -1.03679969054822E-02  -4.90521026597911E-03   0.00000000000000E+00   4.94160421184183E-12
      6.29132015683300E-23  -1.73433587181976E-08  -1.73384171139857E-08  -1.03238000095296E-18
      9.22664820669192E-09
      0.00000000000000E+00  -2.63262836284283E-11   0.00000000000000E+00  -1.45710515896685E-12   2.79813338642115E-23
      2.63277130635708E-08   2.63262559584119E-08  -2.12418052282191E-19  -5.13998561625029E-01  -5.13998561615468E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56110300198386E-09   0.00000000000000E+00  -9.56110300198386E-09
      1.09730153035327E-18  -9.67180244992084E-03  -4.38962978714800E-03   0.00000000000000E+00   4.14598423386941E-12
      3.21011473736529E-23  -1.67692989406620E-08  -1.67651529564281E-08  -8.84883478071079E-19
      9.24664820669192E-09
      0.00000000000000E+00  -2.70919013577902E-11   0.00000000000000E+00   1.91063061651998E-12   1.57152615899532E-23
      2.70900265123758E-08   2.70919371429924E-08  -1.66815617701922E-19  -5.34570889899420E-01  -5.34570889888929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04906394970723E-08   0.00000000000000E+00  -1.04906394970723E-08
      8.87488740411823E-19  -9.37096671038064E-03  -4.14041652763178E-03   0.00000000000000E+00   3.06598450281553E-12
      1.36486984107376E-23  -1.66043636304229E-08  -1.66012976459201E-08  -7.20673122709901E-19
      9.26664820669192E-09
      0.00000000000000E+00  -2.79953780377006E-11   0.00000000000000E+00   2.25796621377541E-12   9.34860285380422E-24
      2.79931597015773E-08   2.79954176677911E-08  -1.20650528339272E-19  -5.55947480245240E-01  -5.55947480233984E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12560491915519E-08   0.00000000000000E+00  -1.12560491915519E-08
      6.62367756580784E-19  -9.25636911006251E-03  -3.98231465638685E-03   0.00000000000000E+00   2.20624466464136E-12
      4.28634577287512E-24  -1.67415747209038E-08  -1.67393684762391E-08  -5.41717228241512E-19
      9.27664820669192E-09
      0.00000000000000E+00  -2.87857938461086E-11   0.00000000000000E+00   3.92403891275253E-12   7.32263978869883E-24
      2.87818747472169E-08   2.87857987861297E-08  -9.75533934449820E-20  -5.66882330895356E-01  -5.66882330883602E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17544909830182E-08   0.00000000000000E+00  -1.17544909830182E-08
      5.44822846750602E-19  -9.33290367149658E-03  -3.96686658706929E-03   0.00000000000000E+00   1.01405266626742E-12
      1.27680425130825E-24  -1.70323218557777E-08  -1.70313078031114E-08  -4.47269453305621E-19
      9.28002320669192E-09
      0.00000000000000E+00  -2.91111079052977E-11   0.00000000000000E+00   4.77748842837939E-12   6.75998988722271E-24
      2.91063394749864E-08   2.91111169634148E-08  -8.97917141451621E-20  -5.70593934416144E-01  -5.70593934404223E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19215711023629E-08   0.00000000000000E+00  -1.19215711023629E-08
      5.04587544280127E-19  -9.38873428224333E-03  -3.97284054862441E-03   0.00000000000000E+00   9.96309045851022E-14
      4.26146935953158E-25  -1.71896454919562E-08  -1.71895458610516E-08  -4.14795830134965E-19
      9.28457945669192E-09
      0.00000000000000E+00  -2.94074908722664E-11   0.00000000000000E+00   3.25719134483569E-12   6.19103041646496E-24
      2.94042590704279E-08   2.94075162617728E-08  -7.93669774140521E-20  -5.75597959692081E-01  -5.75597959680079E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20024658286280E-08   0.00000000000000E+00  -1.20024658286280E-08
      4.49901309348441E-19  -9.45255935394527E-03  -3.96876624820523E-03   0.00000000000000E+00   3.64121986199049E-14
     -3.81352833764838E-25  -1.74050868453433E-08  -1.74050504331447E-08  -3.70534331934389E-19
      9.29073039419192E-09
      0.00000000000000E+00  -2.94642509198606E-11   0.00000000000000E+00   5.01742623886119E-13   5.63055427366665E-24
      2.94637443259903E-08   2.94642460686142E-08  -6.56613724456754E-20  -5.82205252403553E-01  -5.82205252391675E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18779560048301E-08   0.00000000000000E+00  -1.18779560048301E-08
      3.76840744334981E-19  -9.46775756219610E-03  -3.92686103316998E-03   0.00000000000000E+00   8.29553219945685E-13
     -1.06457554823906E-24  -1.75871196170039E-08  -1.75862900637840E-08  -3.11179371889305E-19
      9.29903415981692E-09
      0.00000000000000E+00  -2.89737081784352E-11   0.00000000000000E+00  -2.87893584435110E-12   5.06034640508183E-24
      2.89765578798006E-08   2.89736789439563E-08  -4.84244544927135E-20  -5.90559309103703E-01  -5.90559309092413E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12902733114547E-08   0.00000000000000E+00  -1.12902733114547E-08
      2.83088960914468E-19  -9.38855818845033E-03  -3.81706285920886E-03   0.00000000000000E+00   1.53059076855221E-12
     -1.58318171197786E-24  -1.76849362232701E-08  -1.76834056325015E-08  -2.34664506421754E-19
      9.31024424341067E-09
      0.00000000000000E+00  -2.70941056314832E-11   0.00000000000000E+00  -8.24679045874587E-12   4.37816127740286E-24
      2.71023686001038E-08   2.70941218096450E-08  -2.95352851689095E-20  -5.99734951683320E-01  -5.99734951673929E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.39061146298187E-09   0.00000000000000E+00  -9.39061146298187E-09
      1.77819421418014E-19  -9.15304587654444E-03  -3.57521512322299E-03   0.00000000000000E+00   1.60911181248697E-12
     -1.95080063279001E-24  -1.77051194584756E-08  -1.77035103466631E-08  -1.48284136249105E-19
      9.32537785626223E-09
      0.00000000000000E+00  -2.09122200595190E-11   0.00000000000000E+00  -2.01263245852180E-11   3.21154646886560E-24
      2.09322858183115E-08   2.09121594937263E-08  -2.12037122557526E-20  -6.03511393721998E-01  -6.03511393718778E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.21969898012788E-09   0.00000000000000E+00  -3.21969898012788E-09
      1.29093743554188E-19  -8.56123429402092E-03  -2.98688633836789E-03   0.00000000000000E+00   6.08070261714105E-13
     -2.26142686777644E-24  -1.76930685838600E-08  -1.76924605135983E-08  -1.07890031298435E-19
      9.34537785626223E-09
      0.00000000000000E+00  -4.95878920657158E-12   0.00000000000000E+00  -3.89247219539367E-11   6.62773222928516E-25
      4.99807321981081E-09   4.95914849785688E-09  -6.84247921776879E-20  -5.79498372963734E-01  -5.79498372976465E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27307781378276E-08   0.00000000000000E+00   1.27307781378276E-08
      3.83709306310740E-19  -7.21040594692854E-03  -1.63697712176014E-03   0.00000000000000E+00  -2.66702707257589E-12
     -2.98371277409235E-24  -1.76872596086118E-08  -1.76899266356844E-08  -3.15284514133051E-19
      9.36537785626223E-09
      0.00000000000000E+00   1.37417177362529E-11   0.00000000000000E+00  -4.57166912438199E-11  -4.12050757466874E-24
     -1.36956041089430E-08  -1.37413208001868E-08  -1.97544980342806E-19  -5.18550802286062E-01  -5.18550802317470E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14084606162893E-08   0.00000000000000E+00   3.14084606162893E-08
      1.01187851863653E-18  -5.50839957281752E-03   5.78406883612129E-05   0.00000000000000E+00  -7.19396116867942E-12
     -6.73109209948679E-24  -1.76599458549339E-08  -1.76671398161025E-08  -8.14333538293719E-19
      9.38537785626223E-09
      0.00000000000000E+00   2.45407300923767E-11   0.00000000000000E+00  -2.68253516651004E-11  -1.89971532118711E-23
     -2.45138219678295E-08  -2.45406473194946E-08  -4.22832191826625E-19  -4.23571599116459E-01  -4.23571599158613E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21547988155876E-08   0.00000000000000E+00   4.21547988155876E-08
      1.85497449494828E-18  -3.78734818830289E-03   1.76231102928388E-03   0.00000000000000E+00  -1.48648264589741E-11
     -3.08806677758148E-23  -1.75992866696340E-08  -1.76141514960930E-08  -1.43214230312165E-18
      9.40537785626223E-09
      0.00000000000000E+00   2.06725052954073E-11   0.00000000000000E+00   9.08191905441592E-12  -3.98307166204641E-23
     -2.06816043526772E-08  -2.06725224336228E-08  -7.25445640492730E-19  -3.01865622370351E-01  -3.01865622408652E-01
      0.00000000000000E+00   0.00000000000000E+00   3.83010992175294E-08   0.00000000000000E+00   3.83010992175294E-08
      2.62099647929886E-18  -1.63897749355815E-03   3.91522495678584E-03   0.00000000000000E+00  -3.46889033714203E-11
     -7.42222974794733E-23  -1.75938878805351E-08  -1.76285767839066E-08  -1.89555083880614E-18
      9.42537785626223E-09
      0.00000000000000E+00   1.29841823437653E-11   0.00000000000000E+00   1.82743709317427E-11  -4.40015044580574E-23
     -1.30024448361200E-08  -1.29841704651883E-08  -9.79800561278846E-19  -1.83771100379109E-01  -1.83771100407206E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80966085219097E-08   0.00000000000000E+00   2.80966085219097E-08
      3.18292864973706E-18  -1.68349457526343E-02  -1.20735114380180E-02   0.00000000000000E+00  -6.95222206636733E-11
     -8.55154210890132E-23  -1.50429158360577E-08  -1.51124380567214E-08  -2.20312808845821E-18
      9.44537785626223E-09
      0.00000000000000E+00   8.69604340828305E-12   0.00000000000000E+00   9.75092540673511E-12  -4.65774956412044E-23
     -8.70580541367627E-09  -8.69605448826958E-09  -1.15236985187398E-18  -9.07169796896304E-02  -9.07169797102137E-02
      0.00000000000000E+00   0.00000000000000E+00   2.05833625191853E-08   0.00000000000000E+00   2.05833625191853E-08
      3.59459590012076E-18  -5.22231049073582E-02  -4.84778043394620E-02   0.00000000000000E+00  -1.26306788097283E-10
     -9.86654130350151E-23  -1.17610012428183E-08  -1.18873080309157E-08  -2.44222604824679E-18
      9.45537785626223E-09
      0.00000000000000E+00   5.88072667866073E-12   0.00000000000000E+00   1.30689837511425E-11  -4.74051275902564E-23
     -5.89381530529592E-09  -5.88074632154483E-09  -1.21047325871352E-18  -5.66535757014173E-02  -5.66535757170157E-02
      0.00000000000000E+00   0.00000000000000E+00   1.55983975935947E-08   0.00000000000000E+00   1.55983975935947E-08
      3.75057987605671E-18  -7.62030377915770E-02  -7.31413034747379E-02   0.00000000000000E+00  -1.67939875717689E-10
     -1.05097273172025E-22  -9.54971139633200E-09  -9.71765127204979E-09  -2.54010661734319E-18
      9.46887785626223E-09
      0.00000000000000E+00   2.88934358781158E-12   0.00000000000000E+00   1.04932358487486E-11  -4.78792210483423E-23
     -2.89984672340279E-09  -2.88935348755409E-09  -1.24849547954838E-18  -3.31092828926183E-02  -3.31092829029952E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03768323853404E-08   0.00000000000000E+00   1.03768323853404E-08
      3.89066711325881E-18  -1.15789205268166E-01  -1.13430127116780E-01   0.00000000000000E+00  -1.74885869216012E-10
     -1.12707625137809E-22  -7.31259302857025E-09  -7.48747889778637E-09  -2.64217163371043E-18
      9.47343410626223E-09
      0.00000000000000E+00   1.84497708102480E-12   0.00000000000000E+00   1.10027852635243E-11  -4.79529579149040E-23
     -1.85595030648744E-09  -1.84494752122396E-09  -1.25657000625869E-18  -2.79270694863650E-02  -2.79270694948229E-02
      0.00000000000000E+00   0.00000000000000E+00   8.45789065817162E-09   0.00000000000000E+00   8.45789065817162E-09
      3.92920337757010E-18  -1.29869921363778E-01  -1.27786370616494E-01   0.00000000000000E+00  -1.84167290976137E-10
     -1.15176933542678E-22  -6.42877584597150E-09  -6.61294313694775E-09  -2.67263337131141E-18
      9.47958504376223E-09
      0.00000000000000E+00   1.08367605431161E-12   0.00000000000000E+00   5.97780556348463E-12  -4.80086916313432E-23
     -1.08968883255671E-09  -1.08371102699327E-09  -1.26279216020767E-18  -2.37055985965941E-02  -2.37055986036104E-02
      0.00000000000000E+00   0.00000000000000E+00   7.01622911027010E-09   0.00000000000000E+00   7.01622911027010E-09
      3.97235976431306E-18  -1.49371534069295E-01  -1.47502363249655E-01   0.00000000000000E+00  -1.85839926501195E-10
     -1.18326798770896E-22  -5.74667815677547E-09  -5.93251808327678E-09  -2.70956760410538E-18
      9.48788880938723E-09
      0.00000000000000E+00   6.24268678799559E-13   0.00000000000000E+00   2.66348532226766E-12  -4.80495733348175E-23
     -6.26973513706597E-10  -6.24310028384377E-10  -1.26738721417424E-18  -2.03003287330513E-02  -2.03003287390430E-02
      0.00000000000000E+00   0.00000000000000E+00   5.99178274587105E-09   0.00000000000000E+00   5.99178274587105E-09
      4.02211412391069E-18  -1.75480502097084E-01  -1.73789358891228E-01   0.00000000000000E+00  -1.91009631060350E-10
     -1.22401999460062E-22  -5.17646308642596E-09  -5.36747271748644E-09  -2.75472690973645E-18
      9.49909889298098E-09
      0.00000000000000E+00   3.70869048843993E-13   0.00000000000000E+00   1.08247436974576E-12  -4.80780732597758E-23
     -3.71947609631311E-10  -3.70865135261613E-10  -1.27076856415454E-18  -1.74692785891850E-02  -1.74692785943578E-02
      0.00000000000000E+00   0.00000000000000E+00   5.17286472006098E-09   0.00000000000000E+00   5.17286472006098E-09
      4.08010236984173E-18  -2.09055944024454E-01  -2.07542962963315E-01   0.00000000000000E+00  -1.97892252403178E-10
     -1.27659381857698E-22  -4.60410733239601E-09  -4.80199958479931E-09  -2.80933380568719E-18
      9.51423250583254E-09
      0.00000000000000E+00   2.38245248316324E-13   0.00000000000000E+00   4.18227496213880E-13  -4.80965487128115E-23
     -2.38651804866209E-10  -2.38233577370043E-10  -1.27335710722305E-18  -1.50192954842198E-02  -1.50192954885238E-02
      0.00000000000000E+00   0.00000000000000E+00   4.30399549060944E-09   0.00000000000000E+00   4.30399549060944E-09
      4.14523737131148E-18  -2.49136273249582E-01  -2.47855257428571E-01   0.00000000000000E+00  -1.97287425678267E-10
     -1.34106375098162E-22  -3.86847448756104E-09  -4.06576191323944E-09  -2.87188026408843E-18
      9.53423250583254E-09
      0.00000000000000E+00   1.75698982277999E-13   0.00000000000000E+00   1.49116670221072E-13  -4.81083787750770E-23
     -1.75884159362411E-10  -1.75735042692239E-10  -1.27556838953647E-18  -1.28865976155204E-02  -1.28865976187419E-02
      0.00000000000000E+00   0.00000000000000E+00   3.22148677832496E-09   0.00000000000000E+00   3.22148677832496E-09
      4.20966710687798E-18  -2.89716569847768E-01  -2.88756929927989E-01   0.00000000000000E+00  -1.72570832909614E-10
     -1.40885939821538E-22  -2.87318090272304E-09  -3.04575173563279E-09  -2.93409871734151E-18
      9.55423250583254E-09
      0.00000000000000E+00   1.47502647955288E-13   0.00000000000000E+00   6.85222009281592E-14  -4.81135545500449E-23
     -1.47577012721129E-10  -1.47508490520249E-10  -1.27724309865977E-18  -1.14355976255800E-02  -1.14355976278282E-02
      0.00000000000000E+00   0.00000000000000E+00   2.24828050056588E-09   0.00000000000000E+00   2.24828050056588E-09
      4.25463271688930E-18  -3.17612378419835E-01  -3.16950476972606E-01   0.00000000000000E+00  -1.31582935179998E-10
     -1.45688373883105E-22  -1.96918907486545E-09  -2.10077201004559E-09  -2.97738961822953E-18
      9.57423250583254E-09
      0.00000000000000E+00   1.32991179476499E-13   0.00000000000000E+00   3.64858596116475E-14  -4.81151705246195E-23
     -1.33065835420089E-10  -1.33029349560525E-10  -1.27864695885604E-18  -1.04314642556601E-02  -1.04314642571461E-02
      0.00000000000000E+00   0.00000000000000E+00   1.48594387148680E-09   0.00000000000000E+00   1.48594387148680E-09
      4.28435159431904E-18  -3.34869353648170E-01  -3.34443086594373E-01   0.00000000000000E+00  -8.57697381000501E-11
     -1.48683076144149E-22  -1.26714478382607E-09  -1.35291452192627E-09  -3.00570463546299E-18
      9.59423250583254E-09
      0.00000000000000E+00   1.27572339981255E-13   0.00000000000000E+00   1.46383978886470E-14  -4.81159414790156E-23
     -1.27592950873529E-10  -1.27578312475689E-10  -1.27995340787252E-18  -9.71004110541382E-03  -9.71004110630184E-03
      0.00000000000000E+00   0.00000000000000E+00   8.88015887090257E-10   0.00000000000000E+00   8.88015887090257E-10
      4.30211191206084E-18  -3.43366399166242E-01  -3.43126811705071E-01   0.00000000000000E+00  -4.17392415134250E-11
     -1.50114978727403E-22  -7.18698333100968E-10  -7.60437574614543E-10  -3.02215850418832E-18
      9.61423250583254E-09
      0.00000000000000E+00   9.84575582864687E-14   0.00000000000000E+00   7.73181679872791E-14  -4.81053511357392E-23
     -9.85753922948714E-11  -9.84980741269322E-11  -1.28068894436773E-18  -9.38410574063285E-03  -9.38410574132183E-03
      0.00000000000000E+00   0.00000000000000E+00   6.88985127285178E-10   0.00000000000000E+00   6.88985127285178E-10
      4.31589161460654E-18  -3.49773412702084E-01  -3.49587373695523E-01   0.00000000000000E+00  -2.97255776242659E-11
     -1.51113505369163E-22  -5.60761475533865E-10  -5.90487053158282E-10  -3.03520267023882E-18
      9.63423250583254E-09
      0.00000000000000E+00   7.51289950357569E-14   0.00000000000000E+00   6.68865634371014E-14  -4.80874322025684E-23
     -7.52362640750184E-11  -7.51693775116294E-11  -1.28097111128994E-18  -9.25789432134040E-03  -9.25789432214517E-03
      0.00000000000000E+00   0.00000000000000E+00   8.04773009263329E-10   0.00000000000000E+00   8.04773009263329E-10
      4.33198707479181E-18  -3.58689105120827E-01  -3.58459232010416E-01   0.00000000000000E+00  -4.34671406053589E-11
     -1.52532276909617E-22  -6.86136491146211E-10  -7.29603631751722E-10  -3.05101596350188E-18
      9.64423250583254E-09
      0.00000000000000E+00   4.27996475387075E-14   0.00000000000000E+00   1.73696095661063E-13  -4.80715685607194E-23
     -4.29898781095413E-11  -4.28161820139283E-11  -1.28079318163974E-18  -9.32157231899521E-03  -9.32157232006521E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06999956628967E-09   0.00000000000000E+00   1.06999956628967E-09
      4.34268707045471E-18  -3.65706841410707E-01  -3.65383203952522E-01   0.00000000000000E+00  -7.22761044632542E-11
     -1.53686488927140E-22  -9.54907279812290E-10  -1.02718338427570E-09  -3.06189388881497E-18
      9.65098250583254E-09
      0.00000000000000E+00   1.90118606019580E-14   0.00000000000000E+00   1.92124611724017E-13  -4.80579947167439E-23
     -1.92393158830256E-11  -1.90471912713497E-11  -1.28051524339644E-18  -9.41293813396950E-03  -9.41293813533565E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36615649954172E-09   0.00000000000000E+00   1.36615649954172E-09
      4.35190862682661E-18  -3.72252049466307E-01  -3.71827606498506E-01   0.00000000000000E+00  -1.03903692338362E-10
     -1.54792439726872E-22  -1.24320561593170E-09  -1.34710930827022E-09  -3.07139338343017E-18
      9.66009500583254E-09
      0.00000000000000E+00   2.51654579948623E-14   0.00000000000000E+00  -1.47900897440462E-14  -4.80432967378687E-23
     -2.51597542141596E-11  -2.51745443039517E-11  -1.28020118800597E-18  -9.44530351271267E-03  -9.44530351435594E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64327039494793E-09   0.00000000000000E+00   1.64327039494793E-09
      4.36688292830058E-18  -3.82939810563969E-01  -3.82429983049267E-01   0.00000000000000E+00  -1.31352985333316E-10
     -1.56660272628748E-22  -1.48674286531060E-09  -1.61809585064408E-09  -3.08668174029460E-18
      9.67239688083254E-09
      0.00000000000000E+00   4.46365422828580E-14   0.00000000000000E+00  -6.45598046602278E-14  -4.80287602808572E-23
     -4.45855419700978E-11  -4.46501017748061E-11  -1.28002657572700E-18  -9.30988599808504E-03  -9.30988599985427E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76923147844083E-09   0.00000000000000E+00   1.76923147844083E-09
      4.38864779279442E-18  -3.98236737379956E-01  -3.97693357425106E-01   0.00000000000000E+00  -1.46391085744949E-10
     -1.59420058802778E-22  -1.57819029092087E-09  -1.72458137666598E-09  -3.10862121706742E-18
      9.68900441208254E-09
      0.00000000000000E+00   7.30165660799838E-14   0.00000000000000E+00  -7.65927681860714E-14  -4.80182430388409E-23
     -7.29833622130821E-11  -7.30599549813162E-11  -1.28027916784580E-18  -8.83859342074054E-03  -8.83859342251720E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77666404026819E-09   0.00000000000000E+00   1.77666404026819E-09
      4.41815379636393E-18  -4.18432399382880E-01  -4.17895628536308E-01   0.00000000000000E+00  -1.52505999148324E-10
     -1.63202766458786E-22  -1.55109808613831E-09  -1.70360408528680E-09  -3.13787462851812E-18
      9.70900441208254E-09
      0.00000000000000E+00   1.23071947858086E-13   0.00000000000000E+00  -1.24682974990070E-13  -4.80248730215636E-23
     -1.22908455063589E-10  -1.23033138038627E-10  -1.28160292491562E-18  -7.68694685265044E-03  -7.68694685441243E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76199935812820E-09   0.00000000000000E+00   1.76199935812820E-09
      4.45339378352649E-18  -4.41353349962255E-01  -4.40836944518531E-01   0.00000000000000E+00  -1.56521989998797E-10
     -1.67737367760837E-22  -1.48244423009055E-09  -1.63896622008951E-09  -3.17179085861087E-18
      9.72900441208254E-09
      0.00000000000000E+00   1.66606353294454E-13   0.00000000000000E+00  -1.17070712871640E-13  -4.80468924095537E-23
     -1.66462412020984E-10  -1.66579482733904E-10  -1.28381404290200E-18  -6.03380076844810E-03  -6.03380077018615E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73805391123889E-09   0.00000000000000E+00   1.73805391123889E-09
      4.48815486175127E-18  -4.62907545737290E-01  -4.62412404313644E-01   0.00000000000000E+00  -1.60566298914038E-10
     -1.72248397775802E-22  -1.41090812959084E-09  -1.57147442850505E-09  -3.20434081884927E-18
      9.74900441208254E-09
      0.00000000000000E+00   1.71382279629245E-13   0.00000000000000E+00  -2.29549222601361E-14  -4.80685045214886E-23
     -1.71345987274887E-10  -1.71368942197195E-10  -1.28613583940645E-18  -4.34354472705796E-03  -4.34354472872532E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66735430693291E-09   0.00000000000000E+00   1.66735430693291E-09
      4.52150194788993E-18  -4.83374368276984E-01  -4.82903010884003E-01   0.00000000000000E+00  -1.62590427342357E-10
     -1.76687303449317E-22  -1.33339493739319E-09  -1.49598536473573E-09  -3.23536610848348E-18
      9.76900441208254E-09
      0.00000000000000E+00   2.20794748246894E-13   0.00000000000000E+00  -1.41496437419269E-13  -4.81107239300120E-23
     -2.20717911241645E-10  -2.20859407679113E-10  -1.28945876143031E-18  -2.07084275579493E-03  -2.07084275747357E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67863804462467E-09   0.00000000000000E+00   1.67863804462467E-09
      4.55507470878242E-18  -5.02840001002852E-01  -5.02380680110742E-01   0.00000000000000E+00  -1.68905757380353E-10
     -1.81174084577248E-22  -1.28887287956509E-09  -1.45777863694563E-09  -3.26561594735211E-18
      9.78900441208254E-09
      0.00000000000000E+00  -6.53383460494345E-13   0.00000000000000E+00   2.28079149175919E-12  -4.77880249775489E-23
      6.51116135234821E-10   6.53396926726533E-10  -1.27535850769598E-18  -1.03319448520237E-02  -1.03319448522460E-02
      0.00000000000000E+00   0.00000000000000E+00   2.22315318970353E-10   0.00000000000000E+00   2.22315318970353E-10
      4.55952101516183E-18  -5.22538134612911E-01  -5.22262223542770E-01   0.00000000000000E+00  -9.00787692701738E-11
     -1.83516184538529E-22  -7.85633476426442E-10  -8.75712245696799E-10  -3.28416250746585E-18
      9.80900441208254E-09
      0.00000000000000E+00  -2.55107942067626E-12   0.00000000000000E+00   5.08346105610479E-12  -4.67484181497256E-23
      2.54597574626138E-09   2.55105920731744E-09  -1.22366377526822E-18  -4.04800250244127E-02  -4.04800250215934E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.81926407632088E-09   0.00000000000000E+00  -2.81926407632088E-09
      4.50313573363541E-18  -5.43502003208422E-01  -5.43586549422873E-01   0.00000000000000E+00   8.27276571734486E-11
     -1.81336705066272E-22   1.85477211830155E-10   2.68204869003423E-10  -3.27947195836720E-18
      9.81400441208254E-09
      0.00000000000000E+00  -3.34388319225163E-12   0.00000000000000E+00   8.26754597854273E-12  -4.64014520830290E-23
      3.33565999082442E-09   3.34392753680292E-09  -1.20682912031791E-18  -5.00935788714943E-02  -5.00935788674489E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.04537678405366E-09   0.00000000000000E+00  -4.04537678405366E-09
      4.48290884971514E-18  -5.48826228983469E-01  -5.49047293871470E-01   0.00000000000000E+00   1.46428501730728E-10
     -1.80368469509328E-22   5.55020745520246E-10   7.01449247250793E-10  -3.27607972939724E-18
      9.82075441208254E-09
      0.00000000000000E+00  -4.10141858473931E-12   0.00000000000000E+00   6.09296112109641E-12  -4.58715080472380E-23
      4.09532295272188E-09   4.10141591384293E-09  -1.17916057228043E-18  -6.56194883929562E-02  -6.56194883877581E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.19804914730819E-09   0.00000000000000E+00  -5.19804914730819E-09
      4.44782201797082E-18  -5.56156360367071E-01  -5.56501951202275E-01   0.00000000000000E+00   2.01283089019920E-10
     -1.78549537991252E-22   8.95350144445594E-10   1.09663323346534E-09  -3.26866144569038E-18
      9.82986691208254E-09
      0.00000000000000E+00  -5.08893319919464E-12   0.00000000000000E+00   5.93457582962356E-12  -4.50247083595336E-23
      5.08301640709861E-09   5.08895098292818E-09  -1.13350439188160E-18  -9.05546302599542E-02  -9.05546302533503E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.60394496757312E-09   0.00000000000000E+00  -6.60394496757312E-09
      4.38764356945380E-18  -5.66203301425513E-01  -5.66680726400209E-01   0.00000000000000E+00   2.59613632516983E-10
     -1.75328495466525E-22   1.25538035212831E-09   1.51499398464512E-09  -3.25413917757221E-18
      9.83294238083254E-09
      0.00000000000000E+00  -5.56726059057144E-12   0.00000000000000E+00   8.21352010832994E-12  -4.47089459243105E-23
      5.55903116845533E-09   5.56724468856361E-09  -1.11676317991830E-18  -9.95044826086349E-02  -9.95044826013935E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.24148265702561E-09   0.00000000000000E+00  -7.24148265702561E-09
      4.36537261583845E-18  -5.69602510669048E-01  -5.70130115304431E-01   0.00000000000000E+00   2.77617825297492E-10
     -1.74152158031311E-22   1.39662014316498E-09   1.67423796846230E-09  -3.24860943592015E-18
      9.83709426364504E-09
      0.00000000000000E+00  -6.04356739772968E-12   0.00000000000000E+00   6.26319709881290E-12  -4.42670207997484E-23
      6.03729510359755E-09   6.04355830069632E-09  -1.09254953239998E-18  -1.12243593351033E-01  -1.12243593343200E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.83318885640220E-09   0.00000000000000E+00  -7.83318885640220E-09
      4.33285013365849E-18  -5.74185320725667E-01  -5.74749294165276E-01   0.00000000000000E+00   2.95321959150708E-10
     -1.72446349155939E-22   1.49430859655519E-09   1.78963055570572E-09  -3.24030060125852E-18
      9.84269930544191E-09
      0.00000000000000E+00  -6.56377598927311E-12   0.00000000000000E+00   5.14795508291244E-12  -4.36176054021058E-23
      6.55859473552123E-09   6.56374269060410E-09  -1.05802606429658E-18  -1.30017270085208E-01  -1.30017270076877E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.33144894967382E-09   0.00000000000000E+00  -8.33144894967382E-09
      4.28615201406704E-18  -5.80265770938248E-01  -5.80822856317240E-01   0.00000000000000E+00   3.03694714045591E-10
     -1.70046845533939E-22   1.46401154502412E-09   1.76770625906954E-09  -3.22812594977046E-18
      9.85026611186769E-09
      0.00000000000000E+00  -7.27768513158721E-12   0.00000000000000E+00   5.16576823733228E-12  -4.24465123708978E-23
      7.27255758260935E-09   7.27772335084664E-09  -1.00970248186243E-18  -1.54177779752203E-01  -1.54177779743508E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.69558896072424E-09   0.00000000000000E+00  -8.69558896072424E-09
      4.22035417564308E-18  -5.88076299476672E-01  -5.88523203824208E-01   0.00000000000000E+00   3.00431951814802E-10
     -1.66786639963372E-22   1.11743365806285E-09   1.41786560987749E-09  -3.21065169378065E-18
      9.86048130054250E-09
      0.00000000000000E+00  -8.80065456396242E-12   0.00000000000000E+00   7.77793989437949E-12  -3.88845050881956E-23
      8.79290462908359E-09   8.80068256897793E-09  -9.43634131807852E-19  -1.85979897331206E-01  -1.85979897322256E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94998237224616E-09   0.00000000000000E+00  -8.94998237224616E-09
      4.12892841707441E-18  -5.97207467622698E-01  -5.97254806157766E-01   0.00000000000000E+00   2.88665586531861E-10
     -1.62457719198340E-22  -1.39365783263313E-10   1.49299803268385E-10  -3.18529428526655E-18
      9.87427180525348E-09
      0.00000000000000E+00  -1.33776451979623E-11   0.00000000000000E+00   1.66807240816214E-11  -2.23720865041057E-23
      1.33609073160928E-08   1.33775880401744E-08  -8.57268754912273E-19  -2.25696574505866E-01  -2.25696574496654E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.21144160850276E-09   0.00000000000000E+00  -9.21144160850276E-09
      4.00189798817737E-18  -6.03885980922142E-01  -6.02574018631219E-01   0.00000000000000E+00   2.80951602452382E-10
     -1.56549366102914E-22  -4.44709803412395E-09  -4.16614643167173E-09  -3.14462923326510E-18
      9.89288898661331E-09
      0.00000000000000E+00  -2.67736593433661E-11   0.00000000000000E+00   3.57060101111997E-11   4.09511042733162E-23
      2.67378883034985E-08   2.67735943136097E-08  -7.57039072026962E-19  -2.69919108913033E-01  -2.69919108903333E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70048793276037E-09   0.00000000000000E+00  -9.70048793276037E-09
      3.82130224505432E-18  -5.91317795874053E-01  -5.85940090168562E-01   0.00000000000000E+00   3.00904016913399E-10
     -1.47285673719127E-22  -1.73740103977625E-08  -1.70731063808492E-08  -3.06426317302736E-18
      9.91288898661331E-09
      0.00000000000000E+00  -4.69592038420991E-11   0.00000000000000E+00   5.00213508211725E-11   1.37297217759415E-22
      4.69090935365439E-08   4.69591148873653E-08  -6.78641433227244E-19  -3.04295068098962E-01  -3.04295068088580E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03812019414978E-08   0.00000000000000E+00  -1.03812019414978E-08
      3.61367820622436E-18  -5.41870502712031E-01  -5.30348071556751E-01   0.00000000000000E+00   3.19245939407030E-10
     -1.34495191164547E-22  -3.68971588852743E-08  -3.65779129458674E-08  -2.93503677299712E-18
      9.93288898661331E-09
      0.00000000000000E+00  -6.26763181862116E-11   0.00000000000000E+00   3.91099052235247E-11   2.11014900678749E-22
      6.26371892041964E-08   6.26762991094202E-08  -6.29409787772014E-19  -3.26967295988926E-01  -3.26967295977925E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10015761326904E-08   0.00000000000000E+00  -1.10015761326904E-08
      3.39364668357055E-18  -4.56951486684396E-01  -4.40672320621966E-01   0.00000000000000E+00   2.94466070716404E-10
     -1.18626759105934E-22  -5.19691890474460E-08  -5.16747229767297E-08  -2.76423689579854E-18
      9.95288898661331E-09
      0.00000000000000E+00  -6.52105900199789E-11   0.00000000000000E+00   6.41102321899403E-12   2.23446896923441E-22
      6.52042164835713E-08   6.52106275067906E-08  -6.05793435395695E-19  -3.39699702436169E-01  -3.39699702424613E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15566076443774E-08   0.00000000000000E+00  -1.15566076443774E-08
      3.16251453068300E-18  -3.41897357375772E-01  -3.24993862085745E-01   0.00000000000000E+00   2.45798192302484E-10
     -1.02274907767256E-22  -5.38998180547157E-08  -5.36540198624133E-08  -2.55672109528731E-18
      9.97288898661331E-09
      0.00000000000000E+00  -5.68003674338856E-11   0.00000000000000E+00  -2.08236924500265E-11   1.85340700001649E-22
      5.68212108425574E-08   5.68003871501075E-08  -5.98311245194636E-19  -3.46253343435821E-01  -3.46253343423903E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19175103117351E-08   0.00000000000000E+00  -1.19175103117351E-08
      2.92416432444830E-18  -2.18512157462780E-01  -2.04371549872726E-01   0.00000000000000E+00   1.72296266558883E-10
     -8.56977006900177E-23  -4.50551731049312E-08  -4.48828768383725E-08  -2.32585307925367E-18
      9.99288898661331E-09
      0.00000000000000E+00  -4.94562785572974E-11   0.00000000000000E+00  -1.82222103760828E-11   1.45137484201567E-22
      4.94744806922516E-08   4.94562584818757E-08  -5.89480217937618E-19  -3.53397045182726E-01  -3.53397045170886E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18404862999858E-08   0.00000000000000E+00  -1.18404862999858E-08
      2.68735459844859E-18  -1.16539603856797E-01  -1.04688319404685E-01   0.00000000000000E+00   9.20381467205420E-11
     -7.37921780919699E-23  -3.77078103286103E-08  -3.76157721818898E-08  -2.09787438051097E-18
      9.99466673995998E-09
      0.00000000000000E+00  -4.81533691152714E-11   0.00000000000000E+00  -3.58417269721536E-11   1.40710307066649E-22
      4.81892675259124E-08   4.81534257989404E-08  -5.89136518575587E-19  -3.53844460542447E-01  -3.53844460530514E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19336563118773E-08   0.00000000000000E+00  -1.19336563118773E-08
      2.66613950100211E-18  -1.07588319541597E-01  -9.61768476098278E-02   0.00000000000000E+00   9.22138903406769E-11
     -7.19262660475159E-23  -3.63119833774045E-08  -3.62197694870639E-08  -2.07700298242652E-18
      9.99706670697799E-09
      0.00000000000000E+00  -4.68798499891518E-11   0.00000000000000E+00  -2.65008380999635E-11   1.34761274928190E-22
      4.69063897225920E-08   4.68798888844922E-08  -5.88423352502546E-19  -3.54569138316300E-01  -3.54569138304393E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19079734888082E-08   0.00000000000000E+00  -1.19079734888082E-08
      2.63756075737766E-18  -9.63280955541152E-02  -8.53097516455484E-02   0.00000000000000E+00   7.39273095035315E-11
     -6.86437477751997E-23  -3.50458427051872E-08  -3.49719153956838E-08  -2.04913740487511E-18
      1.00000000000000E-08
      0.00000000000000E+00  -4.54631449177257E-11   0.00000000000000E+00  -2.39758761287338E-11   1.28327242421218E-22
      4.54871416742874E-08   4.54631657981588E-08  -5.86924973592297E-19  -3.55684462838704E-01  -3.55684462826887E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18173935934256E-08   0.00000000000000E+00  -1.18173935934256E-08
      2.60289687921171E-18  -8.37558393438272E-02  -7.31552944712744E-02   0.00000000000000E+00   6.45634788575744E-11
     -6.24880332905539E-23  -3.37103356835910E-08  -3.36457722047335E-08  -2.01597190561941E-18
}
